/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jpa.management.JPAApplInfo;
import com.ibm.ws.jpa.management.JPAIntrospection;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPXml;
import com.ibm.ws.jpa.management.JPAPuScope;
import com.ibm.ws.jpa.management.JPAPxmlInfo;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JPAScopeInfo {
    private static final TraceComponent tc = Tr.register(JPAScopeInfo.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final String scopeName;
    private final JPAPuScope scope;
    private final Map<String, JPAPxmlInfo> pxmlsInfo;

    JPAScopeInfo(String scopeName, JPAPuScope scope) {
        this.scopeName = scopeName;
        this.scope = scope;
        this.pxmlsInfo = new HashMap<String, JPAPxmlInfo>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.toString(), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPersistenceUnit(JPAPXml pxml, JPAApplInfo applInfo) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processPersistenceUnit" + pxml), (Object[])new Object[0]);
        }
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            URL pxmlRootURL = pxml.getRootURL();
            String pxmlInfoKey = this.scope == JPAPuScope.EAR_Scope ? pxml.getArchiveName() : pxmlRootURL.toString();
            JPAPxmlInfo pxmlInfo = this.pxmlsInfo.get(pxmlInfoKey);
            if (pxmlInfo == null) {
                pxmlInfo = new JPAPxmlInfo(this, pxmlRootURL);
                this.pxmlsInfo.put(pxmlInfoKey, pxmlInfo);
                JPAIntrospection.beginPXmlInfoVisit(pxmlInfo);
                try {
                    pxmlInfo.extractPersistenceUnits(pxml);
                }
                finally {
                    JPAIntrospection.endPXmlInfoVisit();
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processPersistenceUnit", (Object)this.getPUList());
        }
    }

    String getScopeName() {
        return this.scopeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPUList() {
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            StringBuilder sbuf = new StringBuilder();
            for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
                pxmlInfo.toStringBuilder(sbuf);
            }
            return sbuf.toString();
        }
    }

    public JPAPuScope getScopeType() {
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JPAPUnitInfo getPuInfo(String puName) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPuInfo : " + puName), (Object[])new Object[0]);
        }
        JPAPUnitInfo rtnVal = null;
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            int archiveEnd;
            if (this.scope == JPAPuScope.EAR_Scope && (archiveEnd = puName.indexOf(35)) != -1) {
                String archiveName = puName.substring(0, archiveEnd);
                puName = puName.substring(archiveEnd + 1);
                JPAPxmlInfo pxmlInfo = this.pxmlsInfo.get(archiveName);
                if (pxmlInfo != null) {
                    rtnVal = pxmlInfo.getPuInfo(puName);
                }
            } else {
                JPAPxmlInfo pxmlInfo;
                Iterator<JPAPxmlInfo> iterator = this.pxmlsInfo.values().iterator();
                while (iterator.hasNext() && (rtnVal = (pxmlInfo = iterator.next()).getPuInfo(puName)) == null) {
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPuInfo : " + (rtnVal != null ? rtnVal.getPersistenceUnitName() : "PU not found.")));
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAllPuCount() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllPuCount", (Object[])new Object[]{this});
        }
        int rtnCount = 0;
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
                rtnCount += pxmlInfo.getPuCount();
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAllPuCount : " + rtnCount));
        }
        return rtnCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JPAPUnitInfo getUniquePuInfo() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniquePuInfo", (Object[])new Object[0]);
        }
        JPAPUnitInfo rtnVal = null;
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
                Set<String> puNames = pxmlInfo.getPuNames();
                if (rtnVal == null && puNames.size() == 1) {
                    rtnVal = pxmlInfo.getPuInfo(puNames.iterator().next());
                    continue;
                }
                if (puNames.size() == 0) continue;
                rtnVal = null;
                break;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniquePuInfo", rtnVal);
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
                pxmlInfo.close();
            }
            this.pxmlsInfo.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringBuilder toStringBuilder(StringBuilder sbuf) {
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            sbuf.append("\nScopeInfo: ScopeName = ").append(this.scopeName).append("\tScope = ").append((Object)this.scope);
            for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
                pxmlInfo.toStringBuilder(sbuf);
            }
        }
        return sbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            return "ScopeName = \"" + this.scopeName + "\"\tScope = " + (Object)((Object)this.scope) + "\t# persistence.xml = " + this.pxmlsInfo.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIntrospect(PrintWriter out) {
        HashMap<String, JPAPxmlInfo> pxmlsInfoCopy = new HashMap<String, JPAPxmlInfo>();
        Map<String, JPAPxmlInfo> map = this.pxmlsInfo;
        synchronized (map) {
            pxmlsInfoCopy.putAll(this.pxmlsInfo);
        }
        for (Map.Entry entry : pxmlsInfoCopy.entrySet()) {
            JPAPxmlInfo value = (JPAPxmlInfo)entry.getValue();
            JPAIntrospection.beginPXmlInfoVisit(value);
            try {
                out.println();
                value.doIntrospect(out);
            }
            finally {
                JPAIntrospection.endPXmlInfoVisit();
            }
        }
    }
}

