/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.wsdl.BindingInput;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.service.model.ServiceSchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.JAXBExtensionHelper;
import org.apache.cxf.wsdl.WSDLExtensionLoader;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.SchemaSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@NoJSR250Annotations(unlessNull={"bus"})
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class WSDLManagerImpl
implements WSDLManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLManagerImpl.class);
    private static final String EXTENSIONS_RESOURCE = "META-INF/cxf/extensions.xml";
    private static final String EXTENSIONS_RESOURCE_COMPAT = "META-INF/extensions.xml";
    final ExtensionRegistry registry;
    final WSDLFactory factory;
    final Map<Object, Definition> definitionsMap;
    final Map<Object, ServiceSchemaInfo> schemaCacheMap;
    private boolean disableSchemaCache;
    private Bus bus;
    static final long serialVersionUID = -6502801710999374827L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLManagerImpl() throws BusException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "<init>", new Object[0]);
        }
        try {
            this.factory = WSDLFactory.newInstance();
            this.registry = this.factory.newPopulatedExtensionRegistry();
            this.registry.registerSerializer(Types.class, WSDLConstants.QNAME_SCHEMA, (ExtensionSerializer)new SchemaSerializer());
            QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
            this.registry.registerDeserializer(MIMEPart.class, header, this.registry.queryDeserializer(BindingInput.class, header));
            this.registry.registerSerializer(MIMEPart.class, header, this.registry.querySerializer(BindingInput.class, header));
            Class<?> clazz = this.registry.createExtension(BindingInput.class, header).getClass();
            this.registry.mapExtensionTypes(MIMEPart.class, header, clazz);
        }
        catch (WSDLException e) {
            throw new BusException((Throwable)e);
        }
        this.definitionsMap = new CacheMap();
        this.schemaCacheMap = new CacheMap();
        this.registerInitialExtensions();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLManagerImpl(Bus b) throws BusException {
        this();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "<init>", new Object[]{b});
        }
        this.setBus(b);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "<init>", this);
        }
    }

    @Resource
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final void setBus(Bus b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "setBus", new Object[]{b});
        }
        this.bus = b;
        if (null != this.bus) {
            this.bus.setExtension((Object)this, WSDLManager.class);
            ConfiguredBeanLocator loc = (ConfiguredBeanLocator)this.bus.getExtension(ConfiguredBeanLocator.class);
            if (loc != null) {
                loc.getBeansOfType(WSDLExtensionLoader.class);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "setBus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSDLFactory getWSDLFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "getWSDLFactory", new Object[0]);
        }
        WSDLFactory wSDLFactory = this.factory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wSDLFactory = wSDLFactory;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getWSDLFactory", wSDLFactory);
        }
        return wSDLFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<Object, Definition> getDefinitions() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinitions", new Object[0]);
        }
        Map<Object, Definition> map2 = this.definitionsMap;
        // MONITORENTER : map2
        Map<Object, Definition> map = Collections.unmodifiableMap(this.definitionsMap);
        // MONITOREXIT : map2
        if (LOG == null) return map;
        if (!LOG.isLoggable(Level.FINER)) return map;
        map = map;
        LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinitions", map);
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExtensionRegistry getExtensionRegistry() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "getExtensionRegistry", new Object[0]);
        }
        ExtensionRegistry extensionRegistry = this.registry;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            extensionRegistry = extensionRegistry;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getExtensionRegistry", extensionRegistry);
        }
        return extensionRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Definition getDefinition(URL url) throws WSDLException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", new Object[]{url});
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(url)) {
                Definition definition = this.definitionsMap.get(url);
                // MONITOREXIT @DISABLED, blocks:[3, 7] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    definition = definition;
                    LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", definition);
                }
                return definition;
            }
        }
        Definition def = this.loadDefinition(url.toString());
        Map<Object, Definition> map2 = this.definitionsMap;
        synchronized (map2) {
            this.definitionsMap.put(url, def);
        }
        Definition definition = def;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            definition = definition;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", definition);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Definition getDefinition(String url) throws WSDLException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", new Object[]{url});
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(url)) {
                Definition definition = this.definitionsMap.get(url);
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    definition = definition;
                    LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", definition);
                }
                return definition;
            }
        }
        Definition definition = this.loadDefinition(url);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            definition = definition;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", definition);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Definition getDefinition(Element el) throws WSDLException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", new Object[]{el});
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(el)) {
                Definition definition = this.definitionsMap.get(el);
                // MONITOREXIT @DISABLED, blocks:[3, 7] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    definition = definition;
                    LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", definition);
                }
                return definition;
            }
        }
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(this.registry);
        Definition def = reader.readWSDL("", el);
        Map<Object, Definition> map2 = this.definitionsMap;
        synchronized (map2) {
            this.definitionsMap.put(el, def);
        }
        Definition definition = def;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            definition = definition;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getDefinition", definition);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addDefinition(Object key, Definition wsdl) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "addDefinition", new Object[]{key, wsdl});
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            this.definitionsMap.put(key, wsdl);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "addDefinition");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Definition loadDefinition(String url) throws WSDLException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "loadDefinition", new Object[]{url});
        }
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        reader.setExtensionRegistry(this.registry);
        CatalogWSDLLocator catLocator = new CatalogWSDLLocator(url, this.bus);
        ResourceManagerWSDLLocator wsdlLocator = new ResourceManagerWSDLLocator(url, catLocator, this.bus);
        InputSource src = wsdlLocator.getBaseInputSource();
        Definition def = null;
        if (src.getByteStream() != null || src.getCharacterStream() != null) {
            Document doc;
            XMLStreamReader xmlReader = null;
            try {
                xmlReader = StaxUtils.createXMLStreamReader((InputSource)src);
                doc = StaxUtils.read((XMLStreamReader)xmlReader, (boolean)true);
                if (src.getSystemId() != null) {
                    try {
                        doc.setDocumentURI(new String(src.getSystemId()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                throw new WSDLException("PARSER_ERROR", e.getMessage(), (Throwable)e);
            }
            finally {
                StaxUtils.close((XMLStreamReader)xmlReader);
            }
            def = reader.readWSDL((WSDLLocator)wsdlLocator, doc.getDocumentElement());
        } else {
            def = reader.readWSDL((WSDLLocator)wsdlLocator);
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            this.definitionsMap.put(url, def);
        }
        Definition definition = def;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            definition = definition;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "loadDefinition", definition);
        }
        return definition;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void registerInitialExtensions() throws BusException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "registerInitialExtensions", new Object[0]);
        }
        this.registerInitialXmlExtensions(EXTENSIONS_RESOURCE_COMPAT);
        this.registerInitialXmlExtensions(EXTENSIONS_RESOURCE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "registerInitialExtensions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void registerInitialXmlExtensions(String resource) throws BusException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "registerInitialXmlExtensions", new Object[]{resource});
        }
        Properties initialExtensions = null;
        try {
            ClassLoader cl = null;
            if (this.bus != null) {
                cl = (ClassLoader)this.bus.getExtension(ClassLoader.class);
            }
            if (cl != null) {
                initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)resource, cl);
            }
            if (initialExtensions == null || initialExtensions.size() == 0) {
                ClassLoader pcl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                    static final long serialVersionUID = -7395299499727343868L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.wsdl11.WSDLManagerImpl$1", 1.class, null, null);
                    }
                });
                initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)resource, (ClassLoader)pcl);
            }
        }
        catch (IOException ex) {
            throw new BusException((Throwable)ex);
        }
        Iterator<Object> it = initialExtensions.keySet().iterator();
        while (it.hasNext()) {
            StringTokenizer st = new StringTokenizer(initialExtensions.getProperty((String)it.next()), "=");
            String parentType = st.nextToken();
            String elementType = st.nextToken();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registering extension: " + elementType + " for parent: " + parentType);
                }
                JAXBExtensionHelper.addExtensions((ExtensionRegistry)this.registry, (String)parentType, (String)elementType);
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
            catch (JAXBException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "registerInitialXmlExtensions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServiceSchemaInfo getSchemasForDefinition(Definition wsdl) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "getSchemasForDefinition", new Object[]{wsdl});
        }
        if (this.disableSchemaCache) {
            ServiceSchemaInfo serviceSchemaInfo = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                serviceSchemaInfo = serviceSchemaInfo;
                LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getSchemasForDefinition", serviceSchemaInfo);
            }
            return serviceSchemaInfo;
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            for (Map.Entry<Object, Definition> e : this.definitionsMap.entrySet()) {
                ServiceSchemaInfo info;
                if (e.getValue() != wsdl || (info = this.schemaCacheMap.get(e.getKey())) == null) continue;
                ServiceSchemaInfo serviceSchemaInfo = info;
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    serviceSchemaInfo = serviceSchemaInfo;
                    LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getSchemasForDefinition", serviceSchemaInfo);
                }
                return serviceSchemaInfo;
            }
        }
        ServiceSchemaInfo serviceSchemaInfo = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            serviceSchemaInfo = serviceSchemaInfo;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "getSchemasForDefinition", serviceSchemaInfo);
        }
        return serviceSchemaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void putSchemasForDefinition(Definition wsdl, ServiceSchemaInfo schemas) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "putSchemasForDefinition", new Object[]{wsdl, schemas});
        }
        if (!this.disableSchemaCache) {
            Map<Object, Definition> map = this.definitionsMap;
            synchronized (map) {
                for (Map.Entry<Object, Definition> e : this.definitionsMap.entrySet()) {
                    if (e.getValue() != wsdl) continue;
                    this.schemaCacheMap.put(e.getKey(), schemas);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "putSchemasForDefinition");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isDisableSchemaCache() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "isDisableSchemaCache", new Object[0]);
        }
        boolean bl = this.disableSchemaCache;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "isDisableSchemaCache", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDisableSchemaCache(boolean disableSchemaCache) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "setDisableSchemaCache", new Object[]{disableSchemaCache});
        }
        this.disableSchemaCache = disableSchemaCache;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "setDisableSchemaCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeDefinition(Definition wsdl) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.wsdl11.WSDLManagerImpl", "removeDefinition", new Object[]{wsdl});
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            ArrayList<Object> keys = new ArrayList<Object>();
            for (Map.Entry<Object, Definition> entry : this.definitionsMap.entrySet()) {
                if (entry.getValue() != wsdl) continue;
                keys.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : keys) {
                this.definitionsMap.remove(entry);
                this.schemaCacheMap.remove(entry);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.wsdl11.WSDLManagerImpl", "removeDefinition");
        }
    }
}

