/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ArtifactDownloaderUtils;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.ProgressBar;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ArtifactDownloader {
    private final int PROGRESS_CHUNK = 500000;
    private final int BUFFER_SIZE = 10000;
    private final String appName = "artifactDownloader";
    private final String appVersion = "1.0.0";
    private final List<File> downloadedFiles = new ArrayList<File>();
    private final Logger logger = InstallLogUtils.getInstallLogger();
    private final ProgressBar progressBar = ProgressBar.getInstance();

    public void synthesizeAndDownloadFeatures(List<String> mavenCoords, String dLocation, String repo) throws InstallException {
        List<String> missingFeatures;
        int repoResponseCode;
        this.info("Establishing a connection to the maven central repository ...\nThis process might take several minutes to complete.");
        this.checkValidProxy();
        this.configureProxyAuthentication();
        this.configureAuthentication();
        this.updateProgress(this.progressBar.getMethodIncrement("establishConnection"));
        this.info("Successfully connected to all configured repositories.");
        this.downloadedFiles.clear();
        try {
            repoResponseCode = ArtifactDownloaderUtils.exists(repo);
        }
        catch (IOException e) {
            throw new InstallException(e.getMessage());
        }
        ArtifactDownloaderUtils.checkResponseCode(repoResponseCode, repo);
        List<String> featureURLs = ArtifactDownloaderUtils.acquireFeatureURLs(mavenCoords, repo);
        dLocation = this.FormatPathSuffix(dLocation);
        try {
            missingFeatures = ArtifactDownloaderUtils.getMissingFiles(featureURLs);
        }
        catch (IOException e) {
            throw new InstallException(e.getMessage());
        }
        if (!missingFeatures.isEmpty()) {
            ArrayList<String> missingFeatureList = new ArrayList<String>();
            for (String f : missingFeatures) {
                if (!f.endsWith(".esa")) continue;
                missingFeatureList.add(ArtifactDownloaderUtils.getFileNameFromURL(f));
            }
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", missingFeatureList, "feature(s)", repo);
        }
        for (String coords : mavenCoords) {
            this.synthesizeAndDownload(coords, "esa", dLocation, repo, false);
            this.synthesizeAndDownload(coords, "pom", dLocation, repo, false);
            this.updateProgress(this.progressBar.getMethodIncrement("downloadArtifact"));
            this.fine("Finished downloading feature: " + coords);
        }
    }

    private String FormatPathSuffix(String dLocation) {
        String result = dLocation;
        if (!dLocation.endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    public void synthesizeAndDownload(String mavenCoords, String filetype, String dLocation, String repo, boolean individualDownload) throws InstallException {
        this.configureProxyAuthentication();
        this.configureAuthentication();
        if (individualDownload) {
            int repoResponseCode;
            this.checkValidProxy();
            dLocation = this.FormatPathSuffix(dLocation);
            try {
                repoResponseCode = ArtifactDownloaderUtils.exists(repo);
            }
            catch (IOException e) {
                throw new InstallException(e.getMessage());
            }
            ArtifactDownloaderUtils.checkResponseCode(repoResponseCode, repo);
        }
        String groupId = ArtifactDownloaderUtils.getGroupId(mavenCoords).replace(".", "/") + "/";
        String artifactId = ArtifactDownloaderUtils.getartifactId(mavenCoords);
        String version = ArtifactDownloaderUtils.getVersion(mavenCoords);
        new File(dLocation + groupId + artifactId + "/" + version + "/").mkdirs();
        String filename = ArtifactDownloaderUtils.getfilename(mavenCoords, filetype);
        String urlLocation = ArtifactDownloaderUtils.getUrlLocation(repo, groupId, artifactId, version, filename);
        String[] checksumFormats = new String[]{"MD5", "SHA1"};
        try {
            if (individualDownload && ArtifactDownloaderUtils.fileIsMissing(urlLocation)) {
                throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", ArtifactDownloaderUtils.getFileNameFromURL(urlLocation), filetype + " file", repo);
            }
            this.download(urlLocation, dLocation, groupId, artifactId, version, filename, checksumFormats);
        }
        catch (IOException e) {
            throw ExceptionUtils.createByKey(e, "ERROR_INVALID_ESA", filename);
        }
    }

    private void download(String urlLocation, String dLocation, String groupId, String artifactId, String version, String filename, String[] checksumFormats) throws IOException, InstallException {
        try {
            URI uriLoc = new URI(urlLocation);
            File fileLoc = new File(ArtifactDownloaderUtils.getFileLocation(dLocation, groupId, artifactId, version, filename));
            this.downloadInternal(uriLoc, fileLoc);
            this.downloadedFiles.add(fileLoc);
            for (String checksumFormat : checksumFormats) {
                String checksumOrigin;
                String checksumLocal = ArtifactDownloaderUtils.getChecksum(fileLoc.getAbsolutePath(), checksumFormat);
                if (checksumLocal.equals(checksumOrigin = ArtifactDownloaderUtils.getMasterChecksum(urlLocation, checksumFormat))) continue;
                ArtifactDownloaderUtils.deleteFiles(this.downloadedFiles, dLocation, groupId, artifactId, version, filename);
                this.downloadedFiles.clear();
                throw ExceptionUtils.createByKey("ERROR_DOWNLOADED_ASSET_INVALID_CHECKSUM", filename, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("FEATURE_ASSET", new Object[0]));
            }
        }
        catch (URISyntaxException e) {
            throw new InstallException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstallException(e.getMessage());
        }
    }

    private void configureProxyAuthentication() {
        if (System.getenv("http.proxyUser") != null) {
            Authenticator.setDefault(new SystemPropertiesProxyAuthenticator());
        }
    }

    private void configureAuthentication() {
        if (System.getProperty("MVNW_USERNAME") != null && System.getProperty("MVNW_PASSWORD") != null && System.getenv("http.proxyUser") == null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(System.getProperty("MVNW_USERNAME"), System.getProperty("MVNW_PASSWORD").toCharArray());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInternal(URI address, File destination) throws IOException, InstallException {
        OutputStream out = null;
        InputStream in = null;
        try {
            int numRead;
            URLConnection conn;
            URL url = address.toURL();
            try {
                out = new BufferedOutputStream(new FileOutputStream(destination));
            }
            catch (FileNotFoundException e) {
                throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_FEATURE", ArtifactDownloaderUtils.getFileNameFromURL(address.toString()), destination.toString());
            }
            if (System.getenv("http.proxyUser") != null) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getenv("http.proxyHost"), 8080));
                conn = url.openConnection(proxy);
            } else {
                conn = url.openConnection();
            }
            this.addBasicAuthentication(address, conn);
            String userAgentValue = this.calculateUserAgent();
            conn.setRequestProperty("User-Agent", userAgentValue);
            in = conn.getInputStream();
            byte[] buffer = new byte[10000];
            long progressCounter = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                if ((progressCounter += (long)numRead) / 500000L > 0L) {
                    progressCounter -= 500000L;
                }
                out.write(buffer, 0, numRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private String calculateUserAgent() {
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String javaVendorVersion = System.getProperty("java.vm.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return String.format("%s/%s (%s;%s;%s) (%s;%s;%s)", "artifactDownloader", "1.0.0", osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private void addBasicAuthentication(URI address, URLConnection connection) throws IOException {
        String userInfo = this.calculateUserInfo(address);
        if (userInfo == null) {
            return;
        }
        connection.setRequestProperty("Authorization", "Basic " + this.base64Encode(userInfo));
    }

    private String base64Encode(String userInfo) {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Method getEncoderMethod = loader.loadClass("java.util.Base64").getMethod("getEncoder", new Class[0]);
            Method encodeMethod = loader.loadClass("java.util.Base64$Encoder").getMethod("encodeToString", byte[].class);
            Object encoder = getEncoderMethod.invoke(null, new Object[0]);
            return (String)encodeMethod.invoke(encoder, new Object[]{userInfo.getBytes("UTF-8")});
        }
        catch (Exception java7OrEarlier) {
            try {
                Method encodeMethod = loader.loadClass("javax.xml.bind.DatatypeConverter").getMethod("printBase64Binary", byte[].class);
                return (String)encodeMethod.invoke(null, new Object[]{userInfo.getBytes("UTF-8")});
            }
            catch (Exception java5OrEarlier) {
                throw new RuntimeException("Downloading Maven distributions with HTTP Basic Authentication is not supported on your JVM.", java5OrEarlier);
            }
        }
    }

    private String calculateUserInfo(URI uri) {
        if (System.getProperty("MVNW_USERNAME") != null && System.getProperty("MVNW_PASSWORD") != null) {
            return System.getProperty("MVNW_USERNAME") + ':' + System.getProperty("MVNW_PASSWORD");
        }
        return uri.getUserInfo();
    }

    public List<File> getDownloadedEsas() {
        ArrayList<File> esaFiles = new ArrayList<File>();
        for (File f : this.downloadedFiles) {
            if (!f.getName().endsWith(".esa")) continue;
            esaFiles.add(f);
        }
        return esaFiles;
    }

    public List<File> getDownloadedPoms() {
        ArrayList<File> pomFiles = new ArrayList<File>();
        for (File f : this.downloadedFiles) {
            if (!f.getName().endsWith(".pom")) continue;
            pomFiles.add(f);
        }
        return pomFiles;
    }

    public List<File> getDownloadedFiles() {
        return this.downloadedFiles;
    }

    public void checkValidProxy() throws InstallException {
        String proxyPort = System.getenv("http.proxyPort");
        if (System.getenv("http.proxyUser") != null) {
            int proxyPortnum = Integer.parseInt(proxyPort);
            if (System.getenv("http.proxyHost").isEmpty()) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_HOST_MISSING", new Object[0]);
            }
            if (proxyPortnum < 0 || proxyPortnum > 65535) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_INVALID_PROXY_PORT", proxyPort);
            }
            if (System.getenv("http.proxyPassword").isEmpty() || System.getenv("http.proxyPassword") == null) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_PWD_MISSING", new Object[0]);
            }
        }
    }

    private void updateProgress(double increment) {
        this.progressBar.updateProgress(increment);
    }

    private void info(String msg) {
        System.out.print("\u001b[2K");
        this.logger.info(msg);
        this.progressBar.display();
    }

    private void fine(String msg) {
        System.out.print("\u001b[2K");
        this.logger.fine(msg);
        this.progressBar.display();
    }

    private void severe(String msg) {
        System.out.print("\u001b[2K");
        this.logger.severe(msg);
        this.progressBar.display();
    }

    private static class SystemPropertiesProxyAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(System.getenv("http.proxyUser"), System.getenv("http.proxyPassword").toCharArray());
        }
    }
}

