/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import java.io.IOException;
import java.util.HashMap;

public class ProgressBar {
    private static ProgressBar progressBar;
    private HashMap<String, Integer> methodMap;
    private static final StringBuilder res;
    private static double counter;

    public static ProgressBar getInstance() {
        if (progressBar == null) {
            progressBar = new ProgressBar();
        }
        return progressBar;
    }

    private ProgressBar() {
        this.initMap();
        counter = 0.0;
    }

    public void setMethodMap(HashMap<String, Integer> methodMap) {
        this.methodMap = methodMap;
    }

    public int getMethodIncrement(String method) {
        if (this.methodMap.containsKey(method)) {
            return this.methodMap.get(method);
        }
        return 0;
    }

    private void initMap() {
        this.methodMap = new HashMap();
        this.methodMap.put("initializeMap", 10);
        this.methodMap.put("fetchJsons", 10);
        this.methodMap.put("resolvedFeatures", 20);
        this.methodMap.put("fetchArtifacts", 20);
        this.methodMap.put("installFeatures", 30);
        this.methodMap.put("cleanUp", 10);
    }

    public void updateProgress(double increment) {
        counter += increment;
    }

    public void display() {
        String data = String.format("[%s] %4.2f%%\r", ProgressBar.progress(counter), counter);
        try {
            System.out.write(data.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String progress(double pct) {
        res.delete(0, res.length());
        int numEquals = 2 * (int)((pct + 9.0) / 10.0);
        for (int i = 0; i < numEquals; ++i) {
            res.append('=');
        }
        while (res.length() < 20) {
            res.append(' ');
        }
        return res.toString();
    }

    public void finish() {
        System.out.print("\u001b[2K");
    }

    public double getCounter() {
        return counter;
    }

    static {
        res = new StringBuilder();
    }
}

