/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.session.MemoryStoreHelper;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionStoreService;
import com.ibm.ws.session.store.cache.CacheHashMap;
import com.ibm.ws.session.store.cache.CacheStore;
import com.ibm.ws.session.store.cache.CachingProviderClassLoader;
import com.ibm.ws.session.store.cache.RuntimeUpdateListenerImpl;
import com.ibm.ws.session.store.cache.SessionInfo;
import com.ibm.ws.session.utils.SessionLoader;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.session.ILoader;
import com.ibm.wsspi.session.IStore;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.OptionalFeature;
import javax.cache.management.CacheMXBean;
import javax.cache.management.CacheStatisticsMXBean;
import javax.cache.spi.CachingProvider;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.transaction.UserTransaction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheStoreService
implements Introspector,
SessionStoreService {
    private static final TraceComponent tc = Tr.register(CacheStoreService.class, null, (String)"com.ibm.ws.session.store.cache.resources.WASSessionCache");
    Map<String, Object> configurationProperties;
    private static final String BASE_PREFIX = "properties";
    private static final int BASE_PREFIX_LENGTH = "properties".length();
    private static final int TOTAL_PREFIX_LENGTH = BASE_PREFIX_LENGTH + 3;
    volatile CacheManager cacheManager;
    volatile CachingProvider cachingProvider;
    private volatile boolean completedPassivation = true;
    private Library library;
    final AtomicReference<ServiceReference<?>> monitorRef = new AtomicReference();
    SerializationService serializationService;
    boolean supportsStoreByReference;
    volatile String tcCacheManager;
    File tempConfigFile;
    private volatile String tcCachingProvider;
    volatile UserTransaction userTransaction;
    static final long serialVersionUID = 6353176533901985335L;

    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.configurationProperties = new HashMap<String, Object>(props);
        Object scheduleInvalidationFirstHour = this.configurationProperties.get("scheduleInvalidationFirstHour");
        Object scheduleInvalidationSecondHour = this.configurationProperties.get("scheduleInvalidationSecondHour");
        Object writeContents = this.configurationProperties.get("writeContents");
        Object writeFrequency = this.configurationProperties.get("writeFrequency");
        if (writeContents == null || "ONLY_SET_ATTRIBUTES".equals(writeContents)) {
            this.configurationProperties.put("writeContents", "ONLY_UPDATED_ATTRIBUTES");
        }
        this.configurationProperties.put("noAffinitySwitchBack", "TIME_BASED_WRITE".equals(writeFrequency));
        this.configurationProperties.put("onlyCheckInCacheDuringPreInvoke", false);
        this.configurationProperties.put("optimizeCacheIdIncrements", true);
        this.configurationProperties.put("scheduleInvalidation", scheduleInvalidationFirstHour != null || scheduleInvalidationSecondHour != null);
        this.configurationProperties.put("sessionPersistenceMode", "JCACHE");
        this.configurationProperties.put("useInvalidatedId", false);
        this.configurationProperties.put("useMultiRowSchema", true);
    }

    /*
     * WARNING - void declaration
     */
    synchronized void activateLazily() {
        URI configuredURI;
        if (this.cacheManager != null) {
            return;
        }
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Properties vendorProperties = new Properties();
        String uriValue = (String)this.configurationProperties.get("uri");
        if (uriValue != null) {
            try {
                configuredURI = new URI(uriValue);
            }
            catch (URISyntaxException uRISyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.session.store.cache.CacheStoreService", (String)"179", (Object)this, (Object[])new Object[0]);
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"INCORRECT_URI_SYNTAX", (Object[])new Object[]{e}), (Throwable)e);
            }
        } else {
            configuredURI = null;
        }
        for (Map.Entry<String, Object> entry : this.configurationProperties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.length() <= TOTAL_PREFIX_LENGTH || key.charAt(BASE_PREFIX_LENGTH) != '.' || !key.startsWith(BASE_PREFIX) || (key = key.substring(TOTAL_PREFIX_LENGTH)).equals("config.referenceType")) continue;
            vendorProperties.setProperty(key, (String)value);
        }
        ClassLoader cl = this.library.getClassLoader();
        try {
            AccessController.doPrivileged(() -> {
                URI uri;
                CachingProviderClassLoader loader = new CachingProviderClassLoader(cl);
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcInvoke("Caching", "getCachingProvider", loader);
                }
                this.cachingProvider = Caching.getCachingProvider((ClassLoader)loader);
                this.tcCachingProvider = "CachingProvider" + Integer.toHexString(System.identityHashCode(this.cachingProvider));
                URI uRI = uri = "org.infinispan.jcache.embedded.JCachingProvider".equals(this.cachingProvider.getClass().getName()) && Boolean.TRUE.equals(this.configurationProperties.get("enableBetaSupportForInfinispan")) ? this.generateOrUpdateInfinispanConfig(configuredURI) : configuredURI;
                if (trace && tc.isDebugEnabled()) {
                    CacheHashMap.tcReturn("Caching", "getCachingProvider", this.tcCachingProvider, this.cachingProvider);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("caching provider class is " + this.cachingProvider.getClass().getName()), (Object[])new Object[0]);
                    CacheHashMap.tcInvoke(this.tcCachingProvider, "getCacheManager", uri, null, vendorProperties);
                }
                this.cacheManager = this.cachingProvider.getCacheManager(uri, null, vendorProperties);
                return null;
            });
            this.tcCacheManager = "CacheManager" + Integer.toHexString(System.identityHashCode(this.cacheManager));
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcCachingProvider, "getCacheManager", this.tcCacheManager, this.cacheManager);
                CacheHashMap.tcInvoke(this.tcCachingProvider, "isSupported", "STORE_BY_REFERENCE");
            }
            this.supportsStoreByReference = this.cachingProvider.isSupported(OptionalFeature.STORE_BY_REFERENCE);
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcCachingProvider, "isSupported", this.supportsStoreByReference);
            }
        }
        catch (CacheException entry) {
            void x;
            FFDCFilter.processException((Throwable)entry, (String)"com.ibm.ws.session.store.cache.CacheStoreService", (String)"240", (Object)this, (Object[])new Object[0]);
            if (this.library.getFiles().isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"ERROR_CONFIG_EMPTY_LIBRARY", (Object[])new Object[]{this.library.id(), Tr.formatMessage((TraceComponent)tc, (String)"SESSION_CACHE_CONFIG_MESSAGE", (Object[])new Object[]{RuntimeUpdateListenerImpl.sampleConfig})});
            }
            throw x;
        }
        catch (Error | RuntimeException | PrivilegedActionException x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.session.store.cache.CacheStoreService", (String)"245", (Object)this, (Object[])new Object[0]);
            if (this.cachingProvider != null) {
                CacheHashMap.tcInvoke(this.tcCachingProvider, "close", new Object[0]);
                this.cachingProvider.close();
                CacheHashMap.tcReturn(this.tcCachingProvider, "close", new Object[0]);
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new RuntimeException(x);
        }
    }

    @Trivial
    void configureMonitoring(String cacheName) {
        boolean enable;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        boolean bl = enable = this.monitorRef.get() != null;
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcInvoke(this.tcCacheManager, "enableManagement", cacheName, enable);
        }
        this.cacheManager.enableManagement(cacheName, enable);
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcReturn(this.tcCacheManager, "enableManagement", new Object[0]);
            CacheHashMap.tcInvoke(this.tcCacheManager, "enableStatistics", cacheName, enable);
        }
        this.cacheManager.enableStatistics(cacheName, enable);
        if (trace && tc.isDebugEnabled()) {
            CacheHashMap.tcReturn(this.tcCacheManager, "enableStatistics", new Object[0]);
        }
    }

    public IStore createStore(SessionManagerConfig smc, String smid, ServletContext sc, MemoryStoreHelper storeHelper, ClassLoader classLoader, boolean applicationSessionStore) {
        CacheStore store = new CacheStore(smc, smid, sc, storeHelper, applicationSessionStore, this);
        store.setLoader((ILoader)new SessionLoader(this.serializationService, classLoader, applicationSessionStore));
        this.setCompletedPassivation(false);
        return store;
    }

    protected void deactivate(ComponentContext context) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        long MAX_WAIT = TimeUnit.SECONDS.toNanos(10L);
        long start = System.nanoTime();
        while (!this.completedPassivation && System.nanoTime() - start < MAX_WAIT) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.session.store.cache.CacheStoreService", (String)"308", (Object)this, (Object[])new Object[]{context});
            }
        }
        if (this.cachingProvider != null) {
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcInvoke(this.tcCachingProvider, "close", new Object[0]);
            }
            AccessController.doPrivileged(() -> {
                this.cachingProvider.close();
                return this.tempConfigFile == null ? null : Boolean.valueOf(this.tempConfigFile.delete());
            });
            if (trace && tc.isDebugEnabled()) {
                CacheHashMap.tcReturn(this.tcCachingProvider, "close", new Object[0]);
            }
            this.cachingProvider = null;
            this.cacheManager = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private URI generateOrUpdateInfinispanConfig(URI configuredURI) throws URISyntaxException, IOException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (configuredURI == null) {
            this.tempConfigFile = File.createTempFile("infinispan", ".xml");
            this.tempConfigFile.setReadable(true);
            this.tempConfigFile.setWritable(true);
            PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.tempConfigFile)));
            try {
                out.println("<infinispan>");
                out.println(" <jgroups>");
                out.println("  <stack-file name=\"jgroups-udp\" path=\"/default-configs/default-jgroups-udp.xml\"/>");
                out.println(" </jgroups>");
                out.println(" <cache-container>");
                out.println("  <transport stack=\"jgroups-udp\"/>");
                out.println("  <replicated-cache-configuration name=\"com.ibm.ws.session.*\"/>");
                out.println(" </cache-container>");
                out.println("</infinispan>");
                out.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.session.store.cache.CacheStoreService", (String)"343", (Object)this, (Object[])new Object[]{configuredURI});
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.session.store.cache.CacheStoreService", (String)"343", (Object)this, (Object[])new Object[]{configuredURI});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return this.tempConfigFile.toURI();
        }
        try {
            Object element;
            URLConnection con = configuredURI.toURL().openConnection();
            DocumentBuilder docbuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docbuilder.parse(con.getInputStream());
            LinkedList<Object> cacheContainers = new LinkedList<Object>();
            LinkedList<Node> elements = new LinkedList<Node>();
            elements.add(doc);
            while ((element = (Node)elements.poll()) != null) {
                NamedNodeMap attributes;
                NodeList nodeList = element.getChildNodes();
                for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                    Node child = nodeList.item(i);
                    if (child.getNodeType() != 1) continue;
                    elements.add(child);
                }
                String elementName = element.getNodeName().toLowerCase();
                if ("cache-container".equalsIgnoreCase(elementName)) {
                    cacheContainers.add(element);
                }
                if ((attributes = element.getAttributes()) == null) continue;
                for (int i = attributes.getLength() - 1; i >= 0; --i) {
                    String regex;
                    Pattern pattern;
                    String nameValue;
                    Node nameAttribute = attributes.getNamedItem("name");
                    if (nameAttribute == null || (nameValue = nameAttribute.getNodeValue()) == null || !elementName.endsWith("-cache") && !elementName.endsWith("-cache-configuration") || !(pattern = Pattern.compile(regex = this.infinispanCacheNameToRegEx(nameValue))).matcher("com.ibm.ws.session.attr.").matches() && !pattern.matcher("com.ibm.ws.session.meta.").matches()) continue;
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("No changes due to " + elementName + " name=" + nameValue), (Object[])new Object[0]);
                    }
                    return configuredURI;
                }
            }
            for (Node node : cacheContainers) {
                Element replicatedCacheConfig = doc.createElement("replicated-cache-configuration");
                Attr nameAttribute = doc.createAttribute("name");
                nameAttribute.setNodeValue("com.ibm.ws.session.*");
                replicatedCacheConfig.setAttributeNode(nameAttribute);
                node.appendChild(replicatedCacheConfig);
            }
            if (cacheContainers.isEmpty()) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"No cache-container was found", (Object[])new Object[0]);
                }
                return configuredURI;
            }
            this.tempConfigFile = File.createTempFile("infinispan", ".xml");
            this.tempConfigFile.setReadable(true);
            this.tempConfigFile.setWritable(true);
            this.tempConfigFile.deleteOnExit();
            StreamResult uriResult = new StreamResult(new FileOutputStream(this.tempConfigFile));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, uriResult);
            if (trace && tc.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                StreamResult loggableResult = new StreamResult(sw);
                transformer.transform(source, loggableResult);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"generateOrUpdateInfinispanConfig", (Object[])new Object[]{this.tempConfigFile, sw.toString()});
            }
            return this.tempConfigFile.toURI();
        }
        catch (ParserConfigurationException | TransformerException | SAXException con) {
            FFDCFilter.processException((Throwable)con, (String)"com.ibm.ws.session.store.cache.CacheStoreService", (String)"433", (Object)this, (Object[])new Object[]{configuredURI});
            if (trace && tc.isDebugEnabled()) {
                void x;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"unable to enhance Infinispan config", (Object[])new Object[]{x});
            }
            return configuredURI;
        }
    }

    public Map<String, Object> getConfiguration() {
        return this.configurationProperties;
    }

    public String getIntrospectorDescription() {
        return "JCache provider diagnostics for HTTP Sessions";
    }

    public String getIntrospectorName() {
        return "SessionCacheIntrospector";
    }

    private String infinispanCacheNameToRegEx(String s) {
        int len = s.length();
        StringBuilder regex = new StringBuilder(len + 5);
        int start = 0;
        int i = 0;
        while ((i = s.indexOf(42, i)) >= 0) {
            String part = s.substring(start, i);
            if (part.length() > 0) {
                regex.append("\\Q").append(part).append("\\E");
            }
            regex.append(".*");
            start = i + 1;
            ++i;
        }
        if (start < len) {
            regex.append("\\Q").append(s.substring(start)).append("\\E");
        }
        return regex.toString();
    }

    public void introspect(PrintWriter out) throws Exception {
        Properties props;
        String INDENT = "  ";
        out.print("CachingProvider implementation: ");
        out.println(this.cachingProvider == null ? null : this.cachingProvider.getClass().getName());
        out.print("Supports store by reference? ");
        out.println(this.cachingProvider == null ? null : Boolean.valueOf(this.cachingProvider.isSupported(OptionalFeature.STORE_BY_REFERENCE)));
        out.println("Caching provider default properties:");
        if (this.cachingProvider != null && (props = this.cachingProvider.getDefaultProperties()) != null) {
            props.entrySet().forEach(prop -> out.println("  " + prop.getKey() + ": " + prop.getValue()));
        }
        out.print("Caching provider default class loader: ");
        out.println(this.cachingProvider == null ? null : this.cachingProvider.getDefaultClassLoader());
        out.println();
        out.print("CacheManager class loader: ");
        out.println(this.cacheManager == null ? null : this.cacheManager.getClassLoader());
        out.print("Cache manager URI: ");
        out.println(this.cacheManager == null ? null : this.cacheManager.getURI());
        out.print("Cache manager is closed? ");
        out.println(this.cacheManager == null ? null : Boolean.valueOf(this.cacheManager.isClosed()));
        out.println("Cache manager properties:");
        if (this.cacheManager != null && (props = this.cacheManager.getProperties()) != null) {
            props.entrySet().forEach(prop -> out.println("  " + prop.getKey() + ": " + prop.getValue()));
        }
        out.print("Cache manager: ");
        out.println(this.cacheManager);
        out.println();
        out.println("Cache names:");
        if (this.cacheManager != null) {
            AccessController.doPrivileged(() -> {
                TreeSet cacheNames = new TreeSet();
                this.cacheManager.getCacheNames().forEach(cacheNames::add);
                for (String cacheName : cacheNames) {
                    out.println("  " + cacheName);
                }
                for (String cacheName : cacheNames) {
                    Cache.Entry entry2;
                    Iterator it;
                    out.println();
                    boolean isMetaCache = cacheName.startsWith("com.ibm.ws.session.meta.");
                    boolean isAttrCache = cacheName.startsWith("com.ibm.ws.session.attr.");
                    out.println("Cache " + cacheName + ":");
                    Cache cache = isMetaCache ? this.cacheManager.getCache(cacheName, String.class, ArrayList.class) : (isAttrCache ? this.cacheManager.getCache(cacheName, String.class, byte[].class) : this.cacheManager.getCache(cacheName));
                    if (cache == null) continue;
                    boolean closed = cache.isClosed();
                    out.println("  closed? " + closed);
                    if (closed) continue;
                    try {
                        CompleteConfiguration config = (CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class);
                        out.println("  configuration " + config);
                        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                        ObjectName objectName = new ObjectName("javax.cache:type=CacheConfiguration,Cache=" + cacheName + ",*");
                        Set<ObjectName> objectNames = mbs.queryNames(objectName, null);
                        if (!objectNames.isEmpty()) {
                            CacheMXBean cacheMXBean = JMX.newMBeanProxy(mbs, objectNames.iterator().next(), CacheMXBean.class);
                            out.println("  is management enabled? " + cacheMXBean.isManagementEnabled());
                            out.println("  is statistics enabled? " + cacheMXBean.isStatisticsEnabled());
                            out.println("  is store by value? " + cacheMXBean.isStoreByValue());
                            out.println("  is read through? " + cacheMXBean.isReadThrough());
                            out.println("  is write through? " + cacheMXBean.isWriteThrough());
                        }
                        if (!(objectNames = mbs.queryNames(objectName = new ObjectName("javax.cache:type=CacheStatistics,Cache=" + cacheName + ",*"), null)).isEmpty()) {
                            CacheStatisticsMXBean statsMXBean = JMX.newMBeanProxy(mbs, objectNames.iterator().next(), CacheStatisticsMXBean.class);
                            out.println("  average get time:    " + (double)statsMXBean.getAverageGetTime() / 1000.0 + "ms");
                            out.println("  average put time:    " + (double)statsMXBean.getAveragePutTime() / 1000.0 + "ms");
                            out.println("  average remove time: " + (double)statsMXBean.getAverageRemoveTime() / 1000.0 + "ms");
                            out.println("  cache evictions: " + statsMXBean.getCacheEvictions());
                            out.println("  cache gets:      " + statsMXBean.getCacheGets());
                            out.println("  cache puts:      " + statsMXBean.getCachePuts());
                            out.println("  cache removals:  " + statsMXBean.getCacheRemovals());
                            out.println("  cache hits:      " + statsMXBean.getCacheHits());
                            out.println("  cache misses:    " + statsMXBean.getCacheMisses());
                            out.println("  cache hit percentage:  " + statsMXBean.getCacheHitPercentage() + '%');
                            out.println("  cache miss percentage: " + statsMXBean.getCacheMissPercentage() + '%');
                        }
                    }
                    catch (IllegalArgumentException config) {
                    }
                    catch (MalformedObjectNameException config) {
                        // empty catch block
                    }
                    if (isAttrCache) {
                        out.println("  First 100 entries:");
                        int i = 0;
                        it = cache.iterator();
                        while (i++ < 50 && it.hasNext()) {
                            try {
                                entry2 = (Cache.Entry)it.next();
                                if (entry2 == null) continue;
                                byte[] bytes = (byte[])entry2.getValue();
                                out.println("    session attribute " + entry2.getKey() + ": " + (bytes == null ? null : "byte[" + bytes.length + "]"));
                            }
                            catch (NoSuchElementException entry2) {}
                        }
                        continue;
                    }
                    if (!isMetaCache) continue;
                    out.println("  First 50 entries:");
                    int i = 0;
                    it = cache.iterator();
                    while (i++ < 50 && it.hasNext()) {
                        try {
                            entry2 = (Cache.Entry)it.next();
                            if (entry2 == null) continue;
                            out.println("    session " + entry2.getKey() + ": " + new SessionInfo((ArrayList)entry2.getValue()));
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                    }
                }
                return null;
            });
        }
    }

    public boolean isValid() {
        return true;
    }

    public void setCompletedPassivation(boolean isInProcessOfStopping) {
        this.completedPassivation = isInProcessOfStopping;
    }

    protected void setLibrary(Library library) {
        this.library = library;
    }

    protected void setMonitor(ServiceReference<?> ref) {
        this.monitorRef.set(ref);
        if (this.cacheManager != null) {
            AccessController.doPrivileged(() -> {
                for (String cacheName : this.cacheManager.getCacheNames()) {
                    this.configureMonitoring(cacheName);
                }
                return null;
            });
        }
    }

    protected void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    protected void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    protected void unsetLibrary(Library library) {
        this.library = null;
    }

    protected void unsetMonitor(ServiceReference<?> ref) {
        if (this.monitorRef.compareAndSet(ref, null) && this.cacheManager != null) {
            AccessController.doPrivileged(() -> {
                for (String cacheName : this.cacheManager.getCacheNames()) {
                    this.configureMonitoring(cacheName);
                }
                return null;
            });
        }
    }

    protected void unsetSerializationService(SerializationService serializationService) {
        this.serializationService = null;
    }

    protected void unsetUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = null;
    }
}

