/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.ASN1OctetString;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.DERGeneralizedTime;
import com.ibm.ws.transport.iiop.asn1.DERInteger;
import com.ibm.ws.transport.iiop.asn1.DERObjectIdentifier;
import com.ibm.ws.transport.iiop.asn1.DEROctetString;
import com.ibm.ws.transport.iiop.asn1.DERSequence;
import com.ibm.ws.transport.iiop.asn1.DERTaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERUTCTime;
import com.ibm.ws.transport.iiop.asn1.x509.AlgorithmIdentifier;
import com.ibm.ws.transport.iiop.asn1.x509.CRLReason;
import com.ibm.ws.transport.iiop.asn1.x509.TBSCertList;
import com.ibm.ws.transport.iiop.asn1.x509.Time;
import com.ibm.ws.transport.iiop.asn1.x509.X509Extension;
import com.ibm.ws.transport.iiop.asn1.x509.X509Extensions;
import com.ibm.ws.transport.iiop.asn1.x509.X509Name;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class V2TBSCertListGenerator {
    DERInteger version = new DERInteger(1);
    AlgorithmIdentifier signature;
    X509Name issuer;
    Time thisUpdate;
    Time nextUpdate = null;
    X509Extensions extensions = null;
    private Vector crlentries = null;
    static final long serialVersionUID = 5428356603003115704L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void setSignature(AlgorithmIdentifier signature) {
        this.signature = signature;
    }

    public void setIssuer(X509Name issuer) {
        this.issuer = issuer;
    }

    public void setThisUpdate(DERUTCTime thisUpdate) {
        this.thisUpdate = new Time(thisUpdate);
    }

    public void setNextUpdate(DERUTCTime nextUpdate) {
        this.nextUpdate = new Time(nextUpdate);
    }

    public void setThisUpdate(Time thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public void setNextUpdate(Time nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public void addCRLEntry(ASN1Sequence crlEntry) {
        if (this.crlentries == null) {
            this.crlentries = new Vector();
        }
        this.crlentries.addElement(crlEntry);
    }

    public void addCRLEntry(DERInteger userCertificate, DERUTCTime revocationDate, int reason) {
        this.addCRLEntry(userCertificate, new Time(revocationDate), reason);
    }

    public void addCRLEntry(DERInteger userCertificate, Time revocationDate, int reason) {
        this.addCRLEntry(userCertificate, revocationDate, reason, null);
    }

    /*
     * WARNING - void declaration
     */
    public void addCRLEntry(DERInteger userCertificate, Time revocationDate, int reason, DERGeneralizedTime invalidityDate) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(userCertificate);
        v.add(revocationDate);
        Vector<DERObjectIdentifier> extOids = new Vector<DERObjectIdentifier>();
        Vector<X509Extension> extValues = new Vector<X509Extension>();
        if (reason != 0) {
            CRLReason crlReason = new CRLReason(reason);
            try {
                extOids.addElement(X509Extensions.ReasonCode);
                extValues.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(crlReason.getEncoded())));
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.transport.iiop.asn1.x509.V2TBSCertListGenerator", (String)"141", (Object)this, (Object[])new Object[]{userCertificate, revocationDate, reason, invalidityDate});
                throw new IllegalArgumentException("error encoding reason: " + e.getMessage(), (Throwable)e);
            }
        }
        if (invalidityDate != null) {
            try {
                extOids.addElement(X509Extensions.InvalidityDate);
                extValues.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(invalidityDate.getEncoded())));
            }
            catch (IOException crlReason) {
                void e;
                FFDCFilter.processException((Throwable)crlReason, (String)"com.ibm.ws.transport.iiop.asn1.x509.V2TBSCertListGenerator", (String)"154", (Object)this, (Object[])new Object[]{userCertificate, revocationDate, reason, invalidityDate});
                throw new IllegalArgumentException("error encoding invalidityDate: " + e.getMessage(), (Throwable)e);
            }
        }
        if (extOids.size() != 0) {
            X509Extensions ex = new X509Extensions(extOids, extValues);
            v.add(ex);
        }
        if (this.crlentries == null) {
            this.crlentries = new Vector();
        }
        this.crlentries.addElement(new DERSequence(v));
    }

    public void setExtensions(X509Extensions extensions) {
        this.extensions = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.signature == null || this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.signature);
        v.add(this.issuer);
        v.add(this.thisUpdate);
        if (this.nextUpdate != null) {
            v.add(this.nextUpdate);
        }
        if (this.crlentries != null) {
            ASN1EncodableVector certs = new ASN1EncodableVector();
            Enumeration it = this.crlentries.elements();
            while (it.hasMoreElements()) {
                certs.add((ASN1Sequence)it.nextElement());
            }
            v.add(new DERSequence(certs));
        }
        if (this.extensions != null) {
            v.add(new DERTaggedObject(0, this.extensions));
        }
        return new TBSCertList(new DERSequence(v));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.asn1.x509.V2TBSCertListGenerator", V2TBSCertListGenerator.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

