/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.proxy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.proxy.JsonWebTokenUtil;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={MpJwtHelper.class}, name="MpJwtHelper", immediate=true, property={"service.vendor=IBM"})
public class MpJwtHelper {
    private static final TraceComponent tc = Tr.register(MpJwtHelper.class, null, null);
    static final String JSON_WEB_TOKEN_UTIL_REF = "JsonWebTokenUtil";
    protected static final AtomicServiceReference<JsonWebTokenUtil> JsonWebTokenUtilRef = new AtomicServiceReference("JsonWebTokenUtil");
    private static boolean isJdk18Up = JavaInfo.majorVersion() >= 8;
    static final long serialVersionUID = -4827362511432097575L;

    public MpJwtHelper() {
    }

    public MpJwtHelper(boolean isJdk18Up) {
        MpJwtHelper.isJdk18Up = isJdk18Up;
    }

    public static Principal getJsonWebTokenPricipal(Subject subject) {
        JsonWebTokenUtil jsonWebTokenUtil = MpJwtHelper.getJsonWebTokenUtil();
        if (jsonWebTokenUtil == null) {
            return null;
        }
        return jsonWebTokenUtil.getJsonWebTokenPrincipal(subject);
    }

    public static void addJsonWebToken(Subject subject, Hashtable<String, ?> customProperties, String key) {
        JsonWebTokenUtil jsonWebTokenUtil = MpJwtHelper.getJsonWebTokenUtil();
        if (jsonWebTokenUtil != null && customProperties != null) {
            jsonWebTokenUtil.addJsonWebToken(subject, customProperties, key);
        }
    }

    public static Principal cloneJsonWebToken(Subject subject) {
        JsonWebTokenUtil jsonWebTokenUtil = MpJwtHelper.getJsonWebTokenUtil();
        if (jsonWebTokenUtil != null) {
            return jsonWebTokenUtil.cloneJsonWebToken(subject);
        }
        return null;
    }

    public static Principal getJsonWebToken(String jwt, String type, String username) {
        JsonWebTokenUtil jsonWebTokenUtil = MpJwtHelper.getJsonWebTokenUtil();
        if (jsonWebTokenUtil != null) {
            return jsonWebTokenUtil.getJsonWebToken(jwt, type, username);
        }
        return null;
    }

    public static void addLoggedOutJwtToList(Principal p) {
        JsonWebTokenUtil jsonWebTokenUtil = MpJwtHelper.getJsonWebTokenUtil();
        if (jsonWebTokenUtil != null) {
            jsonWebTokenUtil.addLoggedOutJwtToList(p);
        }
    }

    private static JsonWebTokenUtil getJsonWebTokenUtil() {
        if (MpJwtHelper.isJavaVersionAtLeast18()) {
            return (JsonWebTokenUtil)JsonWebTokenUtilRef.getService();
        }
        return null;
    }

    public static boolean isMpJwtFeatureActive() {
        return MpJwtHelper.isJavaVersionAtLeast18() && JsonWebTokenUtilRef.getService() != null;
    }

    private static boolean isJavaVersionAtLeast18() {
        return isJdk18Up;
    }

    @Reference(service=JsonWebTokenUtil.class, name="JsonWebTokenUtil", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJsonWebTokenUtil(ServiceReference<JsonWebTokenUtil> ref) {
        if (MpJwtHelper.isJavaVersionAtLeast18()) {
            JsonWebTokenUtilRef.setReference(ref);
        }
    }

    protected void unsetJsonWebTokenUtil(ServiceReference<JsonWebTokenUtil> ref) {
        if (MpJwtHelper.isJavaVersionAtLeast18()) {
            JsonWebTokenUtilRef.unsetReference(ref);
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        if (MpJwtHelper.isJavaVersionAtLeast18()) {
            JsonWebTokenUtilRef.activate(cc);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"MpJwtHelper service is activated", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (MpJwtHelper.isJavaVersionAtLeast18()) {
            JsonWebTokenUtilRef.deactivate(cc);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"MpJwtHelper service is activated", (Object[])new Object[0]);
        }
    }
}

