/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.anno.util.internal.UtilImpl_Factory;
import com.ibm.ws.anno.util.internal.UtilImpl_InternMap;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.util.Util_BidirectionalMap;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UtilImpl_BidirectionalMap
implements Util_BidirectionalMap {
    private static final TraceComponent tc = Tr.register(UtilImpl_BidirectionalMap.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    public static final String CLASS_NAME = UtilImpl_BidirectionalMap.class.getName();
    protected final String hashText;
    protected final UtilImpl_Factory factory;
    protected final String holderTag;
    protected String heldTag;
    protected final UtilImpl_InternMap holderInternMap;
    protected UtilImpl_InternMap heldInternMap;
    protected final boolean isEnabled;
    protected Map<String, Set<String>> i_holderToHeldMap;
    protected Map<String, Set<String>> i_heldToHoldersMap;
    static final long serialVersionUID = -5120548021685902873L;

    @Override
    @Trivial
    public String getHashText() {
        return this.hashText;
    }

    protected UtilImpl_BidirectionalMap(UtilImpl_Factory factory, String holderTag, String heldTag, UtilImpl_InternMap holderInternMap, UtilImpl_InternMap heldInternMap) {
        this(factory, holderTag, heldTag, holderInternMap, heldInternMap, true);
    }

    protected UtilImpl_BidirectionalMap(UtilImpl_Factory factory, String holderTag, String heldTag, UtilImpl_InternMap holderInternMap, UtilImpl_InternMap heldInternMap, boolean isEnabled) {
        this.hashText = AnnotationServiceImpl_Logging.getBaseHash(this) + "(" + holderTag + " : " + heldTag + ", enabled='" + (isEnabled ? "true" : "false") + "')";
        this.factory = factory;
        this.holderTag = holderTag;
        this.heldTag = heldTag;
        this.holderInternMap = holderInternMap;
        this.heldInternMap = heldInternMap;
        this.isEnabled = isEnabled;
        this.i_holderToHeldMap = this.isEnabled ? new IdentityHashMap<String, Set<String>>() : null;
        this.i_heldToHoldersMap = this.isEnabled ? new IdentityHashMap<String, Set<String>>() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]", this.hashText), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public UtilImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    @Trivial
    public String getHolderTag() {
        return this.holderTag;
    }

    @Override
    @Trivial
    public String getHeldTag() {
        return this.heldTag;
    }

    @Override
    public UtilImpl_InternMap getHolderInternMap() {
        return this.holderInternMap;
    }

    @Override
    public boolean containsHolder(String holderName) {
        return this.getIsEnabled() && this.holderInternMap.contains(holderName);
    }

    protected String internHolder(String name, boolean doForce) {
        return this.holderInternMap.intern(name, doForce);
    }

    @Override
    public UtilImpl_InternMap getHeldInternMap() {
        return this.heldInternMap;
    }

    @Override
    public boolean containsHeld(String heldName) {
        return this.getIsEnabled() && this.heldInternMap.contains(heldName);
    }

    protected String internHeld(String name, boolean doForce) {
        return this.heldInternMap.intern(name, doForce);
    }

    @Override
    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    @Override
    @Trivial
    public Set<String> getHolderSet() {
        return this.getIsEnabled() ? this.i_holderToHeldMap.keySet() : Collections.emptySet();
    }

    @Override
    @Trivial
    public Set<String> getHeldSet() {
        return this.getIsEnabled() ? this.i_heldToHoldersMap.keySet() : Collections.emptySet();
    }

    @Override
    public boolean holds(String holderName, String heldName) {
        if (!this.getIsEnabled()) {
            return false;
        }
        String i_holderName = this.internHolder(holderName, false);
        if (i_holderName == null) {
            return false;
        }
        String i_heldName = this.internHeld(heldName, false);
        if (i_heldName == null) {
            return false;
        }
        Set<String> i_held = this.i_holderToHeldMap.get(i_holderName);
        return i_held == null ? false : i_held.contains(i_heldName);
    }

    @Override
    public Set<String> selectHeldOf(String holderName) {
        if (!this.getIsEnabled()) {
            return Collections.emptySet();
        }
        String i_holderName = this.internHolder(holderName, false);
        if (i_holderName == null) {
            return Collections.emptySet();
        }
        Set<String> i_held = this.i_holderToHeldMap.get(i_holderName);
        if (i_held == null) {
            return Collections.emptySet();
        }
        return i_held;
    }

    @Override
    public Set<String> selectHoldersOf(String heldName) {
        if (!this.getIsEnabled()) {
            return Collections.emptySet();
        }
        String i_heldName = this.internHeld(heldName, false);
        if (i_heldName == null) {
            return Collections.emptySet();
        }
        Set<String> i_holders = this.i_heldToHoldersMap.get(i_heldName);
        if (i_holders == null) {
            return Collections.emptySet();
        }
        return i_holders;
    }

    public boolean record(String holderName, String heldName) {
        return this.i_record(this.internHolder(holderName, true), this.internHeld(heldName, true));
    }

    public boolean i_record(String i_holderName, String i_heldName) {
        boolean addedHeldToHolder = this.i_recordHolderToHeld(i_holderName, i_heldName);
        boolean addedHolderToHeld = this.i_recordHeldToHolder(i_holderName, i_heldName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Holder [ {1} ] Held [ {2} ] [ {3} ]", this.getHashText(), i_holderName, i_heldName, addedHeldToHolder), (Object[])new Object[0]);
        }
        if (addedHeldToHolder != addedHolderToHeld) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_UTIL_MAPPING_INCONSISTENCY", (Object[])new Object[]{this.getHashText(), i_holderName, i_heldName, addedHeldToHolder, addedHolderToHeld});
        }
        return addedHeldToHolder;
    }

    protected boolean i_recordHolderToHeld(String i_holderName, String i_heldName) {
        Set<String> i_held = this.i_recordHolder(i_holderName);
        return i_held.add(i_heldName);
    }

    protected Set<String> i_recordHolder(String i_holderName) {
        Set<String> i_held = this.i_holderToHeldMap.get(i_holderName);
        if (i_held == null) {
            i_held = this.factory.createIdentityStringSet();
            this.i_holderToHeldMap.put(i_holderName, i_held);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Holder [ {1} ] Added", this.getHashText(), i_holderName), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Holder [ {1} ] Already present", this.getHashText(), i_holderName), (Object[])new Object[0]);
        }
        return i_held;
    }

    protected boolean i_recordHeldToHolder(String i_holderName, String i_heldName) {
        Set<String> i_holders = this.i_recordHeld(i_heldName);
        return i_holders.add(i_holderName);
    }

    protected Set<String> i_recordHeld(String i_heldName) {
        Set<String> i_holders = this.i_heldToHoldersMap.get(i_heldName);
        if (i_holders == null) {
            i_holders = this.factory.createIdentityStringSet();
            this.i_heldToHoldersMap.put(i_heldName, i_holders);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Held [ {1} ] Added", this.getHashText(), i_heldName), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Held [ {1} ] Already present", this.getHashText(), i_heldName), (Object[])new Object[0]);
        }
        return i_holders;
    }

    @Override
    @Trivial
    public void logState() {
        TraceComponent stateLogger = AnnotationServiceImpl_Logging.stateLogger;
        if (stateLogger.isDebugEnabled()) {
            this.log(stateLogger);
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent useTc) {
        Tr.debug((TraceComponent)useTc, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useTc, (String)MessageFormat.format("  Is Enabled [ {0} ]", this.getIsEnabled()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useTc, (String)MessageFormat.format("  Holder Tag [ {0} ]", this.getHolderTag()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useTc, (String)MessageFormat.format("  Held Tag   [ {0} ]", this.getHeldTag()), (Object[])new Object[0]);
        this.logHolderMap(useTc);
        this.logHeldMap(useTc);
        this.logInternMaps(useTc);
        Tr.debug((TraceComponent)useTc, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    @Trivial
    public void logHolderMap(TraceComponent logger) {
        if (!this.getIsEnabled()) {
            Tr.debug((TraceComponent)logger, (String)"Holder-to-held Map: NULL (disabled)", (Object[])new Object[0]);
            return;
        }
        Tr.debug((TraceComponent)logger, (String)"Holder-to-held Map: BEGIN", (Object[])new Object[0]);
        for (Map.Entry<String, Set<String>> i_holderEntry : this.i_holderToHeldMap.entrySet()) {
            String i_holderName = i_holderEntry.getKey();
            Set<String> i_held = i_holderEntry.getValue();
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Holder [ {0} ] Held [ {1} ]", i_holderName, i_held), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Holder-to-held Map: END", (Object[])new Object[0]);
    }

    @Trivial
    public void logHeldMap(TraceComponent useTc) {
        if (!this.getIsEnabled()) {
            Tr.debug((TraceComponent)useTc, (String)"Held-to-holder Map: NULL (disabled)", (Object[])new Object[0]);
            return;
        }
        Tr.debug((TraceComponent)useTc, (String)"Held-to-holder Map: BEGIN", (Object[])new Object[0]);
        for (Map.Entry<String, Set<String>> i_heldEntry : this.i_heldToHoldersMap.entrySet()) {
            String i_heldName = i_heldEntry.getKey();
            Set<String> i_holders = i_heldEntry.getValue();
            Tr.debug((TraceComponent)useTc, (String)MessageFormat.format("  Held [ {0} ] Holders [ {1} ]", i_heldName, i_holders), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)useTc, (String)"Held-to-holder Map: END", (Object[])new Object[0]);
    }

    @Trivial
    public void logInternMaps(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"Intern Maps: BEGIN", (Object[])new Object[0]);
        UtilImpl_InternMap useHolderMap = this.getHolderInternMap();
        if (useHolderMap == null) {
            Tr.debug((TraceComponent)logger, (String)"  Null holder intern map", (Object[])new Object[0]);
        } else {
            useHolderMap.log(logger);
        }
        UtilImpl_InternMap useHeldMap = this.getHeldInternMap();
        if (useHeldMap == null) {
            Tr.debug((TraceComponent)logger, (String)"  Null held intern map", (Object[])new Object[0]);
        } else {
            useHeldMap.log(logger);
        }
        Tr.debug((TraceComponent)logger, (String)"Intern Maps: END", (Object[])new Object[0]);
    }
}

