/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWTTokenValidationFailedException;
import java.util.List;

@TraceObjectField(fieldName="tcCommon", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class OidcCommonClientRequest {
    private static final TraceComponent tcCommon = Tr.register(OidcCommonClientRequest.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
    public static final String TYPE_ID_TOKEN = "ID Token";
    public static final String TYPE_JWT_TOKEN = "Json Web Token";
    public static final String TYPE_ACCESS_TOKEN = "Access Token";
    public static final String NO_TOKEN = "No Token";
    public static final String BAD_TOKEN_OR_KEY = "Bad Token Or Key";
    public static final String BAD_JDK = "Bad JDK";
    public static final String EXPIRED_TOKEN = "Expired Token";
    public static final String NO_KEY = "No Key";
    public static final String ALL_AUDIENCES = "ALL_AUDIENCES";
    protected boolean bInboundRequired = false;
    protected boolean bInboundSupported = false;
    private String headerFailMsg = "Bad Token Or Key";
    private String rsFailMsg = null;
    static final long serialVersionUID = -2045914175861541326L;

    public abstract String getTokenType();

    public abstract String getInboundPropagation();

    public boolean isInboundSupported() {
        return this.bInboundSupported;
    }

    public JWTTokenValidationFailedException errorCommon(boolean bTrError, TraceComponent tc, String[] msgCodes, Object[] objects) throws JWTTokenValidationFailedException {
        int msgIndex = 0;
        if (!TYPE_ID_TOKEN.equals(this.getTokenType())) {
            msgIndex = 1;
        }
        return this.errorCommon(bTrError, tc, msgCodes[msgIndex], objects);
    }

    public JWTTokenValidationFailedException errorCommon(boolean bTrError, TraceComponent tc, String msgCode, Object[] objects) throws JWTTokenValidationFailedException {
        if (bTrError && !this.bInboundSupported) {
            Tr.error((TraceComponent)tcCommon, (String)msgCode, (Object[])objects);
        }
        if (TYPE_ID_TOKEN.equals(this.getTokenType())) {
            return IDTokenValidationFailedException.format(tc, msgCode, objects);
        }
        return JWTTokenValidationFailedException.format(tc, msgCode, objects);
    }

    public void errorCommon(String[] msgCodes, Object[] objects) {
        int msgIndex = 0;
        if (!TYPE_ID_TOKEN.equals(this.getTokenType())) {
            msgIndex = 1;
        }
        if (!this.bInboundSupported) {
            Tr.error((TraceComponent)tcCommon, (String)msgCodes[msgIndex], (Object[])objects);
        }
    }

    public void errorCommon(String msgCode, Object[] objects) {
        if (!this.bInboundSupported) {
            Tr.error((TraceComponent)tcCommon, (String)msgCode, (Object[])objects);
        }
    }

    public String getHeaderFailMsg() {
        return this.headerFailMsg;
    }

    public String getRsFailMsg() {
        return this.rsFailMsg;
    }

    public void setRsFailMsg(String headerFailMsg, String rsFailMsg) {
        this.headerFailMsg = headerFailMsg;
        this.rsFailMsg = rsFailMsg;
    }

    public abstract List<String> getAudiences();

    public abstract boolean isPreServiceUrl(String var1);

    public abstract boolean allowedAllAudiences();

    public abstract boolean disableIssChecking();
}

