/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.acs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.acs.WebSSOConsumer;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.UserData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SolicitedHandler {
    private static TraceComponent tc = Tr.register(SolicitedHandler.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    HttpServletRequest request;
    HttpServletResponse response;
    SsoRequest samlRequest;
    Map<String, Object> parameters;
    SsoSamlService ssoService;
    static final long serialVersionUID = 7724746424100182037L;

    public SolicitedHandler(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest, Map<String, Object> parameters) {
        this.request = request;
        this.response = response;
        this.samlRequest = samlRequest;
        this.parameters = parameters;
        this.ssoService = (SsoSamlService)parameters.get(Constants.KEY_SAML_SERVICE);
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(String externalRelayState) throws SamlException {
        HttpRequestInfo requestInfo;
        Cache cache;
        BasicMessageContext<?, ?, ?> msgCtx;
        String rawSamlResponse = this.request.getParameter("SAMLResponse");
        if (rawSamlResponse != null) {
            String relayState = null;
            try {
                relayState = URLDecoder.decode(externalRelayState, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                void e;
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.acs.SolicitedHandler", (String)"71", (Object)this, (Object[])new Object[]{externalRelayState});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Internal error process SAML Web SSO Version 2.0 request", (Object[])new Object[]{e});
                }
                throw new SamlException((Exception)e);
            }
            msgCtx = WebSSOConsumer.getInstance().handleSAMLResponse(this.request, this.response, this.ssoService, relayState, this.samlRequest);
            cache = this.ssoService.getAcsCookieCache(this.samlRequest.getProviderName());
            requestInfo = msgCtx.getCachedRequestInfo();
            DateTime authnRequestExpiredTime = requestInfo.getBirthTime().plus(this.ssoService.getConfig().getAuthnRequestTime());
            if (authnRequestExpiredTime.isBeforeNow()) {
                throw new SamlException("SAML20_AUTHN_REQUEST_EXPIRED", null, new Object[]{new Date(requestInfo.getBirthTime().getMillis()), this.ssoService.getConfig().getAuthnRequestTime() / 60000L, new Date(authnRequestExpiredTime.getMillis()), new Date()});
            }
        } else {
            throw new SamlException("Cannot process the request because SAML Response from the IdP is missing", null, new Object[0]);
        }
        requestInfo.setWithFragmentUrl(this.request, this.response);
        this.redirectToRelayState(msgCtx, this.samlRequest.getProviderName(), cache, requestInfo);
    }

    protected void redirectToRelayState(BasicMessageContext<?, ?, ?> msgCtx, String providerName, Cache cache, HttpRequestInfo requestInfo) throws SamlException {
        String cacheId = SamlUtil.generateRandom();
        UserData data = msgCtx.getUserDataIfReady();
        cache.put(cacheId, (Object)data);
        requestInfo.redirectCachedHttpRequest(this.request, this.response, "WASSamlACS_" + SamlUtil.hash(providerName), cacheId);
    }
}

