/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.error.SamlException;
import java.io.File;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileInfo {
    private static TraceComponent tc = Tr.register(FileInfo.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    final File file;
    boolean bExists = false;
    long lLength = -1L;
    long lLastModified = -1L;
    String path = null;
    static final long serialVersionUID = 4152880713028698998L;

    private FileInfo(File file) {
        this.file = file;
    }

    /*
     * WARNING - void declaration
     */
    public static FileInfo getFileInfo(final File file) throws SamlException {
        FileInfo fileInfo = null;
        try {
            fileInfo = (FileInfo)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -5157432894947141715L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    FileInfo fileInfo = new FileInfo(file);
                    fileInfo.path = file.getPath();
                    fileInfo.bExists = file.exists();
                    fileInfo.lLength = file.length();
                    fileInfo.lLastModified = file.lastModified();
                    return fileInfo;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.saml.sso20.internal.utils.FileInfo$1", 1.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.FileInfo", (String)"56", null, (Object[])new Object[]{file});
            throw new SamlException("ACCESS_FILE_INFO_ERROR", e.getException(), new Object[]{file.getPath(), e.getMessage()});
        }
        return fileInfo;
    }

    public String getPath() {
        return this.path;
    }

    public boolean exists() {
        return this.bExists;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FileInfo) {
            boolean result;
            FileInfo newFileInfo = (FileInfo)obj;
            boolean bl = result = newFileInfo.file.equals(this.file) && newFileInfo.lLastModified == this.lLastModified && newFileInfo.lLength == this.lLength;
            if (!result && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Equals:" + newFileInfo.file.equals(this.file) + " " + (newFileInfo.lLastModified == this.lLastModified) + " " + (newFileInfo.lLength == this.lLength)), (Object[])new Object[0]);
            }
            return result;
        }
        return false;
    }

    public static String getHostName() {
        try {
            String hostName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -6906569196503410057L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    return InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.saml.sso20.internal.utils.FileInfo$2", 2.class, null, null);
                }
            });
            return hostName;
        }
        catch (PrivilegedActionException hostName) {
            FFDCFilter.processException((Throwable)hostName, (String)"com.ibm.ws.security.saml.sso20.internal.utils.FileInfo", (String)"110", null, (Object[])new Object[0]);
            return "localhost";
        }
    }
}

