/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.db;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OauthConsentStore;
import com.ibm.ws.security.oauth20.exception.OAuthDataException;
import com.ibm.ws.security.oauth20.plugins.db.DetectDatabaseType;
import com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DBConsentCache
extends OAuthJDBCImpl
implements OauthConsentStore {
    private static final TraceComponent tc = Tr.register(DBConsentCache.class, (String)"OAuth20Provider", null);
    private String TABLE_NAME = "OAuthDBSchema.OAUTH20CONSENTCACHE";
    private static final String INSERT_STMT = "INSERT INTO %s (CLIENTID,USERID,PROVIDERID,SCOPE,EXPIRES,EXTENDEDFIELDS) VALUES (?,?,?,?,?,?)";
    private static final String DELETE_STMT = "DELETE FROM %s WHERE CLIENTID = ? AND USERID = ? AND PROVIDERID = ? ";
    static final String CONFIG_CLEANUP_INTERVAL = "oauthjdbc.CleanupInterval";
    static final String CONFIG_CLEANUP_BATCH_SIZE = "oauthjdbc.CleanupBatchSize";
    int cleanupInterval = 0;
    int cleanupBatchSize = 250;
    protected String componentId;
    private String tokenCacheJndi;
    private DBVENDOR dbVendor = DBVENDOR.UNSPECIFIED;
    private final String MICROSOFT = "MICROSOFT";
    private final String DB2 = "DB2";
    private final String ORACLE = "ORACLE";
    private final String INFORMIX = "INFORMIX";
    private final String SYBASE = "ADAPTIVE SERVER";
    private ExecutorService executorService;
    Future cleanupThreadFuture;
    boolean cleanupThreadExitSemaphore = false;
    static final long serialVersionUID = -4423622914120303984L;

    public DBConsentCache() {
    }

    public DBConsentCache(String componentId, ExecutorService executorsvc, DataSource dataSource, String tableName, @Sensitive Object[] credentials, String tokenCacheJndi, int cleanupInterval, int cleanupBatchSize) {
        super(dataSource, credentials);
        this.componentId = componentId;
        this.TABLE_NAME = tableName;
        this.tokenCacheJndi = tokenCacheJndi == null || "".equals(tokenCacheJndi) ? "services/cache/OAuth20DBTokenCache" : tokenCacheJndi;
        this.executorService = executorsvc;
        this.cleanupInterval = cleanupInterval;
        this.cleanupBatchSize = cleanupBatchSize;
    }

    @Override
    public void initialize() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using cleanup interval: " + this.cleanupInterval + " cleanupBatchSize: " + this.cleanupBatchSize), (Object[])new Object[0]);
        }
        this.createCacheTable();
        this.startCleanupThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @FFDCIgnore(value={SQLException.class})
    private void createCacheTable() {
        block37: {
            boolean error;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block33: {
                connection = null;
                statement = null;
                resultSet = null;
                error = false;
                connection = this.getInitializedConnection();
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                String dbp = connection.getMetaData().getDatabaseProductName();
                if (dbp != null) {
                    if ((dbp = dbp.toUpperCase()).contains("MICROSOFT")) {
                        this.dbVendor = DBVENDOR.MICROSOFT;
                    } else if (dbp.contains("DB2")) {
                        this.dbVendor = DBVENDOR.DB2;
                    } else if (dbp.contains("ORACLE")) {
                        this.dbVendor = DBVENDOR.ORACLE;
                    } else if (dbp.contains("INFORMIX")) {
                        this.dbVendor = DBVENDOR.INFORMIX;
                    } else if (dbp.contains("ADAPTIVE SERVER")) {
                        this.dbVendor = DBVENDOR.SYBASE;
                    }
                }
                boolean tableExists = false;
                resultSet = connection.getMetaData().getTables(null, null, "%", null);
                while (resultSet.next()) {
                    String table_name = resultSet.getString(3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found table =" + table_name), (Object[])new Object[0]);
                    }
                    if (!"OAUTH20CONSENTCACHE".equalsIgnoreCase(table_name)) continue;
                    tableExists = true;
                    break;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("tableExists: " + tableExists), (Object[])new Object[0]);
                }
                if (!tableExists) {
                    String createTable = null;
                    createTable = this.dbVendor.equals((Object)DBVENDOR.ORACLE) ? "CREATE TABLE " + this.TABLE_NAME + " (" + "CLIENTID" + " VARCHAR(256), " + "USERID" + " VARCHAR(256), " + "PROVIDERID" + " VARCHAR(256), " + "SCOPE" + " VARCHAR(1024), " + "EXPIRES" + " NUMBER(19), " + "EXTENDEDFIELDS" + " CLOB )" : "CREATE TABLE " + this.TABLE_NAME + " (" + "CLIENTID" + " VARCHAR(256), " + "USERID" + " VARCHAR(256), " + "PROVIDERID" + " VARCHAR(256), " + "SCOPE" + " VARCHAR(1024), " + "EXPIRES" + " BIGINT, " + "EXTENDEDFIELDS" + " CLOB )";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createTable: " + createTable), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("database provider = " + dbp), (Object[])new Object[0]);
                    }
                    if (!dbp.equals("DB1234")) {
                        statement.executeUpdate(createTable);
                    }
                }
                if (statement == null) break block33;
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug((TraceComponent)tc, (String)"Failed to close JDBC Statement", (Object[])new Object[]{e.getMessage()});
                }
            }
            this.closeResultSet(resultSet);
            this.closeConnection(connection, error);
            break block37;
            catch (SQLException e) {
                block34: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to create JDBC Cache table", (Object[])new Object[]{e.getMessage()});
                    }
                    error = true;
                    if (statement == null) break block34;
                    try {
                        statement.close();
                    }
                    catch (SQLException e2) {
                        if (!tc.isDebugEnabled()) break block34;
                        Tr.debug((TraceComponent)tc, (String)"Failed to close JDBC Statement", (Object[])new Object[]{e2.getMessage()});
                    }
                }
                this.closeResultSet(resultSet);
                this.closeConnection(connection, error);
            }
            catch (OAuthDataException e2) {
                block35: {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"224", (Object)this, (Object[])new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to create JDBC Cache table", (Object[])new Object[]{e2.getMessage()});
                    }
                    error = true;
                    if (statement == null) break block35;
                    {
                        catch (Throwable throwable) {
                            block36: {
                                if (statement != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (SQLException e22) {
                                        if (!tc.isDebugEnabled()) break block36;
                                        Tr.debug((TraceComponent)tc, (String)"Failed to close JDBC Statement", (Object[])new Object[]{e22.getMessage()});
                                    }
                                }
                            }
                            this.closeResultSet(resultSet);
                            this.closeConnection(connection, error);
                            throw throwable;
                        }
                    }
                    try {
                        statement.close();
                    }
                    catch (SQLException e3) {
                        if (!tc.isDebugEnabled()) break block35;
                        Tr.debug((TraceComponent)tc, (String)"Failed to close JDBC Statement", (Object[])new Object[]{e3.getMessage()});
                    }
                }
                this.closeResultSet(resultSet);
                this.closeConnection(connection, error);
            }
        }
    }

    private Connection getInitializedConnection() throws OAuthDataException, SQLException {
        Connection conn = this.getDBConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleanupThread() {
        Class<DBConsentCache> clazz = DBConsentCache.class;
        synchronized (DBConsentCache.class) {
            if (this.cleanupInterval > 0 && this.cleanupThreadFuture == null) {
                this.cleanupThreadFuture = this.executorService.submit(new CleanupThread(this));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void stopCleanupThread() {
        if (this.cleanupThreadFuture != null) {
            this.cleanupThreadExitSemaphore = true;
            this.cleanupThreadFuture.cancel(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void closeStatement(Statement statement) {
        block3: {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    void e;
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"410", (Object)this, (Object[])new Object[]{statement});
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"Internal error closing SQL statement", (Object[])new Object[]{e});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    protected int getExpiredCount(long nowTime) {
        int result = -1;
        ResultSet queryResults = null;
        Statement st = null;
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Checking for expired with time: " + nowTime), (Object[])new Object[0]);
            }
            String query = "SELECT COUNT(*) AS \"TOTAL\" FROM " + this.TABLE_NAME + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ? ";
            st = conn.prepareStatement(query);
            st.setLong(1, nowTime);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                result = queryResults.getInt("TOTAL");
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Updated result to: " + result), (Object[])new Object[0]);
            }
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"441", (Object)this, (Object[])new Object[]{nowTime});
            Tr.error((TraceComponent)tc, (String)("Internal SQL error wile getting expired count: " + e.getMessage()), (Object[])new Object[]{e});
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e2222222222) {
                    FFDCFilter.processException((Throwable)e2222222222, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"452", (Object)this, (Object[])new Object[]{nowTime});
                    Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e2222222222.getMessage()), (Object[])new Object[]{e2222222222});
                }
            }
            this.closeConnection(conn, false);
        }
        catch (OAuthDataException e2) {
            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"444", (Object)this, (Object[])new Object[]{nowTime});
            Tr.error((TraceComponent)tc, (String)("Internal OAuth error wile getting expired count: " + e2.getMessage()), (Object[])new Object[]{e2});
            {
                catch (Throwable throwable) {
                    this.closeResultSet(queryResults);
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException sQLException) {
                            void e3;
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"452", (Object)this, (Object[])new Object[]{nowTime});
                            Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e3.getMessage()), (Object[])new Object[]{e3});
                        }
                    }
                    this.closeConnection(conn, false);
                    throw throwable;
                }
            }
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e4222222222) {
                    FFDCFilter.processException((Throwable)e4222222222, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"452", (Object)this, (Object[])new Object[]{nowTime});
                    Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e4222222222.getMessage()), (Object[])new Object[]{e4222222222});
                }
            }
            this.closeConnection(conn, false);
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException query) {
                void e;
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"452", (Object)this, (Object[])new Object[]{nowTime});
                Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
        this.closeConnection(conn, false);
        return result;
    }

    @Override
    @FFDCIgnore(value={NumberFormatException.class})
    public void init(OAuthComponentConfiguration config) {
        block4: {
            super.init(config);
            this.componentId = config.getUniqueId();
            this.TABLE_NAME = config.getConfigPropertyValue("oauthjdbc.token.table");
            this.cleanupInterval = config.getConfigPropertyIntValue(CONFIG_CLEANUP_INTERVAL);
            try {
                this.cleanupBatchSize = config.getConfigPropertyIntValue(CONFIG_CLEANUP_BATCH_SIZE);
            }
            catch (NumberFormatException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("No setting for oauthjdbc.CleanupBatchSize, using default cleanup batch size of: " + this.cleanupBatchSize), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using cleanup interval: " + this.cleanupInterval + " cleanupBatchSize: " + this.cleanupBatchSize), (Object[])new Object[0]);
        }
        this.startCleanupThread();
        String tokenCacheJndi = config.getConfigPropertyValue("oauth20.db.token.cache.jndi.tokens");
        if (tokenCacheJndi == null || "".equals(tokenCacheJndi)) {
            tokenCacheJndi = "services/cache/OAuth20DBTokenCache";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Connection conn, String clientId, String user, String scopeString, String resource, String providerId, long expires) throws Exception, SQLSyntaxErrorException {
        this.delete(conn, clientId, user, providerId);
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(String.format(INSERT_STMT, this.TABLE_NAME));
            st.setString(1, clientId);
            st.setString(2, user);
            st.setString(3, providerId);
            st.setString(4, scopeString);
            st.setLong(5, expires);
            JsonObject extendedFields = new JsonObject();
            if (resource != null) {
                extendedFields.addProperty("resource", resource);
            } else {
                extendedFields.addProperty("", "");
            }
            st.setString(6, extendedFields.toString());
            st.execute();
            this.closeStatement(st);
        }
        catch (Throwable throwable) {
            this.closeStatement(st);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void delete(Connection conn, String clientId, String user, String providerId) {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(String.format(DELETE_STMT, this.TABLE_NAME));
            st.setString(1, clientId);
            st.setString(2, user);
            st.setString(3, providerId);
            st.execute();
            this.closeStatement(st);
        }
        catch (Exception exception) {
            try {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"561", (Object)this, (Object[])new Object[]{conn, clientId, user, providerId});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception: " + e + " when attempting to delete consent cache entry prior to insert. Entry might not exist. Exception message: " + e.getMessage()), (Object[])new Object[0]);
                }
                this.closeStatement(st);
            }
            catch (Throwable throwable) {
                this.closeStatement(st);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean validateConsent(String clientId, String user, String providerId, String[] scopes, String resource) {
        boolean isValid;
        block8: {
            isValid = false;
            Connection conn = null;
            boolean error = false;
            ResultSet queryResults = null;
            try {
                conn = this.getDBConnection();
                conn.setAutoCommit(false);
                String query = "SELECT * FROM " + this.TABLE_NAME + " WHERE " + "CLIENTID" + " = ? AND " + "USERID" + " = ? AND " + "PROVIDERID" + " = ? ";
                PreparedStatement st = conn.prepareStatement(query);
                st.setString(1, clientId);
                st.setString(2, user);
                st.setString(3, providerId);
                queryResults = st.executeQuery();
                while (queryResults != null && !isValid && queryResults.next()) {
                    isValid = this.checkValidityAndScopeAndResource(queryResults, scopes, resource);
                }
                this.closeResultSet(queryResults);
            }
            catch (Exception query) {
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"611", (Object)this, (Object[])new Object[]{clientId, user, providerId, scopes, resource});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Cannot get consent entry from DB , ", (Object[])new Object[]{e.getMessage()});
                }
                error = true;
                break block8;
            }
            finally {
                this.closeResultSet(queryResults);
                this.closeConnection(conn, error);
            }
            this.closeConnection(conn, error);
        }
        if (isValid) {
            // empty if block
        }
        return isValid;
    }

    private boolean checkValidityAndScopeAndResource(ResultSet queryResults, String[] scopes2, String resource) throws SQLException {
        boolean isValid = true;
        String scopeStr = queryResults.getString("SCOPE");
        long expires = queryResults.getLong("EXPIRES");
        Date now = new Date();
        if (now.getTime() < expires) {
            for (String scope : scopes2) {
                if (scopeStr.contains(scope)) continue;
                isValid = false;
                break;
            }
        } else {
            isValid = false;
        }
        if (isValid) {
            JsonObject extendedFields = null;
            boolean gotData = false;
            if (this.getDBType() != null && this.getDBType().isClobSupported()) {
                Clob clob = queryResults.getClob("EXTENDEDFIELDS");
                if (clob != null) {
                    gotData = true;
                    extendedFields = new JsonParser().parse(clob.getCharacterStream()).getAsJsonObject();
                }
            } else {
                String strClob = queryResults.getString("EXTENDEDFIELDS");
                if (strClob != null) {
                    gotData = true;
                    extendedFields = new JsonParser().parse(strClob).getAsJsonObject();
                }
            }
            JsonPrimitive jPrimitive = null;
            if (gotData) {
                if (extendedFields != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Extended property value  =  ", (Object[])new Object[]{extendedFields.get("").getAsString()});
                    }
                    jPrimitive = extendedFields.getAsJsonPrimitive("resource");
                }
                if (jPrimitive != null && resource != null) {
                    JsonPrimitive jResource = new JsonPrimitive(resource);
                    isValid = jResource.equals((Object)jPrimitive);
                } else {
                    isValid = jPrimitive == null && resource == null;
                }
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void addConsent(String clientId, String user, String scopeString, String resource, String providerId, int keyLifeTimeInSeconds) {
        boolean error = true;
        Connection conn = null;
        long expires = 0L;
        if (keyLifeTimeInSeconds > 0) {
            expires = new Date().getTime() + 1000L * (long)keyLifeTimeInSeconds;
        }
        try {
            conn = this.getInitializedConnection();
            conn.setAutoCommit(false);
            this.add(conn, clientId, user, scopeString, resource, providerId, expires);
            error = false;
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            void sqle;
            FFDCFilter.processException((Throwable)sQLSyntaxErrorException, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"727", (Object)this, (Object[])new Object[]{clientId, user, scopeString, resource, providerId, keyLifeTimeInSeconds});
            Tr.error((TraceComponent)tc, (String)("Internal error adding consent entry: " + sqle.getMessage()), (Object[])new Object[]{sqle});
        }
        catch (Exception sqle) {
            void e;
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.DBConsentCache", (String)"729", (Object)this, (Object[])new Object[]{clientId, user, scopeString, resource, providerId, keyLifeTimeInSeconds});
            Tr.error((TraceComponent)tc, (String)("Internal error adding consent entry: " + e.getMessage()), (Object[])new Object[]{e});
        }
        finally {
            this.closeConnection(conn, error);
            if (tc.isDebugEnabled() && !error) {
                Tr.debug((TraceComponent)tc, (String)"entry added, details follow:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  table: " + this.TABLE_NAME), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  client id: " + clientId), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  user: " + user), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  scopes: " + scopeString), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  resource: " + resource), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  provider id: " + providerId), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  expires: " + expires), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    class CleanupThread
    extends Thread {
        final String MYCLASS = CleanupThread.class.getName();
        Logger _log = Logger.getLogger(this.MYCLASS);
        protected boolean fineLoggable;
        protected boolean finestLoggable;
        protected DBConsentCache _me;
        protected DetectDatabaseType.DBType databaseType = null;

        public CleanupThread(DBConsentCache me) {
            this._me = me;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @FFDCIgnore(value={OAuthDataException.class, InterruptedException.class})
        public void run() {
            String methodName = "run";
            this._log.entering(this.MYCLASS, methodName);
            Connection connCheck = null;
            try {
                connCheck = this._me.getDBConnection();
                this.databaseType = DetectDatabaseType.DetectionUtils.detectDbType(connCheck);
            }
            catch (OAuthDataException e) {
                this._log.logp(Level.SEVERE, OAuthJDBCImpl.CLASS, methodName, e.getMessage(), e);
                return;
            }
            finally {
                block17: {
                    try {
                        if (connCheck != null && !connCheck.isClosed()) {
                            connCheck.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!this.finestLoggable) break block17;
                        this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Unable to close connection.");
                    }
                }
            }
            while (true) {
                block18: {
                    try {
                        CleanupThread.sleep(this._me.cleanupInterval * 1000);
                    }
                    catch (InterruptedException e) {
                        if (!this.finestLoggable) break block18;
                        this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Cleanup thread was interrupted");
                    }
                }
                if (this._me.cleanupThreadExitSemaphore) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"cleanup thread exiting because exit semaphore is true", (Object[])new Object[0]);
                    break;
                }
                this.runCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void runCleanup() {
            String methodName = "runCleanup";
            this._log.entering(this.MYCLASS, methodName);
            Date now = new Date();
            long nowTime = now.getTime();
            int expiredCount = DBConsentCache.this.getExpiredCount(nowTime);
            if (this.fineLoggable) {
                this._log.logp(Level.FINEST, this.MYCLASS, methodName, "About to delete all tokens with expiry <= " + nowTime);
                this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Number of expired tokens in the DB: " + expiredCount);
            }
            if (expiredCount > 10000) {
                String msg = expiredCount + " expired tokens to delete. Consider increasing OAuth provider cleanup interval";
                this._log.logp(Level.WARNING, this.MYCLASS, methodName, msg);
            }
            boolean error = false;
            Connection conn = null;
            int numDeleted = 0;
            while (expiredCount > 0 && numDeleted < expiredCount) {
                PreparedStatement st = null;
                try {
                    String delete;
                    conn = this._me.getDBConnection();
                    conn.setAutoCommit(false);
                    if (DetectDatabaseType.DBType.DB2 == this.databaseType) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Running cleanup with LIMIT in DB2", (Object[])new Object[0]);
                        }
                        delete = "DELETE FROM (SELECT EXPIRES FROM " + DBConsentCache.this.TABLE_NAME + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ?  ORDER BY " + "EXPIRES" + " FETCH FIRST " + DBConsentCache.this.cleanupBatchSize + " ROWS ONLY)";
                        numDeleted += DBConsentCache.this.cleanupBatchSize;
                    } else if (this.databaseType.isSqlLimitSupported()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Running cleanup with LIMIT", (Object[])new Object[0]);
                        }
                        delete = "DELETE FROM " + DBConsentCache.this.TABLE_NAME + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ? LIMIT " + DBConsentCache.this.cleanupBatchSize;
                        numDeleted += DBConsentCache.this.cleanupBatchSize;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Running cleanup without LIMIT", (Object[])new Object[0]);
                        }
                        delete = "DELETE FROM " + DBConsentCache.this.TABLE_NAME + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ?";
                        numDeleted += expiredCount;
                    }
                    st = conn.prepareStatement(delete);
                    st.setLong(1, nowTime);
                    st.execute();
                    DBConsentCache.this.closeStatement(st);
                }
                catch (SQLException syne) {
                    this.databaseType = DetectDatabaseType.DBType.UNKNOWN;
                    this._log.logp(Level.WARNING, OAuthJDBCImpl.CLASS, methodName, syne.getMessage(), syne);
                    this._log.logp(Level.FINE, this.MYCLASS, methodName, "SQL error, switching off LIMIT");
                    continue;
                }
                catch (Exception e) {
                    this._log.logp(Level.SEVERE, OAuthJDBCImpl.CLASS, methodName, e.getMessage(), e);
                    error = true;
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    DBConsentCache.this.closeStatement(st);
                    DBConsentCache.this.closeConnection(conn, error);
                    continue;
                }
                DBConsentCache.this.closeConnection(conn, error);
            }
        }
    }

    public static enum DBVENDOR {
        UNSPECIFIED,
        DB2,
        MICROSOFT,
        ORACLE,
        INFORMIX,
        SYBASE;

    }
}

