/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.AccessLists;
import com.ibm.ws.tcpchannel.internal.ChannelTermination;
import com.ibm.ws.tcpchannel.internal.ConnectionManager;
import com.ibm.ws.tcpchannel.internal.NBAccept;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPChannelFactory;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPPort;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.DiscriminationProcess;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.InboundChannel;
import com.ibm.wsspi.channelfw.OutboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.RetryableChannelException;
import com.ibm.wsspi.connmgmt.ConnectionHandle;
import com.ibm.wsspi.connmgmt.ConnectionType;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class TCPChannel
implements InboundChannel,
OutboundChannel,
FFDCSelfIntrospectable {
    protected static volatile NBAccept acceptReqProcessor = null;
    private String channelName = null;
    protected String externalName = null;
    private ChannelData channelData;
    protected TCPChannelConfiguration config;
    protected ConnectionManager connectionManager = null;
    protected VirtualConnectionFactory vcFactory = null;
    private TCPPort endPoint = null;
    private DiscriminationProcess discriminationProcess = null;
    private long lastConnExceededTime = 0L;
    private AccessLists alists;
    private static final int SIZE_IN_USE = 128;
    private final Queue<TCPConnLink>[] inUse = new ConcurrentLinkedQueue[128];
    private final AtomicInteger inUseIndex = new AtomicInteger(128);
    protected volatile boolean stopFlag = true;
    private boolean preparingToStop = false;
    private String displayableHostName = null;
    private static final TraceComponent tc = Tr.register(TCPChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected TCPChannelFactory channelFactory = null;
    private int connectionCount = 0;
    private final Object connectionCountSync = new Object(){};
    protected StatisticsLogger statLogger = null;
    protected final AtomicLong totalSyncReads = new AtomicLong(0L);
    protected final AtomicLong totalAsyncReads = new AtomicLong(0L);
    protected final AtomicLong totalAsyncReadRetries = new AtomicLong(0L);
    protected final AtomicLong totalPartialAsyncReads = new AtomicLong(0L);
    protected final AtomicLong totalPartialSyncReads = new AtomicLong(0L);
    protected final AtomicLong totalSyncWrites = new AtomicLong(0L);
    protected final AtomicLong totalAsyncWrites = new AtomicLong(0L);
    protected final AtomicLong totalAsyncWriteRetries = new AtomicLong(0L);
    protected final AtomicLong totalPartialAsyncWrites = new AtomicLong(0L);
    protected final AtomicLong totalPartialSyncWrites = new AtomicLong(0L);
    protected final AtomicLong totalConnections = new AtomicLong(0L);
    protected final AtomicLong maxConcurrentConnections = new AtomicLong(0L);
    private static boolean checkStartup = true;

    public void setup(ChannelData runtimeConfig, TCPChannelConfiguration tcpConfig) throws ChannelException {
        this.setup(runtimeConfig, tcpConfig, null);
    }

    public ChannelTermination setup(ChannelData runtimeConfig, TCPChannelConfiguration tcpConfig, TCPChannelFactory factory) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setup", (Object[])new Object[0]);
        }
        this.channelFactory = factory;
        this.channelData = runtimeConfig;
        this.channelName = runtimeConfig.getName();
        this.externalName = runtimeConfig.getExternalName();
        this.config = tcpConfig;
        for (int i = 0; i < this.inUse.length; ++i) {
            this.inUse[i] = new ConcurrentLinkedQueue<TCPConnLink>();
        }
        this.vcFactory = ChannelFrameworkFactory.getChannelFramework().getInboundVCFactory();
        this.alists = AccessLists.getInstance(this.config);
        if (this.config.isInbound() && acceptReqProcessor == null) {
            acceptReqProcessor = new NBAccept(this.config);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setup");
        }
        return null;
    }

    protected AccessLists getAccessLists() {
        return this.alists;
    }

    protected boolean getStopFlag() {
        return this.stopFlag;
    }

    protected String getDisplayableHostName() {
        return this.displayableHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementConnectionCount() {
        Object object = this.connectionCountSync;
        synchronized (object) {
            --this.connectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementConnectionCount() {
        Object object = this.connectionCountSync;
        synchronized (object) {
            ++this.connectionCount;
        }
        if (this.getConfig().getDumpStatsInterval() > 0) {
            this.totalConnections.incrementAndGet();
            long oldMax = this.maxConcurrentConnections.get();
            while ((long)this.connectionCount > oldMax) {
                this.maxConcurrentConnections.compareAndSet(oldMax, this.connectionCount);
                oldMax = this.maxConcurrentConnections.get();
            }
        }
    }

    protected int getInboundConnectionCount() {
        return this.connectionCount;
    }

    @Override
    public Class<?> getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    public TCPChannelConfiguration getConfig() {
        return this.config;
    }

    protected ConnectionManager getConnMgr() {
        return this.connectionManager;
    }

    @Override
    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnectionLink", (Object[])new Object[0]);
        }
        int index = (this.inUseIndex.getAndIncrement() % 128 + 128) % 128;
        TCPConnLink connLink = new TCPConnLink(vc, this, this.config, index);
        this.inUse[index].add(connLink);
        ConnectionType.setDefaultVCConnectionType(vc);
        ConnectionHandle.getConnectionHandle(vc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getConnectionLink: " + connLink));
        }
        return connLink;
    }

    protected abstract TCPReadRequestContextImpl createReadInterface(TCPConnLink var1);

    protected abstract TCPWriteRequestContextImpl createWriteInterface(TCPConnLink var1);

    @Override
    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[0]);
        }
        if (this.stopFlag) {
            this.stopFlag = false;
            if (this.config.isInbound()) {
                try {
                    if (null == this.endPoint.getServerSocket()) {
                        this.initializePort();
                    }
                    acceptReqProcessor.registerPort(this.endPoint);
                    this.preparingToStop = false;
                    String IPvType = "IPv4";
                    if (this.endPoint.getServerSocket().getInetAddress() instanceof Inet6Address) {
                        IPvType = "IPv6";
                    }
                    this.displayableHostName = this.config.getHostname() == null ? "*  (" + IPvType + ")" : this.endPoint.getServerSocket().getInetAddress().getHostName() + "  (" + IPvType + ": " + this.endPoint.getServerSocket().getInetAddress().getHostAddress() + ")";
                    Tr.info((TraceComponent)tc, (String)"TCP_CHANNEL_STARTED", (Object[])new Object[]{this.getExternalName(), this.displayableHostName, String.valueOf(this.endPoint.getListenPort())});
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".start"), (String)"100", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("TCP Channel: " + this.getExternalName() + "- Problem occurred while starting TCP Channel: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    ChannelException x = new ChannelException("TCP Channel: " + this.getExternalName() + "- Problem occurred while starting channel: " + e.getMessage());
                    this.stopFlag = true;
                    throw x;
                }
            }
            if (this.config.getDumpStatsInterval() > 0) {
                this.createStatisticsThread();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    @Override
    public void init() throws ChannelException {
        if (this.config.isInbound()) {
            this.endPoint = this.createEndPoint();
            this.initializePort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" listening port: " + this.endPoint.getListenPort()), (Object[])new Object[0]);
            }
        }
    }

    private void initializePort() throws ChannelException {
        try {
            this.endPoint.initServerSocket();
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("TCP Channel: " + this.getExternalName() + "- Problem occurred while initializing TCP Channel: " + ioe.getMessage()), (Object[])new Object[0]);
            }
            throw new ChannelException("TCP Channel: " + this.getExternalName() + "- Problem occurred while starting channel: " + ioe.getMessage());
        }
        catch (RetryableChannelException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("TCP Channel: " + this.getExternalName() + "- Problem occurred while starting TCP Channel: " + e.getMessage()), (Object[])new Object[0]);
            }
            throw e;
        }
        this.channelData.getPropertyBag().put("listeningPort", String.valueOf(this.endPoint.getListenPort()));
    }

    public TCPPort createEndPoint() throws ChannelException {
        return new TCPPort(this, this.vcFactory);
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroy " + this.getExternalName()), (Object[])new Object[0]);
        }
        if (this.endPoint != null) {
            this.endPoint.destroyServerSocket();
        }
        if (null != this.channelFactory) {
            this.channelFactory.removeChannel(this.channelName);
        }
    }

    @Override
    public Discriminator getDiscriminator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"getDiscriminator called erroneously on TCPChannel", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public void stop(long millisec) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stop (" + millisec + ") " + this.getExternalName()), (Object[])new Object[0]);
        }
        if (!this.preparingToStop && acceptReqProcessor != null && this.config.isInbound()) {
            acceptReqProcessor.removePort(this.endPoint);
            this.endPoint.destroyServerSocket();
            Tr.info((TraceComponent)tc, (String)"TCP_CHANNEL_STOPPED", (Object[])new Object[]{this.getExternalName(), this.displayableHostName, String.valueOf(this.endPoint.getListenPort())});
            this.preparingToStop = true;
        }
        if (millisec == 0L) {
            this.preparingToStop = false;
            this.stopFlag = true;
            this.destroyConnLinks();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    @Override
    public String getName() {
        return this.channelName;
    }

    @Override
    public Class<?> getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    @Override
    public Class<?> getDeviceInterface() {
        return null;
    }

    @Override
    public DiscriminationProcess getDiscriminationProcess() {
        return this.discriminationProcess;
    }

    @Override
    public void setDiscriminationProcess(DiscriminationProcess dp) {
        this.discriminationProcess = dp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ChannelData cc) {
        TCPChannel tCPChannel = this;
        synchronized (tCPChannel) {
            if (this.config.checkAndSetValues(cc)) {
                this.alists = AccessLists.getInstance(this.config);
            }
        }
    }

    public String[] introspectSelf() {
        String[] configFFDC = this.getConfig().introspectSelf();
        String[] rc = new String[1 + configFFDC.length];
        rc[0] = "TCP Channel: " + this.getExternalName();
        System.arraycopy(configFFDC, 0, rc, 1, configFFDC.length);
        return rc;
    }

    @Override
    public Class<?> getDeviceAddress() {
        throw new IllegalStateException("Not implemented and should not be");
    }

    @Override
    public Class<?>[] getApplicationAddress() {
        return new Class[]{TCPConnectRequestContext.class};
    }

    private synchronized void destroyConnLinks() {
        for (Queue<TCPConnLink> queue : this.inUse) {
            try {
                TCPConnLink tcl = queue.poll();
                while (tcl != null) {
                    tcl.close(tcl.getVirtualConnection(), null);
                    tcl = queue.poll();
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"destroyConnLinks", (Object[])new Object[]{this});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Error closing connection: " + t + " " + queue), (Object[])new Object[0]);
            }
        }
    }

    protected void releaseConnectionLink(TCPConnLink conn, int index) {
        this.inUse[index].remove(conn);
    }

    protected VirtualConnectionFactory getVcFactory() {
        return this.vcFactory;
    }

    public String getExternalName() {
        return this.externalName;
    }

    protected long getLastConnExceededTime() {
        return this.lastConnExceededTime;
    }

    protected void setLastConnExceededTime(long lastConnExceededTime) {
        this.lastConnExceededTime = lastConnExceededTime;
    }

    protected boolean verifyConnection(Socket socket) {
        if (this.config.getWaitToAccept() && checkStartup) {
            if (!CHFWBundle.isServerCompletelyStarted()) {
                return false;
            }
            checkStartup = false;
        }
        if (this.alists != null && this.alists.accessDenied(socket.getInetAddress())) {
            return false;
        }
        int maxSocketsToUse = this.config.getMaxOpenConnections();
        if (this.getInboundConnectionCount() >= maxSocketsToUse) {
            long currentTime = System.currentTimeMillis();
            if (currentTime > this.getLastConnExceededTime() + 600000L) {
                Tr.warning((TraceComponent)tc, (String)"MAX_CONNS_EXCEEDED", (Object[])new Object[]{this.getExternalName(), maxSocketsToUse});
                this.setLastConnExceededTime(currentTime);
            }
            return false;
        }
        try {
            socket.setTcpNoDelay(this.config.getTcpNoDelay());
            if (this.config.getSoLinger() >= 0) {
                socket.setSoLinger(true, this.config.getSoLinger());
            } else {
                socket.setSoLinger(false, 0);
            }
            socket.setKeepAlive(this.config.getKeepAlive());
            if (this.config.getSendBufferSize() >= 4 && this.config.getSendBufferSize() <= 0x1000000) {
                socket.setSendBufferSize(this.config.getSendBufferSize());
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException caught while configuring socket: " + ioe), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected abstract SocketIOChannel createOutboundSocketIOChannel() throws IOException;

    protected abstract SocketIOChannel createInboundSocketIOChannel(SocketChannel var1) throws IOException;

    protected void createStatisticsThread() {
        this.statLogger = new StatisticsLogger();
        PrivilegedThreadStarter privThread = new PrivilegedThreadStarter();
        AccessController.doPrivileged(privThread);
    }

    protected void dumpStatistics() {
        if (this.getConfig().isInbound()) {
            System.out.println("Statistics for TCP inbound channel " + this.getExternalName() + " (port " + this.getConfig().getPort() + ")");
            System.out.println("   Total connections accepted: " + this.totalConnections);
        } else {
            System.out.println("Statistics for TCP outbound channel " + this.getExternalName());
            System.out.println("   Total connects processed: " + this.totalConnections);
        }
        System.out.println("   Maximum concurrent connections: " + this.maxConcurrentConnections);
        System.out.println("   Current connection count: " + this.connectionCount);
        System.out.println("   Total Async read requests: " + this.totalAsyncReads.get());
        System.out.println("   Total Async read retries: " + this.totalAsyncReadRetries.get());
        System.out.println("   Total Async read partial reads: " + this.totalPartialAsyncReads.get());
        System.out.println("   Total Sync read requests: " + this.totalSyncReads.get());
        System.out.println("   Total Sync read partial reads: " + this.totalPartialSyncReads.get());
        System.out.println("   Total Async write requests: " + this.totalAsyncWrites.get());
        System.out.println("   Total Async write retries: " + this.totalAsyncWriteRetries.get());
        System.out.println("   Total Async write partial writes: " + this.totalPartialAsyncWrites.get());
        System.out.println("   Total Sync write requests: " + this.totalSyncWrites.get());
        System.out.println("   Total Sync write partial writes: " + this.totalPartialSyncWrites.get());
    }

    class PrivilegedThreadStarter
    implements PrivilegedAction<Object> {
        @Override
        public Object run() {
            String threadName = "Statistics Logging Thread for: " + TCPChannel.this.getExternalName();
            Thread t = new Thread(TCPChannel.this.statLogger);
            t.setName(threadName);
            t.setDaemon(false);
            t.start();
            return null;
        }
    }

    class StatisticsLogger
    implements Runnable {
        @Override
        public void run() {
            TCPChannel channel = TCPChannel.this;
            boolean interrupted = false;
            if (channel.getConfig().isInbound()) {
                System.out.println("Statistics logging for TCP inbound channel " + channel.externalName + " (port " + channel.getConfig().getPort() + ") is now on");
            } else {
                System.out.println("Statistics logging for TCP outbound channel " + channel.externalName + " is now on");
            }
            while (!channel.getStopFlag() && !interrupted) {
                try {
                    Thread.sleep((long)channel.getConfig().getDumpStatsInterval() * 1000L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                channel.dumpStatistics();
            }
            System.out.println(" stat thread exiting");
        }
    }
}

