/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.cdi.FTEnablementConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.FTUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractFTEnablementConfig
implements FTEnablementConfig {
    private static final TraceComponent tc = Tr.register(AbstractFTEnablementConfig.class);
    private final Map<ClassLoader, Set<Class<?>>> activeAnnotationsCache = new WeakHashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Set<Class<?>> ONLY_FALLBACK = Collections.singleton(Fallback.class);
    protected static final Set<Class<?>> ALL_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Asynchronous.class, CircuitBreaker.class, Retry.class, Timeout.class, Bulkhead.class, Fallback.class)));
    private static final String CONFIG_NONFALLBACK_ENABLED = "MP_Fault_Tolerance_NonFallback_Enabled";
    static final long serialVersionUID = 3693881748482783420L;

    @Override
    public boolean isFaultTolerance(Annotation ann) {
        return ALL_ANNOTATIONS.contains(ann.annotationType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Class<?>> getActiveAnnotations(Class<?> clazz) {
        Set<Class<?>> activeAnnotations;
        block10: {
            ClassLoader cl = FTUtils.getClassLoader(clazz);
            activeAnnotations = null;
            this.lock.readLock().lock();
            try {
                activeAnnotations = this.activeAnnotationsCache.get(cl);
                if (activeAnnotations != null) break block10;
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    activeAnnotations = this.activeAnnotationsCache.get(cl);
                    if (activeAnnotations == null) {
                        Config mpConfig = ConfigProvider.getConfig((ClassLoader)cl);
                        boolean allAnnotationsEnabled = mpConfig.getOptionalValue(CONFIG_NONFALLBACK_ENABLED, Boolean.TYPE).orElse(true);
                        if (allAnnotationsEnabled) {
                            activeAnnotations = ALL_ANNOTATIONS;
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"All annotations except Fallback are disabled", (Object[])new Object[0]);
                            }
                            activeAnnotations = ONLY_FALLBACK;
                        }
                        this.activeAnnotationsCache.put(cl, activeAnnotations);
                    }
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return activeAnnotations;
    }
}

