/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.faulttolerance.cdi.FTUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AbstractAnnotationConfig<T extends Annotation> {
    private static final TraceComponent tc = Tr.register(AbstractAnnotationConfig.class);
    private final Class<T> annotationType;
    private final String keyPrefix;
    private final T annotation;
    private final Class<?> annotatedClass;
    private final String targetName;
    private final Method annotatedMethod;
    static final long serialVersionUID = -8823872390610141975L;

    public AbstractAnnotationConfig(Class<?> annotatedClass, T annotation, Class<T> annotationType) {
        this(null, annotatedClass, annotation, annotationType);
    }

    public AbstractAnnotationConfig(Method annotatedMethod, Class<?> annotatedClass, T annotation, Class<T> annotationType) {
        this.annotationType = annotationType;
        if (annotatedMethod == null) {
            this.keyPrefix = AbstractAnnotationConfig.getPropertyKeyPrefix(annotatedClass);
            this.targetName = annotatedClass.getName();
        } else {
            this.keyPrefix = AbstractAnnotationConfig.getPropertyKeyPrefix(annotatedMethod);
            this.targetName = annotatedClass.getName() + "." + annotatedMethod.getName();
        }
        this.annotation = annotation;
        this.annotatedClass = annotatedClass;
        this.annotatedMethod = annotatedMethod;
    }

    protected <S> AnnotationParameterConfig<S> getParameterConfig(String name, Class<S> type) {
        AnnotationParameterConfig parameterConfig = new AnnotationParameterConfig(name, type);
        parameterConfig.init(this.annotation);
        return parameterConfig;
    }

    protected <S> AnnotationParameterConfig<Class<? extends S>> getParameterConfigClass(String name, Class<S> type) {
        AnnotationParameterConfigClass parameterConfig = new AnnotationParameterConfigClass(name, type);
        ((AnnotationParameterConfig)parameterConfig).init(this.annotation);
        return parameterConfig;
    }

    protected <S> AnnotationParameterConfig<Class<? extends S>[]> getParameterConfigClassArray(String name, Class<S> type) {
        AnnotationParameterConfigClassArray parameterConfig = new AnnotationParameterConfigClassArray(name, type);
        ((AnnotationParameterConfig)parameterConfig).init(this.annotation);
        return parameterConfig;
    }

    public Class<T> annotationType() {
        return this.annotationType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    private String getPropertyKey(String prefix, String parameter) {
        String key = prefix + this.annotationType.getSimpleName() + "/" + parameter;
        return key;
    }

    private static String getPropertyKeyPrefix(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        clazz = FTUtils.getRealClass(clazz);
        String key = clazz.getName() + "/" + method.getName() + "/";
        return key;
    }

    private static String getPropertyKeyPrefix(Class<?> clazz) {
        clazz = FTUtils.getRealClass(clazz);
        String key = clazz.getName() + "/";
        return key;
    }

    public Class<?> getAnnotatedClass() {
        return this.annotatedClass;
    }

    public Method getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    public void validate() {
    }

    private ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader classloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -3040869896592162965L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return AbstractAnnotationConfig.this.annotatedClass.getClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return classloader;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AnnotationParameterConfigClassArray<S>
    extends AnnotationParameterConfig<Class<? extends S>[]> {
        private final Class<S> parameterClass;
        static final long serialVersionUID = 2550892822574962949L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AnnotationParameterConfigClassArray(String parameterName, Class<S> parameterClass) {
            super(parameterName, Class[].class);
            this.parameterClass = parameterClass;
        }

        @Override
        public Class<? extends S>[] getConfigValue() {
            String[] configValue = this.readConfigValue(String[].class);
            Class[] result = null;
            if (configValue != null) {
                result = new Class[configValue.length];
                for (int i = 0; i < configValue.length; ++i) {
                    try {
                        result[i] = AbstractAnnotationConfig.this.getClassLoader(AbstractAnnotationConfig.this.annotatedClass).loadClass(configValue[i]);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.impl.AbstractAnnotationConfig$AnnotationParameterConfigClassArray", (String)"190", (Object)this, (Object[])new Object[0]);
                        throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"Cannot load class {0} specified in config for {1}", (Object[])new Object[]{configValue[i], AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)}));
                    }
                    if (this.parameterClass.isAssignableFrom(result[i])) continue;
                    throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"Class {0} cannot be assigned to type {1}, as specified in config for {2}", (Object[])new Object[]{configValue[i], this.parameterClass.getName(), AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)}));
                }
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AnnotationParameterConfigClassArray.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AnnotationParameterConfigClass<S>
    extends AnnotationParameterConfig<Class<? extends S>> {
        private final Class<S> parameterClass;
        static final long serialVersionUID = -828756032714599725L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AnnotationParameterConfigClass(String parameterName, Class<S> parameterClass) {
            super(parameterName, Class.class);
            this.parameterClass = parameterClass;
        }

        @Override
        public Class<? extends S> getConfigValue() {
            String configValue = this.readConfigValue(String.class);
            Class<?> result = null;
            if (configValue != null) {
                try {
                    result = AbstractAnnotationConfig.this.getClassLoader(AbstractAnnotationConfig.this.annotatedClass).loadClass(configValue);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.impl.AbstractAnnotationConfig$AnnotationParameterConfigClass", (String)"147", (Object)this, (Object[])new Object[0]);
                    throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"Cannot load class {0} specified in config for {1}", (Object[])new Object[]{configValue, AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)}));
                }
                if (!this.parameterClass.isAssignableFrom(result)) {
                    throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"Class {0} cannot be assigned to type {1}, as specified in config for {2}", (Object[])new Object[]{configValue, this.parameterClass.getName(), AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)}));
                }
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AnnotationParameterConfigClass.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AnnotationParameterConfig<S> {
        protected S parameterValue = null;
        protected final String parameterName;
        protected final Class<S> parameterType;
        static final long serialVersionUID = -2448573431732857293L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AnnotationParameterConfig(String parameterName, Class<S> parameterType) {
            this.parameterType = parameterType;
            this.parameterName = parameterName;
        }

        private void init(final T annotation) {
            S configValue = this.getConfigValue();
            if (configValue != null) {
                this.parameterValue = configValue;
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = -8737297507648533613L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Void run() {
                        try {
                            Method m = AbstractAnnotationConfig.this.annotationType.getDeclaredMethod(AnnotationParameterConfig.this.parameterName, new Class[0]);
                            AnnotationParameterConfig.this.parameterValue = AnnotationParameterConfig.this.parameterType.cast(m.invoke((Object)annotation, new Object[0]));
                            return null;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException m) {
                            void e;
                            FFDCFilter.processException((Throwable)m, (String)"com.ibm.ws.microprofile.faulttolerance.cdi.config.impl.AbstractAnnotationConfig$AnnotationParameterConfig$1", (String)"80", (Object)this, (Object[])new Object[0]);
                            throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT5997E", (Object[])new Object[]{e}), (Throwable)e);
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            }
        }

        public S getValue() {
            return this.parameterValue;
        }

        public S getConfigValue() {
            return this.readConfigValue(this.parameterType);
        }

        public <P> P readConfigValue(Class<P> type) {
            String key;
            Config mpConfig = ConfigProvider.getConfig((ClassLoader)AbstractAnnotationConfig.this.getClassLoader(AbstractAnnotationConfig.this.annotatedClass));
            Object configValue = mpConfig.getOptionalValue(key = AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName), type).orElse(null);
            if (configValue == null) {
                key = AbstractAnnotationConfig.this.getPropertyKey("", this.parameterName);
                configValue = mpConfig.getOptionalValue(key, type).orElse(null);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (configValue != null) {
                    Tr.debug((TraceComponent)tc, (String)("Found config value for " + AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)), (Object[])new Object[]{configValue});
                } else {
                    Tr.debug((TraceComponent)tc, (String)("No config value found for " + AbstractAnnotationConfig.this.getPropertyKey(AbstractAnnotationConfig.this.keyPrefix, this.parameterName)), (Object[])new Object[0]);
                }
            }
            return configValue;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AnnotationParameterConfig.class);
        }
    }
}

