/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.security.jwt.JwtBuilder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TokenBuilder {
    private static TraceComponent tc = Tr.register(TokenBuilder.class);
    protected static final String USER_CLAIM = "upn";
    protected static final String GROUP_CLAIM = "groups";
    protected static final String CCK_CLAIM = "sid";
    protected static final String APR_CLAIM = "apr";
    protected static final String REALM_CLAIM = "realm";
    private static final String GROUP_PREFIX = "group:";
    static final long serialVersionUID = -2997773681041647843L;

    public String createTokenString(JwtConfig config) {
        return this.createTokenString(config.getId());
    }

    public String createTokenString(String builderConfigId) {
        try {
            return this.createTokenString(builderConfigId, WSSubject.getRunAsSubject(), null, null);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.utils.TokenBuilder", (String)"82", (Object)this, (Object[])new Object[]{builderConfigId});
            return null;
        }
    }

    @Trivial
    private boolean isValidList(List<String> in) {
        return in != null && in.size() > 0;
    }

    public String getUserName(Subject subject) {
        try {
            WSCredential wsCred = this.getWSCredential(subject);
            if (wsCred == null) {
                wsCred = this.getPrivateWSCredential(subject);
            }
            return wsCred != null ? wsCred.getSecurityName() : null;
        }
        catch (Exception wsCred) {
            FFDCFilter.processException((Throwable)wsCred, (String)"com.ibm.ws.security.jwt.utils.TokenBuilder", (String)"108", (Object)this, (Object[])new Object[]{subject});
            return null;
        }
    }

    private WSCredential getPrivateWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPrivateCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }

    private ArrayList<String> getGroups(Subject subject) {
        try {
            WSCredential wsCred = this.getWSCredential(subject);
            if (wsCred == null) {
                wsCred = this.getPrivateWSCredential(subject);
            }
            if (wsCred != null) {
                ArrayList groupIds = wsCred.getGroupIds();
                ArrayList<String> groups = new ArrayList<String>();
                ListIterator it = groupIds.listIterator();
                while (it.hasNext()) {
                    int groupIndex;
                    String origGroup = (String)it.next();
                    if (origGroup != null && origGroup.startsWith(GROUP_PREFIX) && (groupIndex = origGroup.indexOf("/")) > 0) {
                        origGroup = origGroup.substring(groupIndex + 1);
                    }
                    groups.add(origGroup);
                }
                return groups;
            }
        }
        catch (Exception wsCred) {
            FFDCFilter.processException((Throwable)wsCred, (String)"com.ibm.ws.security.jwt.utils.TokenBuilder", (String)"150", (Object)this, (Object[])new Object[]{subject});
            return null;
        }
        return null;
    }

    private WSCredential getWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }

    /*
     * WARNING - void declaration
     */
    public String createTokenString(String builderId, Subject subject, String customCacheKey, String customAuthProvider) throws Exception {
        try {
            ArrayList<String> groups;
            JwtBuilder builder = JwtBuilder.create(builderId);
            String user = this.getUserName(subject);
            builder.subject(user);
            builder.claim(USER_CLAIM, user);
            String realm = this.getRealm(subject);
            if (realm != null) {
                builder.claim(REALM_CLAIM, realm);
            }
            if (this.isValidList(groups = this.getGroups(subject))) {
                builder.claim(GROUP_CLAIM, groups);
            }
            if (customCacheKey != null) {
                builder.claim(CCK_CLAIM, customCacheKey);
            }
            if (customAuthProvider != null) {
                builder.claim(APR_CLAIM, customAuthProvider);
            }
            return builder.buildJwt().compact();
        }
        catch (Exception builder) {
            void e;
            FFDCFilter.processException((Throwable)builder, (String)"com.ibm.ws.security.jwt.utils.TokenBuilder", (String)"197", (Object)this, (Object[])new Object[]{builderId, subject, customCacheKey, customAuthProvider});
            throw e;
        }
    }

    private String getRealm(Subject subject) {
        try {
            WSCredential wsCred = this.getWSCredential(subject);
            if (wsCred == null) {
                wsCred = this.getPrivateWSCredential(subject);
            }
            return wsCred != null ? wsCred.getRealmName() : null;
        }
        catch (Exception wsCred) {
            FFDCFilter.processException((Throwable)wsCred, (String)"com.ibm.ws.security.jwt.utils.TokenBuilder", (String)"210", (Object)this, (Object[])new Object[]{subject});
            return null;
        }
    }
}

