/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class RequestIdTable {
    private static final TraceComponent tc = SibTr.register(RequestIdTable.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private final HashMap<RequestIdTableEntry, RequestIdTableEntry> table;
    private RequestIdTableEntry testReqIdTableEntry = null;

    public RequestIdTable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.table = new HashMap();
        this.testReqIdTableEntry = new RequestIdTableEntry(0, null, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public synchronized void add(int requestId, ReceiveListener rl, SendListener s) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)new Object[]{"" + requestId, rl, s});
        }
        if (this.containsId(requestId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.debugTraceTable("id (" + requestId + ") already in table");
            }
            throw new SIErrorException(nls.getFormattedMessage("REQIDTABLE_INTERNAL_SICJ0058", null, "REQIDTABLE_INTERNAL_SICJ0058"));
        }
        RequestIdTableEntry newEntry = new RequestIdTableEntry(requestId, rl, s);
        this.table.put(newEntry, newEntry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    public synchronized void remove(int requestId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove");
        }
        if (!this.containsId(requestId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.debugTraceTable("id (" + requestId + ") not in table");
            }
            throw new SIErrorException(nls.getFormattedMessage("REQIDTABLE_INTERNAL_SICJ0058", null, "REQIDTABLE_INTERNAL_SICJ0058"));
        }
        this.testReqIdTableEntry.requestId = requestId;
        this.table.remove(this.testReqIdTableEntry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized SendListener getSendListener(int requestId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSendListener", (Object)("" + requestId));
        }
        if (!this.containsId(requestId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.debugTraceTable("id (" + requestId + ") not in table");
            }
            throw new SIErrorException(nls.getFormattedMessage("REQIDTABLE_INTERNAL_SICJ0058", null, "REQIDTABLE_INTERNAL_SICJ0058"));
        }
        this.testReqIdTableEntry.requestId = requestId;
        RequestIdTableEntry entry = this.table.get(this.testReqIdTableEntry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSendListener", (Object)entry.sendListener);
        }
        return entry.sendListener;
    }

    public synchronized ReceiveListener getListener(int requestId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getListener", (Object)("" + requestId));
        }
        if (!this.containsId(requestId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.debugTraceTable("id (" + requestId + ") not in table");
            }
            throw new SIErrorException(nls.getFormattedMessage("REQIDTABLE_INTERNAL_SICJ0058", null, "REQIDTABLE_INTERNAL_SICJ0058"));
        }
        this.testReqIdTableEntry.requestId = requestId;
        RequestIdTableEntry entry = this.table.get(this.testReqIdTableEntry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getListener", (Object)entry.receiveListener);
        }
        return entry.receiveListener;
    }

    public synchronized boolean containsId(int requestId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"containsId", (Object)("" + requestId));
        }
        this.testReqIdTableEntry.requestId = requestId;
        boolean result = this.table.containsKey(this.testReqIdTableEntry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"containsId", (Object)("" + result));
        }
        return result;
    }

    public synchronized Iterator receiveListenerIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveListenerIterator");
        }
        LinkedList<ReceiveListener> linkedList = new LinkedList<ReceiveListener>();
        for (RequestIdTableEntry tableEntry : this.table.values()) {
            if (tableEntry.receiveListener == null) continue;
            linkedList.add(tableEntry.receiveListener);
        }
        Iterator result = linkedList.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveListenerIterator", result);
        }
        return result;
    }

    public synchronized Iterator sendListenerIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendListenerIterator");
        }
        LinkedList<SendListener> linkedList = new LinkedList<SendListener>();
        for (RequestIdTableEntry tableEntry : this.table.values()) {
            if (tableEntry.sendListener == null) continue;
            linkedList.add(tableEntry.sendListener);
        }
        Iterator result = linkedList.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendListenerIterator", result);
        }
        return result;
    }

    public synchronized boolean hasReceiveListeners() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasReceiveListeners");
        }
        boolean returnValue = false;
        if (!this.table.values().isEmpty()) {
            returnValue = this.receiveListenerIterator().hasNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasReceiveListeners", (Object)("" + returnValue));
        }
        return returnValue;
    }

    public synchronized boolean hasSendListeners() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasSendListeners");
        }
        boolean returnValue = false;
        if (!this.table.values().isEmpty()) {
            returnValue = this.sendListenerIterator().hasNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasSendListeners", (Object)("" + returnValue));
        }
        return returnValue;
    }

    public synchronized Iterator idIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"idIterator");
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (RequestIdTableEntry tableEntry : this.table.values()) {
            linkedList.add(tableEntry.requestId);
        }
        Iterator result = linkedList.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"idIterator", result);
        }
        return result;
    }

    public synchronized void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clear");
        }
        this.table.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clear");
        }
    }

    private void debugTraceTable(String comment) {
        StringBuffer sb = new StringBuffer();
        sb.append("table:\n");
        Iterator<RequestIdTableEntry> keyIterator = this.table.keySet().iterator();
        if (!keyIterator.hasNext()) {
            sb.append("   <empty>\n");
        } else {
            while (keyIterator.hasNext()) {
                RequestIdTableEntry key = keyIterator.next();
                RequestIdTableEntry value = this.table.get(key);
                sb.append("   [key: " + key + "] -> [value: " + value + "]\n");
            }
        }
        SibTr.debug((Object)this, (TraceComponent)tc, (String)sb.toString());
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/RequestIdTable.java, SIB.comms, WASX.SIB, uu1215.01 1.16");
        }
    }

    private static class RequestIdTableEntry {
        public int requestId;
        public ReceiveListener receiveListener;
        public SendListener sendListener;

        public RequestIdTableEntry(int id, ReceiveListener listener, SendListener sl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"RequestIdTableEntry.<init>", (Object)new Object[]{"" + id, listener, sl});
            }
            this.requestId = id;
            this.receiveListener = listener;
            this.sendListener = sl;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"RequestIdTableEntry.<init>");
            }
        }

        public boolean equals(Object o) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"RequstIdTableEntry.equals", (Object)o);
            }
            boolean value = false;
            if (o instanceof RequestIdTableEntry) {
                boolean bl = value = ((RequestIdTableEntry)o).requestId == this.requestId;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"RequstIdTableEntry.equals", (Object)("" + value));
            }
            return value;
        }

        public int hashCode() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"RequstIdTableEntry.hashCode");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"RequstIdTableEntry.hashCode", (Object)("" + this.requestId));
            }
            return this.requestId;
        }

        public String toString() {
            return this.getClass() + "@" + System.identityHashCode(this) + " requestid:" + this.requestId + " receiveListener:" + this.receiveListener + " sendListener";
        }
    }
}

