/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.internal.ContextRootUtil;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.application.handler.DefaultApplicationMonitoringInformation;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class WARDeployedAppInfo
extends DeployedAppInfoBase {
    private static final String CONTEXT_ROOT = "context-root";
    private final SimpleDeployedAppInfoBase.WebModuleContainerInfo webContainerModuleInfo;
    private static final List<String> DYNAMIC_IMPORT_PACKAGE_LIST;
    static final long serialVersionUID = 6176035338244935179L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    WARDeployedAppInfo(ApplicationInformation<DeployedAppInfo> applicationInformation, DeployedAppServices deployedAppServices, ModuleHandler webModuleHandler) throws UnableToAdaptException {
        super(applicationInformation, deployedAppServices);
        String moduleURI = ModuleInfoUtils.getModuleURIFromLocation((String)applicationInformation.getLocation());
        String contextRoot = ContextRootUtil.getContextRoot((String)((String)applicationInformation.getConfigProperty(CONTEXT_ROOT)));
        if (contextRoot == null) {
            contextRoot = ContextRootUtil.getContextRoot((Container)this.getContainer());
        }
        this.webContainerModuleInfo = new SimpleDeployedAppInfoBase.WebModuleContainerInfo(webModuleHandler, deployedAppServices.getModuleMetaDataExtenders("web"), deployedAppServices.getNestedModuleMetaDataFactories("web"), applicationInformation.getContainer(), null, moduleURI, (ModuleClassLoaderFactory)this, this.moduleClassesInfo, contextRoot);
        this.moduleContainerInfos.add(this.webContainerModuleInfo);
    }

    public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
        if (moduleInfo instanceof WebModuleInfo) {
            ApplicationInfo appInfo = moduleInfo.getApplicationInfo();
            String j2eeAppName = appInfo.getDeploymentName();
            String j2eeModuleName = moduleInfo.getURI();
            ClassLoadingService cls = this.classLoadingService;
            ArrayList<Container> containers = new ArrayList<Container>();
            Iterator<ContainerInfo> infos = moduleClassesContainers.iterator();
            if (infos.hasNext()) {
                infos.next();
                while (infos.hasNext()) {
                    containers.add(infos.next().getContainer());
                }
                containers.add(moduleClassesContainers.get(0).getContainer());
            }
            GatewayConfiguration gwCfg = cls.createGatewayConfiguration().setApplicationName(j2eeAppName).setDynamicImportPackage(DYNAMIC_IMPORT_PACKAGE_LIST);
            ProtectionDomain protectionDomain = this.getProtectionDomain();
            ClassLoaderConfiguration clCfg = cls.createClassLoaderConfiguration().setId(cls.createIdentity("WebModule", j2eeAppName + "#" + j2eeModuleName)).setProtectionDomain(protectionDomain).setIncludeAppExtensions(true);
            return this.createTopLevelClassLoader(containers, gwCfg, clCfg);
        }
        return null;
    }

    protected ExtendedApplicationInfo createApplicationInfo() {
        ExtendedApplicationInfo appInfo = this.appInfoFactory.createApplicationInfo(this.getName(), this.webContainerModuleInfo.moduleName, this.getContainer(), (ApplicationClassesContainerInfo)this, this.getConfigHelper());
        this.webContainerModuleInfo.moduleName = appInfo.getName();
        this.webContainerModuleInfo.defaultContextRoot = this.getName();
        return appInfo;
    }

    public List<ModuleClassesContainerInfo> getModuleClassesContainerInfo() {
        return Collections.singletonList(this.webContainerModuleInfo);
    }

    public ApplicationMonitoringInformation createApplicationMonitoringInformation(Container originalContainer) {
        DefaultNotification webInfNotification = new DefaultNotification(this.applicationInformation.getContainer(), "/WEB-INF");
        DefaultNotification metaInfNotification = new DefaultNotification(this.applicationInformation.getContainer(), "/META-INF");
        HashSet<DefaultNotification> notifications = new HashSet<DefaultNotification>();
        notifications.add(webInfNotification);
        notifications.add(metaInfNotification);
        if (originalContainer != this.applicationInformation.getContainer()) {
            DefaultNotification oldWeb = new DefaultNotification(originalContainer, "/WEB-INF");
            DefaultNotification oldMeta = new DefaultNotification(originalContainer, "/META-INF");
            notifications.add(oldWeb);
            notifications.add(oldMeta);
        }
        return new DefaultApplicationMonitoringInformation(notifications, false);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WARDeployedAppInfo.class);
        DYNAMIC_IMPORT_PACKAGE_LIST = Collections.unmodifiableList(Arrays.asList("*"));
    }
}

