/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.ApplicationManager;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.war.internal.WARDeployedAppInfo;
import com.ibm.ws.app.manager.war.internal.ZipUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DeployedAppInfoFactory.class}, property={"service.vendor=IBM", "type:String=war"})
public class WARDeployedAppInfoFactoryImpl
implements DeployedAppInfoFactory {
    private static final TraceComponent tc = Tr.register(WARDeployedAppInfoFactoryImpl.class);
    @Reference
    protected DeployedAppServices deployedAppServices;
    @Reference(target="(type=web)")
    protected ModuleHandler webModuleHandler;
    @Reference
    protected ApplicationManager applicationManager;
    private final ZipUtils zipUtils = new ZipUtils();
    private static final Map<String, Long> timestamps = new HashMap<String, Long>();
    private static final Map<String, Long> expansionStamps = new HashMap<String, Long>(1);
    static final long serialVersionUID = -8959370670111799613L;

    protected void prepareExpansion() throws IOException {
        WsResource expansionResource = this.deployedAppServices.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/");
        expansionResource.create();
    }

    protected WsResource resolveExpansion(String appName) {
        return this.deployedAppServices.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/" + appName + ".war/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getUpdatedStamp(String absPath, File file) {
        Long newStamp;
        String methodName = "getUpdatedStamp";
        boolean doDebug = tc.isDebugEnabled();
        Long currentStamp = file.lastModified();
        String newStampReason = null;
        Map<String, Long> map = expansionStamps;
        synchronized (map) {
            Long priorStamp = expansionStamps.put(absPath, currentStamp);
            if (priorStamp == null) {
                newStamp = currentStamp;
                if (doDebug) {
                    newStampReason = "First extraction; stamp [ " + currentStamp + " ]";
                }
            } else if (currentStamp.longValue() != priorStamp.longValue()) {
                newStamp = currentStamp;
                if (doDebug) {
                    newStampReason = "Additional extraction; old stamp [ " + priorStamp + " ] new stamp [ " + currentStamp + " ]";
                }
            } else {
                newStamp = null;
                if (doDebug) {
                    newStampReason = "No extraction; stamp [ " + currentStamp + " ]";
                }
            }
        }
        if (doDebug) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": " + newStampReason), (Object[])new Object[0]);
        }
        return newStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearStamp(String absPath, File file) {
        Map<String, Long> map = expansionStamps;
        synchronized (map) {
            expansionStamps.remove(absPath);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void expand(String name, File collapsedFile, WsResource expandedResource, File expandedFile) throws IOException {
        String collapsedPath = collapsedFile.getAbsolutePath();
        Long updatedStamp = WARDeployedAppInfoFactoryImpl.getUpdatedStamp(collapsedPath, collapsedFile);
        if (updatedStamp == null) {
            return;
        }
        try {
            File failedDelete;
            if (expandedFile.exists() && (failedDelete = ZipUtils.deleteWithRetry(expandedFile)) != null) {
                if (failedDelete == expandedFile) {
                    throw new IOException("Failed to delete [ " + expandedFile.getAbsolutePath() + " ]");
                }
                throw new IOException("Failed to delete [ " + expandedFile.getAbsolutePath() + " ] because [ " + failedDelete.getAbsolutePath() + " ] could not be deleted.");
            }
            expandedResource.create();
            ZipUtils.unzip(collapsedFile, expandedFile, false, updatedStamp);
        }
        catch (IOException failedDelete) {
            void e;
            FFDCFilter.processException((Throwable)failedDelete, (String)"com.ibm.ws.app.manager.war.internal.WARDeployedAppInfoFactoryImpl", (String)"163", (Object)this, (Object[])new Object[]{name, collapsedFile, expandedResource, expandedFile});
            WARDeployedAppInfoFactoryImpl.clearStamp(collapsedPath, collapsedFile);
            throw e;
        }
    }

    private boolean isArchive(File file, String path) {
        if (path.toLowerCase().endsWith(".xml")) {
            return false;
        }
        return file.isFile();
    }

    /*
     * WARNING - void declaration
     */
    public WARDeployedAppInfo createDeployedAppInfo(ApplicationInformation<DeployedAppInfo> appInfo) throws UnableToAdaptException {
        String warPid = appInfo.getPid();
        String warName = appInfo.getName();
        String warPath = appInfo.getLocation();
        File warFile = new File(warPath);
        Tr.debug((TraceComponent)tc, (String)("Create deployed application: PID [ " + warPid + " ] Name [ " + warName + " ] Location [ " + warPath + " ]"), (Object[])new Object[0]);
        if (this.applicationManager.getExpandApps() && this.isArchive(warFile, warPath)) {
            try {
                this.prepareExpansion();
                WsResource expandedResource = this.resolveExpansion(warName);
                File expandedFile = expandedResource.asFile();
                this.expand(warName, warFile, expandedResource, expandedFile);
                Container expandedContainer = this.deployedAppServices.setupContainer(warPid, expandedFile);
                appInfo.setContainer(expandedContainer);
            }
            catch (IOException expandedResource) {
                void e;
                FFDCFilter.processException((Throwable)expandedResource, (String)"com.ibm.ws.app.manager.war.internal.WARDeployedAppInfoFactoryImpl", (String)"203", (Object)this, (Object[])new Object[]{appInfo});
                Tr.error((TraceComponent)tc, (String)"warning.could.not.expand.application", (Object[])new Object[]{warName, e.getMessage()});
            }
        }
        WARDeployedAppInfo deployedApp = new WARDeployedAppInfo(appInfo, this.deployedAppServices, this.webModuleHandler);
        appInfo.setHandlerInfo((Object)deployedApp);
        return deployedApp;
    }
}

