/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.security.internal;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditAuthResult;
import com.ibm.websphere.security.audit.AuditAuthenticationResult;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.container.service.metadata.ComponentMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.ejbcontainer.EJBComponentMetaData;
import com.ibm.ws.ejbcontainer.EJBMethodInterface;
import com.ibm.ws.ejbcontainer.EJBMethodMetaData;
import com.ibm.ws.ejbcontainer.EJBRequestData;
import com.ibm.ws.ejbcontainer.EJBSecurityCollaborator;
import com.ibm.ws.ejbcontainer.security.internal.EJBAccessDeniedException;
import com.ibm.ws.ejbcontainer.security.internal.EJBAuthorizationHelper;
import com.ibm.ws.ejbcontainer.security.internal.EJBSecurityConfig;
import com.ibm.ws.ejbcontainer.security.internal.EJBSecurityConfigImpl;
import com.ibm.ws.ejbcontainer.security.internal.SecurityCookieImpl;
import com.ibm.ws.ejbcontainer.security.internal.jacc.EJBJaccAuthorizationHelper;
import com.ibm.ws.ejbcontainer.security.internal.jacc.JaccUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authentication.principals.WSIdentity;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.authorization.jacc.JaccService;
import com.ibm.ws.security.collaborator.CollaboratorUtils;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.Identity;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EJBSecurityCollaboratorImpl
implements EJBSecurityCollaborator<SecurityCookieImpl>,
EJBAuthorizationHelper,
ComponentMetaDataListener {
    private static final TraceComponent tc = Tr.register(EJBSecurityCollaboratorImpl.class);
    protected static final String KEY_SECURITY_SERVICE = "securityService";
    protected static final String KEY_CREDENTIAL_SERVICE = "credentialsService";
    protected static final String KEY_UNAUTHENTICATED_SUBJECT_SERVICE = "unauthenticatedSubjectService";
    protected static final String KEY_JACC_SERVICE = "jaccService";
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    private final AtomicServiceReference<CredentialsService> credServiceRef = new AtomicServiceReference("credentialsService");
    private final AtomicServiceReference<UnauthenticatedSubjectService> unauthenticatedSubjectServiceRef = new AtomicServiceReference("unauthenticatedSubjectService");
    private final AtomicServiceReference<JaccService> jaccService = new AtomicServiceReference("jaccService");
    protected SubjectManager subjectManager;
    protected CollaboratorUtils collabUtils;
    public HashMap<String, Object> ejbAuditHashMap = new HashMap();
    protected AuditManager auditManager;
    public HashMap<String, Object> extraAuditData = new HashMap();
    protected volatile EJBSecurityConfig ejbSecConfig = null;
    private EJBAuthorizationHelper eah = this;
    static final long serialVersionUID = -7046417664225712733L;

    public EJBSecurityCollaboratorImpl() {
        this(new SubjectManager());
        this.auditManager = new AuditManager();
    }

    public EJBSecurityCollaboratorImpl(SubjectManager subjectManager) {
        this.subjectManager = subjectManager;
        this.collabUtils = new CollaboratorUtils(subjectManager);
    }

    protected void setCredentialService(ServiceReference<CredentialsService> ref) {
        this.credServiceRef.setReference(ref);
    }

    protected void unsetCredentialService(ServiceReference<CredentialsService> ref) {
        this.credServiceRef.unsetReference(ref);
    }

    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.unsetReference(ref);
    }

    protected void setUnauthenticatedSubjectService(ServiceReference<UnauthenticatedSubjectService> ref) {
        this.unauthenticatedSubjectServiceRef.setReference(ref);
    }

    protected void unsetUnauthenticatedSubjectService(ServiceReference<UnauthenticatedSubjectService> ref) {
        this.unauthenticatedSubjectServiceRef.unsetReference(ref);
    }

    protected void setJaccService(ServiceReference<JaccService> reference) {
        this.jaccService.setReference(reference);
        this.eah = new EJBJaccAuthorizationHelper(this.jaccService);
    }

    protected void unsetJaccService(ServiceReference<JaccService> reference) {
        this.jaccService.unsetReference(reference);
        this.eah = this;
    }

    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.securityServiceRef.activate(cc);
        this.credServiceRef.activate(cc);
        this.unauthenticatedSubjectServiceRef.activate(cc);
        this.jaccService.activate(cc);
        this.ejbSecConfig = new EJBSecurityConfigImpl(props);
    }

    protected void modified(Map<String, Object> newProperties) {
        EJBSecurityConfigImpl newEjbSecConfig = new EJBSecurityConfigImpl(newProperties);
        String deltaString = newEjbSecConfig.getChangedProperties(this.ejbSecConfig);
        this.ejbSecConfig = newEjbSecConfig;
        Tr.audit((TraceComponent)tc, (String)"EJB_SECURITY_CONFIGURATION_UPDATED", (Object[])new Object[]{deltaString});
    }

    protected void deactivate(ComponentContext cc) {
        this.securityServiceRef.deactivate(cc);
        this.credServiceRef.deactivate(cc);
        this.unauthenticatedSubjectServiceRef.deactivate(cc);
        this.jaccService.deactivate(cc);
    }

    public SecurityCookieImpl preInvoke(EJBRequestData request) throws EJBAccessDeniedException {
        Subject subjectToAuthorize;
        Subject invokedSubject = this.subjectManager.getInvocationSubject();
        Subject callerSubject = this.subjectManager.getCallerSubject();
        EJBMethodMetaData methodMetaData = request.getEJBMethodMetaData();
        if (this.ejbSecConfig.getUseUnauthenticatedForExpiredCredentials()) {
            invokedSubject = this.setNullSubjectWhenExpired(invokedSubject);
            callerSubject = this.setNullSubjectWhenExpired(callerSubject);
        }
        Subject originalInvokedSubject = invokedSubject;
        Subject originalCallerSubject = callerSubject;
        if (this.setUnauthenticatedSubjectIfNeeded(invokedSubject, callerSubject)) {
            invokedSubject = this.subjectManager.getInvocationSubject();
            callerSubject = this.subjectManager.getCallerSubject();
        }
        Subject subject = subjectToAuthorize = invokedSubject == null ? callerSubject : invokedSubject;
        if (!this.isInternalUnprotectedMethod(methodMetaData)) {
            this.eah.authorizeEJB(request, subjectToAuthorize);
        }
        this.performDelegation(methodMetaData, subjectToAuthorize);
        this.subjectManager.setCallerSubject(subjectToAuthorize);
        SecurityCookieImpl securityCookie = new SecurityCookieImpl(originalInvokedSubject, originalCallerSubject, this.subjectManager.getInvocationSubject(), subjectToAuthorize);
        return securityCookie;
    }

    public void postInvoke(EJBRequestData request, SecurityCookieImpl preInvokeResult) throws EJBAccessDeniedException {
        if (preInvokeResult != null) {
            JaccService js = (JaccService)this.jaccService.getService();
            if (js != null) {
                js.resetPolicyContextHandlerInfo();
            }
            SecurityCookieImpl securityCookie = preInvokeResult;
            Subject invocationSubject = this.subjectManager.getInvocationSubject();
            Subject callerSubject = this.subjectManager.getCallerSubject();
            if ((invocationSubject == null || invocationSubject.equals(securityCookie.getAdjustedInvokedSubject())) && (callerSubject == null || callerSubject.equals(securityCookie.getAdjustedReceivedSubject()))) {
                Subject invokedSubject = securityCookie.getInvokedSubject();
                Subject receivedSubject = securityCookie.getReceivedSubject();
                this.subjectManager.setCallerSubject(receivedSubject);
                this.subjectManager.setInvocationSubject(invokedSubject);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Subjects have been changed, preserving the current Subjects.", (Object[])new Object[0]);
            }
        }
    }

    public void argumentsUpdated(EJBRequestData request, SecurityCookieImpl preInvokeData) throws Exception {
    }

    public Identity getCallerIdentity(EJBComponentMetaData cmd, EJBRequestData request, SecurityCookieImpl preInvokeData) {
        Principal callerPrincipal = this.getCallerPrincipal(cmd, request, preInvokeData);
        if (callerPrincipal != null) {
            return new WSIdentity(callerPrincipal.getName());
        }
        return null;
    }

    public Principal getCallerPrincipal(EJBComponentMetaData cmd, EJBRequestData request, SecurityCookieImpl preInvokeData) {
        String realm = null;
        boolean useRealmQualifiedUserNames = this.ejbSecConfig.getUseRealmQualifiedUserNames();
        if (useRealmQualifiedUserNames) {
            realm = this.collabUtils.getUserRegistryRealm(this.securityServiceRef);
        }
        return this.collabUtils.getCallerPrincipal(this.ejbSecConfig.getUseRealmQualifiedUserNames(), realm, false, false);
    }

    public boolean isCallerInRole(EJBComponentMetaData cmd, EJBRequestData request, SecurityCookieImpl preInvokeData, String roleName, String roleLink) {
        CredentialsService credService;
        if (request == null) {
            return false;
        }
        Subject callerSubject = this.subjectManager.getCallerSubject();
        if (this.ejbSecConfig.getUseUnauthenticatedForExpiredCredentials() && (credService = (CredentialsService)this.credServiceRef.getService()) != null && !credService.isSubjectValid(callerSubject)) {
            callerSubject = ((UnauthenticatedSubjectService)this.unauthenticatedSubjectServiceRef.getService()).getUnauthenticatedSubject();
        }
        return this.eah.isCallerInRole(cmd, request, roleName, roleLink, callerSubject);
    }

    @Override
    public boolean isCallerInRole(EJBComponentMetaData cmd, EJBRequestData request, String roleName, String roleLink, Subject subject) {
        String role = roleLink == null ? roleName : roleLink;
        String appName = this.getApplicationName(request.getEJBMethodMetaData());
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        AuthorizationService authzService = securityService.getAuthorizationService();
        if (authzService == null) {
            String authzUserName = subject.getPrincipals(WSPrincipal.class).iterator().next().getName();
            Tr.error((TraceComponent)tc, (String)"EJB_AUTHZ_SERVICE_NOTFOUND", (Object[])new Object[]{authzUserName, "isCallerInRole", appName});
            return false;
        }
        ArrayList<String> requiredRoles = new ArrayList<String>();
        requiredRoles.add(role);
        return authzService.isAuthorized(appName, requiredRoles, subject);
    }

    private Subject setNullSubjectWhenExpired(Subject subject) {
        CredentialsService credService;
        if (subject != null && (credService = (CredentialsService)this.credServiceRef.getService()) != null && !credService.isSubjectValid(subject)) {
            subject = null;
        }
        return subject;
    }

    private boolean isInternalUnprotectedMethod(EJBMethodMetaData methodMetaData) {
        EJBMethodInterface interfaceType = methodMetaData.getEJBMethodInterface();
        return EJBMethodInterface.LIFECYCLE_INTERCEPTOR.value() == interfaceType.value() || EJBMethodInterface.TIMER.value() == interfaceType.value();
    }

    public void populateAuditEJBHashMap(EJBRequestData request) {
        EJBMethodMetaData methodMetaData = request.getEJBMethodMetaData();
        Object[] methodArguments = request.getMethodArguments();
        String applicationName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getApplication();
        String moduleName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getModule();
        String methodName = methodMetaData.getMethodName();
        String methodInterface = methodMetaData.getEJBMethodInterface().specName();
        String methodSignature = methodMetaData.getMethodSignature();
        String beanName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getComponent();
        List<Object> methodParameters = null;
        if (methodArguments != null && methodArguments.length > 0) {
            methodParameters = Arrays.asList(methodArguments);
        }
        this.ejbAuditHashMap.put("methodArguments", methodArguments);
        this.ejbAuditHashMap.put("applicationName", applicationName);
        this.ejbAuditHashMap.put("moduleName", moduleName);
        this.ejbAuditHashMap.put("methodName", methodName);
        this.ejbAuditHashMap.put("methodInterface", methodInterface);
        this.ejbAuditHashMap.put("methodSignature", methodSignature);
        this.ejbAuditHashMap.put("beanName", beanName);
        this.ejbAuditHashMap.put("methodParameters", methodParameters);
    }

    @Override
    public void authorizeEJB(EJBRequestData request, Subject subject) throws EJBAccessDeniedException {
        EJBMethodMetaData methodMetaData = request.getEJBMethodMetaData();
        String authzUserName = subject.getPrincipals(WSPrincipal.class).iterator().next().getName();
        String applicationName = this.getApplicationName(methodMetaData);
        String methodName = methodMetaData.getMethodName();
        Object req = this.auditManager != null ? this.auditManager.getHttpServletRequest() : null;
        Object webRequest = this.auditManager != null ? this.auditManager.getWebRequest() : null;
        String realm = this.auditManager != null ? this.auditManager.getRealm() : null;
        this.populateAuditEJBHashMap(request);
        Collection<String> roles = this.getRequiredRoles(methodMetaData);
        if (methodMetaData.isDenyAll()) {
            this.ejbAuditHashMap.put("reason.reasonType", "EJB Deny All");
            Tr.audit((TraceComponent)tc, (String)"EJB_AUTHZ_EXCLUDED", (Object[])new Object[]{authzUserName, methodName, applicationName});
            AuditAuthenticationResult auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.FAILURE, authzUserName, "BASIC", null, "failure");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_04, (Object[])new Object[]{auditAuthResult, this.ejbAuditHashMap, req, webRequest, realm, subject, roles, Integer.valueOf("403")});
            throw new EJBAccessDeniedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.ejbcontainer.security.internal.resources.EJBSecurityMessages", (String)"EJB_AUTHZ_EXCLUDED", (Object[])new Object[]{authzUserName, methodName, applicationName}, (String)"CWWKS9402A: Authorization failed for user {0} while invoking {1} on {2} because the method is explicitly excluded."));
        }
        if (methodMetaData.isPermitAll()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authorization granted for " + methodName + " on " + applicationName + " because permitAll is set."), (Object[])new Object[0]);
            }
            this.ejbAuditHashMap.put("reason.reasonType", "EJB Permit All");
            AuditAuthenticationResult auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.SUCCESS, authzUserName, "BASIC", null, "success");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_04, (Object[])new Object[]{auditAuthResult, this.ejbAuditHashMap, req, webRequest, realm, subject, roles, Integer.valueOf("200")});
            return;
        }
        if (roles == null || roles.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authorization granted for " + methodName + " on " + applicationName + " because no roles are required."), (Object[])new Object[0]);
            }
            this.ejbAuditHashMap.put("reason.reasonType", "EBJ No Roles");
            AuditAuthenticationResult auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.SUCCESS, authzUserName, "BASIC", null, "success");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_04, (Object[])new Object[]{auditAuthResult, this.ejbAuditHashMap, req, webRequest, realm, subject, null, Integer.valueOf("200")});
            return;
        }
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        AuthorizationService authzService = securityService.getAuthorizationService();
        if (authzService == null) {
            this.ejbAuditHashMap.put("reason.reasonType", "EJB No Authorization Service Found");
            AuditAuthenticationResult auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.FAILURE, authzUserName, "BASIC", null, "failure");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_04, (Object[])new Object[]{auditAuthResult, this.ejbAuditHashMap, req, webRequest, realm, subject, roles, Integer.valueOf("403")});
            Tr.error((TraceComponent)tc, (String)"EJB_AUTHZ_SERVICE_NOTFOUND", (Object[])new Object[]{authzUserName, methodName, applicationName});
            throw new EJBAccessDeniedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.ejbcontainer.security.internal.resources.EJBSecurityMessages", (String)"EJB_AUTHZ_SERVICE_NOTFOUND", (Object[])new Object[]{authzUserName, methodName, applicationName}, (String)"CWWKS9403E: The authorization service could not be found. As a result, the user is not authorized."));
        }
        if (!authzService.isAuthorized(applicationName, roles, subject)) {
            this.ejbAuditHashMap.put("reason.reasonType", "EJB");
            AuditAuthenticationResult auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.FAILURE, authzUserName, "BASIC", null, "failure");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_04, (Object[])new Object[]{auditAuthResult, this.ejbAuditHashMap, req, webRequest, realm, subject, roles, Integer.valueOf("403")});
            Tr.audit((TraceComponent)tc, (String)"EJB_AUTHZ_FAILED", (Object[])new Object[]{authzUserName, methodName, applicationName, roles});
            throw new EJBAccessDeniedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.ejbcontainer.security.internal.resources.EJBSecurityMessages", (String)"EJB_AUTHZ_FAILED", (Object[])new Object[]{authzUserName, methodName, applicationName, roles}, (String)"CWWKS9400A: Authorization failed. The user is not granted access to any of the required roles."));
        }
        this.ejbAuditHashMap.put("reason.reasonType", "EJB");
        AuditAuthenticationResult auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.SUCCESS, authzUserName, "BASIC", null, "success");
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_04, (Object[])new Object[]{auditAuthResult, this.ejbAuditHashMap, req, webRequest, realm, subject, roles, Integer.valueOf("200")});
    }

    protected Collection<String> getRequiredRoles(EJBMethodMetaData methodMetaData) {
        return methodMetaData.getRolesAllowed();
    }

    protected String getApplicationName(EJBMethodMetaData methodMetaData) {
        return methodMetaData.getEJBComponentMetaData().getJ2EEName().getApplication();
    }

    protected String getModuleName(EJBMethodMetaData methodMetaData) {
        return methodMetaData.getEJBComponentMetaData().getJ2EEName().getModule();
    }

    protected String getComponentName(EJBMethodMetaData methodMetaData) {
        return methodMetaData.getEJBComponentMetaData().getJ2EEName().getComponent();
    }

    /*
     * WARNING - void declaration
     */
    private void performDelegation(EJBMethodMetaData methodMetaData, Subject delegationSubject) {
        block23: {
            ArrayList<String> delUsers = new ArrayList<String>();
            String invalidUser = "";
            Set<WSCredential> publicCredentials = delegationSubject == null ? null : delegationSubject.getPublicCredentials(WSCredential.class);
            Iterator<WSCredential> it = null;
            if (publicCredentials != null && (it = publicCredentials.iterator()) != null && it.hasNext()) {
                WSCredential credential = it.next();
                try {
                    this.extraAuditData.put("REALM", credential.getRealmName());
                }
                catch (CredentialExpiredException credentialExpiredException) {
                    FFDCFilter.processException((Throwable)credentialExpiredException, (String)"com.ibm.ws.ejbcontainer.security.internal.EJBSecurityCollaboratorImpl", (String)"569", (Object)this, (Object[])new Object[]{methodMetaData, delegationSubject});
                }
                catch (CredentialDestroyedException credentialDestroyedException) {
                    FFDCFilter.processException((Throwable)credentialDestroyedException, (String)"com.ibm.ws.ejbcontainer.security.internal.EJBSecurityCollaboratorImpl", (String)"570", (Object)this, (Object[])new Object[]{methodMetaData, delegationSubject});
                }
                try {
                    delUsers.add("user:" + credential.getRealmSecurityName());
                }
                catch (CredentialExpiredException credentialExpiredException) {
                    FFDCFilter.processException((Throwable)credentialExpiredException, (String)"com.ibm.ws.ejbcontainer.security.internal.EJBSecurityCollaboratorImpl", (String)"574", (Object)this, (Object[])new Object[]{methodMetaData, delegationSubject});
                }
                catch (CredentialDestroyedException credentialDestroyedException) {
                    FFDCFilter.processException((Throwable)credentialDestroyedException, (String)"com.ibm.ws.ejbcontainer.security.internal.EJBSecurityCollaboratorImpl", (String)"576", (Object)this, (Object[])new Object[]{methodMetaData, delegationSubject});
                }
            }
            String applicationName = this.getApplicationName(methodMetaData);
            String methodName = methodMetaData.getMethodName();
            if (this.auditManager != null && this.auditManager.getHttpServletRequest() != null) {
                this.extraAuditData.put("HTTP_SERVLET_REQUEST", this.auditManager.getHttpServletRequest());
            }
            this.extraAuditData.put("REASON_TYPE", "EJB");
            if (methodMetaData.isUseSystemPrincipal()) {
                Tr.error((TraceComponent)tc, (String)"EJB_RUNAS_SYSTEM_NOT_SUPPORTED", (Object[])new Object[]{methodName, applicationName});
                delUsers.add("EJB_RUNAS_SYSTEM");
                this.extraAuditData.put("DELEGATION_USERS_LIST", delUsers);
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_DELEGATION_01, (Object[])new Object[]{this.extraAuditData, "failure", 401});
                throw new EJBAccessDeniedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.ejbcontainer.security.internal.resources.EJBSecurityMessages", (String)"EJB_RUNAS_SYSTEM_NOT_SUPPORTED", (Object[])new Object[]{methodName, applicationName}, (String)("CWWKS9405E: Authorization failed for EJB method" + methodName + " in the application " + applicationName + ". The run-as-mode of SYSTEM_IDENTITY specified in the ibm-ejb-jar-ext.xml is not supported and must be removed or replaced.")));
            }
            if (methodMetaData.isUseCallerPrincipal()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Returning without delegating because run-as-mode in ibm-ejb-jar-ext for " + methodName + " in " + applicationName + " is set to CALLER_IDENTITY."), (Object[])new Object[0]);
                }
                return;
            }
            String roleName = this.getRunAsRole(methodMetaData);
            this.extraAuditData.put("RUN_AS_ROLE", roleName);
            if (roleName != null) {
                try {
                    SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                    AuthenticationService authService = securityService.getAuthenticationService();
                    delegationSubject = authService.delegate(roleName, this.getApplicationName(methodMetaData));
                    if (delegationSubject != null) {
                        int a;
                        String buff = delegationSubject.toString();
                        if (buff != null && (a = buff.indexOf("accessId")) != -1 && (a = (buff = buff.substring(a + 9)).indexOf(",")) != -1) {
                            buff = buff.substring(0, a);
                            delUsers.add(buff);
                        }
                    } else {
                        invalidUser = authService.getInvalidDelegationUser();
                        delUsers.add(invalidUser);
                    }
                    this.extraAuditData.put("DELEGATION_USERS_LIST", delUsers);
                    if (delegationSubject != null) {
                        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_DELEGATION_01, (Object[])new Object[]{this.extraAuditData, "success", 200});
                    } else {
                        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_DELEGATION_01, (Object[])new Object[]{this.extraAuditData, "failure", 401});
                    }
                }
                catch (IllegalArgumentException securityService) {
                    void e;
                    FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.ejbcontainer.security.internal.EJBSecurityCollaboratorImpl", (String)"646", (Object)this, (Object[])new Object[]{methodMetaData, delegationSubject});
                    if (delegationSubject != null) {
                        int a;
                        String buff = delegationSubject.toString();
                        if (buff != null && (a = buff.indexOf("accessId")) != -1 && (a = (buff = buff.substring(a + 9)).indexOf(",")) != -1) {
                            buff = buff.substring(0, a);
                            delUsers.add(buff);
                        }
                    } else {
                        SecurityService securityService2 = (SecurityService)this.securityServiceRef.getService();
                        AuthenticationService authService = securityService2.getAuthenticationService();
                        invalidUser = authService.getInvalidDelegationUser();
                        delUsers.add(invalidUser);
                        this.extraAuditData.put("DELEGATION_USERS_LIST", delUsers);
                    }
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_DELEGATION_01, (Object[])new Object[]{this.extraAuditData, "failure", 401});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block23;
                    Tr.debug((TraceComponent)tc, (String)"Exception performing delegation.", (Object[])new Object[]{e});
                }
            }
        }
        if (delegationSubject != null) {
            this.subjectManager.setInvocationSubject(delegationSubject);
        }
    }

    protected String getRunAsRole(EJBMethodMetaData methodMetaData) {
        return methodMetaData.getRunAs();
    }

    private boolean setUnauthenticatedSubjectIfNeeded(Subject invokedSubject, Subject receivedSubject) {
        if (invokedSubject == null && receivedSubject == null) {
            this.subjectManager.setInvocationSubject(((UnauthenticatedSubjectService)this.unauthenticatedSubjectServiceRef.getService()).getUnauthenticatedSubject());
            return true;
        }
        return false;
    }

    public boolean areRequestMethodArgumentsRequired() {
        JaccService js = (JaccService)this.jaccService.getService();
        boolean result = false;
        if (js != null) {
            result = js.areRequestMethodArgumentsRequired();
        }
        return result;
    }

    public void componentMetaDataCreated(MetaDataEvent<ComponentMetaData> event) {
        MetaData metaData;
        JaccService js = (JaccService)this.jaccService.getService();
        if (js != null && (metaData = event.getMetaData()) instanceof BeanMetaData) {
            BeanMetaData bmd = (BeanMetaData)metaData;
            js.propagateEJBRoles(bmd.j2eeName.getApplication(), bmd.j2eeName.getModule(), bmd.enterpriseBeanName, (Map)bmd.ivRoleLinkMap, JaccUtil.convertMethodInfoList(JaccUtil.mergeMethodInfos(bmd)));
        }
    }

    public void componentMetaDataDestroyed(MetaDataEvent<ComponentMetaData> event) {
    }
}

