/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverters;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ResolvedSchema;
import com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils;
import com.ibm.ws.microprofile.openapi.impl.core.util.BaseReaderUtils;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.core.util.ParameterProcessor;
import com.ibm.ws.microprofile.openapi.impl.core.util.PathUtils;
import com.ibm.ws.microprofile.openapi.impl.core.util.ReflectionUtils;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.OperationParser;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.ResolvedParameter;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.SecurityParser;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.ext.OpenAPIExtension;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.ext.OpenAPIExtensions;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.util.ReaderUtils;
import com.ibm.ws.microprofile.openapi.impl.model.ComponentsImpl;
import com.ibm.ws.microprofile.openapi.impl.model.OpenAPIImpl;
import com.ibm.ws.microprofile.openapi.impl.model.OperationImpl;
import com.ibm.ws.microprofile.openapi.impl.model.PathItemImpl;
import com.ibm.ws.microprofile.openapi.impl.model.PathsImpl;
import com.ibm.ws.microprofile.openapi.impl.model.callbacks.CallbackImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.ContentImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.MediaTypeImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.microprofile.openapi.impl.model.parameters.ParameterImpl;
import com.ibm.ws.microprofile.openapi.impl.model.parameters.RequestBodyImpl;
import com.ibm.ws.microprofile.openapi.impl.model.responses.APIResponseImpl;
import com.ibm.ws.microprofile.openapi.impl.model.responses.APIResponsesImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.SecuritySchemeImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.annotations.Components;
import org.eclipse.microprofile.openapi.annotations.ExternalDocumentation;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callback;
import org.eclipse.microprofile.openapi.annotations.callbacks.CallbackOperation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirementsSet;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.eclipse.microprofile.openapi.annotations.tags.Tags;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Reader {
    public static final String DEFAULT_MEDIA_TYPE_VALUE = "*/*";
    public static final String DEFAULT_DESCRIPTION = "default response";
    private final OpenAPI openAPI;
    private final org.eclipse.microprofile.openapi.models.Components components;
    private final Paths paths;
    private final Set<org.eclipse.microprofile.openapi.models.tags.Tag> openApiTags;
    private String applicationPath;
    private static final String GET_METHOD = "get";
    private static final String POST_METHOD = "post";
    private static final String PUT_METHOD = "put";
    private static final String DELETE_METHOD = "delete";
    private static final String PATCH_METHOD = "patch";
    private static final String TRACE_METHOD = "trace";
    private static final String HEAD_METHOD = "head";
    private static final String OPTIONS_METHOD = "options";
    static final long serialVersionUID = 8092849474350980129L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Reader() {
        this.openAPI = new OpenAPIImpl();
        this.paths = new PathsImpl();
        this.openApiTags = new LinkedHashSet<org.eclipse.microprofile.openapi.models.tags.Tag>();
        this.components = new ComponentsImpl();
    }

    public Reader(OpenAPI openAPI) {
        if (openAPI != null) {
            this.openAPI = openAPI;
        } else {
            openAPI = this.openAPI = new OpenAPIImpl();
        }
        this.paths = openAPI.getPaths() != null ? openAPI.getPaths() : new PathsImpl();
        this.openApiTags = new LinkedHashSet<org.eclipse.microprofile.openapi.models.tags.Tag>();
        if (openAPI.getTags() != null) {
            this.openApiTags.addAll(openAPI.getTags());
        }
        this.components = openAPI.getComponents() != null ? openAPI.getComponents() : new ComponentsImpl();
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public OpenAPI read(Class<?> cls) {
        return this.read(cls, this.applicationPath != null ? this.applicationPath : "");
    }

    public OpenAPI read(Set<Class<?>> classes) {
        TreeSet sortedClasses = new TreeSet(new Comparator<Class<?>>(){
            static final long serialVersionUID = -6974272232978402046L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(Class<?> class1, Class<?> class2) {
                if (class1.equals(class2)) {
                    return 0;
                }
                if (class1.isAssignableFrom(class2)) {
                    return -1;
                }
                if (class2.isAssignableFrom(class1)) {
                    return 1;
                }
                return class1.getName().compareTo(class2.getName());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        sortedClasses.addAll(classes);
        for (Class clazz : sortedClasses) {
            this.read(clazz, this.applicationPath != null ? this.applicationPath : "");
        }
        return this.openAPI;
    }

    public OpenAPI read(Set<Class<?>> classes, Map<String, Object> resources) {
        return this.read(classes);
    }

    public OpenAPI read(Class<?> cls, String parentPath) {
        Method[] methods;
        Optional<List<Server>> serversObject;
        Optional<Object> requirementsObject;
        Map<String, Object> ext;
        List<org.eclipse.microprofile.openapi.annotations.security.SecurityScheme> apiSecurityScheme = ReflectionUtils.getRepeatableAnnotations(cls, org.eclipse.microprofile.openapi.annotations.security.SecurityScheme.class);
        List<SecurityRequirement> apiSecurityRequirements = ReflectionUtils.getRepeatableAnnotations(cls, SecurityRequirement.class);
        SecurityRequirementsSet apiSecurityRequirementSet = ReflectionUtils.getAnnotation(cls, SecurityRequirementsSet.class);
        List<org.eclipse.microprofile.openapi.annotations.servers.Server> apiServers = ReflectionUtils.getRepeatableAnnotations(cls, org.eclipse.microprofile.openapi.annotations.servers.Server.class);
        List<Callback> apiCallbacks = ReflectionUtils.getRepeatableAnnotations(cls, Callback.class);
        List<Extension> classExtensions = ReflectionUtils.getRepeatableAnnotations(cls, Extension.class);
        if (classExtensions != null && classExtensions.size() > 0 && (ext = BaseReaderUtils.parseExtensions(classExtensions.toArray(new Extension[classExtensions.size()]))) != null && ext.size() > 0) {
            ext.forEach((k, v) -> ((OpenAPIImpl)this.openAPI).addExtension_compat(k, v));
        }
        ExternalDocumentation apiExternalDocs = ReflectionUtils.getAnnotation(cls, ExternalDocumentation.class);
        Tag[] apiTags = (Tag[])ReflectionUtils.getRepeatableAnnotationsArray(cls, Tag.class);
        Tags tagsAnnotation = ReflectionUtils.getAnnotation(cls, Tags.class);
        Consumes classConsumes = ReflectionUtils.getAnnotation(cls, Consumes.class);
        Produces classProduces = ReflectionUtils.getAnnotation(cls, Produces.class);
        if (apiSecurityScheme != null) {
            for (org.eclipse.microprofile.openapi.annotations.security.SecurityScheme securitySchemeAnnotation : apiSecurityScheme) {
                Optional<SecurityScheme> securityScheme = SecurityParser.getSecurityScheme(securitySchemeAnnotation);
                if (!securityScheme.isPresent()) continue;
                HashMap<String, SecurityScheme> securitySchemeMap = new HashMap<String, SecurityScheme>();
                if (!StringUtils.isNotBlank((CharSequence)((SecuritySchemeImpl)securityScheme.get()).getSchemeName())) continue;
                securitySchemeMap.put(((SecuritySchemeImpl)securityScheme.get()).getSchemeName(), securityScheme.get());
                if (this.components.getSecuritySchemes() != null && this.components.getSecuritySchemes().size() != 0) {
                    this.components.getSecuritySchemes().putAll(securitySchemeMap);
                    continue;
                }
                this.components.setSecuritySchemes(securitySchemeMap);
            }
        }
        ArrayList<org.eclipse.microprofile.openapi.models.security.SecurityRequirement> classSecurityRequirements = new ArrayList<org.eclipse.microprofile.openapi.models.security.SecurityRequirement>();
        if (apiSecurityRequirements != null && (requirementsObject = SecurityParser.getSecurityRequirements(apiSecurityRequirements.toArray(new SecurityRequirement[apiSecurityRequirements.size()]))).isPresent()) {
            classSecurityRequirements = (List)requirementsObject.get();
        }
        if (apiSecurityRequirementSet != null && (requirementsObject = SecurityParser.getSecurityRequirementFromSet(apiSecurityRequirementSet)).isPresent()) {
            classSecurityRequirements.add((org.eclipse.microprofile.openapi.models.security.SecurityRequirement)requirementsObject.get());
        }
        ArrayList<Server> classServers = new ArrayList();
        if (apiServers != null && (serversObject = AnnotationsUtils.getServers(apiServers.toArray(new org.eclipse.microprofile.openapi.annotations.servers.Server[apiServers.size()]))).isPresent()) {
            classServers = serversObject.get();
        }
        LinkedHashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> classCallbacks = null;
        if (apiCallbacks != null) {
            LinkedHashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> callbacks = new LinkedHashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback>();
            for (Callback classCallback : apiCallbacks) {
                Map<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> currentCallbacks = this.getCallbacks(classCallback);
                callbacks.putAll(currentCallbacks);
            }
            if (callbacks.size() > 0) {
                classCallbacks = callbacks;
            }
        }
        LinkedHashSet<String> classTags = new LinkedHashSet<String>();
        if (apiTags != null) {
            AnnotationsUtils.getTags(apiTags, false).ifPresent(tags -> tags.stream().map(t -> t.getName()).forEach(t -> classTags.add((String)t)));
        }
        if (tagsAnnotation != null && tagsAnnotation.refs() != null) {
            classTags.addAll(Stream.of(tagsAnnotation.refs()).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        }
        Optional<org.eclipse.microprofile.openapi.models.ExternalDocumentation> classExternalDocumentation = AnnotationsUtils.getExternalDocumentation(apiExternalDocs);
        Path apiPath = ReflectionUtils.getAnnotation(cls, Path.class);
        JavaType classType = TypeFactory.defaultInstance().constructType(cls);
        BeanDescription bd = Json.mapper().getSerializationConfig().introspect(classType);
        ArrayList<Parameter> globalParameters = new ArrayList<Parameter>();
        globalParameters.addAll(ReaderUtils.collectConstructorParameters(cls, this.components, classConsumes));
        globalParameters.addAll(ReaderUtils.collectFieldParameters(cls, this.components, classConsumes));
        for (Method method : methods = cls.getMethods()) {
            ResolvedParameter resolvedParameter;
            JavaType type;
            org.eclipse.microprofile.openapi.models.Operation operation;
            LinkedHashMap<String, String> regexMap;
            Path methodPath;
            String operationPath;
            if (this.isOperationHidden(method)) continue;
            AnnotatedMethod annotatedMethod = bd.findMethod(method.getName(), (Class[])method.getParameterTypes());
            Produces methodProduces = ReflectionUtils.getAnnotation(method, Produces.class);
            Consumes methodConsumes = ReflectionUtils.getAnnotation(method, Consumes.class);
            if (ReflectionUtils.isOverriddenMethod(method, cls) || this.ignoreOperationPath(operationPath = ReaderUtils.getPath(apiPath, methodPath = ReflectionUtils.getAnnotation(method, Path.class), parentPath), parentPath) || (operationPath = PathUtils.parsePath(operationPath, regexMap = new LinkedHashMap<String, String>())) == null || (operation = this.parseMethod(method, globalParameters, methodProduces, classProduces, methodConsumes, classConsumes, classSecurityRequirements, classExternalDocumentation, classTags, classServers, classCallbacks)) == null) continue;
            Object pathItemObject = this.openAPI.getPaths() != null && this.openAPI.getPaths().get((Object)operationPath) != null ? (PathItem)this.openAPI.getPaths().get((Object)operationPath) : new PathItemImpl();
            String httpMethod = ReaderUtils.extractOperationMethod(operation, method, OpenAPIExtensions.chain());
            if (StringUtils.isBlank((CharSequence)httpMethod)) continue;
            this.setPathItemOperation((PathItem)pathItemObject, httpMethod, operation);
            org.eclipse.microprofile.openapi.annotations.parameters.RequestBody methodRequestBody = method.getAnnotation(org.eclipse.microprofile.openapi.annotations.parameters.RequestBody.class);
            ArrayList<Parameter> operationParameters = new ArrayList<Parameter>();
            Annotation[][] paramAnnotations = ReflectionUtils.getParameterAnnotations(method);
            if (annotatedMethod == null) {
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < genericParameterTypes.length; ++i) {
                    type = TypeFactory.defaultInstance().constructType(genericParameterTypes[i], cls);
                    resolvedParameter = this.getParameters((Type)type, Arrays.asList(paramAnnotations[i]), operation, classConsumes, methodConsumes);
                    for (Parameter p : resolvedParameter.parameters) {
                        operationParameters.add(p);
                    }
                    if (resolvedParameter.requestBody == null) continue;
                    this.processRequestBody(resolvedParameter.requestBody, operation, methodConsumes, classConsumes, paramAnnotations[i], methodRequestBody);
                }
            } else {
                for (int i = 0; i < annotatedMethod.getParameterCount(); ++i) {
                    AnnotatedParameter param2 = annotatedMethod.getParameter(i);
                    type = TypeFactory.defaultInstance().constructType(param2.getParameterType(), cls);
                    resolvedParameter = this.getParameters((Type)type, Arrays.asList(paramAnnotations[i]), operation, classConsumes, methodConsumes);
                    for (Parameter p : resolvedParameter.parameters) {
                        operationParameters.add(p);
                    }
                    if (resolvedParameter.requestBody == null) continue;
                    this.processRequestBody(resolvedParameter.requestBody, operation, methodConsumes, classConsumes, paramAnnotations[i], methodRequestBody);
                }
            }
            if (operation.getRequestBody() == null) {
                this.processRequestBody((Parameter)new ParameterImpl(), operation, methodConsumes, classConsumes, null, methodRequestBody);
            }
            if (operationParameters.size() > 0) {
                HashMap<String, Parameter> params = new HashMap<String, Parameter>();
                if (operation.getParameters() != null) {
                    for (Parameter param3 : operation.getParameters()) {
                        if (param3.getIn() != null) {
                            params.put(param3.getName() + '/' + param3.getIn().toString(), param3);
                            continue;
                        }
                        params.put(param3.getName(), param3);
                    }
                }
                for (Parameter operationParameter : operationParameters) {
                    Parameter p = null;
                    if (operationParameter.getIn() != null) {
                        p = (Parameter)params.get(operationParameter.getName() + '/' + operationParameter.getIn().toString());
                    }
                    if (p == null) {
                        p = (Parameter)params.get(operationParameter.getName());
                    }
                    if (p != null) {
                        ReaderUtils.copyParamValues(p, operationParameter);
                        continue;
                    }
                    operation.addParameter(operationParameter);
                }
            }
            if (operation.getParameters() != null) {
                LinkedList parameters = new LinkedList();
                operation.getParameters().forEach(param -> {
                    if (param.getRef() != null) {
                        parameters.add(new ParameterImpl().ref(param.getRef()));
                    } else {
                        parameters.add(param);
                    }
                });
                operation.setParameters(parameters);
            }
            if (operation.getRequestBody() != null && operation.getRequestBody().getRef() != null) {
                operation.setRequestBody(new RequestBodyImpl().ref(operation.getRequestBody().getRef()));
            }
            this.paths.addPathItem(operationPath, (PathItem)pathItemObject);
            if (this.openAPI.getPaths() != null) {
                this.paths.putAll((Map)this.openAPI.getPaths());
            }
            this.openAPI.setPaths(this.paths);
        }
        AnnotationsUtils.getTags(apiTags, true).ifPresent(tags -> this.openApiTags.addAll((Collection<org.eclipse.microprofile.openapi.models.tags.Tag>)tags));
        if (!this.openApiTags.isEmpty()) {
            LinkedHashSet<org.eclipse.microprofile.openapi.models.tags.Tag> tagsSet = new LinkedHashSet<org.eclipse.microprofile.openapi.models.tags.Tag>();
            if (this.openAPI.getTags() != null) {
                for (org.eclipse.microprofile.openapi.models.tags.Tag tag : this.openAPI.getTags()) {
                    if (!tagsSet.stream().noneMatch(t -> t.getName().equals(tag.getName()))) continue;
                    tagsSet.add(tag);
                }
            }
            for (org.eclipse.microprofile.openapi.models.tags.Tag tag : this.openApiTags) {
                if (!tagsSet.stream().noneMatch(t -> t.getName().equals(tag.getName()))) continue;
                tagsSet.add(tag);
            }
            this.openAPI.setTags(new ArrayList(tagsSet));
        }
        this.handleOpenAPIDefinition(ReflectionUtils.getAnnotation(cls, OpenAPIDefinition.class));
        if (!this.isEmptyComponents(this.components) && this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(this.components);
        }
        return this.openAPI;
    }

    private void handleOpenAPIDefinition(OpenAPIDefinition openAPIDefinition) {
        if (openAPIDefinition != null) {
            AnnotationsUtils.getInfo(openAPIDefinition.info()).ifPresent(info -> this.openAPI.setInfo(info));
            SecurityParser.getSecurityRequirements(openAPIDefinition.security()).ifPresent(s -> this.openAPI.setSecurity(s));
            AnnotationsUtils.getExternalDocumentation(openAPIDefinition.externalDocs()).ifPresent(docs -> this.openAPI.setExternalDocs(docs));
            AnnotationsUtils.getTags(openAPIDefinition.tags(), false).ifPresent(tags -> this.openApiTags.addAll((Collection<org.eclipse.microprofile.openapi.models.tags.Tag>)tags));
            AnnotationsUtils.getServers(openAPIDefinition.servers()).ifPresent(servers -> this.openAPI.setServers(servers));
            this.handleComponentsAnnotation(openAPIDefinition.components());
        }
    }

    private void handleComponentsAnnotation(Components annotationComponents) {
        Map<String, Link> linksMap;
        Optional<List<Parameter>> parameters;
        Optional<APIResponses> responses;
        if (annotationComponents == null) {
            return;
        }
        Optional<Map<String, Header>> headers = AnnotationsUtils.getHeaders(annotationComponents.headers());
        if (headers.isPresent()) {
            if (this.components.getHeaders() == null) {
                this.components.setHeaders(headers.get());
            } else {
                this.components.getHeaders().putAll(headers.get());
            }
        }
        if ((responses = AnnotationsUtils.getApiResponses(annotationComponents.responses(), null, null, this.components, false)).isPresent()) {
            if (this.components.getResponses() == null) {
                this.components.setResponses((Map)responses.get());
            } else {
                this.components.getResponses().putAll((Map)responses.get());
            }
        }
        if ((parameters = this.getParametersListFromAnnotation(annotationComponents.parameters(), null, null, null)).isPresent()) {
            for (Parameter parameter : parameters.get()) {
                this.components.addParameter(parameter.getName(), parameter);
            }
        }
        HashMap exampleMap = new HashMap();
        for (Parameter exampleObject : annotationComponents.examples()) {
            AnnotationsUtils.getExample((ExampleObject)exampleObject).ifPresent(arg_0 -> Reader.lambda$handleComponentsAnnotation$13(exampleMap, (ExampleObject)exampleObject, arg_0));
        }
        if (exampleMap.size() > 0) {
            if (this.components.getExamples() == null) {
                this.components.setExamples(exampleMap);
            } else {
                this.components.getExamples().putAll(exampleMap);
            }
        }
        HashMap requestBodyMap = new HashMap();
        for (org.eclipse.microprofile.openapi.annotations.parameters.RequestBody requestBody : annotationComponents.requestBodies()) {
            OperationParser.getRequestBody(requestBody, null, null, this.components).ifPresent(request -> requestBodyMap.put(requestBody.name(), request));
        }
        if (requestBodyMap.size() > 0) {
            if (this.components.getRequestBodies() == null) {
                this.components.setRequestBodies(requestBodyMap);
            } else {
                this.components.getRequestBodies().putAll(requestBodyMap);
            }
        }
        HashMap securitySchemeMap = new HashMap();
        for (org.eclipse.microprofile.openapi.annotations.security.SecurityScheme securityScheme : annotationComponents.securitySchemes()) {
            SecurityParser.getSecurityScheme(securityScheme).ifPresent(security -> securitySchemeMap.put(securityScheme.securitySchemeName(), security));
        }
        if (securitySchemeMap.size() > 0) {
            if (this.components.getSecuritySchemes() == null) {
                this.components.setSecuritySchemes(securitySchemeMap);
            } else {
                this.components.getSecuritySchemes().putAll(securitySchemeMap);
            }
        }
        if ((linksMap = AnnotationsUtils.getLinks(annotationComponents.links())).size() > 0) {
            if (this.components.getLinks() == null) {
                this.components.setLinks(linksMap);
            } else {
                this.components.getLinks().putAll(linksMap);
            }
        }
        LinkedHashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> callbackMap = new LinkedHashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback>();
        for (Callback callback : annotationComponents.callbacks()) {
            callbackMap.putAll(this.getCallbacks(callback));
        }
        if (callbackMap.size() > 0) {
            if (this.components.getCallbacks() == null) {
                this.components.setCallbacks(callbackMap);
            } else {
                this.components.getCallbacks().putAll(callbackMap);
            }
        }
        for (Callback callback : annotationComponents.schemas()) {
            Optional<? extends org.eclipse.microprofile.openapi.models.media.Schema> optSchema = AnnotationsUtils.getSchema((Schema)callback, this.components);
            if (!optSchema.isPresent()) continue;
            this.components.addSchema(callback.name(), optSchema.get());
        }
    }

    protected Content processContent(Content content, org.eclipse.microprofile.openapi.models.media.Schema schema, Consumes methodConsumes, Consumes classConsumes) {
        if (content == null) {
            content = new ContentImpl();
        }
        if (methodConsumes != null) {
            for (String value : methodConsumes.value()) {
                this.setMediaTypeToContent(schema, content, value);
            }
        } else if (classConsumes != null) {
            for (String value : classConsumes.value()) {
                this.setMediaTypeToContent(schema, content, value);
            }
        } else {
            this.setMediaTypeToContent(schema, content, DEFAULT_MEDIA_TYPE_VALUE);
        }
        return content;
    }

    protected void processRequestBody(Parameter requestBodyParameter, org.eclipse.microprofile.openapi.models.Operation operation, Consumes methodConsumes, Consumes classConsumes, Annotation[] paramAnnotations, org.eclipse.microprofile.openapi.annotations.parameters.RequestBody methodRequestBody) {
        if (operation.getRequestBody() == null) {
            org.eclipse.microprofile.openapi.annotations.parameters.RequestBody requestBodyAnnotation = null;
            if (paramAnnotations != null) {
                requestBodyAnnotation = this.getRequestBody(Arrays.asList(paramAnnotations));
            }
            if (requestBodyAnnotation == null && methodRequestBody != null) {
                requestBodyAnnotation = methodRequestBody;
            }
            if (requestBodyAnnotation != null) {
                Optional<RequestBody> optionalRequestBody = OperationParser.getRequestBody(requestBodyAnnotation, classConsumes, methodConsumes, this.components);
                if (optionalRequestBody.isPresent()) {
                    RequestBody requestBody = optionalRequestBody.get();
                    if (StringUtils.isBlank((CharSequence)requestBody.getRef()) && (requestBody.getContent() == null || requestBody.getContent().isEmpty())) {
                        if (requestBodyParameter.getSchema() != null) {
                            Content content = this.processContent(requestBody.getContent(), requestBodyParameter.getSchema(), methodConsumes, classConsumes);
                            requestBody.setContent(content);
                        }
                    } else if (StringUtils.isBlank((CharSequence)requestBody.getRef()) && requestBody.getContent() != null && !requestBody.getContent().isEmpty() && requestBodyParameter.getSchema() != null) {
                        for (MediaType mediaType : requestBody.getContent().values()) {
                            if (mediaType.getSchema() == null) {
                                mediaType.setSchema((org.eclipse.microprofile.openapi.models.media.Schema)new SchemaImpl());
                            }
                            if (mediaType.getSchema().getType() != null) continue;
                            mediaType.getSchema().setType(requestBodyParameter.getSchema().getType());
                        }
                    }
                    operation.setRequestBody(requestBody);
                }
            } else {
                boolean isRequestBodyEmpty = true;
                RequestBodyImpl requestBody = new RequestBodyImpl();
                if (StringUtils.isNotBlank((CharSequence)requestBodyParameter.getRef())) {
                    requestBody.setRef(requestBodyParameter.getRef());
                    isRequestBodyEmpty = false;
                }
                if (StringUtils.isNotBlank((CharSequence)requestBodyParameter.getDescription())) {
                    requestBody.setDescription(requestBodyParameter.getDescription());
                    isRequestBodyEmpty = false;
                }
                if (Boolean.TRUE.equals(requestBodyParameter.getRequired())) {
                    requestBody.setRequired(requestBodyParameter.getRequired());
                    isRequestBodyEmpty = false;
                }
                if (requestBodyParameter.getSchema() != null) {
                    Content content = this.processContent(null, requestBodyParameter.getSchema(), methodConsumes, classConsumes);
                    requestBody.setContent(content);
                    isRequestBodyEmpty = false;
                }
                if (!isRequestBodyEmpty) {
                    operation.setRequestBody((RequestBody)requestBody);
                }
            }
        }
    }

    private org.eclipse.microprofile.openapi.annotations.parameters.RequestBody getRequestBody(List<Annotation> annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation a : annotations) {
            if (!(a instanceof org.eclipse.microprofile.openapi.annotations.parameters.RequestBody)) continue;
            return (org.eclipse.microprofile.openapi.annotations.parameters.RequestBody)a;
        }
        return null;
    }

    private void setMediaTypeToContent(org.eclipse.microprofile.openapi.models.media.Schema schema, Content content, String value) {
        MediaTypeImpl mediaTypeObject = new MediaTypeImpl();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, (MediaType)mediaTypeObject);
    }

    public org.eclipse.microprofile.openapi.models.Operation parseMethod(Method method, List<Parameter> globalParameters) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method, globalParameters, null, null, null, null, new ArrayList<org.eclipse.microprofile.openapi.models.security.SecurityRequirement>(), Optional.empty(), new HashSet<String>(), null, null);
    }

    public org.eclipse.microprofile.openapi.models.Operation parseMethod(Method method, List<Parameter> globalParameters, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, List<org.eclipse.microprofile.openapi.models.security.SecurityRequirement> classSecurityRequirements, Optional<org.eclipse.microprofile.openapi.models.ExternalDocumentation> classExternalDocs, Set<String> classTags, List<Server> classServers, Map<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> classCallbacks) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method, globalParameters, methodProduces, classProduces, methodConsumes, classConsumes, classSecurityRequirements, classExternalDocs, classTags, classServers, classCallbacks);
    }

    private org.eclipse.microprofile.openapi.models.Operation parseMethod(Class<?> cls, Method method, List<Parameter> globalParameters, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, List<org.eclipse.microprofile.openapi.models.security.SecurityRequirement> classSecurityRequirements, Optional<org.eclipse.microprofile.openapi.models.ExternalDocumentation> classExternalDocs, Set<String> classTags, List<Server> classServers, Map<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> classCallbacks) {
        Type returnType;
        Parameter paramAnns;
        Parameter globalParameter2;
        ExternalDocumentation apiExternalDocumentation;
        List<APIResponse> apiResponses;
        List<org.eclipse.microprofile.openapi.annotations.parameters.Parameter> apiParameters;
        Tags tagsAnnotation;
        List<Tag> apiTags;
        List<org.eclipse.microprofile.openapi.annotations.servers.Server> apiServers;
        Operation apiOperation;
        OperationImpl operation;
        block34: {
            block33: {
                Optional<Object> requirementsObject;
                Map<String, Object> ext;
                operation = new OperationImpl();
                apiOperation = ReflectionUtils.getAnnotation(method, Operation.class);
                List<SecurityRequirement> apiSecurity = ReflectionUtils.getRepeatableAnnotations(method, SecurityRequirement.class);
                SecurityRequirementsSet apiSecurityReqSet = ReflectionUtils.getAnnotation(method, SecurityRequirementsSet.class);
                List<Callback> apiCallbacks = ReflectionUtils.getRepeatableAnnotations(method, Callback.class);
                apiServers = ReflectionUtils.getRepeatableAnnotations(method, org.eclipse.microprofile.openapi.annotations.servers.Server.class);
                apiTags = ReflectionUtils.getRepeatableAnnotations(method, Tag.class);
                tagsAnnotation = ReflectionUtils.getAnnotation(method, Tags.class);
                apiParameters = ReflectionUtils.getRepeatableAnnotations(method, org.eclipse.microprofile.openapi.annotations.parameters.Parameter.class);
                apiResponses = ReflectionUtils.getRepeatableAnnotations(method, APIResponse.class);
                List<Extension> operationExtensions = ReflectionUtils.getRepeatableAnnotations(method, Extension.class);
                apiExternalDocumentation = ReflectionUtils.getAnnotation(method, ExternalDocumentation.class);
                if (operationExtensions != null && operationExtensions.size() > 0 && (ext = BaseReaderUtils.parseExtensions(operationExtensions.toArray(new Extension[operationExtensions.size()]))) != null && ext.size() > 0) {
                    ext.forEach((arg_0, arg_1) -> Reader.lambda$parseMethod$16((org.eclipse.microprofile.openapi.models.Operation)operation, arg_0, arg_1));
                }
                LinkedHashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> callbacks = new LinkedHashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback>();
                if (apiCallbacks != null) {
                    for (Callback methodCallback : apiCallbacks) {
                        Map<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> currentCallbacks = this.getCallbacks(methodCallback);
                        callbacks.putAll(currentCallbacks);
                    }
                }
                if (!callbacks.isEmpty()) {
                    operation.setCallbacks(callbacks);
                } else {
                    operation.setCallbacks(classCallbacks);
                }
                if (apiSecurity != null && apiSecurity.size() > 0 && (requirementsObject = SecurityParser.getSecurityRequirements(apiSecurity.toArray(new SecurityRequirement[apiSecurity.size()]))).isPresent()) {
                    ((List)requirementsObject.get()).stream().filter(arg_0 -> Reader.lambda$parseMethod$17((org.eclipse.microprofile.openapi.models.Operation)operation, arg_0)).forEach(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).addSecurityRequirement(arg_0));
                }
                if (apiSecurityReqSet != null && apiSecurityReqSet.value().length > 0 && (requirementsObject = SecurityParser.getSecurityRequirementFromSet(apiSecurityReqSet)).isPresent()) {
                    operation.addSecurityRequirement((org.eclipse.microprofile.openapi.models.security.SecurityRequirement)requirementsObject.get());
                }
                if (operation.getSecurity() == null) break block33;
                if (operation.getSecurity().size() != 0) break block34;
            }
            classSecurityRequirements.forEach(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).addSecurityRequirement(arg_0));
        }
        if (apiServers != null && apiServers.size() > 0) {
            AnnotationsUtils.getServers(apiServers.toArray(new org.eclipse.microprofile.openapi.annotations.servers.Server[apiServers.size()])).ifPresent(arg_0 -> Reader.lambda$parseMethod$18((org.eclipse.microprofile.openapi.models.Operation)operation, arg_0));
        } else if (classServers != null && classServers.size() > 0) {
            operation.setServers(classServers);
        }
        AnnotationsUtils.getExternalDocumentation(apiExternalDocumentation).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).setExternalDocs(arg_0));
        if (apiTags != null && !apiTags.isEmpty() || tagsAnnotation != null && ArrayUtils.isNotEmpty((Object[])tagsAnnotation.refs())) {
            Stream<String> operationTags = Stream.empty();
            if (apiTags != null) {
                operationTags = apiTags.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.name()) || StringUtils.isNotBlank((CharSequence)t.ref())).map(t -> {
                    if (StringUtils.isNotBlank((CharSequence)t.ref())) {
                        return t.ref();
                    }
                    return t.name();
                });
                AnnotationsUtils.getTags(apiTags.toArray(new Tag[apiTags.size()]), true).ifPresent(tags -> this.openApiTags.addAll((Collection<org.eclipse.microprofile.openapi.models.tags.Tag>)tags));
            }
            if (tagsAnnotation != null && ArrayUtils.isNotEmpty((Object[])tagsAnnotation.refs())) {
                operationTags = Stream.concat(operationTags, Stream.of(tagsAnnotation.refs()).filter(StringUtils::isNotBlank));
            }
            operationTags.distinct().forEach(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).addTag(arg_0));
        } else if (classTags != null && !classTags.isEmpty()) {
            operation.setTags(new ArrayList<String>(classTags));
        }
        if (globalParameters != null) {
            for (Parameter globalParameter2 : globalParameters) {
                operation.addParameter(globalParameter2);
            }
        }
        if (apiParameters != null) {
            this.getParametersListFromAnnotation(apiParameters.toArray(new org.eclipse.microprofile.openapi.annotations.parameters.Parameter[apiParameters.size()]), classConsumes, methodConsumes, (org.eclipse.microprofile.openapi.models.Operation)operation).ifPresent(arg_0 -> Reader.lambda$parseMethod$22((org.eclipse.microprofile.openapi.models.Operation)operation, arg_0));
        }
        globalParameter2 = paramAnns = ReflectionUtils.getParameterAnnotations(method);
        int currentCallbacks = ((Annotation[][])globalParameter2).length;
        for (int i = 0; i < currentCallbacks; ++i) {
            Parameter annotations;
            for (Parameter annotation : annotations = globalParameter2[i]) {
                if (!(annotation instanceof Parameters)) continue;
                Parameters params = (Parameters)annotation;
                this.getParametersListFromAnnotation(params.value(), classConsumes, methodConsumes, (org.eclipse.microprofile.openapi.models.Operation)operation).ifPresent(arg_0 -> Reader.lambda$parseMethod$23((org.eclipse.microprofile.openapi.models.Operation)operation, arg_0));
            }
        }
        if (apiResponses != null) {
            OperationParser.getApiResponses(apiResponses.toArray(new APIResponse[apiResponses.size()]), classProduces, methodProduces, this.components).ifPresent(arg_0 -> Reader.lambda$parseMethod$24((org.eclipse.microprofile.openapi.models.Operation)operation, arg_0));
        }
        if (StringUtils.isBlank((CharSequence)operation.getOperationId())) {
            operation.setOperationId(method.getName());
        }
        if (apiOperation != null) {
            this.setOperationObjectFromApiOperationAnnotation((org.eclipse.microprofile.openapi.models.Operation)operation, apiOperation, methodProduces, classProduces, methodConsumes, classConsumes);
        }
        if (operation.getExternalDocs() == null) {
            classExternalDocs.ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).setExternalDocs(arg_0));
        }
        if (!this.shouldIgnoreClass((returnType = method.getGenericReturnType()).getTypeName())) {
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAnnotatedType(returnType, new ArrayList<Annotation>(), "");
            if (resolvedSchema.schema != null) {
                Map<String, org.eclipse.microprofile.openapi.models.media.Schema> schemaMap;
                org.eclipse.microprofile.openapi.models.media.Schema returnTypeSchema = resolvedSchema.schema;
                ContentImpl content = new ContentImpl();
                MediaType mediaType = new MediaTypeImpl().schema(returnTypeSchema);
                AnnotationsUtils.applyTypes(classProduces == null ? new String[]{} : classProduces.value(), methodProduces == null ? new String[]{} : methodProduces.value(), (Content)content, mediaType);
                if (operation.getResponses() == null) {
                    operation.responses(new APIResponsesImpl().defaultValue(new APIResponseImpl().description(DEFAULT_DESCRIPTION).content((Content)content)));
                }
                if (operation.getResponses().getDefault() != null && StringUtils.isBlank((CharSequence)operation.getResponses().getDefault().getRef()) && operation.getResponses().getDefault().getContent() == null) {
                    operation.getResponses().getDefault().content((Content)content);
                }
                if ((schemaMap = resolvedSchema.referencedSchemas) != null) {
                    schemaMap.forEach((key, schema) -> this.components.addSchema(key, schema));
                }
            }
        }
        if (operation.getResponses() == null || operation.getResponses().size() == 0) {
            APIResponseImpl apiResponseObject = new APIResponseImpl();
            apiResponseObject.setDescription(DEFAULT_DESCRIPTION);
            operation.setResponses(new APIResponsesImpl().defaultValue((org.eclipse.microprofile.openapi.models.responses.APIResponse)apiResponseObject));
        }
        return operation;
    }

    private boolean shouldIgnoreClass(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return true;
        }
        boolean ignore = false;
        ignore = ignore || className.startsWith("javax.ws.rs.");
        ignore = ignore || className.equalsIgnoreCase("void");
        return ignore;
    }

    private Map<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> getCallbacks(Callback apiCallback) {
        HashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> callbackMap = new HashMap<String, org.eclipse.microprofile.openapi.models.callbacks.Callback>();
        if (apiCallback == null) {
            return callbackMap;
        }
        CallbackImpl callbackObject = new CallbackImpl();
        if (StringUtils.isNotBlank((CharSequence)apiCallback.ref())) {
            callbackObject.setRef(apiCallback.ref());
        }
        if (apiCallback.operations().length > 0) {
            PathItemImpl pathItemObject = new PathItemImpl();
            for (CallbackOperation callbackOperation : apiCallback.operations()) {
                OperationImpl callbackNewOperation = new OperationImpl();
                this.setOperationObjectFromApiOperationAnnotation((org.eclipse.microprofile.openapi.models.Operation)callbackNewOperation, callbackOperation);
                this.setPathItemOperation((PathItem)pathItemObject, callbackOperation.method(), (org.eclipse.microprofile.openapi.models.Operation)callbackNewOperation);
            }
            callbackObject.addPathItem(apiCallback.callbackUrlExpression(), (PathItem)pathItemObject);
        }
        callbackMap.put(AnnotationsUtils.getNameOfReferenceableItem(apiCallback), (org.eclipse.microprofile.openapi.models.callbacks.Callback)callbackObject);
        return callbackMap;
    }

    private void setPathItemOperation(PathItem pathItemObject, String method, org.eclipse.microprofile.openapi.models.Operation operation) {
        switch (method) {
            case "post": {
                pathItemObject.POST(operation);
                break;
            }
            case "get": {
                pathItemObject.GET(operation);
                break;
            }
            case "delete": {
                pathItemObject.DELETE(operation);
                break;
            }
            case "put": {
                pathItemObject.PUT(operation);
                break;
            }
            case "patch": {
                pathItemObject.PATCH(operation);
                break;
            }
            case "trace": {
                pathItemObject.TRACE(operation);
                break;
            }
            case "head": {
                pathItemObject.HEAD(operation);
                break;
            }
            case "options": {
                pathItemObject.OPTIONS(operation);
                break;
            }
        }
    }

    private void setOperationObjectFromApiOperationAnnotation(org.eclipse.microprofile.openapi.models.Operation operation, Operation apiOperation, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes) {
        if (StringUtils.isNotBlank((CharSequence)apiOperation.summary())) {
            operation.setSummary(apiOperation.summary());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.description())) {
            operation.setDescription(apiOperation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.operationId())) {
            operation.setOperationId(this.getOperationId(apiOperation.operationId()));
        }
        if (apiOperation.deprecated()) {
            operation.setDeprecated(Boolean.valueOf(apiOperation.deprecated()));
        }
    }

    private void setOperationObjectFromApiOperationAnnotation(org.eclipse.microprofile.openapi.models.Operation operation, CallbackOperation callbackOp) {
        if (StringUtils.isNotBlank((CharSequence)callbackOp.summary())) {
            operation.setSummary(callbackOp.summary());
        }
        if (StringUtils.isNotBlank((CharSequence)callbackOp.description())) {
            operation.setDescription(callbackOp.description());
        }
        AnnotationsUtils.getExternalDocumentation(callbackOp.externalDocs()).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).setExternalDocs(arg_0));
        this.getParametersListFromAnnotation(callbackOp.parameters(), null, null, operation).ifPresent(p -> p.forEach(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).addParameter(arg_0)));
        SecurityParser.getSecurityRequirements(callbackOp.security()).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).setSecurity(arg_0));
        OperationParser.getApiResponses(callbackOp.responses(), null, null, this.components).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).setResponses(arg_0));
        this.processRequestBody((Parameter)new ParameterImpl(), operation, null, null, null, callbackOp.requestBody());
    }

    protected String getOperationId(String operationId) {
        boolean operationIdUsed = this.existOperationId(operationId);
        String operationIdToFind = null;
        int counter = 0;
        while (operationIdUsed) {
            operationIdToFind = String.format("%s_%d", operationId, ++counter);
            operationIdUsed = this.existOperationId(operationIdToFind);
        }
        if (operationIdToFind != null) {
            operationId = operationIdToFind;
        }
        return operationId;
    }

    private boolean existOperationId(String operationId) {
        if (this.openAPI == null) {
            return false;
        }
        if (this.openAPI.getPaths() == null || this.openAPI.getPaths().isEmpty()) {
            return false;
        }
        for (PathItem path : this.openAPI.getPaths().values()) {
            String pathOperationId = this.extractOperationIdFromPathItem(path);
            if (!operationId.equalsIgnoreCase(pathOperationId)) continue;
            return true;
        }
        return false;
    }

    protected Optional<List<Parameter>> getParametersListFromAnnotation(org.eclipse.microprofile.openapi.annotations.parameters.Parameter[] parameters, Consumes classConsumes, Consumes methodConsumes, org.eclipse.microprofile.openapi.models.Operation operation) {
        if (parameters == null) {
            return Optional.empty();
        }
        ArrayList<Parameter> parametersObject = new ArrayList<Parameter>();
        for (org.eclipse.microprofile.openapi.annotations.parameters.Parameter parameter : parameters) {
            ResolvedParameter resolvedParameter = this.getParameters(ParameterProcessor.getParameterType(parameter), Collections.singletonList(parameter), operation, classConsumes, methodConsumes);
            parametersObject.addAll(resolvedParameter.parameters);
        }
        if (parametersObject.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(parametersObject);
    }

    protected ResolvedParameter getParameters(Type type, List<Annotation> annotations, org.eclipse.microprofile.openapi.models.Operation operation, Consumes classConsumes, Consumes methodConsumes) {
        Iterator<OpenAPIExtension> chain = OpenAPIExtensions.chain();
        if (!chain.hasNext()) {
            return new ResolvedParameter();
        }
        HashSet<Type> typesToSkip = new HashSet<Type>();
        OpenAPIExtension extension = chain.next();
        ResolvedParameter extractParametersResult = extension.extractParameters(annotations, type, typesToSkip, this.components, classConsumes, methodConsumes, true, chain);
        return extractParametersResult;
    }

    private String extractOperationIdFromPathItem(PathItem path) {
        if (path.getGET() != null) {
            return path.getGET().getOperationId();
        }
        if (path.getPOST() != null) {
            return path.getPOST().getOperationId();
        }
        if (path.getPUT() != null) {
            return path.getPUT().getOperationId();
        }
        if (path.getDELETE() != null) {
            return path.getDELETE().getOperationId();
        }
        if (path.getOPTIONS() != null) {
            return path.getOPTIONS().getOperationId();
        }
        if (path.getHEAD() != null) {
            return path.getHEAD().getOperationId();
        }
        if (path.getPATCH() != null) {
            return path.getPATCH().getOperationId();
        }
        return "";
    }

    private boolean isEmptyComponents(org.eclipse.microprofile.openapi.models.Components components) {
        if (components == null) {
            return true;
        }
        if (components.getSchemas() != null && components.getSchemas().size() > 0) {
            return false;
        }
        if (components.getSecuritySchemes() != null && components.getSecuritySchemes().size() > 0) {
            return false;
        }
        if (components.getCallbacks() != null && components.getCallbacks().size() > 0) {
            return false;
        }
        if (components.getExamples() != null && components.getExamples().size() > 0) {
            return false;
        }
        if (components.getExtensions() != null && components.getExtensions().size() > 0) {
            return false;
        }
        if (components.getHeaders() != null && components.getHeaders().size() > 0) {
            return false;
        }
        if (components.getLinks() != null && components.getLinks().size() > 0) {
            return false;
        }
        if (components.getParameters() != null && components.getParameters().size() > 0) {
            return false;
        }
        if (components.getRequestBodies() != null && components.getRequestBodies().size() > 0) {
            return false;
        }
        return components.getResponses() == null || components.getResponses().size() <= 0;
    }

    protected boolean isOperationHidden(Method method) {
        Operation apiOperation = ReflectionUtils.getAnnotation(method, Operation.class);
        return apiOperation != null && apiOperation.hidden();
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }

    protected boolean ignoreOperationPath(String path, String parentPath) {
        if (StringUtils.isBlank((CharSequence)path) && StringUtils.isBlank((CharSequence)parentPath)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isBlank((CharSequence)parentPath)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)parentPath)) {
            return false;
        }
        if (parentPath != null && !"".equals(parentPath) && !"/".equals(parentPath)) {
            if (!parentPath.startsWith("/")) {
                parentPath = "/" + parentPath;
            }
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
        }
        if (path != null && !"".equals(path) && !"/".equals(path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path.equals(parentPath);
    }

    private static /* synthetic */ void lambda$parseMethod$24(org.eclipse.microprofile.openapi.models.Operation operation, APIResponses responses) {
        if (operation.getResponses() == null) {
            operation.setResponses(responses);
        } else {
            responses.forEach((arg_0, arg_1) -> ((APIResponses)operation.getResponses()).addApiResponse(arg_0, arg_1));
        }
    }

    private static /* synthetic */ void lambda$parseMethod$23(org.eclipse.microprofile.openapi.models.Operation operation, List p) {
        p.forEach(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).addParameter(arg_0));
    }

    private static /* synthetic */ void lambda$parseMethod$22(org.eclipse.microprofile.openapi.models.Operation operation, List p) {
        p.forEach(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).addParameter(arg_0));
    }

    private static /* synthetic */ void lambda$parseMethod$18(org.eclipse.microprofile.openapi.models.Operation operation, List servers) {
        servers.forEach(arg_0 -> ((org.eclipse.microprofile.openapi.models.Operation)operation).addServer(arg_0));
    }

    private static /* synthetic */ boolean lambda$parseMethod$17(org.eclipse.microprofile.openapi.models.Operation operation, org.eclipse.microprofile.openapi.models.security.SecurityRequirement r) {
        return operation.getSecurity() == null || !operation.getSecurity().contains(r);
    }

    private static /* synthetic */ void lambda$parseMethod$16(org.eclipse.microprofile.openapi.models.Operation operation, String k, Object v) {
        ((OperationImpl)operation).addExtension_compat(k, v);
    }

    private static /* synthetic */ void lambda$handleComponentsAnnotation$13(Map exampleMap, ExampleObject exampleObject, Example example) {
        exampleMap.put(exampleObject.name(), example);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Reader.class);
    }
}

