/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.ejb;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ejbcontainer.osgi.EJBContainer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.ejb.EJBJaxWsWebEndpoint;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ejbcontainer.WSEJBEndpointManager;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EJBPreInvokeInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    private final Class<?> implClass;
    private final J2EEName j2EEName;
    private final EJBContainer ejbContainer;
    private final Method[] methods;
    private EJBJaxWsWebEndpoint ejbJaxWsWebEndpoint;
    private volatile boolean handlerChainInitializationRequired = true;
    private final Object handlerInitializationLock = new Object(){
        static final long serialVersionUID = -884320459367628111L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private static final TraceComponent tc = Tr.register(EJBPreInvokeInterceptor.class);
    static final long serialVersionUID = -6219338842715082275L;

    public EJBPreInvokeInterceptor(J2EEName j2EEName, Class<?> implClass, EJBContainer ejbContainer, List<Method> methods) {
        super("pre-protocol-frontend");
        this.implClass = implClass;
        this.j2EEName = j2EEName;
        this.ejbContainer = ejbContainer;
        this.methods = methods == null ? null : methods.toArray(new Method[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void handleMessage(SoapMessage message) throws Fault {
        Exchange exchange = message.getExchange();
        WSEJBEndpointManager endpointManager = null;
        Method targetMethod = null;
        try {
            if (this.implClass.isAnnotationPresent(WebServiceProvider.class)) {
                endpointManager = this.ejbContainer.createWebServiceEndpointManager(this.j2EEName, Provider.class);
                targetMethod = this.getProviderMethod(this.implClass);
            } else {
                endpointManager = this.ejbContainer.createWebServiceEndpointManager(this.j2EEName, this.methods);
                targetMethod = this.getTargetMethod(this.implClass, message);
            }
            if (targetMethod == null) {
                throw new IllegalStateException("Invocation target method should not be null.");
            }
        }
        catch (EJBConfigurationException eJBConfigurationException) {
            void e;
            FFDCFilter.processException((Throwable)eJBConfigurationException, (String)"com.ibm.ws.jaxws.ejb.EJBPreInvokeInterceptor", (String)"100", (Object)((Object)this), (Object[])new Object[]{message});
            throw new IllegalStateException((Throwable)e);
        }
        Object instance = null;
        WrappedMessageContext ctx = new WrappedMessageContext((Message)message, MessageContext.Scope.APPLICATION);
        try {
            instance = endpointManager.ejbPreInvoke(targetMethod, (Map)ctx);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Execute ejbPreInvoke successfully in EJBPreInvokeInterceptor handleMessage: ", (Object[])new Object[]{instance});
            }
            if (this.handlerChainInitializationRequired) {
                Object object = this.handlerInitializationLock;
                synchronized (object) {
                    if (this.handlerChainInitializationRequired) {
                        this.ejbJaxWsWebEndpoint.initializeHandlers(message);
                        this.handlerChainInitializationRequired = false;
                    }
                }
            }
            exchange.put((Object)"com.ibm.ws.jaxws.EXCHANGE_EJBINSTANCE", instance);
        }
        catch (RemoteException remoteException) {
            void e;
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.jaxws.ejb.EJBPreInvokeInterceptor", (String)"129", (Object)((Object)this), (Object[])new Object[]{message});
            throw new IllegalStateException((Throwable)e);
        }
        finally {
            exchange.put((Object)"com.ibm.ws.jaxws.EXCHANGE_WSEJBENDPOINTMANAGER", (Object)endpointManager);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleFault(SoapMessage message) {
        block4: {
            try {
                Exchange exchange = message.getExchange();
                WSEJBEndpointManager endpointManager = (WSEJBEndpointManager)exchange.get((Object)"com.ibm.ws.jaxws.EXCHANGE_WSEJBENDPOINTMANAGER");
                if (endpointManager != null) {
                    endpointManager.ejbPostInvoke();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Execute ejbPostInvoke successfully in EJBPreInvokeInterceptor handleFault", (Object[])new Object[0]);
                    }
                }
            }
            catch (Exception exchange) {
                void e;
                FFDCFilter.processException((Throwable)exchange, (String)"com.ibm.ws.jaxws.ejb.EJBPreInvokeInterceptor", (String)"151", (Object)((Object)this), (Object[])new Object[]{message});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception occurred when attempting ejbPostInvoke: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    protected Method getProviderMethod(final Class<?> providerClass) {
        Method providerMethod = null;
        Method[] methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){
            static final long serialVersionUID = -8734799343377478827L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Method[] run() {
                return providerClass.getMethods();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        if (methods != null) {
            for (Method method : methods) {
                if (!method.getName().equals("invoke")) continue;
                providerMethod = method;
                break;
            }
        }
        return providerMethod;
    }

    private Method getTargetMethod(Class<?> implClass, SoapMessage message) {
        this.setupBindingOperationInfo(message);
        BindingOperationInfo bop = message.getExchange().getBindingOperationInfo();
        if (bop == null) {
            return null;
        }
        return this.getMethod((Message)message, bop);
    }

    private void setupBindingOperationInfo(SoapMessage message) {
        Exchange exch = message.getExchange();
        if (exch.get(BindingOperationInfo.class) == null) {
            QName opName = this.getOpQName(message);
            if (opName == null) {
                return;
            }
            BindingOperationInfo bop = ServiceModelUtil.getOperationForWrapperElement((Exchange)exch, (QName)opName, (boolean)false);
            if (bop == null) {
                bop = ServiceModelUtil.getOperation((Exchange)exch, (QName)opName);
            }
            if (bop != null) {
                exch.put(BindingOperationInfo.class, (Object)bop);
                exch.put(OperationInfo.class, (Object)bop.getOperationInfo());
                if (bop.getOutput() == null) {
                    exch.setOneWay(true);
                }
            }
        }
    }

    private QName getOpQName(SoapMessage message) {
        SOAPMessageContextImpl sm = new SOAPMessageContextImpl((Message)message);
        try {
            Node nd;
            SOAPMessage msg = sm.getMessage();
            if (msg == null) {
                return null;
            }
            SOAPBody body = SAAJUtils.getBody((SOAPMessage)msg);
            if (body == null) {
                return null;
            }
            for (nd = body.getFirstChild(); nd != null && !(nd instanceof Element); nd = nd.getNextSibling()) {
            }
            if (nd != null) {
                return new QName(nd.getNamespaceURI(), nd.getLocalName());
            }
            Collection boi = message.getExchange().getEndpoint().getEndpointInfo().getBinding().getOperations();
            if (boi.size() > 0) {
                return ((BindingOperationInfo)boi.iterator().next()).getName();
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.jaxws.ejb.EJBPreInvokeInterceptor", (String)"234", (Object)((Object)this), (Object[])new Object[]{message});
        }
        return null;
    }

    private Method getMethod(Message message, BindingOperationInfo operation) {
        MethodDispatcher md = (MethodDispatcher)((Service)message.getExchange().get(Service.class)).get((Object)MethodDispatcher.class.getName());
        return md.getMethod(operation);
    }

    public void setEjbJaxWsWebEndpoint(EJBJaxWsWebEndpoint ejbJaxWsWebEndpoint) {
        this.ejbJaxWsWebEndpoint = ejbJaxWsWebEndpoint;
    }
}

