/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.impl.StatementCacheKey;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;

public class WSJdbcPreparedStatement
extends WSJdbcStatement
implements PreparedStatement {
    private static final TraceComponent tc = Tr.register(WSJdbcPreparedStatement.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    protected PreparedStatement pstmtImpl;
    protected StatementCacheKey key;
    protected String sql;
    Object sqljSection;

    public WSJdbcPreparedStatement() {
        this.poolabilityHint = true;
    }

    public WSJdbcPreparedStatement(PreparedStatement pstmtImplObject, WSJdbcConnection connWrapper, int theHoldability, String pstmtSQL) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{AdapterUtil.toString(pstmtImplObject), connWrapper, AdapterUtil.getCursorHoldabilityString(theHoldability)});
        }
        this.pstmtImpl = pstmtImplObject;
        this.stmtImpl = this.pstmtImpl;
        this.init(connWrapper);
        this.sql = pstmtSQL;
        this.poolabilityHint = true;
        this.holdability = theHoldability;
        this.mcf = this.parentWrapper.mcf;
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.<init>", (String)"94", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("current fetchSize is " + this.currentFetchSize));
        }
    }

    public WSJdbcPreparedStatement(PreparedStatement pstmtImplObject, WSJdbcConnection connWrapper, int theHoldability, String pstmtSQL, StatementCacheKey pstmtKey) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{AdapterUtil.toString(pstmtImplObject), connWrapper, AdapterUtil.getCursorHoldabilityString(theHoldability), pstmtKey});
        }
        this.pstmtImpl = pstmtImplObject;
        this.stmtImpl = this.pstmtImpl;
        this.init(connWrapper);
        this.sql = pstmtSQL;
        this.key = pstmtKey;
        this.poolabilityHint = true;
        this.holdability = theHoldability;
        this.mcf = this.parentWrapper.mcf;
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.<init>", (String)"184", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("current fetchSize is " + this.currentFetchSize));
        }
    }

    @Override
    public void addBatch() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"addBatch", (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.addBatch();
            this.hasBatchParameters = true;
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"addBatch", (Object[])new Object[]{ex});
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    private Object addBatch(Object implObject, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        InvocationHandler handler;
        Object sqljPstmt = args[0];
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addBatch", (Object[])new Object[]{this, AdapterUtil.toString(sqljPstmt)});
        }
        if (sqljPstmt != null && Proxy.isProxyClass(sqljPstmt.getClass()) && (handler = Proxy.getInvocationHandler(sqljPstmt)) instanceof WSJdbcWrapper) {
            args = new Object[]{((WSJdbcWrapper)handler).getJDBCImplObject()};
        }
        return method.invoke(implObject, args);
    }

    @Override
    public void clearParameters() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"clearParameters", (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.clearParameters();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.clearParameters", (String)"87", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected SQLException closeWrapper(boolean closeWrapperOnly) {
        SQLException sqlX;
        boolean isTraceOn;
        block25: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            sqlX = null;
            try {
                this.parentWrapper.childWrappers.remove(this);
            }
            catch (RuntimeException runtimeX) {
                if (this.parentWrapper.state == WSJdbcWrapper.State.CLOSED) break block25;
                throw runtimeX;
            }
        }
        if (this.key == null || !this.poolabilityHint) {
            try {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)(this.key == null ? "statement caching is disabled" : "statement is not poolable"), (Object[])new Object[0]);
                }
                this.pstmtImpl.close();
            }
            catch (SQLException closeX) {
                FFDCFilter.processException((Throwable)closeX, (String)(this.getClass().getName() + ".closeWrapper"), (String)"264", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object[])new Object[]{this.pstmtImpl, closeX});
                sqlX = closeX;
            }
        } else {
            WSRdbManagedConnectionImpl mc = ((WSJdbcConnection)this.parentWrapper).managedConn;
            if (mc == null) {
                try {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Not associated with a ManagedConnection. Statement cannot be cached.", (Object[])new Object[0]);
                    }
                    this.pstmtImpl.close();
                }
                catch (SQLException closeX) {
                    FFDCFilter.processException((Throwable)closeX, (String)(this.getClass().getName() + ".closeWrapper"), (String)"281", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object[])new Object[]{this.pstmtImpl, closeX});
                    sqlX = closeX;
                }
            } else {
                try {
                    if (!this.pstmtImpl.getMoreResults() && this.mcf.getHelper().getUpdateCount(this) == -1L) {
                        if (this.haveStatementPropertiesChanged) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Cleaning up Statement", (Object[])new Object[0]);
                            }
                            this.mcf.getHelper().doStatementCleanup(this.pstmtImpl);
                            this.haveStatementPropertiesChanged = false;
                        }
                        this.pstmtImpl.clearParameters();
                        if (this.hasBatchParameters) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Clearing batch parameters", (Object[])new Object[0]);
                            }
                            this.pstmtImpl.clearBatch();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Attempt to cache statement", (Object[])new Object[0]);
                        }
                        mc.cacheStatement(this.pstmtImpl, this.key);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Cannot cache statement as there are unprocessed results", (Object[])new Object[0]);
                        }
                        this.pstmtImpl.close();
                    }
                }
                catch (SQLException cleanupX) {
                    if (!mc.isAborted()) {
                        FFDCFilter.processException((Throwable)cleanupX, (String)(this.getClass().getName() + ".closeWrapper"), (String)"310", (Object)this);
                        sqlX = cleanupX;
                    }
                    try {
                        this.pstmtImpl.close();
                    }
                    catch (SQLException closeX) {
                        FFDCFilter.processException((Throwable)closeX, (String)(this.getClass().getName() + ".closeWrapper"), (String)"321", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object[])new Object[]{this.pstmtImpl, closeX});
                    }
                }
            }
        }
        this.stmtImpl = null;
        this.pstmtImpl = null;
        this.key = null;
        this.sql = null;
        return sqlX == null ? null : WSJdbcUtil.mapException(this, sqlX);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        super.closeOnCompletion();
        this.key = null;
    }

    @Override
    public boolean execute() throws SQLException {
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"execute", (Object[])new Object[0]);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            result = this.pstmtImpl.execute();
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)"NullPointerException");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (RuntimeException rte) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)rte);
            }
            throw rte;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)(result ? "QUERY" : "UPDATE"));
        }
        return result;
    }

    private Object executeBatch(Object implObject, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeBatch", (Object[])new Object[]{this, args[0]});
        }
        if (this.childWrapper != null) {
            this.closeAndRemoveResultSet();
        }
        if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
            this.closeAndRemoveResultSets();
        }
        this.enforceStatementProperties();
        Object results = method.invoke(implObject, args);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)(results instanceof int[] ? Arrays.toString((int[])results) : results));
        }
        return results;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object[])new Object[0]);
        }
        WSJdbcResultSet rsetWrapper = null;
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            rsetWrapper = this.createResultSetWrapper(this.pstmtImpl.executeQuery());
            this.childWrapper = rsetWrapper;
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object)"NullPointerException");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (RuntimeException rte) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object)rte);
            }
            throw rte;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeQuery", (Object)this.childWrapper);
        }
        return rsetWrapper;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object[])new Object[0]);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.pstmtImpl.executeUpdate();
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)"NullPpointerException");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (RuntimeException rte) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)rte);
            }
            throw rte;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object[])new Object[0]);
        }
        ResultSetMetaData md = null;
        try {
            md = this.pstmtImpl.getMetaData();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.getMetaData", (String)"621", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)md);
        }
        return md;
    }

    private Object getReturnResultSet(Object implObject, Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getReturnResultSet", (Object[])new Object[]{this});
        }
        WSJdbcResultSet rsetWrapper = null;
        ResultSet rsetImpl = (ResultSet)method.invoke(implObject, new Object[0]);
        if (rsetImpl != null) {
            if (this.childWrapper == null && (this.childWrappers == null || this.childWrappers.isEmpty())) {
                rsetWrapper = this.mcf.jdbcRuntime.newResultSet(rsetImpl, this);
                this.childWrapper = rsetWrapper;
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set the result set to child wrapper", (Object[])new Object[0]);
                }
            } else {
                if (this.childWrappers == null) {
                    this.childWrappers = new ArrayList(5);
                }
                rsetWrapper = this.mcf.jdbcRuntime.newResultSet(rsetImpl, this);
                this.childWrappers.add(rsetWrapper);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add the result set to child wrappers list.", (Object[])new Object[0]);
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getReturnResultSet", rsetWrapper);
        }
        return rsetWrapper;
    }

    private Object getSingletonResultSet(Object implObject, Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSingletonResultSet", (Object[])new Object[]{this});
        }
        Object sqljWrapper = null;
        ResultSet rsetImpl = (ResultSet)method.invoke(implObject, new Object[0]);
        if (rsetImpl != null) {
            WSJdbcResultSet rsetWrapper;
            if (this.childWrapper == null && (this.childWrappers == null || this.childWrappers.isEmpty())) {
                rsetWrapper = this.mcf.jdbcRuntime.newResultSet(rsetImpl, this);
                this.childWrapper = rsetWrapper;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set the result set to child wrapper", (Object[])new Object[0]);
                }
            } else {
                if (this.childWrappers == null) {
                    this.childWrappers = new ArrayList(5);
                }
                rsetWrapper = this.mcf.jdbcRuntime.newResultSet(rsetImpl, this);
                this.childWrappers.add(rsetWrapper);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add the result set to child wrappers list.", (Object[])new Object[0]);
                }
            }
            sqljWrapper = rsetWrapper.unwrap(method.getReturnType());
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSingletonResultSet", sqljWrapper);
        }
        return sqljWrapper;
    }

    @Override
    protected TraceComponent getTracer() {
        return tc;
    }

    @Override
    protected void introspectWrapperSpecificInfo(FFDCLogger info) {
        super.introspectWrapperSpecificInfo(info);
        info.append("key:", this.key);
        info.append("sql:", this.sql);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.haveStatementPropertiesChanged && VENDOR_PROPERTY_SETTERS.contains(method.getName())) {
            this.haveStatementPropertiesChanged = true;
        }
        if (this.sqljSection != null && "getSection".equals(method.getName())) {
            return this.sqljSection;
        }
        return super.invoke(proxy, method, args);
    }

    @Override
    Object invokeOperation(Object implObject, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        if (args == null || args.length == 0) {
            String methodName = method.getName();
            if (methodName.equals("getReturnResultSet")) {
                return this.getReturnResultSet(implObject, method);
            }
            if (methodName.equals("getSingletonResultSet")) {
                return this.getSingletonResultSet(implObject, method);
            }
        } else if (args.length == 1) {
            String methodName = method.getName();
            if (methodName.equals("addBatch") && method.getParameterTypes()[0].getName().equals("com.ibm.db2.jcc.SQLJPreparedStatement")) {
                return this.addBatch(implObject, method, args);
            }
            if (methodName.equals("executeBatch")) {
                return this.executeBatch(implObject, method, args);
            }
            if (methodName.equals("setSection") && method.getParameterTypes()[0].getName().equals("com.ibm.db2.jcc.SQLJSection")) {
                this.sqljSection = args[0];
            }
        }
        return super.invokeOperation(implObject, method, args);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setArray #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setArray(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setArray", (String)"500", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setAsciiStream(int i, InputStream x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setAsciiStream #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setAsciiStream(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setAsciiStream"), (String)"1057", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setAsciiStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setAsciiStream"), (String)"1054", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setAsciiStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setAsciiStream"), (String)"1061", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setAsciiStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setAsciiStream #" + i), (Object[])new Object[]{length});
        }
        try {
            this.pstmtImpl.setAsciiStream(i, x, length);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setAsciiStream", (String)"522", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setAsciiStream(int i, InputStream x, long length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setAsciiStream #" + i), (Object[])new Object[]{"length = " + length});
        }
        try {
            this.pstmtImpl.setAsciiStream(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setAsciiStream"), (String)"1057", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setAsciiStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setAsciiStream"), (String)"1123", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setAsciiStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setAsciiStream"), (String)"1130", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setAsciiStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBigDecimal #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setBigDecimal(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBigDecimal", (String)"544", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setBinaryStream(int i, InputStream x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBinaryStream #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setBinaryStream(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setBinaryStream"), (String)"1127", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setBinaryStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setBinaryStream"), (String)"1192", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setBinaryStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setBinaryStream"), (String)"1199", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setBinaryStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBinaryStream #" + i), (Object[])new Object[]{length});
        }
        try {
            this.pstmtImpl.setBinaryStream(i, x, length);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBinaryStream", (String)"566", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setBinaryStream(int i, InputStream x, long length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBinaryStream #" + i), (Object[])new Object[]{"length = " + length});
        }
        try {
            this.pstmtImpl.setBinaryStream(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setBinaryStream"), (String)"1127", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setBinaryStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setBinaryStream"), (String)"1261", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setBinaryStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setBinaryStream"), (String)"1268", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setBinaryStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBlob #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setBlob(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBlob", (String)"588", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setBlob(int i, InputStream x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBlob #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setBlob(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setBlob"), (String)"1175", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setBlob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setBlob"), (String)"1330", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setBlob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setBlob"), (String)"1337", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setBlob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setBlob(int i, InputStream x, long length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBlob #" + i), (Object[])new Object[]{"length = " + length});
        }
        try {
            this.pstmtImpl.setBlob(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setBlob"), (String)"1283", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setBlob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setBlob"), (String)"1299", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setBlob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setBlob"), (String)"1306", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setBlob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBoolean #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setBoolean(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBoolean", (String)"610", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setByte #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setByte(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setByte", (String)"632", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setBytes #" + i), (Object[])new Object[0]);
        }
        try {
            this.mcf.getHelper().psSetBytes(this.pstmtImpl, i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBytes", (String)"654", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            FFDCFilter.processException((Throwable)nullX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBytes", (String)"949", (Object)this);
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setCharacterStream #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setCharacterStream(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setCharacterStream"), (String)"1292", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setCharacterStream"), (String)"1490", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setCharacterStream"), (String)"1497", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setCharacterStream #" + i), (Object[])new Object[]{length});
        }
        try {
            this.pstmtImpl.setCharacterStream(i, x, length);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setCharacterStream", (String)"677", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, long length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setCharacterStream #" + i), (Object[])new Object[]{"length = " + length});
        }
        try {
            this.pstmtImpl.setCharacterStream(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setCharacterStream"), (String)"1292", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setCharacterStream"), (String)"1560", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setCharacterStream"), (String)"1567", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setClob #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setClob(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setClob", (String)"699", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setClob(int i, Reader x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setClob #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setClob(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setClob"), (String)"1340", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setClob"), (String)"1629", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setClob"), (String)"1636", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setClob(int i, Reader x, long length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setClob #" + i), (Object[])new Object[]{"length = " + length});
        }
        try {
            this.pstmtImpl.setClob(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setClob"), (String)"1534", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setClob"), (String)"1550", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setClob"), (String)"1558", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setDate #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setDate(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDate", (String)"721", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setDate(int i, Date x, Calendar cal) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setDate with Calendar #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setDate(i, x, cal);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDate", (String)"743", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setDouble #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setDouble(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDouble", (String)"765", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setFloat #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setFloat(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setFloat", (String)"787", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setInt #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setInt(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setInt", (String)"809", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setLong #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setLong(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setLong", (String)"831", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setNCharacterStream(int i, Reader x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setNCharacterStream #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setCharacterStream(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setNCharacterStream"), (String)"1499", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setNCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setNCharacterStream"), (String)"1853", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setNCharacterStream"), (String)"1860", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setNCharacterStream(int i, Reader x, long length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setNCharacterStream #" + i), (Object[])new Object[]{"length = " + length});
        }
        try {
            this.pstmtImpl.setNCharacterStream(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setNCharacterStream"), (String)"1499", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setNCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setNCharacterStream"), (String)"1901", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setNCharacterStream"), (String)"1908", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setNClob(int i, NClob x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setNClob #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setNClob(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setNClob"), (String)"1684", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setNClob"), (String)"1700", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setNClob"), (String)"1707", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setNClob(int i, Reader x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setNClob #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setNClob(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setNClob"), (String)"1525", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setNClob"), (String)"1993", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setNClob"), (String)"2000", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setNClob(int i, Reader x, long length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setNClob #" + i), (Object[])new Object[]{"length = " + length});
        }
        try {
            this.pstmtImpl.setNClob(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setNClob"), (String)"1525", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setNClob"), (String)"2040", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setNClob"), (String)"2047", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setNString(int i, String x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setNString #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setNString(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setNString"), (String)"1551", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setNString", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setNString"), (String)"2087", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNString", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setNString"), (String)"2094", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setNString", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setNull #" + i), (Object[])new Object[]{AdapterUtil.getSQLTypeString(sqlType)});
        }
        try {
            this.pstmtImpl.setNull(i, sqlType);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setNull", (String)"854", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setNull(int i, int sqlType, String typeName) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setNull #" + i), (Object[])new Object[]{AdapterUtil.getSQLTypeString(sqlType), typeName});
        }
        try {
            this.pstmtImpl.setNull(i, sqlType, typeName);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setNull", (String)"877", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setObject(int i, Object x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setObject #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setObject(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", (String)"899", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setObject #" + i), (Object[])new Object[]{targetSqlType});
        }
        try {
            this.pstmtImpl.setObject(i, x, targetSqlType);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", (String)"921", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType, int scale) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setObject #" + i), (Object[])new Object[]{targetSqlType, scale});
        }
        try {
            this.pstmtImpl.setObject(i, x, targetSqlType, scale);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", (String)"944", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setRef #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setRef(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setRef", (String)"966", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setRowId(int i, RowId x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setRowId #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setRowId(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setRowId"), (String)"1957", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setRowId", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setRowId"), (String)"1973", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setRowId", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setRowId"), (String)"1980", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setRowId", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setShort #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setShort(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setShort", (String)"988", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setSQLXML(int i, SQLXML xml) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setSQLXML #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setSQLXML(i, xml);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".setSQLXML"), (String)"2024", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("PreparedStatement.setSQLXML", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".setSQLXML"), (String)"2040", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setSQLXML", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".setSQLXML"), (String)"2047", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setSQLXML", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setString #" + i), (Object[])new Object[0]);
        }
        try {
            this.mcf.getHelper().psSetString(this.pstmtImpl, i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setString", (String)"1010", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            FFDCFilter.processException((Throwable)nullX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setString", (String)"1307", (Object)this);
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setTime #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setTime(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTime", (String)"1032", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setTime(int i, Time x, Calendar cal) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setTime with Calendar #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setTime(i, x, cal);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTime", (String)"1054", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setTimestamp #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setTimestamp(i, x);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTimestamp", (String)"1076", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setTimestamp with Calendar #" + i), (Object[])new Object[0]);
        }
        try {
            this.pstmtImpl.setTimestamp(i, x, cal);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTimestamp", (String)"1098", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setUnicodeStream #" + i), (Object[])new Object[]{length});
        }
        try {
            this.pstmtImpl.setUnicodeStream(i, x, length);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setUnicodeStream", (String)"1120", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setURL(int i, URL url) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setURL", (Object[])new Object[]{i});
        }
        try {
            this.pstmtImpl.setURL(i, url);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setURL", (String)"1140", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getParameterMetaData", (Object[])new Object[0]);
        }
        ParameterMetaData pmd = null;
        try {
            pmd = this.pstmtImpl.getParameterMetaData();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.getParameterMetaData", (String)"1442", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getParameterMetaData", (Object)"Exception, details in FFDC");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getParameterMetaData", (Object)"Exception, details in FFDC");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getParameterMetaData", (Object)pmd);
        }
        return pmd;
    }
}

