/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.opentracing.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.opentracing.OpenTracingService;
import com.ibm.ws.opentracing.OpentracingService;
import com.ibm.ws.opentracing.OpentracingTracerManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.Tracer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.eclipse.microprofile.opentracing.Traced;

@Traced
@Interceptor
@Priority(value=1000)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TracedInterceptor {
    private static final TraceComponent tc = Tr.register(TracedInterceptor.class);
    static final long serialVersionUID = 5988801244852842402L;

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AroundInvoke
    public Object execute(InvocationContext context) throws Exception {
        Object object;
        String operationName;
        String methodName = "execute";
        String classOperationName = OpenTracingService.getClassOperationName(context.getMethod());
        String methodOperationName = OpenTracingService.getMethodOperationName(context.getMethod());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " operation names"), (Object[])new Object[]{classOperationName, methodOperationName});
        }
        boolean process = true;
        if (!OpenTracingService.isTraced(classOperationName, methodOperationName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " skipping untraced method"), (Object[])new Object[0]);
            }
            process = false;
        }
        if (process && this.isHandledByFilter(context.getMethod())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " skipping JAXRS method"), (Object[])new Object[0]);
            }
            process = false;
        }
        if (!process) {
            if (!TraceComponent.isAnyTracingEnabled()) return context.proceed();
            if (!tc.isDebugEnabled()) return context.proceed();
            Tr.debug((TraceComponent)tc, (String)(methodName + " normal processing"), (Object[])new Object[0]);
            return context.proceed();
        }
        if (OpenTracingService.hasExplicitOperationName(methodOperationName)) {
            operationName = methodOperationName;
        } else {
            operationName = OpenTracingService.hasExplicitOperationName(classOperationName) ? classOperationName : context.getMethod().getDeclaringClass().getName() + "." + context.getMethod().getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " setting default operationName"), (Object[])new Object[]{operationName});
            }
        }
        Tracer tracer = OpentracingTracerManager.getTracer();
        ActiveSpan activeSpan = tracer.buildSpan(operationName).startActive();
        try {
            Object result;
            object = result = context.proceed();
            if (activeSpan == null) return object;
        }
        catch (Exception result) {
            try {
                void e23333332;
                FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.microprofile.opentracing.cdi.TracedInterceptor", (String)"115", (Object)this, (Object[])new Object[]{context});
                OpentracingService.addSpanErrorInfo((BaseSpan)activeSpan, (Throwable)e23333332);
                throw e23333332;
                catch (Error e23333332) {
                    FFDCFilter.processException((Throwable)e23333332, (String)"com.ibm.ws.microprofile.opentracing.cdi.TracedInterceptor", (String)"118", (Object)this, (Object[])new Object[]{context});
                    OpentracingService.addSpanErrorInfo((BaseSpan)activeSpan, (Throwable)e23333332);
                    throw e23333332;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.opentracing.cdi.TracedInterceptor", (String)"111", (Object)this, (Object[])new Object[]{context});
                if (activeSpan == null) throw throwable;
                try {
                    activeSpan.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.microprofile.opentracing.cdi.TracedInterceptor", (String)"111", (Object)this, (Object[])new Object[]{context});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        activeSpan.close();
        return object;
    }

    private boolean isHandledByFilter(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!HttpMethod.class.isAssignableFrom(annotation.annotationType())) continue;
            return true;
        }
        return method.isAnnotationPresent(Path.class);
    }
}

