/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.client.LibertyServiceImpl;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws22.spi.ProviderImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyProviderImpl
extends ProviderImpl {
    private static final TraceComponent tc = Tr.register(LibertyProviderImpl.class);
    private static final ThreadLocal<List<WebServiceFeature>> wsFeatures = new ThreadLocal();
    private static final ThreadLocal<WebServiceRefInfo> wsRefInfo = new ThreadLocal();
    private static final AtomicReference<AtomicServiceReference<JaxWsSecurityConfigurationService>> securityConfigSR = new AtomicReference();
    static final long serialVersionUID = 5918876997604011290L;

    public ServiceDelegate createServiceDelegate(URL url, QName qname, Class cls) {
        JaxWsSecurityConfigurationService securityConfigService;
        List<WebServiceFeature> serviceFeatures;
        LibertyApplicationBus bus = null;
        JaxWsClientMetaData clientMetaData = JaxWsMetaDataManager.getJaxWsClientMetaData();
        if (clientMetaData != null) {
            bus = clientMetaData.getClientBus();
        }
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No client  bus is found, the thread context default bus " + bus.getId() + " is used"), (Object[])new Object[0]);
            }
        }
        WebServiceRefInfo wsrInfo = wsRefInfo.get();
        List<WebServiceFeature> fServiceFeatures = serviceFeatures = wsFeatures.get();
        AtomicServiceReference<JaxWsSecurityConfigurationService> secConfigSR = securityConfigSR.get();
        final JaxWsSecurityConfigurationService scs = securityConfigService = secConfigSR == null ? null : (JaxWsSecurityConfigurationService)secConfigSR.getService();
        final WebServiceRefInfo wi = wsrInfo;
        LibertyApplicationBus b = bus;
        URL u = url;
        QName qn = qname;
        Class c = cls;
        List<WebServiceFeature> sf = serviceFeatures;
        if (serviceFeatures != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Thread context features are configured with " + serviceFeatures), (Object[])new Object[0]);
            }
            LibertyServiceImpl lsl = AccessController.doPrivileged(new PrivilegedAction<LibertyServiceImpl>((Bus)b, u, qn, c, sf){
                final /* synthetic */ Bus val$b;
                final /* synthetic */ URL val$u;
                final /* synthetic */ QName val$qn;
                final /* synthetic */ Class val$c;
                final /* synthetic */ List val$sf;
                static final long serialVersionUID = -6355243537275988452L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;
                {
                    this.val$b = bus;
                    this.val$u = uRL;
                    this.val$qn = qName;
                    this.val$c = clazz;
                    this.val$sf = list;
                }

                @Override
                public LibertyServiceImpl run() {
                    return new LibertyServiceImpl(scs, wi, this.val$b, this.val$u, this.val$qn, this.val$c, this.val$sf.toArray(new WebServiceFeature[this.val$sf.size()]));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            return lsl;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Thread context features are not set", (Object[])new Object[0]);
        }
        LibertyServiceImpl lsl = AccessController.doPrivileged(new PrivilegedAction<LibertyServiceImpl>((Bus)b, u, qn, c){
            final /* synthetic */ Bus val$b;
            final /* synthetic */ URL val$u;
            final /* synthetic */ QName val$qn;
            final /* synthetic */ Class val$c;
            static final long serialVersionUID = -7387260005451876246L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                this.val$b = bus;
                this.val$u = uRL;
                this.val$qn = qName;
                this.val$c = clazz;
            }

            @Override
            public LibertyServiceImpl run() {
                return new LibertyServiceImpl(scs, wi, this.val$b, this.val$u, this.val$qn, this.val$c, new WebServiceFeature[0]);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        return lsl;
    }

    public static void setWebServiceFeatures(List<WebServiceFeature> features) {
        wsFeatures.set(features);
    }

    public static List<WebServiceFeature> getWebServiceFeatures() {
        return wsFeatures.get();
    }

    public static void clearWebServiceFeatures() {
        wsFeatures.remove();
    }

    public static void setWebServiceRefInfo(WebServiceRefInfo wsrInfo) {
        wsRefInfo.set(wsrInfo);
    }

    public static void clearWebServiceRefInfo() {
        wsRefInfo.remove();
    }

    public static WebServiceRefInfo getWebServiceRefInfo() {
        return wsRefInfo.get();
    }

    public static void setSecurityConfigService(AtomicServiceReference<JaxWsSecurityConfigurationService> serviceRefer) {
        securityConfigSR.set(serviceRefer);
    }
}

