/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config12.converters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.config.converters.BuiltInConverter;
import com.ibm.ws.microprofile.config.interfaces.ConversionException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ImplicitConverter
extends BuiltInConverter {
    private static final TraceComponent tc = Tr.register(ImplicitConverter.class);
    private Method valueOfMethod;
    private final Constructor<?> ctor;
    private Method parseMethod;
    static final long serialVersionUID = 502995287345361296L;

    @Trivial
    public ImplicitConverter(Class<?> converterType) {
        super(converterType);
        this.ctor = ImplicitConverter.getConstructor(converterType);
        if (this.ctor == null) {
            this.valueOfMethod = ImplicitConverter.getValueOfMethod(converterType);
        }
        if (this.ctor == null && this.valueOfMethod == null) {
            this.parseMethod = ImplicitConverter.getParse(converterType);
        }
        if (this.ctor == null && this.valueOfMethod == null && this.parseMethod == null) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"implicit.string.constructor.method.not.found.CWMCG0017E", (Object[])new Object[]{converterType}));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (this.ctor != null) {
                Tr.debug((TraceComponent)tc, (String)"Automatic converter for {0} using {1}", (Object[])new Object[]{converterType, this.ctor});
            } else if (this.valueOfMethod != null) {
                Tr.debug((TraceComponent)tc, (String)"Automatic converter for {0} using {1}", (Object[])new Object[]{converterType, this.valueOfMethod});
            } else if (this.parseMethod != null) {
                Tr.debug((TraceComponent)tc, (String)"Automatic converter for {0} using {1}", (Object[])new Object[]{converterType, this.parseMethod});
            }
        }
    }

    @Trivial
    @FFDCIgnore(value={NoSuchMethodException.class})
    private static <M> Constructor<M> getConstructor(Class<M> reflectionClass) {
        Constructor<M> ctor = null;
        try {
            ctor = reflectionClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return ctor;
    }

    @Trivial
    @FFDCIgnore(value={NoSuchMethodException.class})
    private static Method getValueOfMethod(Class<?> reflectionClass) {
        Method method = null;
        try {
            method = reflectionClass.getMethod("valueOf", String.class);
            if ((method.getModifiers() & 8) == 0) {
                method = null;
            } else if (!reflectionClass.equals(method.getReturnType())) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    @Trivial
    @FFDCIgnore(value={NoSuchMethodException.class})
    private static Method getParse(Class<?> reflectionClass) {
        Method method = null;
        try {
            method = reflectionClass.getMethod("parse", CharSequence.class);
            if ((method.getModifiers() & 8) == 0) {
                method = null;
            } else if (!reflectionClass.equals(method.getReturnType())) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    /*
     * WARNING - void declaration
     */
    public Object convert(String value) {
        Object converted = null;
        if (value != null) {
            try {
                if (this.ctor != null) {
                    converted = this.ctor.newInstance(value);
                } else if (this.valueOfMethod != null) {
                    converted = this.valueOfMethod.invoke(null, value);
                } else if (this.parseMethod != null) {
                    converted = this.parseMethod.invoke(null, value);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                void e;
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.microprofile.config12.converters.ImplicitConverter", (String)"125", (Object)((Object)this), (Object[])new Object[]{value});
                Throwable cause = e.getCause();
                if (cause instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)cause;
                }
                throw new ConversionException(cause);
            }
            catch (IllegalAccessException | InstantiationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config12.converters.ImplicitConverter", (String)"132", (Object)((Object)this), (Object[])new Object[]{value});
                throw new ConversionException((Throwable)e);
            }
        }
        return converted;
    }

    public String toString() {
        return "Implicit Converter for type " + this.getType();
    }
}

