/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.ClientPolicyFactory;
import com.ibm.ws.transport.iiop.security.ClientSecurityInterceptor;
import com.ibm.ws.transport.iiop.security.IORSecurityInterceptor;
import com.ibm.ws.transport.iiop.security.ServerPolicyFactory;
import com.ibm.ws.transport.iiop.security.ServerSecurityInterceptor;
import com.ibm.ws.transport.iiop.security.config.tss.TSSConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SecurityInitializer
extends LocalObject
implements ORBInitializer {
    private static final Encoding CDR_1_2_ENCODING = new Encoding(0, 1, 2);
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(SecurityInitializer.class);

    public SecurityInitializer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SecurityInitializer.<init>", (Object[])new Object[0]);
        }
    }

    public void pre_init(ORBInitInfo info) {
    }

    /*
     * WARNING - void declaration
     */
    public void post_init(ORBInitInfo info) {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registering interceptors and policy factories", (Object[])new Object[0]);
            }
            TSSConfig config = Util.getRegisteredTSSConfig(info.orb_id());
            try {
                Codec codec;
                try {
                    codec = info.codec_factory().create_codec(CDR_1_2_ENCODING);
                }
                catch (UnknownEncoding unknownEncoding) {
                    void e;
                    FFDCFilter.processException((Throwable)unknownEncoding, (String)"com.ibm.ws.transport.iiop.security.SecurityInitializer", (String)"84", (Object)((Object)this), (Object[])new Object[]{info});
                    INITIALIZE err = new INITIALIZE("Could not create CDR 1.2 codec");
                    err.initCause((Throwable)e);
                    throw err;
                }
                info.add_client_request_interceptor((ClientRequestInterceptor)new ClientSecurityInterceptor(codec));
                info.add_server_request_interceptor((ServerRequestInterceptor)new ServerSecurityInterceptor(codec));
                info.add_ior_interceptor((IORInterceptor)new IORSecurityInterceptor(config, codec));
            }
            catch (DuplicateName codec) {
                void dn;
                FFDCFilter.processException((Throwable)codec, (String)"com.ibm.ws.transport.iiop.security.SecurityInitializer", (String)"93", (Object)((Object)this), (Object[])new Object[]{info});
                Tr.error((TraceComponent)tc, (String)"Error registering interceptor", (Object[])new Object[]{dn});
            }
            info.register_policy_factory(1095976449, (PolicyFactory)new ClientPolicyFactory());
            info.register_policy_factory(1095976448, (PolicyFactory)new ServerPolicyFactory());
        }
        catch (RuntimeException config) {
            void re;
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.transport.iiop.security.SecurityInitializer", (String)"99", (Object)((Object)this), (Object[])new Object[]{info});
            Tr.error((TraceComponent)tc, (String)"Error registering interceptor", (Object[])new Object[]{re});
            throw re;
        }
    }
}

