/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UserInfoHelper {
    private static final TraceComponent tc = Tr.register(UserInfoHelper.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private ConvergedClientConfig clientConfig = null;
    static final long serialVersionUID = 932675445799467539L;

    public UserInfoHelper(ConvergedClientConfig config) {
        this.clientConfig = config;
    }

    public boolean willRetrieveUserInfo() {
        return this.clientConfig.getUserInfoEndpointUrl() != null && this.clientConfig.isUserInfoEnabled();
    }

    public boolean getUserInfo(ProviderAuthenticationResult oidcResult, SSLSocketFactory sslSocketFactory, String accessToken, String subjectFromIdToken) {
        if (!this.willRetrieveUserInfo() || accessToken == null) {
            return false;
        }
        String userInfoStr = this.getUserInfoFromURL(this.clientConfig, sslSocketFactory, accessToken);
        if (userInfoStr == null) {
            return false;
        }
        if (!this.isUserInfoValid(userInfoStr, subjectFromIdToken)) {
            return false;
        }
        this.updateAuthenticationResultPropertiesWithUserInfo(oidcResult, userInfoStr);
        return true;
    }

    protected void updateAuthenticationResultPropertiesWithUserInfo(ProviderAuthenticationResult oidcResult, String userInfoStr) {
        oidcResult.getCustomProperties().put("userinfo_string", userInfoStr);
    }

    protected boolean isUserInfoValid(String userInfoStr, String subClaim) {
        String userInfoSubClaim = this.getUserInfoSubClaim(userInfoStr);
        if (userInfoSubClaim == null || subClaim == null || userInfoSubClaim.compareTo(subClaim) != 0) {
            Tr.error((TraceComponent)tc, (String)"USERINFO_INVALID", (Object[])new Object[]{userInfoStr, subClaim});
            return false;
        }
        return true;
    }

    protected String getUserInfoSubClaim(String userInfo) {
        JSONObject jobj = null;
        try {
            jobj = JSONObject.parse((String)userInfo);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper", (String)"86", (Object)this, (Object[])new Object[]{userInfo});
        }
        return jobj == null ? null : (String)jobj.get((Object)"sub");
    }

    protected String getUserInfoFromURL(ConvergedClientConfig config, SSLSocketFactory sslsf, String accessToken) {
        String url = config.getUserInfoEndpointUrl();
        boolean hostnameVerification = config.isHostNameVerificationEnabled();
        if (!url.toLowerCase().startsWith("https:") && config.isHttpsRequired()) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{url});
            return null;
        }
        OidcClientUtil oidccu = new OidcClientUtil();
        int statusCode = 0;
        String responseStr = null;
        try {
            boolean useSysProps = config.getUseSystemPropertiesForHttpClientConnections();
            Map<String, Object> resultMap = oidccu.getUserinfo(url, accessToken, sslsf, hostnameVerification, useSysProps);
            if (resultMap == null) {
                throw new Exception("result map from getUserinfo is null");
            }
            HttpResponse response = (HttpResponse)resultMap.get("RESPONSEMAP_CODE");
            if (response == null) {
                throw new Exception("HttpResponse from getUserinfo is null");
            }
            statusCode = response.getStatusLine().getStatusCode();
            responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper", (String)"121", (Object)this, (Object[])new Object[]{config, sslsf, accessToken});
        }
        if (statusCode != 200) {
            Tr.error((TraceComponent)tc, (String)"USERINFO_RETREIVE_FAILED", (Object[])new Object[]{url, Integer.toString(statusCode), responseStr});
            return null;
        }
        return responseStr;
    }
}

