/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.token;

import com.google.gson.JsonObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.joda.time.Duration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSJsonToken {
    private final JsonObject header;
    private final JsonObject payload;
    private final String tokenString;
    private final Duration skew;
    public static final String ISSUED_AT = "iat";
    public static final String EXPIRATION = "exp";
    private long issuedAt;
    private long expiration;
    static final long serialVersionUID = 5332577464298107729L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public String getIssuer() {
        return this.payload.get("iss") != null ? this.payload.get("iss").getAsString() : null;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
        if (this.payload != null) {
            this.payload.addProperty(ISSUED_AT, (Number)issuedAt);
        }
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
        if (this.payload != null) {
            this.payload.addProperty(EXPIRATION, (Number)expiration);
        }
    }

    WSJsonToken(JsonObject header, JsonObject payload, Duration skew, String tokenString) {
        this.header = header;
        this.payload = payload;
        this.skew = skew;
        this.tokenString = tokenString;
        this.setIatExp(payload);
    }

    WSJsonToken() {
        this.header = new JsonObject();
        this.payload = new JsonObject();
        this.skew = null;
        this.tokenString = null;
    }

    WSJsonToken(JsonObject header, JsonObject payload) {
        this.header = header;
        this.payload = payload;
        this.skew = null;
        this.tokenString = null;
        this.setIatExp(payload);
    }

    private void setIatExp(JsonObject payload) {
        this.issuedAt = payload.getAsJsonPrimitive(ISSUED_AT) != null ? payload.getAsJsonPrimitive(ISSUED_AT).getAsLong() : 0L;
        this.expiration = payload.getAsJsonPrimitive(EXPIRATION) != null ? payload.getAsJsonPrimitive(EXPIRATION).getAsLong() : 0L;
    }

    public JsonObject getHeader() {
        return this.header;
    }

    public JsonObject getPayload() {
        return this.payload;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public Duration getSkew() {
        return this.skew;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WSJsonToken.class);
    }
}

