/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.wim.Service;
import com.ibm.websphere.security.wim.ras.WIMTraceHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.ConfiguredRepository;
import com.ibm.ws.security.wim.ProfileManager;
import com.ibm.ws.security.wim.RealmConfig;
import com.ibm.ws.security.wim.RealmConfigChangeListener;
import com.ibm.ws.security.wim.RepositoryManager;
import com.ibm.wsspi.security.wim.CustomRepository;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Root;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={VMMService.class}, property={"service.vendor=IBM"})
public class VMMService
implements Service,
RealmConfigChangeListener {
    private static final TraceComponent tc = Tr.register(VMMService.class);
    static final String KEY_FACTORY = "Factory";
    static final String KEY_CONFIGURATION = "Configuration";
    static final String KEY_TYPE = "com.ibm.ws.security.wim.repository.type";
    static final String KEY_ID = "config.id";
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private volatile List<UserRegistryChangeListener> listeners = Collections.emptyList();
    @Reference
    ConfigManager configMgr;
    private Set<String> registryRealmNames = null;
    private ProfileManager profileManager = null;
    private RepositoryManager repositoryManager = new RepositoryManager(this);
    static final long serialVersionUID = -5278720081853910862L;

    public VMMService() {
        this.profileManager = new ProfileManager(this.repositoryManager);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setConfiguredRepository(ConfiguredRepository configuredRepository, Map<String, Object> props) {
        String repositoryId = (String)props.get(KEY_ID);
        this.repositoryManager.addConfiguredRepository(repositoryId, configuredRepository);
        this.notifyListeners();
    }

    protected void updatedConfiguredRepository(ConfiguredRepository configuredRepository) {
        this.notifyListeners();
    }

    protected void unsetConfiguredRepository(Map<String, Object> props) {
        String repositoryId = (String)props.get(KEY_ID);
        this.repositoryManager.removeRepositoryHolder(repositoryId);
        this.notifyListeners();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setCustomRepository(CustomRepository customRepository, Map<String, Object> props) {
        String repositoryId = (String)props.get(KEY_ID);
        this.repositoryManager.addCustomRepository(repositoryId, customRepository);
        this.notifyListeners();
    }

    protected void updatedCustomRepository(CustomRepository customRepository) {
        this.notifyListeners();
    }

    protected void unsetCustomRepository(Map<String, Object> props) {
        String repositoryId = (String)props.get(KEY_ID);
        this.repositoryManager.removeRepositoryHolder(repositoryId);
        this.notifyListeners();
    }

    ConfigManager getConfigManager() {
        return this.configMgr;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.profileManager.setConfigManager(this.configMgr);
        this.getConfigManager().registerRealmConfigChangeListener(this);
        this.notifyListeners();
        if (tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"FEDERATED_MANAGER_SERVICE_READY", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"FEDERATED_MANAGER_SERVICE_STOPPED", (Object[])new Object[0]);
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (UserRegistryChangeListener listener : this.listeners) {
            listener.notifyOfUserRegistryChange();
        }
    }

    public Root createRootObject() throws WIMException {
        String METHODNAME = "createRootObject";
        Root result = null;
        result = new Root();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createRootObject " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public Root get(Root root) throws WIMException {
        String METHODNAME = "get";
        Root result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("get " + WIMTraceHelper.trace((Object)root)), (Object[])new Object[0]);
        }
        result = this.profileManager.get(root);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("get " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public Root search(Root root) throws WIMException {
        String METHODNAME = "search";
        Root result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("search " + WIMTraceHelper.trace((Object)root)), (Object[])new Object[0]);
        }
        result = this.profileManager.search(root);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("search " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public Root login(Root root) throws WIMException {
        String METHODNAME = "login";
        Root result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("login " + WIMTraceHelper.trace((Object)root)), (Object[])new Object[0]);
        }
        result = this.profileManager.login(root);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("login " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public String getRealmName() throws WIMException {
        String result = null;
        result = this.profileManager.getRealmName();
        return result;
    }

    @Override
    public void notifyRealmConfigChange() {
        this.verifyParticipatingBaseEntries();
    }

    private void verifyParticipatingBaseEntries() {
        Map<String, List<String>> repositoryBaseEntrymap = this.repositoryManager.getRepositoriesBaseEntries();
        HashSet<String> baseEntries = new HashSet<String>();
        for (List<String> entries : repositoryBaseEntrymap.values()) {
            baseEntries.addAll(entries);
        }
        Set<String> realmNames = this.configMgr.getRealmNames();
        if (realmNames != null) {
            for (String realmName : realmNames) {
                RealmConfig config = this.configMgr.getRealmConfig(realmName);
                String[] participatingEntries = config.getParticipatingBaseEntries();
                if (participatingEntries == null) continue;
                for (String baseEntry : participatingEntries) {
                    if (baseEntries.contains(baseEntry)) continue;
                    Tr.error((TraceComponent)tc, (String)"INVALID_PARTICIPATING_BASE_ENTRY_DEFINITION", (Object[])new Object[]{baseEntry});
                }
            }
        }
    }

    public Root delete(Root root) throws WIMException {
        String METHODNAME = "delete";
        Root result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("delete " + WIMTraceHelper.trace((Object)root)), (Object[])new Object[0]);
        }
        result = this.profileManager.delete(root);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("delete " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public Root create(Root root) throws WIMException {
        String METHODNAME = "create";
        Root result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("create " + WIMTraceHelper.trace((Object)root)), (Object[])new Object[0]);
        }
        result = this.profileManager.create(root);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("create " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public Root update(Root root) throws WIMException {
        return this.profileManager.update(root);
    }

    public void addFederationRegistries(List<UserRegistry> registries) {
        if (this.registryRealmNames == null) {
            this.registryRealmNames = new HashSet<String>();
        }
        for (UserRegistry ur : registries) {
            this.registryRealmNames.add(ur.getRealm());
            this.repositoryManager.addUserRegistry(ur);
        }
        this.configMgr.processConfig();
    }

    public void removeAllFederatedRegistries() {
        if (this.registryRealmNames != null) {
            for (String realm : this.registryRealmNames) {
                this.repositoryManager.removeRepositoryHolder(realm);
            }
            this.registryRealmNames.clear();
        }
        this.repositoryManager.clearAllCachedURRepositories();
    }
}

