/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.env.was;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.env.ICacheUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Cache
implements ICacheUtil {
    private static final TraceComponent tc = Tr.register(Cache.class, (String)"Authentication");
    private static int defaultTimeout;
    private ConcurrentHashMap<String, Object> primaryTable;
    private ConcurrentHashMap<String, Object> secondaryTable;
    private ConcurrentHashMap<String, Object> tertiaryTable;
    private int minSize = 0;
    private int entryLimit = 4500;
    private Timer timer;
    private boolean isInitialized = false;
    private String cacheName = "DefaultCacheName";
    static final long serialVersionUID = -2524432500573642179L;

    public Cache() {
    }

    private Cache(int initialSize, int cacheMaxSize, long timeoutInMilliSeconds, String name) {
        this.primaryTable = new ConcurrentHashMap(initialSize);
        this.secondaryTable = new ConcurrentHashMap(initialSize);
        this.tertiaryTable = new ConcurrentHashMap(initialSize);
        this.minSize = initialSize;
        this.entryLimit = cacheMaxSize;
        this.cacheName = name;
        this.isInitialized = true;
        Cache.setDefaultTimeout((int)timeoutInMilliSeconds);
        if (timeoutInMilliSeconds > 0L) {
            this.scheduleEvictionTask(timeoutInMilliSeconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleEvictionTask(long timeoutInMilliSeconds) {
        EvictionTask evictionTask = new EvictionTask();
        SwapTCCLAction swapTCCL = new SwapTCCLAction();
        AccessController.doPrivileged(swapTCCL);
        try {
            long period;
            this.timer = new Timer(true);
            long delay = period = timeoutInMilliSeconds / 3L;
            this.timer.schedule((TimerTask)evictionTask, delay, period);
        }
        finally {
            AccessController.doPrivileged(swapTCCL);
        }
    }

    public synchronized Object remove(String key) {
        Object retVal = this.primaryTable.remove(key);
        if (retVal == null && (retVal = this.secondaryTable.remove(key)) == null) {
            return this.tertiaryTable.remove(key);
        }
        return retVal;
    }

    @Override
    public synchronized Object get(Object key) {
        ConcurrentHashMap<String, Object> tableRef = this.primaryTable;
        CacheEntry curEntry = (CacheEntry)this.primaryTable.get(key);
        if (curEntry == null) {
            tableRef = this.secondaryTable;
            curEntry = (CacheEntry)this.secondaryTable.get(key);
            if (curEntry == null) {
                tableRef = this.tertiaryTable;
                curEntry = (CacheEntry)this.tertiaryTable.get(key);
            }
            if (curEntry == null) {
                tableRef = null;
            }
        }
        if (tableRef == null && (curEntry = (CacheEntry)this.primaryTable.get(key)) == null) {
            curEntry = new CacheEntry();
            this.primaryTable.put(String.valueOf(key), curEntry);
        }
        return curEntry.value;
    }

    public synchronized Object insert(String key, Object value) {
        while (this.isEvictionRequired() && this.entryLimit > 0 && this.entryLimit < Integer.MAX_VALUE) {
            this.evictStaleEntries();
        }
        CacheEntry curEntry = new CacheEntry(value);
        CacheEntry oldEntry1 = (CacheEntry)this.primaryTable.put(key, curEntry);
        CacheEntry oldEntry2 = (CacheEntry)this.secondaryTable.remove(key);
        CacheEntry oldEntry3 = (CacheEntry)this.tertiaryTable.remove(key);
        return oldEntry1 != null ? oldEntry1.value : (oldEntry2 != null ? oldEntry2.value : (oldEntry3 != null ? oldEntry3.value : null));
    }

    public synchronized Object update(String key, Object value) {
        while (this.isEvictionRequired() && this.entryLimit > 0 && this.entryLimit < Integer.MAX_VALUE) {
            this.evictStaleEntries();
        }
        CacheEntry oldEntry = null;
        CacheEntry curEntry = new CacheEntry(value);
        oldEntry = this.primaryTable.containsKey(key) ? (CacheEntry)this.primaryTable.put(key, curEntry) : (this.secondaryTable.containsKey(key) ? (CacheEntry)this.secondaryTable.put(key, curEntry) : (this.tertiaryTable.containsKey(key) ? (CacheEntry)this.tertiaryTable.put(key, curEntry) : (CacheEntry)this.primaryTable.put(key, curEntry)));
        return oldEntry != null ? oldEntry.value : null;
    }

    protected boolean isEvictionRequired() {
        String METHODNAME = "isEvictionRequired";
        boolean evictionRequired = false;
        int size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isEvictionRequired The current " + this.cacheName + " cache (" + this.hashCode() + ") size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ")"), (Object[])new Object[0]);
        }
        if (this.entryLimit != 0 && this.entryLimit != Integer.MAX_VALUE && size >= this.entryLimit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isEvictionRequired The cache size on " + this.cacheName + " is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ") which is greater than the cache limit of " + this.entryLimit + "."), (Object[])new Object[0]);
            }
            evictionRequired = true;
        }
        return evictionRequired;
    }

    @Trivial
    protected synchronized void evictStaleEntries() {
        if (!this.tertiaryTable.isEmpty() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("evictStaleEntries Evicting tertiaryTable cache " + this.cacheName + ", size is " + this.tertiaryTable.size()), (Object[])new Object[0]);
        }
        this.tertiaryTable = this.secondaryTable;
        this.secondaryTable = this.primaryTable;
        this.primaryTable = new ConcurrentHashMap(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size());
    }

    public synchronized void clearAllEntries() {
        this.tertiaryTable.putAll(this.primaryTable);
        this.tertiaryTable.putAll(this.secondaryTable);
        this.primaryTable.clear();
        this.secondaryTable.clear();
        this.evictStaleEntries();
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public static void setDefaultTimeout(int timeout) {
        defaultTimeout = timeout;
    }

    @Override
    public void stopEvictionTask() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    @Override
    public boolean isCacheInitialized() {
        return this.isInitialized;
    }

    @Override
    public boolean isCacheAvailable() {
        return true;
    }

    @Override
    public int getNotSharedInt() {
        return 0;
    }

    @Override
    public int getSharedPushInt() {
        return 0;
    }

    @Override
    public int getSharedPushPullInt() {
        return 0;
    }

    @Override
    public void setSharingPolicy(int sharingPolicy) {
    }

    @Override
    public int getSharingPolicyInt(String sharingPolicyStr) {
        return 0;
    }

    @Override
    public Object put(Object key, Object value, int priority, long timeToLive, int sharingPolicy, Object[] dependencyIds) {
        return this.insert(String.valueOf(key), value);
    }

    @Override
    public void invalidate(Object key) {
        this.remove(key);
    }

    @Override
    public int size(boolean includeDiskCache) {
        return this.size();
    }

    @Override
    public boolean isEmpty(boolean includeDiskCache) {
        return this.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.primaryTable.containsKey(key) || this.secondaryTable.containsKey(key) || this.tertiaryTable.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key, boolean includeDiskCache) {
        return this.containsKey(key);
    }

    @Override
    public Set<String> keySet(boolean includeDiskCache) {
        return this.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.update(String.valueOf(key), value);
    }

    @Override
    public void clear() {
        this.clearAllEntries();
    }

    @Override
    public boolean containsValue(Object value) {
        CacheEntry entry = new CacheEntry(value);
        return this.primaryTable.containsValue(entry) || this.secondaryTable.containsValue(entry) || this.tertiaryTable.containsValue(entry);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.primaryTable.keySet());
        keySet.addAll(this.secondaryTable.keySet());
        keySet.addAll(this.tertiaryTable.keySet());
        return keySet;
    }

    @Override
    public int size() {
        return this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
    }

    @Override
    public void setTimeToLive(int timeToLive) {
        Cache.setDefaultTimeout(timeToLive);
    }

    @Override
    public ICacheUtil initialize(int initialSize, int cacheSize, long cachetimeOut) {
        return this.initialize(this.cacheName, initialSize, cacheSize, cachetimeOut);
    }

    @Override
    public ICacheUtil initialize(String name, int initialSize, int cacheSize, long cachetimeOut) {
        String METHODNAME = "initialize";
        Cache cache = new Cache(initialSize, cacheSize, cachetimeOut, name);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initialize cache initialized successfully: " + name), (Object[])new Object[0]);
        }
        return cache;
    }

    @Override
    public ICacheUtil initialize(String cacheName, int cacheSize, boolean diskOffLoad) {
        return this.initialize(cacheSize, cacheSize, defaultTimeout);
    }

    @Override
    public ICacheUtil initialize(String cacheName, int cacheSize, boolean diskOffLoad, int sharingPolicy) {
        return this.initialize(cacheSize, cacheSize, defaultTimeout);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> retValue = this.primaryTable.entrySet();
        retValue.addAll(this.secondaryTable.entrySet());
        retValue.addAll(this.tertiaryTable.entrySet());
        return retValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        Set<Map.Entry<? extends String, ? extends Object>> entrySet = map.entrySet();
        Iterator<Map.Entry<? extends String, ? extends Object>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<? extends String, ? extends Object> entry;
            Map.Entry<? extends String, ? extends Object> actualEntry = entry = iterator.next();
            this.put(String.valueOf(actualEntry.getKey()), actualEntry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.remove(String.valueOf(key));
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> retValue = new ArrayList<Object>();
        retValue.addAll(this.primaryTable.values());
        retValue.addAll(this.secondaryTable.values());
        retValue.addAll(this.tertiaryTable.values());
        return retValue;
    }

    @Override
    public void invalidate() {
        this.clearAllEntries();
    }

    @Trivial
    private class EvictionTask
    extends TimerTask {
        private EvictionTask() {
        }

        @Override
        public void run() {
            Cache.this.evictStaleEntries();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class CacheEntry {
        public Object value;
        public int timesAccessed;
        static final long serialVersionUID = 6492571826079053138L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CacheEntry() {
        }

        public CacheEntry(Object value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CacheEntry.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class SwapTCCLAction
    implements PrivilegedAction<ClassLoader> {
        private ClassLoader savedTCCL;
        private boolean swapped = false;
        static final long serialVersionUID = 7139371906860113420L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SwapTCCLAction() {
        }

        @Override
        public ClassLoader run() {
            ClassLoader cl;
            if (this.swapped) {
                cl = this.savedTCCL;
            } else {
                cl = ClassLoader.getSystemClassLoader();
                this.savedTCCL = Thread.currentThread().getContextClassLoader();
            }
            Thread.currentThread().setContextClassLoader(cl);
            this.swapped = !this.swapped;
            return cl;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SwapTCCLAction.class);
        }
    }
}

