/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.core;

import com.ibm.ws.container.AbstractContainer;
import com.ibm.ws.container.Container;
import com.ibm.ws.webcontainer.core.Command;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.RequestMapper;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class BaseContainer
extends AbstractContainer
implements RequestProcessor {
    protected ArrayList<Command> commands;
    protected RequestMapper requestMapper;
    protected Container parent;

    public BaseContainer(String name, Container parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.addSubContainer(this);
        }
        this.commands = new ArrayList(3);
        this.start();
    }

    public RequestMapper getRequestMapper() {
        return this.requestMapper;
    }

    public void setRequestMapper(RequestMapper mapper) {
        this.requestMapper = mapper;
    }

    @Override
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        throw new Exception("Super class implementation called...Subclass must override this method.");
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public void removeCommand(Command command) {
        this.commands.remove(command);
    }

    public void execute(Request req, Response res) {
        for (int i = 0; i < this.commands.size(); ++i) {
            this.commands.get(i).execute(req, res);
        }
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public Iterator getTargetMappings() {
        return this.requestMapper.targetMappings();
    }

    @Override
    public boolean isInternal() {
        return false;
    }
}

