/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.metrics.integration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorderProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.function.LongSupplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MetricRecorderImpl
implements MetricRecorder {
    private final Counter invocationCounter;
    private final Counter invocationFailedCounter;
    private final Counter retryCallsSuccessImmediateCounter;
    private final Counter retryCallsSuccessRetryCounter;
    private final Counter retryCallsFailureCounter;
    private final Counter retryRetriesCounter;
    private final Histogram timeoutDurationHistogram;
    private final Counter timeoutTrueCalls;
    private final Counter timeoutFalseCalls;
    private final Counter circuitBreakerCallsSuccessCounter;
    private final Counter circuitBreakerCallsFailureCounter;
    private final Counter circuitBreakerCallsOpenCounter;
    private final Gauge<Long> circuitBreakerOpenTime;
    private final Gauge<Long> circuitBreakerHalfOpenTime;
    private final Gauge<Long> circuitBreakerClosedTime;
    private final Counter circuitBreakerTimesOpenedCounter;
    private final Gauge<Long> bulkheadConcurrentExecutions;
    private final Counter bulkheadRejectionsCounter;
    private final Counter bulkheadAcceptedCounter;
    private final Histogram bulkheadExecutionDuration;
    private final Gauge<Long> bulkheadQueuePopulation;
    private final Histogram bulkheadQueueWaitTimeHistogram;
    private final Counter fallbackCalls;
    private LongSupplier concurrentExecutionCountSupplier = null;
    private LongSupplier queuePopulationSupplier = null;
    private long openNanos;
    private long halfOpenNanos;
    private long closedNanos;
    private CircuitBreakerState circuitBreakerState = CircuitBreakerState.CLOSED;
    private long lastCircuitBreakerTransitionTime;
    static final long serialVersionUID = 3599496135254787111L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MetricRecorderImpl(String metricPrefix, MetricRegistry registry, RetryPolicy retryPolicy, CircuitBreakerPolicy circuitBreakerPolicy, TimeoutPolicy timeoutPolicy, BulkheadPolicy bulkheadPolicy, FallbackPolicy fallbackPolicy, MetricRecorderProvider.AsyncType isAsync) {
        if (retryPolicy != null || timeoutPolicy != null || circuitBreakerPolicy != null || bulkheadPolicy != null || fallbackPolicy != null) {
            this.invocationCounter = registry.counter(metricPrefix + ".invocations.total");
            this.invocationFailedCounter = registry.counter(metricPrefix + ".invocations.failed.total");
        } else {
            this.invocationCounter = null;
            this.invocationFailedCounter = null;
        }
        if (retryPolicy != null) {
            this.retryCallsSuccessImmediateCounter = registry.counter(metricPrefix + ".retry.callsSucceededNotRetried.total");
            this.retryCallsSuccessRetryCounter = registry.counter(metricPrefix + ".retry.callsSucceededRetried.total");
            this.retryCallsFailureCounter = registry.counter(metricPrefix + ".retry.callsFailed.total");
            this.retryRetriesCounter = registry.counter(metricPrefix + ".retry.retries.total");
        } else {
            this.retryCallsSuccessImmediateCounter = null;
            this.retryCallsSuccessRetryCounter = null;
            this.retryCallsFailureCounter = null;
            this.retryRetriesCounter = null;
        }
        if (timeoutPolicy != null) {
            this.timeoutDurationHistogram = registry.histogram(new Metadata(metricPrefix + ".timeout.executionDuration", MetricType.HISTOGRAM, "nanoseconds"));
            this.timeoutTrueCalls = registry.counter(metricPrefix + ".timeout.callsTimedOut.total");
            this.timeoutFalseCalls = registry.counter(metricPrefix + ".timeout.callsNotTimedOut.total");
        } else {
            this.timeoutDurationHistogram = null;
            this.timeoutTrueCalls = null;
            this.timeoutFalseCalls = null;
        }
        if (circuitBreakerPolicy != null) {
            this.circuitBreakerCallsFailureCounter = registry.counter(metricPrefix + ".circuitbreaker.callsFailed.total");
            this.circuitBreakerCallsSuccessCounter = registry.counter(metricPrefix + ".circuitbreaker.callsSucceeded.total");
            this.circuitBreakerCallsOpenCounter = registry.counter(metricPrefix + ".circuitbreaker.callsPrevented.total");
            this.circuitBreakerOpenTime = this.gauge(registry, metricPrefix + ".circuitbreaker.open.total", "nanoseconds", (Gauge<Long>)((Gauge)this::getCircuitBreakerAccumulatedOpen));
            this.circuitBreakerHalfOpenTime = this.gauge(registry, metricPrefix + ".circuitbreaker.halfOpen.total", "nanoseconds", (Gauge<Long>)((Gauge)this::getCircuitBreakerAccumulatedHalfOpen));
            this.circuitBreakerClosedTime = this.gauge(registry, metricPrefix + ".circuitbreaker.closed.total", "nanoseconds", (Gauge<Long>)((Gauge)this::getCircuitBreakerAccumulatedClosed));
            this.circuitBreakerTimesOpenedCounter = registry.counter(metricPrefix + ".circuitbreaker.opened.total");
        } else {
            this.circuitBreakerCallsFailureCounter = null;
            this.circuitBreakerCallsSuccessCounter = null;
            this.circuitBreakerCallsOpenCounter = null;
            this.circuitBreakerOpenTime = null;
            this.circuitBreakerHalfOpenTime = null;
            this.circuitBreakerClosedTime = null;
            this.circuitBreakerTimesOpenedCounter = null;
        }
        if (bulkheadPolicy != null) {
            this.bulkheadConcurrentExecutions = this.gauge(registry, metricPrefix + ".bulkhead.concurrentExecutions", "none", (Gauge<Long>)((Gauge)this::getConcurrentExecutions));
            this.bulkheadRejectionsCounter = registry.counter(metricPrefix + ".bulkhead.callsRejected.total");
            this.bulkheadAcceptedCounter = registry.counter(metricPrefix + ".bulkhead.callsAccepted.total");
            this.bulkheadExecutionDuration = registry.histogram(new Metadata(metricPrefix + ".bulkhead.executionDuration", MetricType.HISTOGRAM, "nanoseconds"));
        } else {
            this.bulkheadConcurrentExecutions = null;
            this.bulkheadRejectionsCounter = null;
            this.bulkheadAcceptedCounter = null;
            this.bulkheadExecutionDuration = null;
        }
        if (bulkheadPolicy != null && isAsync == MetricRecorderProvider.AsyncType.ASYNC) {
            this.bulkheadQueuePopulation = this.gauge(registry, metricPrefix + ".bulkhead.waitingQueue.population", "none", (Gauge<Long>)((Gauge)this::getQueuePopulation));
            this.bulkheadQueueWaitTimeHistogram = registry.histogram(new Metadata(metricPrefix + ".bulkhead.waiting.duration", MetricType.HISTOGRAM, "nanoseconds"));
        } else {
            this.bulkheadQueuePopulation = null;
            this.bulkheadQueueWaitTimeHistogram = null;
        }
        this.fallbackCalls = fallbackPolicy != null ? registry.counter(metricPrefix + ".fallback.calls.total") : null;
        this.lastCircuitBreakerTransitionTime = System.nanoTime();
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Gauge<Long> gauge(MetricRegistry registry, String name, String units, Gauge<Long> supplier) {
        Gauge result = null;
        try {
            result = (Gauge)registry.register(new Metadata(name, MetricType.GAUGE, units), supplier);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    @Trivial
    public void incrementInvocationCount() {
        if (this.invocationCounter != null) {
            this.invocationCounter.inc();
        }
    }

    @Trivial
    public void incrementInvocationFailedCount() {
        if (this.invocationFailedCounter != null) {
            this.invocationFailedCounter.inc();
        }
    }

    @Trivial
    public void incrementRetryCallsSuccessImmediateCount() {
        if (this.retryCallsSuccessImmediateCounter != null) {
            this.retryCallsSuccessImmediateCounter.inc();
        }
    }

    @Trivial
    public void incrementRetryCallsSuccessRetriesCount() {
        if (this.retryCallsSuccessRetryCounter != null) {
            this.retryCallsSuccessRetryCounter.inc();
        }
    }

    @Trivial
    public void incrementRetryCallsFailureCount() {
        if (this.retryCallsFailureCounter != null) {
            this.retryCallsFailureCounter.inc();
        }
    }

    @Trivial
    public void incrementRetriesCount() {
        if (this.retryRetriesCounter != null) {
            this.retryRetriesCounter.inc();
        }
    }

    @Trivial
    public void recordTimeoutExecutionTime(long executionNanos) {
        if (this.timeoutDurationHistogram != null) {
            this.timeoutDurationHistogram.update(executionNanos);
        }
    }

    @Trivial
    public void incrementTimeoutTrueCount() {
        if (this.timeoutTrueCalls != null) {
            this.timeoutTrueCalls.inc();
        }
    }

    @Trivial
    public void incrementTimeoutFalseCount() {
        if (this.timeoutFalseCalls != null) {
            this.timeoutFalseCalls.inc();
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsCircuitOpenCount() {
        if (this.circuitBreakerCallsOpenCounter != null) {
            this.circuitBreakerCallsOpenCounter.inc();
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsSuccessCount() {
        if (this.circuitBreakerCallsSuccessCounter != null) {
            this.circuitBreakerCallsSuccessCounter.inc();
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsFailureCount() {
        if (this.circuitBreakerCallsFailureCounter != null) {
            this.circuitBreakerCallsFailureCounter.inc();
        }
    }

    @Trivial
    public void incrementBulkheadRejectedCount() {
        if (this.bulkheadRejectionsCounter != null) {
            this.bulkheadRejectionsCounter.inc();
        }
    }

    @Trivial
    public void incrementBulkeadAcceptedCount() {
        if (this.bulkheadAcceptedCounter != null) {
            this.bulkheadAcceptedCounter.inc();
        }
    }

    @Trivial
    public synchronized void reportCircuitOpen() {
        if (this.circuitBreakerState != CircuitBreakerState.OPEN) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState);
            this.circuitBreakerState = CircuitBreakerState.OPEN;
            this.circuitBreakerTimesOpenedCounter.inc();
        }
    }

    @Trivial
    public synchronized void reportCircuitHalfOpen() {
        if (this.circuitBreakerState != CircuitBreakerState.HALF_OPEN) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState);
            this.circuitBreakerState = CircuitBreakerState.HALF_OPEN;
        }
    }

    @Trivial
    public synchronized void reportCircuitClosed() {
        if (this.circuitBreakerState != CircuitBreakerState.CLOSED) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState);
            this.circuitBreakerState = CircuitBreakerState.CLOSED;
        }
    }

    @Trivial
    private void recordEndOfCircuitBreakerState(CircuitBreakerState oldState) {
        long now = System.nanoTime();
        switch (oldState) {
            case CLOSED: {
                this.closedNanos += now - this.lastCircuitBreakerTransitionTime;
                break;
            }
            case HALF_OPEN: {
                this.halfOpenNanos += now - this.lastCircuitBreakerTransitionTime;
                break;
            }
            case OPEN: {
                this.openNanos += now - this.lastCircuitBreakerTransitionTime;
            }
        }
        this.lastCircuitBreakerTransitionTime = now;
    }

    @Trivial
    public void reportQueueWaitTime(long queueWaitNanos) {
        if (this.bulkheadQueueWaitTimeHistogram != null) {
            this.bulkheadQueueWaitTimeHistogram.update(queueWaitNanos);
        }
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedOpen() {
        long computedNanos = this.openNanos;
        if (this.circuitBreakerState == CircuitBreakerState.OPEN) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedHalfOpen() {
        long computedNanos = this.halfOpenNanos;
        if (this.circuitBreakerState == CircuitBreakerState.HALF_OPEN) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedClosed() {
        long computedNanos = this.closedNanos;
        if (this.circuitBreakerState == CircuitBreakerState.CLOSED) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private Long getConcurrentExecutions() {
        if (this.concurrentExecutionCountSupplier != null) {
            return this.concurrentExecutionCountSupplier.getAsLong();
        }
        return 0L;
    }

    @Trivial
    public void setBulkheadConcurentExecutionCountSupplier(LongSupplier concurrentExecutionCountSupplier) {
        this.concurrentExecutionCountSupplier = concurrentExecutionCountSupplier;
    }

    @Trivial
    private Long getQueuePopulation() {
        if (this.queuePopulationSupplier != null) {
            return this.queuePopulationSupplier.getAsLong();
        }
        return 0L;
    }

    @Trivial
    public void setBulkheadQueuePopulationSupplier(LongSupplier queuePopulationSupplier) {
        this.queuePopulationSupplier = queuePopulationSupplier;
    }

    @Trivial
    public void recordBulkheadExecutionTime(long executionTime) {
        if (this.bulkheadExecutionDuration != null) {
            this.bulkheadExecutionDuration.update(executionTime);
        }
    }

    @Trivial
    public void incrementFallbackCalls() {
        this.fallbackCalls.inc();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetricRecorderImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class CircuitBreakerState
    extends Enum<CircuitBreakerState> {
        public static final /* enum */ CircuitBreakerState CLOSED;
        public static final /* enum */ CircuitBreakerState HALF_OPEN;
        public static final /* enum */ CircuitBreakerState OPEN;
        private static final /* synthetic */ CircuitBreakerState[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static CircuitBreakerState[] values() {
            return (CircuitBreakerState[])$VALUES.clone();
        }

        public static CircuitBreakerState valueOf(String name) {
            return Enum.valueOf(CircuitBreakerState.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CircuitBreakerState.class);
            CLOSED = new CircuitBreakerState();
            HALF_OPEN = new CircuitBreakerState();
            OPEN = new CircuitBreakerState();
            $VALUES = new CircuitBreakerState[]{CLOSED, HALF_OPEN, OPEN};
        }
    }
}

