/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.bus;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.jaxrs20.api.ExtensionProvider;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBus;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBusListener;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyApplicationBusFactory
extends CXFBusFactory {
    private static final TraceComponent tc = Tr.register(LibertyApplicationBusFactory.class);
    private static final ThreadContextAccessor THREAD_CONTEXT_ACCESSOR = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    private static final LibertyApplicationBusFactory INSTANCE = new LibertyApplicationBusFactory();
    protected final List<LibertyApplicationBusListener> listeners = new CopyOnWriteArrayList<LibertyApplicationBusListener>();
    protected final List<ExtensionProvider> extensionProviders = new CopyOnWriteArrayList<ExtensionProvider>();
    private final List<Bus> serverScopedBuses = Collections.synchronizedList(new ArrayList());
    private final List<Bus> clientScopedBuses = Collections.synchronizedList(new ArrayList());
    static final long serialVersionUID = 4001342343186039721L;

    public static LibertyApplicationBusFactory getInstance() {
        return INSTANCE;
    }

    public List<LibertyApplicationBusListener> getBusListenersCopy() {
        if (!this.listeners.isEmpty()) {
            return Collections.unmodifiableList(this.listeners);
        }
        return null;
    }

    public List<ExtensionProvider> getExtensionProviderCopy() {
        if (!this.extensionProviders.isEmpty()) {
            return Collections.unmodifiableList(this.extensionProviders);
        }
        return null;
    }

    public LibertyApplicationBus createServerScopedBus(JaxRsModuleMetaData moduleMetaData) {
        ModuleInfo moduleInfo = moduleMetaData.getModuleInfo();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("org.apache.cxf.bus.id", moduleInfo.getName() + "-Server-Bus");
        HashMap extensions = new HashMap();
        extensions.put(ClassLoader.class, moduleMetaData.getAppContextClassLoader());
        extensions.put(JaxRsModuleMetaData.class, moduleMetaData);
        extensions.put(LibertyApplicationBus.Type.class, (Object)((Object)LibertyApplicationBus.Type.SERVER));
        LibertyApplicationBus bus = this.createBus(extensions, properties, moduleInfo.getClassLoader());
        return bus;
    }

    public LibertyApplicationBus createClientScopedBus(JaxRsModuleMetaData moduleMetaData) {
        ModuleInfo moduleInfo = moduleMetaData.getModuleInfo();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("org.apache.cxf.bus.id", moduleInfo.getName() + "-Client-Bus");
        HashMap extensions = new HashMap();
        extensions.put(ClassLoader.class, moduleMetaData.getAppContextClassLoader());
        extensions.put(JaxRsModuleMetaData.class, moduleMetaData);
        extensions.put(LibertyApplicationBus.Type.class, (Object)((Object)LibertyApplicationBus.Type.CLIENT));
        LibertyApplicationBus bus = this.createBus(extensions, properties, moduleInfo.getClassLoader());
        return bus;
    }

    public Bus createBus(Map<Class<?>, Object> e, Map<String, Object> properties) {
        return this.createBus(e, properties, THREAD_CONTEXT_ACCESSOR.getContextClassLoader(Thread.currentThread()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibertyApplicationBus createBus(Map<Class<?>, Object> e, Map<String, Object> properties, ClassLoader classLoader) {
        Bus originalBus = LibertyApplicationBusFactory.getThreadDefaultBus((boolean)false);
        try {
            LibertyApplicationBus bus = new LibertyApplicationBus(e, properties, classLoader);
            this.initializeBus((Bus)bus);
            BusLifeCycleManager lifeCycleManager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
            if (lifeCycleManager != null) {
                lifeCycleManager.registerLifeCycleListener((BusLifeCycleListener)new BusLifeCycleListenerAdapter((Bus)bus));
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to locate LifeCycleManager for the bus " + bus.getId() + ", postShutdown and preShutDown methods configured in LibertyApplicationBusListener will not be invoked"), (Object[])new Object[0]);
            }
            bus.initialize();
            LibertyApplicationBus libertyApplicationBus = bus;
            return libertyApplicationBus;
        }
        finally {
            LibertyApplicationBusFactory.setThreadDefaultBus((Bus)originalBus);
        }
    }

    protected void initializeBus(Bus bus) {
        super.initializeBus(bus);
        for (LibertyApplicationBusListener listener : this.listeners) {
            listener.preInit(bus);
        }
        ExtensionManager extensionManager = (ExtensionManager)bus.getExtension(ExtensionManager.class);
        if (extensionManager != null && extensionManager instanceof ExtensionManagerImpl) {
            ExtensionManagerImpl managerImpl = (ExtensionManagerImpl)extensionManager;
            for (ExtensionProvider extensionProvider : this.extensionProviders) {
                Extension extension = extensionProvider.getExtension(bus);
                if (extension == null) continue;
                managerImpl.add(extension);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)((extensionManager == null ? "Unable to locate extension manager " : "The extension manager is not of type ExtensionManagerImpl") + ", all the extensions from ExtensionProvider are ignored"), (Object[])new Object[0]);
        }
    }

    public void registerApplicationBusListener(LibertyApplicationBusListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void unregisterApplicationBusListener(LibertyApplicationBusListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public List<Bus> getServerScopedBuses() {
        return new ArrayList<Bus>(this.serverScopedBuses);
    }

    public List<Bus> getClientScopedBuses() {
        return new ArrayList<Bus>(this.clientScopedBuses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultBus(Bus bus) {
        Class<BusFactory> clazz = BusFactory.class;
        synchronized (BusFactory.class) {
            defaultBus = bus == null ? null : bus;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void registerExtensionProvider(ExtensionProvider extensionProvider) {
        if (extensionProvider != null) {
            this.extensionProviders.add(extensionProvider);
        }
    }

    public void unregisterExtensionProvider(ExtensionProvider extensionProvider) {
        if (extensionProvider != null) {
            this.extensionProviders.remove(extensionProvider);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class BusLifeCycleListenerAdapter
    implements BusLifeCycleListener {
        private final Bus bus;
        static final long serialVersionUID = -7603311816250263225L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BusLifeCycleListenerAdapter(Bus bus) {
            this.bus = bus;
        }

        public void initComplete() {
            for (LibertyApplicationBusListener listener : LibertyApplicationBusFactory.this.listeners) {
                listener.initComplete(this.bus);
            }
        }

        public void postShutdown() {
            try {
                for (LibertyApplicationBusListener listener : LibertyApplicationBusFactory.this.listeners) {
                    listener.postShutdown(this.bus);
                }
            }
            finally {
                if (!LibertyApplicationBusFactory.this.serverScopedBuses.remove(this.bus)) {
                    LibertyApplicationBusFactory.this.clientScopedBuses.remove(this.bus);
                }
            }
        }

        public void preShutdown() {
            for (LibertyApplicationBusListener listener : LibertyApplicationBusFactory.this.listeners) {
                listener.postShutdown(this.bus);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BusLifeCycleListenerAdapter.class);
        }
    }
}

