/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwtsso.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.jwt.utils.TokenBuilder;
import com.ibm.ws.security.jwtsso.utils.SubjectUtil;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl;
import com.ibm.ws.security.mp.jwt.tai.MicroProfileJwtTAI;
import com.ibm.ws.security.mp.jwt.tai.TAIJwtUtils;
import com.ibm.ws.security.mp.jwt.tai.TAIRequestHelper;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtSsoTokenUtils {
    private static TraceComponent tc = Tr.register(JwtSsoTokenUtils.class);
    String builderId = null;
    String consumerId = null;
    boolean isValid = true;
    MicroProfileJwtTAI mpjwttai = null;
    TAIJwtUtils taiJwtUtils = new TAIJwtUtils();
    TAIRequestHelper taiRequestHelper = new TAIRequestHelper();
    static final long serialVersionUID = -6121470994582032953L;

    public JwtSsoTokenUtils() {
    }

    public JwtSsoTokenUtils(String builder) {
        this.builderId = builder;
    }

    public JwtSsoTokenUtils(String consumer, AtomicServiceReference<TrustAssociationInterceptor> mpjwttaiserviceref) {
        this.consumerId = consumer;
        TrustAssociationInterceptor service = (TrustAssociationInterceptor)mpjwttaiserviceref.getService();
        if (service instanceof MicroProfileJwtTAI) {
            this.mpjwttai = (MicroProfileJwtTAI)service;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public JsonWebToken buildTokenFromSecuritySubject() throws Exception {
        Subject subj = WSSubject.getRunAsSubject();
        Set<Principal> principals = subj.getPrincipals();
        for (Principal p : principals) {
            if (!(p instanceof JsonWebToken)) continue;
            return (JsonWebToken)p;
        }
        return this.buildTokenFromSecuritySubject(subj);
    }

    public JsonWebToken buildTokenFromSecuritySubject(Subject subject) throws Exception {
        String tokenString;
        if (!this.isValid) {
            return null;
        }
        TokenBuilder tb = new TokenBuilder();
        SubjectUtil subjectUtil = new SubjectUtil(subject);
        String customCacheKey = subjectUtil.getCustomCacheKey();
        String customAuthProvider = subjectUtil.getCustomAuthProvider();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"custom values, cck : ", (Object[])new Object[]{customCacheKey});
            Tr.debug((TraceComponent)tc, (String)"custom values, apr : ", (Object[])new Object[]{customAuthProvider});
        }
        if ((tokenString = tb.createTokenString(this.builderId, subject, customCacheKey, customAuthProvider)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"returning null because tokenString was null, creation failed.", (Object[])new Object[0]);
            }
            return null;
        }
        String userName = tb.getUserName(subject);
        if (userName == null || userName.compareTo("UNAUTHENTICATED") == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("returning null because username = " + userName), (Object[])new Object[0]);
            }
            return null;
        }
        return new DefaultJsonWebTokenImpl(tokenString, "JWT", userName);
    }

    private boolean checkForClaim(JsonWebToken jwt, String claimName) {
        return jwt.containsClaim(claimName);
    }

    public Subject handleJwtSsoTokenValidation(String tokenstr) throws Exception {
        JwtUtils.setJwtSsoValidationPath();
        Subject tempSubject = null;
        tempSubject = this.handleValidationUsingMPjwtConsumer(tokenstr);
        return tempSubject;
    }

    public Subject handleJwtSsoTokenValidationWithSubject(Subject subject, String tokenstr) throws Exception {
        JwtUtils.setJwtSsoValidationPath();
        JwtToken jwttoken = this.recreateJwt(tokenstr);
        if (jwttoken != null) {
            TokenBuilder tb = new TokenBuilder();
            String user = tb.getUserName(subject);
            DefaultJsonWebTokenImpl principal = new DefaultJsonWebTokenImpl(tokenstr, "JWT", user);
            subject.getPrincipals().add((Principal)principal);
            return subject;
        }
        return null;
    }

    private Subject handleValidationUsingMPjwtConsumer(String tokenstr) throws Exception {
        MicroProfileJwtConfig mpjwtConfig = this.getMpJwtConsumer();
        return this.mpjwttai.handleMicroProfileJwtValidation(null, null, mpjwtConfig, tokenstr, true).getSubject();
    }

    protected JwtToken recreateJwt(String tokenstr) throws Exception {
        JwtToken jwttoken = null;
        try {
            jwttoken = this.taiJwtUtils.createJwt(tokenstr, this.getMpJwtConsumer().getUniqueId());
        }
        catch (MpJwtProcessingException mpJwtProcessingException) {
            FFDCFilter.processException((Throwable)mpJwtProcessingException, (String)"com.ibm.ws.security.jwtsso.utils.JwtSsoTokenUtils", (String)"207", (Object)this, (Object[])new Object[]{tokenstr});
        }
        return jwttoken;
    }

    private MicroProfileJwtConfig getMpJwtConsumer() throws MpJwtProcessingException {
        MicroProfileJwtConfig mpjwtconfig;
        JwtSsoTokenUtils jwtSsoTokenUtils = this;
        Iterator it = jwtSsoTokenUtils.mpjwttai.getServices();
        boolean mpjwt = false;
        int mpJwtConfigs = 0;
        String mpjwtids = "";
        String mpJwtConfigId = null;
        boolean jwtsso = false;
        boolean jwtssoConfigs = false;
        while (it.hasNext()) {
            MicroProfileJwtConfig mpJwtConfig = (MicroProfileJwtConfig)it.next();
            if (mpJwtConfig.toString().contains("com.ibm.ws.security.jwtsso.internal.JwtSsoComponent") || this.taiRequestHelper.isMpJwtDefaultConfig(mpJwtConfig)) continue;
            mpjwt = true;
            mpJwtConfigId = mpJwtConfig.getUniqueId();
            mpjwtids = mpjwtids.concat(mpJwtConfigId).concat(" ");
            ++mpJwtConfigs;
        }
        if (mpJwtConfigs > 1) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"TOO_MANY_MP_JWT_PROVIDERS", (Object[])new Object[]{mpjwtids});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg);
        }
        if (mpjwt) {
            this.consumerId = mpJwtConfigId;
        }
        if ((mpjwtconfig = MicroProfileJwtTAI.getMicroProfileJwtConfig((String)this.consumerId)) == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_CONSUMER_CONFIG_NOT_FOUND", (Object[])new Object[]{this.consumerId});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg);
        }
        return mpjwtconfig;
    }

    public boolean isJwtValid(String tokenstr) {
        try {
            if (this.recreateJwt(tokenstr) == null) {
                return false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwtsso.utils.JwtSsoTokenUtils", (String)"256", (Object)this, (Object[])new Object[]{tokenstr});
            return false;
        }
        return true;
    }

    public String getCustomCacheKeyFromToken(String tokenstr) {
        String customCacheKey = null;
        String payload = this.decodedPayload(tokenstr);
        if (payload != null) {
            customCacheKey = (String)this.getClaim(payload, "sid");
        }
        return customCacheKey;
    }

    private Object getClaim(String payload, String claim) {
        try {
            return JsonUtils.claimFromJsonObject((String)payload, (String)claim);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwtsso.utils.JwtSsoTokenUtils", (String)"274", (Object)this, (Object[])new Object[]{payload, claim});
            return null;
        }
    }

    public String decodedPayload(String tokenstr) {
        if (tokenstr != null) {
            String payload = JsonUtils.getPayload((String)tokenstr);
            return JsonUtils.decodeFromBase64String((String)payload);
        }
        return null;
    }
}

