/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer40.util;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.util.ClauseNode;
import com.ibm.ws.webcontainer.util.URIMatcher;
import com.ibm.ws.webcontainer40.osgi.webapp.WebAppDispatcherContext40;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.util.URIMatcher;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.MappingMatch;

public class URIMatcher40
extends URIMatcher {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer40.util");
    private static final String CLASS_NAME = URIMatcher40.class.getName();

    public URIMatcher40() {
    }

    public URIMatcher40(boolean scalable) {
        super(scalable);
    }

    public Object match(IExtendedRequest req) {
        String methodName = "match";
        WebAppDispatcherContext40 dispatchContext = (WebAppDispatcherContext40)req.getWebAppDispatcherContext();
        String uri = dispatchContext.getRelativeUri().trim();
        dispatchContext.setPossibleSlashStarMapping(true);
        int jsessionIndex = uri.indexOf(59);
        if (WCCustomProperties.USE_SEMICOLON_AS_DELIMITER_IN_URI) {
            String lowerCaseURI = uri.toLowerCase();
            if (jsessionIndex >= 0 && !lowerCaseURI.substring(jsessionIndex + 1).startsWith("jsessionid")) {
                int realJSIndex;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "The semi-colon is being treated as a delimiter");
                }
                if ((realJSIndex = lowerCaseURI.indexOf(";jsessionid")) < 0) {
                    uri = uri.substring(0, jsessionIndex);
                    jsessionIndex = -1;
                } else {
                    uri = uri.substring(0, jsessionIndex) + uri.substring(realJSIndex);
                }
            }
        }
        String strippedUri = uri;
        if (jsessionIndex != -1) {
            strippedUri = strippedUri.substring(0, jsessionIndex);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, "uri->" + uri);
            logger.logp(Level.FINE, CLASS_NAME, methodName, "jsessionIndex->" + jsessionIndex);
        }
        if (uri.equals("/") && this.root.getTarget() != null) {
            dispatchContext.setPossibleSlashStarMapping(false);
            dispatchContext.setMappingMatch(MappingMatch.CONTEXT_ROOT);
            dispatchContext.setPathElements("", "/");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "found an exact match on the context-root");
                logger.logp(Level.FINE, CLASS_NAME, methodName, "set mappingMatch to: " + MappingMatch.CONTEXT_ROOT);
            }
            return this.root.getTarget();
        }
        URIMatcher.Result result = this.findNode(strippedUri);
        Object target = null;
        if (result != null && result.node != this.defaultNode) {
            String servletPath;
            ClauseNode node = result.node;
            target = result.target;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "found a target-->" + target);
            }
            boolean starTarget = node.getStarTarget() == target;
            String pathInfo = null;
            if (starTarget) {
                dispatchContext.setMappingMatch(MappingMatch.PATH);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "set MappingMatch to: " + MappingMatch.PATH);
                }
                int split = node.getDepth();
                servletPath = uri;
                if (split < uri.length()) {
                    servletPath = uri.substring(0, split);
                    pathInfo = uri.substring(split);
                }
            } else {
                dispatchContext.setMappingMatch(MappingMatch.EXACT);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "set MappingMatch to: " + MappingMatch.EXACT);
                }
                servletPath = strippedUri;
                String string = pathInfo = jsessionIndex == -1 ? null : uri.substring(jsessionIndex);
            }
            if (node != this.root) {
                dispatchContext.setPossibleSlashStarMapping(false);
            }
            dispatchContext.setPathElements(servletPath, pathInfo);
            return target;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, "looking for extension mapping");
        }
        if ((target = this.findByExtension(strippedUri)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "uri-->" + strippedUri + ", target-->" + target);
            }
            dispatchContext.setPossibleSlashStarMapping(false);
            dispatchContext.setPathElements(jsessionIndex == -1 ? uri : uri.substring(0, jsessionIndex), jsessionIndex == -1 ? null : uri.substring(jsessionIndex));
            dispatchContext.setMappingMatch(MappingMatch.EXTENSION);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "set MappingMatch to: " + MappingMatch.EXTENSION);
            }
            return target;
        }
        if (this.defaultNode != null) {
            dispatchContext.setMappingMatch(MappingMatch.DEFAULT);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "set MappingMatch to: " + MappingMatch.DEFAULT);
            }
            dispatchContext.setPossibleSlashStarMapping(true);
            Object starTarget = this.defaultNode.getStarTarget();
            if (URIMatcher.SERVLET_PATH_FOR_DEFAULT_MAPPING && starTarget instanceof ServletWrapper && ((ServletWrapper)starTarget).isDefaultServlet()) {
                dispatchContext.setPathElements(uri, null);
            } else {
                dispatchContext.setPathElements("", uri);
            }
            return starTarget;
        }
        return null;
    }
}

