/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.internal.interfaces.SecurityContextStore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Iterator;
import org.jboss.weld.security.spi.SecurityServices;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.cdi.impl.DefaultSecurityService", property={"service.vendor=IBM", "service.ranking:Integer=50"})
public class DefaultSecurityService
implements SecurityServices {
    private static final TraceComponent tc = Tr.register(DefaultSecurityService.class);
    private final ConcurrentServiceReferenceSet<SecurityContextStore> securityContextStores = new ConcurrentServiceReferenceSet("securityContextStore");
    static final long serialVersionUID = 1644863611338052795L;

    protected void activate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.securityContextStores.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.securityContextStores.deactivate(compcontext);
    }

    @Reference(name="securityContextStore", service=SecurityContextStore.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.AT_LEAST_ONE)
    protected void addSecurityContextStore(ServiceReference<SecurityContextStore> ref) {
        this.securityContextStores.addReference(ref);
    }

    protected void removeSecurityContextStore(ServiceReference<SecurityContextStore> ref) {
        this.securityContextStores.removeReference(ref);
    }

    public Principal getPrincipal() {
        Principal principal = AccessController.doPrivileged(new PrivilegedAction<Principal>(){
            static final long serialVersionUID = -4534389146720387882L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Principal run() {
                Principal principal = null;
                Iterator contextStores = DefaultSecurityService.this.securityContextStores.getServices();
                while (contextStores.hasNext() && principal == null) {
                    SecurityContextStore securityContextStore = (SecurityContextStore)contextStores.next();
                    if (securityContextStore == null) continue;
                    principal = securityContextStore.getCurrentPrincipal();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Principal from " + securityContextStore + ": " + principal), (Object[])new Object[0]);
                }
                return principal;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return principal;
    }

    public void cleanup() {
    }
}

