/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.quickstart.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.management.security.ManagementRole;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.quickstart.internal.Password;
import com.ibm.ws.security.quickstart.internal.QuickStartSecurityAdministratorRole;
import com.ibm.ws.security.quickstart.internal.QuickStartSecurityConfig;
import com.ibm.ws.security.quickstart.internal.QuickStartSecurityRegistry;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.felix.scr.ext.annotation.DSExt;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.security.quickStartSecurity"}, property={"service.vendor=IBM"})
@DSExt.ConfigureWithInterfaces
public class QuickStartSecurity {
    private static final TraceComponent tc = Tr.register(QuickStartSecurity.class);
    static final String KEY_MANAGEMENT_ROLE = "ManagementRole";
    private final Set<ServiceReference<UserRegistry>> urs = new ConcurrentSkipListSet<ServiceReference<UserRegistry>>();
    private final Set<ServiceReference<ManagementRole>> managementRoles = new ConcurrentSkipListSet<ServiceReference<ManagementRole>>();
    static final String QUICK_START_SECURITY_REGISTRY_ID = "com.ibm.ws.management.security.QuickStartSecurity";
    static final String QUICK_START_SECURITY_REGISTRY_TYPE = "QuickStartSecurityRegistry";
    static final String QUICK_START_ADMINISTRATOR_ROLE_NAME = "QuickStartSecurityAdministratorRole";
    static final String CFG_KEY_USER = "userName";
    static final String CFG_KEY_PASSWORD = "userPassword";
    private BundleContext bc = null;
    private ServiceRegistration<UserRegistry> urConfigReg = null;
    private QuickStartSecurityRegistry quickStartRegistry = null;
    private ServiceRegistration<ManagementRole> managementRoleReg = null;
    private ManagementRole managementRole = null;
    private QuickStartSecurityConfig config;
    static final long serialVersionUID = -7436412887173142665L;

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(!(com.ibm.ws.security.registry.type=QuickStartSecurityRegistry))")
    protected synchronized void setUserRegistry(ServiceReference<UserRegistry> ref) {
        this.urs.add(ref);
        this.unregisterQuickStartSecurityRegistryConfiguration();
        this.unregisterQuickStartSecurityAdministratorRole();
    }

    protected synchronized void unsetUserRegistry(ServiceReference<UserRegistry> ref) {
        this.urs.remove(ref);
        this.registerQuickStartSecurityRegistryConfiguration();
        this.registerQuickStartSecurityAdministratorRole();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(!(com.ibm.ws.management.security.role.name=QuickStartSecurityAdministratorRole))")
    protected synchronized void setManagementRole(ServiceReference<ManagementRole> ref) {
        this.managementRoles.add(ref);
        this.unregisterQuickStartSecurityRegistryConfiguration();
        this.unregisterQuickStartSecurityAdministratorRole();
    }

    protected synchronized void unsetManagementRole(ServiceReference<ManagementRole> ref) {
        this.managementRoles.remove(ref);
        this.registerQuickStartSecurityRegistryConfiguration();
        this.registerQuickStartSecurityAdministratorRole();
    }

    @Activate
    protected synchronized void activate(BundleContext bc, QuickStartSecurityConfig config) {
        this.bc = bc;
        this.config = config;
        this.validateConfigurationProperties();
        this.registerQuickStartSecurityRegistryConfiguration();
        this.registerQuickStartSecurityAdministratorRole();
    }

    @Modified
    protected synchronized void modify(QuickStartSecurityConfig config) {
        this.config = config;
        this.validateConfigurationProperties();
        if (this.urConfigReg == null) {
            this.registerQuickStartSecurityRegistryConfiguration();
        } else {
            this.updateQuickStartSecurityRegistryConfiguration();
        }
        this.unregisterQuickStartSecurityAdministratorRole();
        this.registerQuickStartSecurityAdministratorRole();
    }

    @Deactivate
    protected synchronized void deactivate() {
        this.bc = null;
        this.config = null;
        this.unregisterQuickStartSecurityRegistryConfiguration();
        this.unregisterQuickStartSecurityAdministratorRole();
    }

    @Trivial
    private boolean isStringValueUndefined(Object str) {
        if (str instanceof SerializableProtectedString) {
            char[] contents;
            for (char ch : contents = ((SerializableProtectedString)str).getChars()) {
                if (ch <= ' ') continue;
                return false;
            }
            return true;
        }
        return str == null || ((String)str).trim().isEmpty();
    }

    private void validateConfigurationProperties() {
        if (this.isStringValueUndefined(this.config.userName()) && !this.isStringValueUndefined(this.config.userPassword())) {
            Tr.error((TraceComponent)tc, (String)"QUICK_START_SECURITY_MISSING_ATTIRBUTES", (Object[])new Object[]{CFG_KEY_USER});
        }
        if (!this.isStringValueUndefined(this.config.userName()) && this.isStringValueUndefined(this.config.userPassword())) {
            Tr.error((TraceComponent)tc, (String)"QUICK_START_SECURITY_MISSING_ATTIRBUTES", (Object[])new Object[]{CFG_KEY_PASSWORD});
        }
        this.errorOnAnotherRegistry();
        this.errorOnAnotherManagementRole();
    }

    private void errorOnAnotherRegistry() {
        if (!(this.isStringValueUndefined(this.config.userName()) && this.isStringValueUndefined(this.config.userPassword()) || this.config.UserRegistry() == null || this.config.UserRegistry().length <= 0)) {
            Tr.error((TraceComponent)tc, (String)"QUICK_START_SECURITY_WITH_ANOTHER_REGISTRY", (Object[])new Object[0]);
        }
    }

    private void errorOnAnotherManagementRole() {
        if (!(this.isStringValueUndefined(this.config.userName()) && this.isStringValueUndefined(this.config.userPassword()) || this.config.ManagementRole() == null || this.config.ManagementRole().length <= 0)) {
            Tr.error((TraceComponent)tc, (String)"QUICK_START_SECURITY_WITH_OTHER_MANAGEMENT_AUTHORIZATION", (Object[])new Object[0]);
        }
    }

    private Dictionary<String, Object> buildUserRegistryConfigProps() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("config.id", QUICK_START_SECURITY_REGISTRY_ID);
        properties.put("id", QUICK_START_SECURITY_REGISTRY_ID);
        properties.put("com.ibm.ws.security.registry.type", QUICK_START_SECURITY_REGISTRY_TYPE);
        properties.put(CFG_KEY_USER, this.config.userName());
        properties.put("service.vendor", "IBM");
        return properties;
    }

    private void registerQuickStartSecurityRegistryConfiguration() {
        if (this.bc == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BundleContext is null, we must be deactivated.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.urConfigReg != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"QuickStartSecurityRegistry configuration is already registered.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.isStringValueUndefined(this.config.userName()) || this.isStringValueUndefined(this.config.userPassword())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Incomplete configuration. This should already have been reported. Will not register QuickStartSecurityRegistry configuration.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.config.UserRegistry() != null && this.config.UserRegistry().length > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Other UserRegistryConfiguration are present, will not register the QuickStartSecurityRegistry configuration.", (Object[])new Object[0]);
            }
            return;
        }
        if (!this.managementRoles.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Other ManagementRole are present, will not register the QuickStartSecurityRegistry configuration.", (Object[])new Object[0]);
            }
            return;
        }
        Dictionary<String, Object> props = this.buildUserRegistryConfigProps();
        this.quickStartRegistry = new QuickStartSecurityRegistry(this.config.userName(), Password.create(this.config.userPassword()));
        this.urConfigReg = this.bc.registerService(UserRegistry.class, (Object)this.quickStartRegistry, props);
    }

    private void updateQuickStartSecurityRegistryConfiguration() {
        if (!(this.isStringValueUndefined(this.config.userName()) || this.isStringValueUndefined(this.config.userPassword()) || this.config.UserRegistry() != null && this.config.UserRegistry().length != 0 || this.config.ManagementRole() != null && this.config.ManagementRole().length != 0)) {
            this.quickStartRegistry.update(this.config.userName(), Password.create(this.config.userPassword()));
            Dictionary<String, Object> newConfigProps = this.buildUserRegistryConfigProps();
            this.urConfigReg.setProperties(newConfigProps);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Lost required configuration information, removing the configuration (if its registered).", (Object[])new Object[0]);
            }
            this.unregisterQuickStartSecurityRegistryConfiguration();
        }
    }

    private void unregisterQuickStartSecurityRegistryConfiguration() {
        if (this.urConfigReg != null) {
            this.urConfigReg.unregister();
            this.urConfigReg = null;
            this.quickStartRegistry = null;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"QuickStartSecurityRegistry configuration is not registered.", (Object[])new Object[0]);
        }
    }

    private void registerQuickStartSecurityAdministratorRole() {
        if (this.bc == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BundleContext is null, we must be deactivated.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.managementRoleReg != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"QuickStartSecurityAdministratorRole is already registered.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.urConfigReg == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"QuickStartSecurityRegistry configuration is not registered, will not register QuickStartSecurityAdministratorRole.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.isStringValueUndefined(this.config.userName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"User is not set, can not register the QuickStartSecurityAdministratorRole", (Object[])new Object[0]);
            }
            return;
        }
        if (!this.managementRoles.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Other managment roles are present, will not register the QuickStartSecurityAdministratorRole", (Object[])new Object[0]);
            }
            return;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("com.ibm.ws.management.security.role.name", QUICK_START_ADMINISTRATOR_ROLE_NAME);
        ((Dictionary)props).put("service.vendor", "IBM");
        this.managementRole = new QuickStartSecurityAdministratorRole(this.config.userName());
        this.managementRoleReg = this.bc.registerService(ManagementRole.class, (Object)this.managementRole, props);
    }

    private void unregisterQuickStartSecurityAdministratorRole() {
        if (this.managementRoleReg != null) {
            this.managementRoleReg.unregister();
            this.managementRoleReg = null;
            this.managementRole = null;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"QuickStartSecurityAdministratorRole is not registered.", (Object[])new Object[0]);
        }
    }
}

