/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.principals;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Principal;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -5854954199707595239L;
    private static final String AUTH_METHOD = "authMethod";
    private static final String ACCESS_ID = "accessId";
    private static final String SECURITY_NAME = "securityName";
    private static final ObjectStreamField[] serialPersistentFields;
    public static final String AUTH_METHOD_PASSWORD = "password";
    public static final String AUTH_METHOD_CERTIFICATE = "certificate";
    public static final String AUTH_METHOD_TOKEN = "token";
    public static final String AUTH_METHOD_JWT_SSO_TOKEN = "jwtSSOToken";
    public static final String AUTH_METHOD_IDENTITY_ASSERTION = "idAssert";
    public static final String AUTH_METHOD_HASH_TABLE = "hashtable";
    public static final String AUTH_METHOD_BASIC = "basic";
    private transient String securityName;
    private transient String accessId;
    private transient String authMethod;
    private transient int hash;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WSPrincipal(String securityName, String accessId, String authMethod) {
        if (securityName == null || securityName.isEmpty() || authMethod == null || authMethod.isEmpty()) {
            throw new IllegalArgumentException("Sanity check, null / empty values are invalid here");
        }
        this.securityName = securityName;
        this.accessId = accessId;
        this.authMethod = authMethod;
        this.hash = (this.toString() + accessId).hashCode();
    }

    @Override
    public String getName() {
        return this.securityName;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getAuthenticationMethod() {
        return this.authMethod;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WSPrincipal)) {
            return false;
        }
        WSPrincipal that = (WSPrincipal)obj;
        boolean securityNamesAreEqual = false;
        boolean accessIdsAreEqual = false;
        if (this.securityName.equals(that.securityName)) {
            securityNamesAreEqual = true;
        }
        if (this.accessId != null && this.accessId.equals(that.accessId) || this.accessId == null && that.accessId == null) {
            accessIdsAreEqual = true;
        }
        return securityNamesAreEqual && accessIdsAreEqual;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.authMethod = (String)fields.get(AUTH_METHOD, null);
        this.accessId = (String)fields.get(ACCESS_ID, null);
        this.securityName = (String)fields.get(SECURITY_NAME, null);
        this.hash = (this.toString() + this.accessId).hashCode();
    }

    @Override
    public String toString() {
        return "WSPrincipal:" + this.securityName;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put(AUTH_METHOD, this.authMethod);
        fields.put(ACCESS_ID, this.accessId);
        fields.put(SECURITY_NAME, this.securityName);
        out.writeFields();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WSPrincipal.class);
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(AUTH_METHOD, String.class), new ObjectStreamField(ACCESS_ID, String.class), new ObjectStreamField(SECURITY_NAME, String.class)};
    }
}

