/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javamail.internal;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javamail.j2ee.MailSessionRegistrar;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.javamail.mailSession"}, property={"creates.objectClass=javax.mail.Session"})
public class MailSessionService
implements ResourceFactory {
    private final TraceComponent tc = Tr.register(MailSessionService.class);
    private final AtomicReference<ComponentContext> cctx = new AtomicReference();
    private static final String KEY_MAIL_SESSION_REGISTRAR = "MailSessionRegistrar";
    private final AtomicServiceReference<MailSessionRegistrar> mailSessionRegistrarRef = new AtomicServiceReference("MailSessionRegistrar");
    private ServiceRegistration<?> mbeanServiceReg;
    private final Properties sessionProperties = new Properties();
    public static final String MAILSESSIONID = "mailSessionID";
    public static final String JNDI_NAME = "jndiName";
    public static final String DESCRIPTION = "description";
    public static final String STOREPROTOCOL = "storeProtocol";
    public static final String TRANSPORTPROTOCOL = "transportProtocol";
    public static final String HOST = "host";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String FROM = "from";
    public static final String STOREPROTOCOLCLASSNAME = "storeProtocolClassName";
    public static final String TRANSPORTPROTOCOLCLASSNAME = "transportProtocolClassName";
    public static final String PROPERTY = "property";
    public static final String NAME = "name";
    protected static final String VALUE = "value";
    private final String[] propertiesArray = new String[]{"mailSessionID", "jndiName", "description", "storeProtocol", "transportProtocol", "host", "user", "password", "from", "storeProtocolClassName", "transportProtocolClassName", "property"};
    List<Map<String, Object>> listOfPropMap;
    static final long serialVersionUID = 2287595353265058259L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext context) throws Exception {
        this.cctx.set(context);
        this.mailSessionRegistrarRef.activate(context);
        this.modified(context);
        Tr.info((TraceComponent)this.tc, (String)"CWWKX0957I", (Object[])new Object[]{"For the mailSession with the mailSessionID: " + this.sessionProperties.getProperty(MAILSESSIONID)});
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.deregisterJavaMailMBean();
        this.mailSessionRegistrarRef.deactivate(context);
    }

    @Modified
    protected void modified(ComponentContext context) throws Exception {
        this.processProperties(context.getProperties());
        this.deregisterJavaMailMBean();
        this.registerJavaMailMBean();
    }

    public void processProperties(Dictionary<String, Object> properties) {
        for (String i : this.propertiesArray) {
            if (properties.get(i) != null) {
                this.sessionProperties.put(i, properties.get(i));
            }
            if (i != PROPERTY || Nester.nest(PROPERTY, properties) == null) continue;
            this.listOfPropMap = Nester.nest(PROPERTY, properties);
        }
    }

    public Object createResource(ResourceInfo info) throws Exception {
        Properties propertyNames = this.createPropertyNames();
        Properties props = this.createProperties(propertyNames);
        if (this.listOfPropMap != null) {
            for (Map<String, Object> nestedProperties : this.listOfPropMap) {
                props.put(nestedProperties.get(NAME), nestedProperties.get(VALUE));
            }
        }
        Session session = this.createSession(props);
        return session;
    }

    private Properties createProperties(Properties propertyNames) {
        Properties props = new Properties();
        for (String key : this.propertiesArray) {
            if (this.sessionProperties.get(key) == null) continue;
            if (!key.equalsIgnoreCase(STOREPROTOCOLCLASSNAME) && !key.equalsIgnoreCase(TRANSPORTPROTOCOLCLASSNAME)) {
                props.put(key, this.sessionProperties.get(key));
                if (propertyNames.getProperty(key) == null) continue;
                props.put(propertyNames.getProperty(key), this.sessionProperties.get(key));
                continue;
            }
            if (key.equalsIgnoreCase(STOREPROTOCOLCLASSNAME)) {
                props.put("mail." + props.getProperty(STOREPROTOCOL) + ".class", this.sessionProperties.get(key));
                continue;
            }
            props.put("mail." + props.getProperty(TRANSPORTPROTOCOL) + ".class", this.sessionProperties.get(key));
        }
        return props;
    }

    private Properties createPropertyNames() {
        Properties propertyNames = new Properties();
        propertyNames.setProperty(HOST, "mail.host");
        propertyNames.setProperty(USER, "mail.user");
        propertyNames.setProperty(FROM, "mail.from");
        propertyNames.setProperty(TRANSPORTPROTOCOL, "mail.transport.protocol");
        propertyNames.setProperty(STOREPROTOCOL, "mail.store.protocol");
        return propertyNames;
    }

    private Session createSession(Properties props) throws InvalidPasswordDecodingException, UnsupportedCryptoAlgorithmException {
        Session session = null;
        if (this.sessionProperties.get(PASSWORD) != null && this.sessionProperties.get(USER) != null) {
            SerializableProtectedString password = (SerializableProtectedString)this.sessionProperties.get(PASSWORD);
            String pwdStr = password == null ? null : String.valueOf(password.getChars());
            final String pwd = pwdStr = PasswordUtil.getCryptoAlgorithm((String)pwdStr) == null ? pwdStr : PasswordUtil.decode((String)pwdStr);
            this.sessionProperties.put("mail.password", pwdStr);
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){
                static final long serialVersionUID = 5226258423655845645L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication((String)MailSessionService.this.sessionProperties.get(MailSessionService.USER), pwd);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        } else {
            session = Session.getInstance((Properties)props, null);
        }
        return session;
    }

    @Reference(service=MailSessionRegistrar.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, target="(component.name=com.ibm.ws.javamail.management.j2ee.MailSessionRegistrarImpl)")
    protected void setMailSessionRegistrar(ServiceReference<MailSessionRegistrar> ref) {
        this.mailSessionRegistrarRef.setReference(ref);
        this.registerJavaMailMBean();
    }

    protected void unsetMailSessionRegistrar(ServiceReference<MailSessionRegistrar> ref) {
        this.deregisterJavaMailMBean();
        this.mailSessionRegistrarRef.unsetReference(ref);
    }

    private void registerJavaMailMBean() {
        MailSessionRegistrar msr = (MailSessionRegistrar)this.mailSessionRegistrarRef.getService();
        if (msr != null && this.mbeanServiceReg == null) {
            this.mbeanServiceReg = msr.registerJavaMailMBean(String.valueOf(this.sessionProperties.get(MAILSESSIONID)));
        }
    }

    private void deregisterJavaMailMBean() {
        if (this.mbeanServiceReg != null) {
            try {
                this.mbeanServiceReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.javamail.internal.MailSessionService", (String)"305", (Object)this, (Object[])new Object[0]);
            }
            finally {
                this.mbeanServiceReg = null;
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MailSessionService.class);
    }
}

