/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.statemachine;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.ApplicationStateCoordinator;
import com.ibm.ws.app.manager.internal.ApplicationConfig;
import com.ibm.ws.app.manager.internal.ApplicationDependency;
import com.ibm.ws.app.manager.internal.ApplicationInstallInfo;
import com.ibm.ws.app.manager.internal.FutureCollectionCompletionListener;
import com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor;
import com.ibm.ws.app.manager.internal.monitor.ApplicationMonitorConfig;
import com.ibm.ws.app.manager.internal.statemachine.Action;
import com.ibm.ws.app.manager.internal.statemachine.ApplicationStateMachine;
import com.ibm.ws.app.manager.internal.statemachine.DownloadFileAction;
import com.ibm.ws.app.manager.internal.statemachine.ResolveFileAction;
import com.ibm.ws.app.manager.internal.statemachine.ResourceCallback;
import com.ibm.ws.app.manager.internal.statemachine.StartAction;
import com.ibm.ws.app.manager.internal.statemachine.StateChangeCallback;
import com.ibm.ws.app.manager.internal.statemachine.StopAction;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.application.ApplicationState;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ApplicationStateMachineImpl
extends ApplicationStateMachine
implements ApplicationMonitor.UpdateHandler,
Runnable {
    private static final TraceComponent _tc = Tr.register(ApplicationStateMachineImpl.class);
    final Future<Boolean>[] EMPTY_FUTURE_ARRAY = (Future[])Array.newInstance(Future.class, 0);
    private static final AtomicLong asmSequenceNumber = new AtomicLong(0L);
    private final AtomicInteger _qscaCounter = new AtomicInteger();
    private volatile Throwable _failedThrowable;
    private final Object _interruptibleLock = new Object(){
        static final long serialVersionUID = 1428897424970146289L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(2.class);
        }
    };
    private volatile boolean _interruptible;
    private volatile boolean _performingQueuedActions;
    private final ConcurrentLinkedQueue<QueuedStateChangeAction> _queuedActions = new ConcurrentLinkedQueue();
    private final AtomicReference<CallbackState> _callbackState = new AtomicReference();
    private final Set<ApplicationDependency> blockAppStartingFutures = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicReference<ApplicationDependency> waitingForAppHandlerFuture = new AtomicReference();
    private final AtomicReference<ApplicationDependency> waitingForExplicitStartFuture = new AtomicReference();
    private final AtomicReference<CancelableCompletionListenerWrapper<Boolean>> completionListener = new AtomicReference();
    private final ConcurrentLinkedQueue<ApplicationDependency> _notifyAppStopped = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ApplicationDependency> _notifyAppStarting = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ApplicationDependency> _notifyAppInstallCalled = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ApplicationDependency> _notifyAppStarted = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ApplicationDependency> _notifyAppRemoved = new ConcurrentLinkedQueue();
    private final Object _stateLock = new Object(){
        static final long serialVersionUID = -2844785999478513305L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(3.class);
        }
    };
    private final AtomicReference<InternalState> _internalState = new AtomicReference();
    private final AtomicReference<Action> _currentAction = new AtomicReference();
    private final AtomicReference<ResolveFileAction> _rfa = new AtomicReference();
    private final AtomicReference<ApplicationInstallInfo> _appInstallInfo = new AtomicReference();
    private final AtomicBoolean _update = new AtomicBoolean();
    private final AtomicReference<ApplicationConfig> _appConfig = new AtomicReference();
    private final AtomicReference<ApplicationConfig> _nextAppConfig = new AtomicReference();
    private final AtomicReference<Container> _appContainer = new AtomicReference();
    private final AtomicReference<WsResource> _resolvedLocation = new AtomicReference();
    private final AtomicReference<ApplicationHandler<?>> _handler = new AtomicReference();
    private final long _asmSeqNo;
    private final BundleContext _ctx;
    private final WsLocationAdmin _locAdmin;
    private final FutureMonitor _futureMonitor;
    private final ArtifactContainerFactory _artifactFactory;
    private final AdaptableModuleFactory _moduleFactory;
    private final ExecutorService _executorService;
    private final ScheduledExecutorService _scheduledExecutorService;
    private final ApplicationStateMachine.ASMHelper _asmHelper;
    private final ApplicationMonitor _appMonitor;
    private final AtomicBoolean enterStateCalled = new AtomicBoolean();
    static final long serialVersionUID = 6511956370079301927L;

    @Override
    public Future<Boolean> start() {
        CancelableCompletionListenerWrapper cl;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(this.asmLabel() + "appService: start for app " + this._appConfig.get().getName()), (Object[])new Object[0]);
        }
        if ((cl = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
            cl.cancel();
        }
        ApplicationDependency appDep = this.createDependency("resolves when app " + this.getAppName() + " finishes starting");
        this._notifyAppStarted.add(appDep);
        this.completeExplicitStartFuture();
        this.attemptStateChange(StateChangeAction.START);
        return appDep.getFuture();
    }

    @Override
    public Future<Boolean> stop() {
        CancelableCompletionListenerWrapper cl;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(this.asmLabel() + "appService: stop for app " + this._appConfig.get().getName()), (Object[])new Object[0]);
        }
        if ((cl = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
            cl.cancel();
        }
        ApplicationDependency appDep = this.createDependency("resolves when app " + this.getAppName() + " finishes stopping");
        this._notifyAppStopped.add(appDep);
        this.createExplicitStartFuture();
        this.attemptStateChange(StateChangeAction.STOP);
        return appDep.getFuture();
    }

    @Override
    public void restart() {
        CancelableCompletionListenerWrapper cl;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(this.asmLabel() + "appService: restart for app " + this._appConfig.get().getName()), (Object[])new Object[0]);
        }
        if ((cl = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
            cl.cancel();
        }
        this.completeExplicitStartFuture();
        this.attemptStateChange(StateChangeAction.RESTART);
    }

    @Override
    public void setAppHandler(ApplicationHandler<?> appHandler) {
        ApplicationHandler<?> oldHandler;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "setAppHandler: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if ((oldHandler = this._handler.getAndSet(appHandler)) == appHandler) {
            return;
        }
        if (appHandler == null) {
            this.cleanupActions();
            ApplicationDependency appHandlerFuture = this.createDependency("resolves when the app handler for app " + this.getAppName() + " arrives");
            appHandlerFuture = this.waitingForAppHandlerFuture.getAndSet(appHandlerFuture);
            if (appHandlerFuture != null) {
                this.resolveDependency(appHandlerFuture);
            }
        } else {
            this.completeAppHandlerFuture();
            if (oldHandler != null) {
                this.queueStateChange(StateChangeAction.RESTART);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(ApplicationConfig appConfig, Collection<ApplicationDependency> appStartingFutures, ApplicationDependency notifyAppStopped, ApplicationDependency notifyAppStarting, ApplicationDependency notifyAppInstallCalled, ApplicationDependency notifyAppStarted) {
        CancelableCompletionListenerWrapper cl;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "configure: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if ((cl = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
            cl.cancel();
        }
        boolean checkForUnprocessedConfigChange = this._nextAppConfig.getAndSet(appConfig) != null;
        this.addAppStartingFutures(appStartingFutures);
        if (notifyAppStopped != null) {
            this._notifyAppStopped.add(notifyAppStopped);
        }
        if (notifyAppStarting != null) {
            this._notifyAppStarting.add(notifyAppStarting);
        }
        if (notifyAppInstallCalled != null) {
            this._notifyAppInstallCalled.add(notifyAppInstallCalled);
        }
        if (notifyAppStarted != null) {
            this._notifyAppStarted.add(notifyAppStarted);
        }
        if (this.getInternalState() == InternalState.INITIAL && !appConfig.isAutoStarted()) {
            this.createExplicitStartFuture();
        }
        if (checkForUnprocessedConfigChange) {
            Object object = this._interruptibleLock;
            synchronized (object) {
                for (QueuedStateChangeAction queuedAction : this._queuedActions) {
                    if (queuedAction.action != StateChangeAction.CONFIGURE) continue;
                    return;
                }
            }
        }
        this.queueStateChange(StateChangeAction.CONFIGURE);
    }

    @Override
    public void recycle(Collection<ApplicationDependency> appStartingFutures, ApplicationDependency notifyAppStopped, ApplicationDependency notifyAppInstallCalled, ApplicationDependency notifyAppStarted) {
        CancelableCompletionListenerWrapper cl;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "recycle: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if ((cl = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
            cl.cancel();
        }
        this.addAppStartingFutures(appStartingFutures);
        if (notifyAppStopped != null) {
            this._notifyAppStopped.add(notifyAppStopped);
        }
        if (notifyAppInstallCalled != null) {
            this._notifyAppInstallCalled.add(notifyAppInstallCalled);
        }
        if (notifyAppStarted != null) {
            this._notifyAppStarted.add(notifyAppStarted);
        }
        this.queueStateChange(StateChangeAction.RESTART);
    }

    @Override
    public void uninstall(ApplicationDependency notifyAppRemoved) {
        CancelableCompletionListenerWrapper cl;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "uninstall: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if ((cl = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
            cl.cancel();
        }
        if (this.getInternalState() == InternalState.REMOVED) {
            throw new IllegalStateException("uninstall: removed");
        }
        if (notifyAppRemoved != null) {
            this._notifyAppRemoved.add(notifyAppRemoved);
        }
        ApplicationDependency appStoppedFuture = this.createDependency("resolves when the app " + this.getAppName() + " finishes stopping, at which point it will be removed");
        appStoppedFuture.onCompletion(new CompletionListener<Boolean>(){
            static final long serialVersionUID = 1431708938203468364L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void successfulCompletion(Future<Boolean> future, Boolean result) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "uninstall: successfulCompletion: future " + future + ", result " + result), (Object[])new Object[0]);
                }
                ApplicationStateMachineImpl.this.switchInternalState(InternalState.STOPPED, InternalState.REMOVED);
            }

            public void failedCompletion(Future<Boolean> future, Throwable t) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "uninstall: failedCompletion: future " + future + ", throwable " + t), (Object[])new Object[0]);
                }
                ApplicationStateMachineImpl.this.switchInternalState(InternalState.STOPPED, InternalState.FAILED);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        this._notifyAppStopped.add(appStoppedFuture);
        this.queueStateChange(StateChangeAction.REMOVE);
    }

    @Override
    @Trivial
    public void describe(StringBuilder sb) {
        WsResource location;
        sb.append("\nASM");
        sb.append("\nSequence Number: ");
        sb.append(this._asmSeqNo);
        sb.append("\nInternal State: ");
        sb.append((Object)this.getInternalState());
        sb.append("\nCallback State: ");
        sb.append((Object)this._callbackState.get());
        if (!this._notifyAppStopped.isEmpty()) {
            sb.append("\nApp Stopped Dependencies: ");
            for (ApplicationDependency ad : this._notifyAppStopped) {
                sb.append("\n");
                sb.append(ad.toString());
            }
        }
        if (!this._notifyAppInstallCalled.isEmpty()) {
            sb.append("\nApp Install Called Dependencies: ");
            for (ApplicationDependency ad : this._notifyAppInstallCalled) {
                sb.append("\n");
                sb.append(ad.toString());
            }
        }
        if (!this._notifyAppStarting.isEmpty()) {
            sb.append("\nApp Starting Dependencies: ");
            for (ApplicationDependency ad : this._notifyAppStarting) {
                sb.append("\n");
                sb.append(ad.toString());
            }
        }
        if (!this._notifyAppStarted.isEmpty()) {
            sb.append("\nApp Started Dependencies: ");
            for (ApplicationDependency ad : this._notifyAppStarted) {
                sb.append("\n");
                sb.append(ad.toString());
            }
        }
        if (!this._notifyAppRemoved.isEmpty()) {
            sb.append("\nApp Removed Dependencies: ");
            for (ApplicationDependency ad : this._notifyAppRemoved) {
                sb.append("\n");
                sb.append(ad.toString());
            }
        }
        if (this.waitingForAppHandlerFuture.get() != null) {
            sb.append("\nWaiting for App Handler: ");
            sb.append(this.waitingForAppHandlerFuture.get());
        }
        if (this.waitingForExplicitStartFuture.get() != null) {
            sb.append("\nWaiting for Explicit Start: ");
            sb.append(this.waitingForExplicitStartFuture.get());
        }
        if ((location = this._resolvedLocation.get()) != null) {
            sb.append("\nResolved Location: ");
            sb.append(location.toString());
        }
    }

    @Override
    public void handleMonitorUpdate(boolean shouldRemove) {
        if (FrameworkState.isStopping()) {
            return;
        }
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "handleMonitorUpdate: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if (shouldRemove) {
            Object val = this._appConfig.get().getConfigProperty(".installedByDropins");
            if (val == null || !((Boolean)val).booleanValue()) {
                AppMessageHelper.get(this._handler.get()).error("INVALID_DELETE_OF_APPLICATION", this._appConfig.get().getName(), this._appConfig.get().getLocation());
            } else {
                return;
            }
        }
        if (this.getInternalState() != InternalState.REMOVED) {
            this.queueStateChange(StateChangeAction.CONFIGURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationStateMachineImpl(BundleContext ctx, WsLocationAdmin locAdmin, FutureMonitor futureMonitor, ArtifactContainerFactory artifactFactory, AdaptableModuleFactory moduleFactory, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, ApplicationStateMachine.ASMHelper asmHelper, ApplicationMonitor appMonitor) {
        this._asmSeqNo = asmSequenceNumber.getAndIncrement();
        this._ctx = ctx;
        this._locAdmin = locAdmin;
        this._futureMonitor = futureMonitor;
        this._artifactFactory = artifactFactory;
        this._moduleFactory = moduleFactory;
        this._executorService = executorService;
        this._scheduledExecutorService = scheduledExecutorService;
        this._asmHelper = asmHelper;
        this._appMonitor = appMonitor;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)("ASM[" + this._asmSeqNo + "]: created"), (Object[])new Object[0]);
        }
        this.waitingForAppHandlerFuture.set(this.createDependency("resolves when the app handler for this app arrives"));
        Object object = this._stateLock;
        synchronized (object) {
            this._internalState.set(InternalState.INITIAL);
        }
        this.setInterruptible();
    }

    @Trivial
    private String getAppName() {
        ApplicationConfig appConfig = this._appConfig.get();
        return appConfig != null ? appConfig.getName() : null;
    }

    @Trivial
    private String asmLabel() {
        ApplicationConfig appConfig = this._appConfig.get();
        return "ASM[" + this._asmSeqNo + "]: " + (appConfig != null ? appConfig.getName() + ": " : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private InternalState getInternalState() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._internalState.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchInternalState(InternalState oldState, InternalState newState) {
        Object object = this._stateLock;
        synchronized (object) {
            return this._internalState.compareAndSet(oldState, newState);
        }
    }

    @FFDCIgnore(value={MalformedURLException.class})
    private boolean isLocationAURL(String location) {
        try {
            new URL(location);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    boolean isInterruptible() {
        Object object = this._interruptibleLock;
        synchronized (object) {
            return this._interruptible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertInterruptible() {
        Object object = this._interruptibleLock;
        synchronized (object) {
            if (!this._interruptible) {
                this.interruptibleFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNonInterruptible() {
        Object object = this._interruptibleLock;
        synchronized (object) {
            if (this._interruptible) {
                this.interruptibleFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterruptible() {
        this.executeQueuedActions();
        Object object = this._interruptibleLock;
        synchronized (object) {
            if (this._interruptible) {
                this.interruptibleFailure();
            }
            this._interruptible = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNonInterruptible() {
        Object object = this._interruptibleLock;
        synchronized (object) {
            if (!this._interruptible) {
                this.interruptibleFailure();
            }
            this._interruptible = false;
        }
    }

    void interruptibleFailure() {
        throw new IllegalStateException("interruptibleFailure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushQueuedActions() {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "flushQueuedActions: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        Object object = this._interruptibleLock;
        synchronized (object) {
            this._queuedActions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeQueuedActions() {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "executeQueuedActions: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        Object object = this._interruptibleLock;
        synchronized (object) {
            if (this._performingQueuedActions) {
                return false;
            }
            this._performingQueuedActions = true;
        }
        boolean performedAction = false;
        while (true) {
            QueuedStateChangeAction queuedAction;
            this.assertNonInterruptible();
            Object object2 = this._interruptibleLock;
            synchronized (object2) {
                if (this._queuedActions.isEmpty()) {
                    if (!this._performingQueuedActions) {
                        this.interruptibleFailure();
                    }
                    this._performingQueuedActions = false;
                    return performedAction;
                }
                queuedAction = this._queuedActions.poll();
            }
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "executeQueuedActions: executing " + queuedAction), (Object[])new Object[0]);
            }
            this.performAction(queuedAction.action);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "executeQueuedActions: executed " + queuedAction), (Object[])new Object[0]);
            }
            performedAction = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "run: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
            }
            Object object = this._interruptibleLock;
            synchronized (object) {
                if (this._performingQueuedActions) {
                    return;
                }
                this._performingQueuedActions = true;
            }
            while (true) {
                InternalState callbackReceivedState = null;
                QueuedStateChangeAction queuedAction = null;
                Object object2 = this._interruptibleLock;
                synchronized (object2) {
                    if (!this.isInterruptible() && this._callbackState.get() == CallbackState.WAITING) {
                        this._performingQueuedActions = false;
                        return;
                    }
                    if (this._callbackState.compareAndSet(CallbackState.RECEIVED, null)) {
                        callbackReceivedState = this.getInternalState();
                    } else {
                        if (this._queuedActions.isEmpty()) {
                            if (!this._performingQueuedActions) {
                                this.interruptibleFailure();
                            }
                            this._performingQueuedActions = false;
                            return;
                        }
                        this.setNonInterruptible();
                        queuedAction = this._queuedActions.poll();
                    }
                }
                if (callbackReceivedState != null) {
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "run: calling enterState " + (Object)((Object)callbackReceivedState)), (Object[])new Object[0]);
                    }
                    this.enterState(callbackReceivedState);
                    if (!_tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "run: called enterState " + (Object)((Object)callbackReceivedState)), (Object[])new Object[0]);
                    continue;
                }
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "run: executing " + queuedAction), (Object[])new Object[0]);
                }
                this.performAction(queuedAction.action);
                if (!_tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "run: executed " + queuedAction), (Object[])new Object[0]);
            }
        }
        catch (Throwable callbackReceivedState) {
            void t;
            FFDCFilter.processException((Throwable)callbackReceivedState, (String)"com.ibm.ws.app.manager.internal.statemachine.ApplicationStateMachineImpl", (String)"890", (Object)this, (Object[])new Object[0]);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "run: caught throwable " + t), (Object[])new Object[0]);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueStateChange(StateChangeAction action) {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "queueStateChange: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        Object object = this._interruptibleLock;
        synchronized (object) {
            this._queuedActions.add(new QueuedStateChangeAction(action, this._qscaCounter.getAndIncrement()));
        }
        this._executorService.execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attemptStateChange(StateChangeAction action) {
        boolean callQueueAction;
        boolean callPerformAction;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "attemptStateChange: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        Object object = this._interruptibleLock;
        synchronized (object) {
            if (!this._performingQueuedActions && this._queuedActions.isEmpty()) {
                if (this.isInterruptible()) {
                    this.setNonInterruptible();
                    callPerformAction = true;
                    callQueueAction = false;
                } else {
                    callPerformAction = false;
                    InternalState internalState = this.getInternalState();
                    callQueueAction = internalState != InternalState.STOPPING && (internalState != InternalState.STARTING || action != StateChangeAction.START);
                }
            } else {
                callPerformAction = false;
                callQueueAction = true;
            }
        }
        if (callPerformAction) {
            this.performAction(action);
        } else if (callQueueAction) {
            this.queueStateChange(action);
        }
    }

    @Trivial
    ApplicationDependency createDependency(String desc) {
        ApplicationDependency appDep = new ApplicationDependency(this._futureMonitor, desc);
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "createDependency: created " + appDep), (Object[])new Object[0]);
        }
        return appDep;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    void resolveDependency(ApplicationDependency appDep) {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "resolveDependency: " + appDep), (Object[])new Object[0]);
        }
        try {
            appDep.setResult(true);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.internal.statemachine.ApplicationStateMachineImpl", (String)"957", (Object)this, (Object[])new Object[]{appDep});
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "resolveDependency: caught throwable " + t), (Object[])new Object[0]);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    void failedDependency(ApplicationDependency appDep, Throwable failure) {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "failedDependency: " + appDep), (Object[])new Object[0]);
        }
        try {
            appDep.setResult(failure);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.internal.statemachine.ApplicationStateMachineImpl", (String)"976", (Object)this, (Object[])new Object[]{appDep, failure});
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "failedDependency: caught throwable " + t), (Object[])new Object[0]);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException((Throwable)t);
        }
    }

    private void addAppStartingFutures(Collection<ApplicationDependency> appStartingFutures) {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "addAppStartingFutures: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        this.blockAppStartingFutures.addAll(appStartingFutures);
    }

    private void addAppHandlerFuture() {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "addAppHandlerFuture: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        ApplicationDependency appHandlerFuture = this.waitingForAppHandlerFuture.get();
        this.blockAppStartingFutures.add(appHandlerFuture);
    }

    private void completeAppHandlerFuture() {
        ApplicationDependency appHandlerFuture = this.waitingForAppHandlerFuture.get();
        this.resolveDependency(appHandlerFuture);
    }

    private void createExplicitStartFuture() {
        ApplicationDependency explicitStartFuture;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "createExplicitStartFuture: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if (this.waitingForExplicitStartFuture.compareAndSet(null, explicitStartFuture = this.createDependency("resolves when the app " + this.getAppName() + " is explicitly (re)started"))) {
            this.blockAppStartingFutures.add(explicitStartFuture);
        }
    }

    private void completeExplicitStartFuture() {
        ApplicationDependency explicitStartFuture;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "completeExplicitStartFuture: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if ((explicitStartFuture = (ApplicationDependency)this.waitingForExplicitStartFuture.getAndSet(null)) != null) {
            this.resolveDependency(explicitStartFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForFutures() {
        List<ApplicationDependency> futureConditions;
        CompletionListener<Boolean> listener;
        CancelableCompletionListenerWrapper<Boolean> newCL;
        CancelableCompletionListenerWrapper<Boolean> oldCL;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "waitForFutures: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if ((oldCL = this.completionListener.getAndSet(newCL = new CancelableCompletionListenerWrapper<Boolean>(listener = new CompletionListener<Boolean>(futureConditions = Arrays.asList(this.blockAppStartingFutures.toArray(new ApplicationDependency[0]))){
            final /* synthetic */ Collection val$futureConditions;
            static final long serialVersionUID = -2808618507134268517L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                this.val$futureConditions = collection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void successfulCompletion(Future<Boolean> future, Boolean result) {
                CancelableCompletionListenerWrapper cl;
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "waitForFutures: successfulCompletion: future " + future + ", result " + result), (Object[])new Object[0]);
                }
                if ((cl = (CancelableCompletionListenerWrapper)ApplicationStateMachineImpl.this.completionListener.getAndSet(null)) != null) {
                    boolean execute;
                    ApplicationStateMachineImpl.this.blockAppStartingFutures.removeAll(this.val$futureConditions);
                    Object object = ApplicationStateMachineImpl.this._interruptibleLock;
                    synchronized (object) {
                        if (!ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, null) && ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.WAITING, CallbackState.RECEIVED)) {
                            ApplicationStateMachineImpl.this.setNonInterruptible();
                            execute = true;
                        } else {
                            execute = false;
                        }
                    }
                    if (execute) {
                        ApplicationStateMachineImpl.this._executorService.execute(ApplicationStateMachineImpl.this);
                    }
                }
            }

            public void failedCompletion(Future<Boolean> future, Throwable t) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "waitForFutures: failedCompletion: future " + future + ", throwable " + t), (Object[])new Object[0]);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class);
            }
        }))) != null) {
            oldCL.cancel();
        }
        this._callbackState.set(CallbackState.CALLING);
        FutureCollectionCompletionListener.newFutureCollectionCompletionListener(futureConditions, newCL);
        Object object = this._interruptibleLock;
        synchronized (object) {
            if (this._callbackState.compareAndSet(CallbackState.CALLING, CallbackState.WAITING)) {
                this.setInterruptible();
                return true;
            }
            return false;
        }
    }

    private void cancelWaitForFutures() {
        CancelableCompletionListenerWrapper cl;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "cancelWaitForFutures: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if ((cl = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
            this._callbackState.set(null);
            cl.cancel();
        }
    }

    private void performAction(StateChangeAction action) {
        this.assertNonInterruptible();
        InternalState currentState = this.getInternalState();
        switch (currentState) {
            case INITIAL: {
                if (action == StateChangeAction.REMOVE) {
                    this.switchInternalState(InternalState.INITIAL, InternalState.REMOVED);
                    this.enterState(InternalState.REMOVED);
                    break;
                }
                ApplicationConfig nextAppConfig = this._nextAppConfig.getAndSet(null);
                if (nextAppConfig != null) {
                    this._appConfig.set(nextAppConfig);
                }
                this.switchInternalState(InternalState.INITIAL, InternalState.STOPPED);
                this.enterState(InternalState.STOPPED);
                break;
            }
            case STOPPED: {
                this.cancelWaitForFutures();
                this.cleanupActions();
                if (action == StateChangeAction.REMOVE) {
                    this.switchInternalState(InternalState.STOPPED, InternalState.REMOVED);
                    this.enterState(InternalState.REMOVED);
                    break;
                }
                this.enterState(InternalState.STOPPED);
                break;
            }
            case STARTING: {
                break;
            }
            case STARTED: {
                if (action == StateChangeAction.START) {
                    this.enterState(InternalState.STARTED);
                    break;
                }
                this.switchInternalState(InternalState.STARTED, InternalState.STOPPING);
                this.enterState(InternalState.STOPPING);
                break;
            }
            case STOPPING: {
                break;
            }
            case FAILED: {
                InternalState nextState = action == StateChangeAction.REMOVE ? InternalState.REMOVED : InternalState.STOPPED;
                this.switchInternalState(InternalState.FAILED, nextState);
                this.enterState(nextState);
                break;
            }
            case REMOVED: {
                break;
            }
            default: {
                throw new IllegalStateException("currentState");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupActions() {
        Object object = this._stateLock;
        synchronized (object) {
            Action a;
            ResolveFileAction rfa = this._rfa.getAndSet(null);
            if (rfa != null) {
                rfa.cancel();
            }
            if ((a = (Action)this._currentAction.getAndSet(null)) != null) {
                a.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void enterState(InternalState state) {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)(this.asmLabel() + "enterState: interruptible=" + this.isInterruptible()), (Object[])new Object[0]);
        }
        if (!this.enterStateCalled.compareAndSet(false, true)) {
            throw new RuntimeException("enterState reentry");
        }
        try {
            block33: while (true) {
                this.assertNonInterruptible();
                switch (state) {
                    case INITIAL: {
                        throw new IllegalStateException("enterState");
                    }
                    case STOPPED: {
                        Action resolveFileAction;
                        Object configPid;
                        ResolveFileCallback resolveFileCallback;
                        ApplicationDependency stoppedFuture;
                        this._asmHelper.switchApplicationState(this._appConfig.get(), ApplicationState.STOPPED);
                        this.flushQueuedActions();
                        while ((stoppedFuture = this._notifyAppStopped.poll()) != null) {
                            this.resolveDependency(stoppedFuture);
                        }
                        state = this.getInternalState();
                        if (state != InternalState.STOPPED) continue block33;
                        if (this.waitForFutures()) {
                            return;
                        }
                        ApplicationConfig nextAppConfig = this._nextAppConfig.getAndSet(null);
                        if (nextAppConfig != null) {
                            this._appConfig.set(nextAppConfig);
                        }
                        if (!this._appConfig.get().isValid()) {
                            try {
                                throw new IllegalArgumentException("ApplicationConfig");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                void e;
                                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.app.manager.internal.statemachine.ApplicationStateMachineImpl", (String)"1202", (Object)this, (Object[])new Object[]{state});
                                this._failedThrowable = e;
                                this.switchInternalState(InternalState.STOPPED, InternalState.FAILED);
                                state = InternalState.FAILED;
                                break;
                            }
                        }
                        if (this._handler.get() == null) {
                            ApplicationDependency startingFuture;
                            CancelableCompletionListenerWrapper cl;
                            if (!this._asmHelper.appTypeSupported()) {
                                Tr.error((TraceComponent)_tc, (String)"NO_APPLICATION_HANDLER", (Object[])new Object[]{this._appConfig.get().getLocation()});
                            }
                            if ((cl = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
                                cl.cancel();
                            }
                            this.addAppHandlerFuture();
                            while ((startingFuture = this._notifyAppStarting.poll()) != null) {
                                this.failedDependency(startingFuture, null);
                            }
                            continue block33;
                        }
                        Object object = this._stateLock;
                        synchronized (object) {
                            resolveFileCallback = new ResolveFileCallback();
                            ApplicationConfig appConfig = this._appConfig.get();
                            configPid = appConfig.getConfigPid();
                            String location = appConfig.getLocation();
                            if (this.isLocationAURL(location)) {
                                resolveFileAction = new DownloadFileAction(this._locAdmin, (String)configPid, location, resolveFileCallback, this._handler);
                            } else {
                                ApplicationMonitorConfig appMonitorConfig = this._appMonitor.getConfig();
                                resolveFileAction = new ResolveFileAction(this._ctx, appMonitorConfig.getPollingRate(), appMonitorConfig.getUpdateTrigger(), this._locAdmin, appConfig.getName(), (String)configPid, location, resolveFileCallback, this._handler);
                                this._rfa.set((ResolveFileAction)resolveFileAction);
                            }
                            this._currentAction.set(resolveFileAction);
                        }
                        resolveFileAction.execute(this._executorService);
                        state = resolveFileCallback.resolvedState();
                        if (state != null) {
                            this.switchInternalState(InternalState.STOPPED, state);
                            break;
                        }
                        return;
                    }
                    case STARTING: {
                        ApplicationDependency startingFuture;
                        StartAction startAction;
                        StartActionCallback startCallback;
                        this.cleanupActions();
                        Object configPid = this._stateLock;
                        synchronized (configPid) {
                            ApplicationInstallInfo aii = new ApplicationInstallInfo(this._appConfig.get(), this._appContainer.getAndSet(null), this._resolvedLocation.getAndSet(null), this._handler.get(), this);
                            this._appInstallInfo.set(aii);
                            startCallback = new StartActionCallback();
                            startAction = new StartAction(this._appConfig.get(), this._update.getAndSet(true), this._appMonitor, aii, startCallback, this._futureMonitor);
                            this._currentAction.set(startAction);
                        }
                        this._asmHelper.switchApplicationState(this._appConfig.get(), ApplicationState.STARTING);
                        while ((startingFuture = this._notifyAppStarting.poll()) != null) {
                            this.resolveDependency(startingFuture);
                        }
                        startAction.execute(this._scheduledExecutorService);
                        state = startCallback.resolvedState();
                        if (state != null) {
                            this.switchInternalState(InternalState.STARTING, state);
                            break;
                        }
                        return;
                    }
                    case STARTED: {
                        this._asmHelper.switchApplicationState(this._appConfig.get(), ApplicationState.STARTED);
                        ApplicationDependency startedFuture = null;
                        while ((startedFuture = this._notifyAppStarted.poll()) != null) {
                            this.resolveDependency(startedFuture);
                        }
                        this._asmHelper.notifyAppStarted(this._appConfig.get().getConfigPid());
                        this.setInterruptible();
                        return;
                    }
                    case STOPPING: {
                        StopAction stopAction;
                        StopActionCallback stopCallback;
                        Object object = this._stateLock;
                        synchronized (object) {
                            stopCallback = new StopActionCallback();
                            stopAction = new StopAction(this._appInstallInfo.getAndSet(null), this._appMonitor, this._futureMonitor, stopCallback);
                            this._currentAction.set(stopAction);
                        }
                        this._asmHelper.switchApplicationState(this._appConfig.get(), ApplicationState.STOPPING);
                        stopAction.execute(this._executorService);
                        state = stopCallback.resolvedState();
                        if (state != null) {
                            this.switchInternalState(InternalState.STOPPING, state);
                            break;
                        }
                        return;
                    }
                    case FAILED: {
                        Object object = this._stateLock;
                        synchronized (object) {
                            this._appInstallInfo.set(null);
                        }
                        this.cleanupActions();
                        this._asmHelper.switchApplicationState(this._appConfig.get(), ApplicationState.INSTALLED);
                        ApplicationDependency failedFuture = null;
                        while ((failedFuture = this._notifyAppStarting.poll()) != null) {
                            this.failedDependency(failedFuture, this._failedThrowable);
                        }
                        while ((failedFuture = this._notifyAppStarted.poll()) != null) {
                            this.failedDependency(failedFuture, this._failedThrowable);
                        }
                        while ((failedFuture = this._notifyAppStopped.poll()) != null) {
                            this.failedDependency(failedFuture, this._failedThrowable);
                        }
                        this._asmHelper.notifyAppFailed(this._appConfig.get().getConfigPid());
                        this.setInterruptible();
                        return;
                    }
                    case REMOVED: {
                        ApplicationDependency failedFuture;
                        ApplicationDependency startedFuture;
                        this._asmHelper.switchApplicationState(this._appConfig.get(), ApplicationState.INSTALLED);
                        ApplicationDependency removedFuture = null;
                        while ((removedFuture = this._notifyAppRemoved.poll()) != null) {
                            this.resolveDependency(removedFuture);
                        }
                        while ((failedFuture = this._notifyAppStarting.poll()) != null) {
                            this.failedDependency(failedFuture, null);
                        }
                        while ((startedFuture = this._notifyAppStarted.poll()) != null) {
                            this.resolveDependency(startedFuture);
                        }
                        this.flushQueuedActions();
                        this.setInterruptible();
                        return;
                    }
                }
            }
        }
        finally {
            if (!this.enterStateCalled.compareAndSet(true, false)) {
                throw new RuntimeException("enterState finally");
            }
        }
    }

    @Override
    public boolean isBlocked() {
        ArrayList<ApplicationDependency> blockingConditions = new ArrayList<ApplicationDependency>(this.blockAppStartingFutures);
        for (ApplicationDependency blockingCondition : blockingConditions) {
            if (blockingCondition.isDone()) continue;
            return true;
        }
        return false;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private final class ResolveFileCallback
    implements ResourceCallback {
        private final AtomicReference<InternalState> immediateCallbackResult = new AtomicReference();
        static final long serialVersionUID = 8842738090148983287L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ResolveFileCallback() {
            ApplicationStateMachineImpl.this._callbackState.set(CallbackState.CALLING);
        }

        InternalState resolvedState() {
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, CallbackState.WAITING)) {
                ApplicationStateMachineImpl.this.setInterruptible();
                return null;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return null;
            }
            return this.immediateCallbackResult.getAndSet(null);
        }

        @Override
        public void pending() {
            ApplicationDependency appDep;
            while ((appDep = (ApplicationDependency)ApplicationStateMachineImpl.this._notifyAppStarting.poll()) != null) {
                ApplicationStateMachineImpl.this.failedDependency(appDep, null);
            }
            ApplicationStateCoordinator.updateStartingAppStatus(((ApplicationConfig)ApplicationStateMachineImpl.this._appConfig.get()).getConfigPid(), ApplicationStateCoordinator.AppStatus.FAILED);
        }

        @Override
        public void successfulCompletion(Container container, WsResource resource) {
            ApplicationStateMachineImpl.this._appContainer.set(container);
            ApplicationStateMachineImpl.this._resolvedLocation.set(resource);
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, null)) {
                this.immediateCallbackResult.set(InternalState.STARTING);
                return;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return;
            }
            if (ApplicationStateMachineImpl.this._internalState.compareAndSet(InternalState.STOPPED, InternalState.STARTING) && ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.WAITING, CallbackState.RECEIVED)) {
                ApplicationStateMachineImpl.this.setNonInterruptible();
                ApplicationStateMachineImpl.this._executorService.execute(ApplicationStateMachineImpl.this);
            }
        }

        @Override
        public void failedCompletion(Throwable t) {
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, null)) {
                ApplicationStateMachineImpl.this._failedThrowable = t;
                this.immediateCallbackResult.set(InternalState.FAILED);
                return;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return;
            }
            if (ApplicationStateMachineImpl.this._internalState.compareAndSet(InternalState.STOPPED, InternalState.FAILED)) {
                ApplicationStateMachineImpl.this._failedThrowable = t;
                if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.WAITING, CallbackState.RECEIVED)) {
                    ApplicationStateMachineImpl.this._executorService.execute(ApplicationStateMachineImpl.this);
                }
            }
        }

        @Override
        public Container setupContainer(String pid, File locationFile) {
            File cacheDir = new File(this.getCacheDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDir)) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "Could not create directory at {0}."), (Object[])new Object[]{cacheDir.getAbsolutePath()});
                }
                return null;
            }
            ArtifactContainer artifactContainer = ApplicationStateMachineImpl.this._artifactFactory.getContainer(cacheDir, (Object)locationFile);
            if (artifactContainer == null) {
                return null;
            }
            File cacheDirAdapt = new File(this.getCacheAdaptDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "Could not create directory at {0}."), (Object[])new Object[]{cacheDirAdapt.getAbsolutePath()});
                }
                return null;
            }
            File cacheDirOverlay = new File(this.getCacheOverlayDir(), pid);
            if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "Could not create directory at {0}."), (Object[])new Object[]{cacheDirOverlay.getAbsolutePath()});
                }
                return null;
            }
            return ApplicationStateMachineImpl.this._moduleFactory.getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
        }

        private File getCacheDir() {
            return ApplicationStateMachineImpl.this._locAdmin.getBundleFile((Object)this, "cache");
        }

        private File getCacheAdaptDir() {
            return ApplicationStateMachineImpl.this._locAdmin.getBundleFile((Object)this, "cacheAdapt");
        }

        private File getCacheOverlayDir() {
            return ApplicationStateMachineImpl.this._locAdmin.getBundleFile((Object)this, "cacheOverlay");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ResolveFileCallback.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private final class StopActionCallback
    implements StateChangeCallback {
        private final AtomicReference<InternalState> immediateCallbackResult = new AtomicReference();
        static final long serialVersionUID = -955912347227798359L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        StopActionCallback() {
            ApplicationStateMachineImpl.this._callbackState.set(CallbackState.CALLING);
        }

        InternalState resolvedState() {
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, CallbackState.WAITING)) {
                return null;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return null;
            }
            return this.immediateCallbackResult.getAndSet(null);
        }

        @Override
        public void changed() {
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, null)) {
                this.immediateCallbackResult.set(InternalState.STOPPED);
                return;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return;
            }
            if (ApplicationStateMachineImpl.this.switchInternalState(InternalState.STOPPING, InternalState.STOPPED) && ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.WAITING, CallbackState.RECEIVED)) {
                ApplicationStateMachineImpl.this._executorService.execute(ApplicationStateMachineImpl.this);
            }
        }

        @Override
        public void failed(Throwable t) {
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, null)) {
                ApplicationStateMachineImpl.this._failedThrowable = t;
                this.immediateCallbackResult.set(InternalState.FAILED);
                return;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return;
            }
            if (ApplicationStateMachineImpl.this.switchInternalState(InternalState.STOPPING, InternalState.FAILED)) {
                ApplicationStateMachineImpl.this._failedThrowable = t;
                if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.WAITING, CallbackState.RECEIVED)) {
                    ApplicationStateMachineImpl.this._executorService.execute(ApplicationStateMachineImpl.this);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StopActionCallback.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private final class StartActionCallback
    implements StateChangeCallback {
        private final AtomicReference<InternalState> immediateCallbackResult = new AtomicReference();
        static final long serialVersionUID = 6735534421474643855L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        StartActionCallback() {
            ApplicationStateMachineImpl.this._callbackState.set(CallbackState.CALLING);
        }

        InternalState resolvedState() {
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, CallbackState.WAITING)) {
                ApplicationDependency installCalledFuture;
                while ((installCalledFuture = (ApplicationDependency)ApplicationStateMachineImpl.this._notifyAppInstallCalled.poll()) != null) {
                    ApplicationStateMachineImpl.this.resolveDependency(installCalledFuture);
                }
                return null;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return null;
            }
            return this.immediateCallbackResult.getAndSet(null);
        }

        @Override
        public void changed() {
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, null)) {
                ApplicationDependency installCalledFuture;
                while ((installCalledFuture = (ApplicationDependency)ApplicationStateMachineImpl.this._notifyAppInstallCalled.poll()) != null) {
                    ApplicationStateMachineImpl.this.resolveDependency(installCalledFuture);
                }
                this.immediateCallbackResult.set(InternalState.STARTED);
                return;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return;
            }
            if (ApplicationStateMachineImpl.this.switchInternalState(InternalState.STARTING, InternalState.STARTED) && ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.WAITING, CallbackState.RECEIVED)) {
                ApplicationStateMachineImpl.this._executorService.execute(ApplicationStateMachineImpl.this);
            }
        }

        @Override
        public void failed(Throwable t) {
            if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.CALLING, null)) {
                ApplicationDependency installCalledFuture;
                while ((installCalledFuture = (ApplicationDependency)ApplicationStateMachineImpl.this._notifyAppInstallCalled.poll()) != null) {
                    ApplicationStateMachineImpl.this.resolveDependency(installCalledFuture);
                }
                ApplicationStateMachineImpl.this._failedThrowable = t;
                this.immediateCallbackResult.set(InternalState.FAILED);
                return;
            }
            if (ApplicationStateMachineImpl.this._currentAction.getAndSet(null) == null) {
                return;
            }
            if (ApplicationStateMachineImpl.this.switchInternalState(InternalState.STARTING, InternalState.FAILED)) {
                ApplicationStateMachineImpl.this._failedThrowable = t;
                if (ApplicationStateMachineImpl.this._callbackState.compareAndSet(CallbackState.WAITING, CallbackState.RECEIVED)) {
                    ApplicationStateMachineImpl.this._executorService.execute(ApplicationStateMachineImpl.this);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StartActionCallback.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class CancelableCompletionListenerWrapper<T>
    implements CompletionListener<T> {
        private volatile CompletionListener<T> listener;
        static final long serialVersionUID = -1509886557273253647L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CancelableCompletionListenerWrapper(CompletionListener<T> listener) {
            this.listener = listener;
        }

        public void cancel() {
            this.listener = null;
        }

        public void successfulCompletion(Future<T> future, T result) {
            CompletionListener<T> l;
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "CCLW" + (this.listener == null ? "[cancelled]" : "") + ": successfulCompletion: completed future " + future + ", result " + result), (Object[])new Object[0]);
            }
            if ((l = this.listener) != null) {
                l.successfulCompletion(future, result);
            }
        }

        public void failedCompletion(Future<T> future, Throwable t) {
            CompletionListener<T> l;
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "CCLW" + (this.listener == null ? "[cancelled]" : "") + ": failedCompletion: future " + future + ", throwable " + t), (Object[])new Object[0]);
            }
            if ((l = this.listener) != null) {
                l.failedCompletion(future, t);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CancelableCompletionListenerWrapper.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class QueuedStateChangeAction {
        private final StateChangeAction action;
        private final int actionNum;
        static final long serialVersionUID = 6753917487636125741L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        QueuedStateChangeAction(StateChangeAction action, int actionNum) {
            this.action = action;
            this.actionNum = actionNum;
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)(ApplicationStateMachineImpl.this.asmLabel() + "created " + this), (Object[])new Object[0]);
            }
        }

        public String toString() {
            return "SCA[" + this.actionNum + "] action=" + (Object)((Object)this.action);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(QueuedStateChangeAction.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class CallbackState
    extends Enum<CallbackState> {
        public static final /* enum */ CallbackState CALLING;
        public static final /* enum */ CallbackState WAITING;
        public static final /* enum */ CallbackState RECEIVED;
        private static final /* synthetic */ CallbackState[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static CallbackState[] values() {
            return (CallbackState[])$VALUES.clone();
        }

        public static CallbackState valueOf(String name) {
            return Enum.valueOf(CallbackState.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CallbackState.class);
            CALLING = new CallbackState();
            WAITING = new CallbackState();
            RECEIVED = new CallbackState();
            $VALUES = new CallbackState[]{CALLING, WAITING, RECEIVED};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class StateChangeAction
    extends Enum<StateChangeAction> {
        public static final /* enum */ StateChangeAction CONFIGURE;
        public static final /* enum */ StateChangeAction START;
        public static final /* enum */ StateChangeAction STOP;
        public static final /* enum */ StateChangeAction RESTART;
        public static final /* enum */ StateChangeAction REMOVE;
        private static final /* synthetic */ StateChangeAction[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static StateChangeAction[] values() {
            return (StateChangeAction[])$VALUES.clone();
        }

        public static StateChangeAction valueOf(String name) {
            return Enum.valueOf(StateChangeAction.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StateChangeAction.class);
            CONFIGURE = new StateChangeAction();
            START = new StateChangeAction();
            STOP = new StateChangeAction();
            RESTART = new StateChangeAction();
            REMOVE = new StateChangeAction();
            $VALUES = new StateChangeAction[]{CONFIGURE, START, STOP, RESTART, REMOVE};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class InternalState
    extends Enum<InternalState> {
        public static final /* enum */ InternalState INITIAL;
        public static final /* enum */ InternalState STOPPED;
        public static final /* enum */ InternalState STARTING;
        public static final /* enum */ InternalState STARTED;
        public static final /* enum */ InternalState STOPPING;
        public static final /* enum */ InternalState FAILED;
        public static final /* enum */ InternalState REMOVED;
        private static final /* synthetic */ InternalState[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static InternalState[] values() {
            return (InternalState[])$VALUES.clone();
        }

        public static InternalState valueOf(String name) {
            return Enum.valueOf(InternalState.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(InternalState.class);
            INITIAL = new InternalState();
            STOPPED = new InternalState();
            STARTING = new InternalState();
            STARTED = new InternalState();
            STOPPING = new InternalState();
            FAILED = new InternalState();
            REMOVED = new InternalState();
            $VALUES = new InternalState[]{INITIAL, STOPPED, STARTING, STARTED, STOPPING, FAILED, REMOVED};
        }
    }
}

