/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.X509CertificateMapper;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.BaseRepository;
import com.ibm.ws.security.wim.ConfiguredRepository;
import com.ibm.ws.security.wim.adapter.ldap.Filter;
import com.ibm.ws.security.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.security.wim.adapter.ldap.LdapConfigManager;
import com.ibm.ws.security.wim.adapter.ldap.LdapConnection;
import com.ibm.ws.security.wim.adapter.ldap.LdapConstants;
import com.ibm.ws.security.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.security.wim.adapter.ldap.LdapEntry;
import com.ibm.ws.security.wim.adapter.ldap.LdapHelper;
import com.ibm.ws.security.wim.adapter.ldap.LdapSearchControl;
import com.ibm.ws.security.wim.adapter.ldap.LdapURL;
import com.ibm.ws.security.wim.adapter.ldap.change.ChangeHandlerFactory;
import com.ibm.ws.security.wim.adapter.ldap.change.IChangeHandler;
import com.ibm.ws.security.wim.adapter.ldap.context.TimedDirContext;
import com.ibm.ws.security.wim.util.ControlsHelper;
import com.ibm.ws.security.wim.util.NodeHelper;
import com.ibm.ws.security.wim.util.UniqueIdGenerator;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.ws.security.wim.xpath.TokenMgrError;
import com.ibm.ws.security.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.security.wim.xpath.ldap.util.LdapXPathTranslateHelper;
import com.ibm.ws.security.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.security.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.ws.ssl.optional.SSLSupportOptional;
import com.ibm.wsspi.security.wim.exception.ChangeControlException;
import com.ibm.wsspi.security.wim.exception.EntityHasDescendantsException;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.EntityTypeNotSupportedException;
import com.ibm.wsspi.security.wim.exception.InvalidEntityTypeException;
import com.ibm.wsspi.security.wim.exception.InvalidPropertyValueException;
import com.ibm.wsspi.security.wim.exception.MissingMandatoryPropertyException;
import com.ibm.wsspi.security.wim.exception.PasswordCheckFailedException;
import com.ibm.wsspi.security.wim.exception.SearchControlException;
import com.ibm.wsspi.security.wim.exception.UpdatePropertyException;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import com.ibm.wsspi.security.wim.model.AncestorControl;
import com.ibm.wsspi.security.wim.model.CacheControl;
import com.ibm.wsspi.security.wim.model.ChangeControl;
import com.ibm.wsspi.security.wim.model.ChangeResponseControl;
import com.ibm.wsspi.security.wim.model.CheckGroupMembershipControl;
import com.ibm.wsspi.security.wim.model.CheckPointType;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.DeleteControl;
import com.ibm.wsspi.security.wim.model.DescendantControl;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.GroupMemberControl;
import com.ibm.wsspi.security.wim.model.GroupMembershipControl;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.LangType;
import com.ibm.wsspi.security.wim.model.LoginAccount;
import com.ibm.wsspi.security.wim.model.LoginControl;
import com.ibm.wsspi.security.wim.model.Person;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.Subject;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.security.registry.ldap.config"}, property={"service.vendor=IBM"})
public class LdapAdapter
extends BaseRepository
implements ConfiguredRepository {
    private static final TraceComponent tc = Tr.register(LdapAdapter.class);
    private String reposId = null;
    private String reposRealm = null;
    private static final String KEY_ID = "config.id";
    private static final String REALM = "realm";
    protected LdapConnection iLdapConn = null;
    private LdapConfigManager iLdapConfigMgr = null;
    protected IChangeHandler changeHandler = null;
    private boolean isActiveDirectory = false;
    private final AtomicReference<X509CertificateMapper> iCertificateMapperRef = new AtomicReference();
    static final long serialVersionUID = 6323673891706250643L;

    @Activate
    protected void activated(Map<String, Object> properties, ComponentContext cc) throws WIMException {
        super.activate(properties, cc);
        this.initialize(properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) throws WIMException {
        super.modify(properties);
        this.initialize(properties);
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
        super.deactivate(reason, cc);
    }

    public void initialize(Map<String, Object> configProps) throws WIMException {
        this.reposId = (String)configProps.get(KEY_ID);
        this.reposRealm = (String)configProps.get(REALM);
        if (String.valueOf(configProps.get("supportChangeLog")).equalsIgnoreCase("native")) {
            this.changeHandler = ChangeHandlerFactory.getChangeHandler(this.iLdapConn);
        }
        this.iLdapConfigMgr = new LdapConfigManager();
        this.iLdapConfigMgr.initialize(configProps);
        this.iLdapConn = new LdapConnection(this.iLdapConfigMgr);
        this.iLdapConn.initialize(configProps);
        this.isActiveDirectory = this.iLdapConfigMgr.isActiveDirectory();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSSLSupport(SSLSupportOptional sslSupport) {
    }

    public Root get(Root root) throws WIMException {
        String METHODNAME = "get";
        Root outRoot = new Root();
        Map ctrlMap = ControlsHelper.getControlMap((Root)root);
        PropertyControl propertyCtrl = (PropertyControl)ctrlMap.get("PropertyControl");
        GroupMembershipControl grpMbrshipCtrl = (GroupMembershipControl)ctrlMap.get("GroupMembershipControl");
        GroupMemberControl grpMbrCtrl = (GroupMemberControl)ctrlMap.get("GroupMemberControl");
        AncestorControl ancesCtrl = (AncestorControl)ctrlMap.get("AncestorControl");
        DescendantControl descCtrl = (DescendantControl)ctrlMap.get("DescendantControl");
        CheckGroupMembershipControl chkGrpMbrshipCtrl = (CheckGroupMembershipControl)ctrlMap.get("CheckGroupMembershipControl");
        CacheControl cacheCtrl = (CacheControl)ctrlMap.get("CacheControl");
        boolean clearCacheForMembership = false;
        if (cacheCtrl != null) {
            String cacheMode = cacheCtrl.getMode();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("get Cache Control is passed with mode " + cacheMode), (Object[])new Object[0]);
            }
            if (cacheMode != null && "clearAll".equalsIgnoreCase(cacheMode)) {
                this.iLdapConn.invalidateAttributeCache();
                this.iLdapConn.invalidateSearchCache();
                String uniqueName = this.getCallerUniqueName();
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"CLEAR_ALL_CLEAR_CACHE_MODE", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)cacheMode, (Object)uniqueName));
                }
            } else if (cacheMode != null && "clearEntity".equalsIgnoreCase(cacheMode)) {
                List entities = root.getEntities();
                for (Entity inEntity : entities) {
                    IdentifierType id = inEntity.getIdentifier();
                    String externalName = id.getExternalName();
                    String extId = id.getExternalId();
                    String uniqueName = id.getUniqueName();
                    this.iLdapConn.invalidateAttributes(externalName, extId, uniqueName);
                }
                clearCacheForMembership = true;
            } else if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"UNKNOWN_CLEAR_CACHE_MODE", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)cacheMode));
            }
        }
        List propNames = null;
        if (propertyCtrl != null) {
            propNames = propertyCtrl.getProperties();
        }
        boolean needMbrAttr = false;
        if (!(grpMbrCtrl == null || this.iLdapConfigMgr.getMembershipAttribute() != null && this.iLdapConfigMgr.isDefaultMbrAttr())) {
            needMbrAttr = true;
        }
        for (Entity inEntity : root.getEntities()) {
            String inEntityType = inEntity.getTypeName();
            List<String> properties = this.iLdapConfigMgr.getSupportedProperties(inEntityType, (List<String>)propNames);
            ArrayList<String> EntityType = new ArrayList<String>(1);
            EntityType.add(inEntityType);
            IdentifierType inId = inEntity.getIdentifier();
            LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(inId, EntityType, properties, grpMbrshipCtrl != null || chkGrpMbrshipCtrl != null, needMbrAttr);
            if (ldapEntry != null && propNames != null) {
                NamingEnumeration<? extends Attribute> attEnum;
                Attributes attrs;
                ArrayList<String> entityTypes;
                String[] attrIds;
                String attrName;
                String type;
                if (propNames.contains("displayBridgePrincipalName")) {
                    type = ldapEntry.getType();
                    LdapEntity entity = this.iLdapConfigMgr.getLdapEntity(type);
                    attrName = entity.getAttribute("principalName");
                    attrIds = new String[]{attrName};
                    entityTypes = new ArrayList<String>(1);
                    entityTypes.add(type);
                    attrs = this.iLdapConn.getAttributesByUniqueName(ldapEntry.getUniqueName(), attrIds, entityTypes);
                    if (attrs != null) {
                        attEnum = attrs.getAll();
                        while (attEnum.hasMoreElements()) {
                            try {
                                ldapEntry.getAttributes().put(attEnum.next());
                            }
                            catch (NamingException namingException) {
                                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"360", (Object)((Object)this), (Object[])new Object[]{root});
                            }
                        }
                    }
                    if (properties != null) {
                        properties.add("principalName");
                    } else {
                        properties = new ArrayList<String>();
                        properties.add("principalName");
                    }
                } else if (propNames.contains("displayBridgeCN")) {
                    type = ldapEntry.getType();
                    LdapEntity entity = this.iLdapConfigMgr.getLdapEntity(type);
                    attrName = entity.getAttribute("cn");
                    attrIds = new String[]{attrName};
                    entityTypes = new ArrayList(1);
                    entityTypes.add(type);
                    attrs = this.iLdapConn.getAttributesByUniqueName(ldapEntry.getUniqueName(), attrIds, entityTypes);
                    if (attrs != null) {
                        attEnum = attrs.getAll();
                        while (attEnum.hasMoreElements()) {
                            try {
                                ldapEntry.getAttributes().put(attEnum.next());
                            }
                            catch (NamingException namingException) {
                                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"385", (Object)((Object)this), (Object[])new Object[]{root});
                            }
                        }
                    }
                    if (properties != null) {
                        properties.add("cn");
                    } else {
                        properties = new ArrayList<String>();
                        properties.add("cn");
                    }
                }
            }
            Entity outEntity = this.createEntityFromLdapEntry(outRoot, "entities", ldapEntry, properties);
            if (clearCacheForMembership) {
                if (this.iLdapConfigMgr.isGroup(ldapEntry.getType())) {
                    if (grpMbrCtrl != null) {
                        this.iLdapConn.invalidateSearchCache();
                    }
                    if (grpMbrshipCtrl != null || chkGrpMbrshipCtrl != null) {
                        this.iLdapConn.invalidateSearchCache();
                    }
                } else if ((this.iLdapConfigMgr.isPerson(ldapEntry.getType()) || this.iLdapConfigMgr.isPersonAccount(ldapEntry.getType())) && (grpMbrshipCtrl != null || chkGrpMbrshipCtrl != null)) {
                    if (this.iLdapConfigMgr.getMembershipAttribute() != null) {
                        String mbrshipAttrName = this.iLdapConfigMgr.getMembershipAttribute();
                        Attribute mbrshipAttr = ldapEntry.getAttributes().get(mbrshipAttrName);
                        try {
                            if (mbrshipAttr == null || mbrshipAttr.size() == 1 && mbrshipAttr.get(0) == null) {
                                this.iLdapConn.invalidateSearchCache();
                            }
                            if (this.iLdapConfigMgr.getMembershipAttributeScope() != 2 && this.iLdapConfigMgr.supportDynamicGroup()) {
                                this.iLdapConn.invalidateSearchCache();
                            }
                        }
                        catch (NamingException attrIds) {
                            FFDCFilter.processException((Throwable)attrIds, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"435", (Object)((Object)this), (Object[])new Object[]{root});
                            this.iLdapConn.invalidateSearchCache();
                        }
                    } else {
                        this.iLdapConn.invalidateSearchCache();
                    }
                }
            }
            this.getGroups(outEntity, ldapEntry, grpMbrshipCtrl);
            if (this.iLdapConfigMgr.isGroup(ldapEntry.getType())) {
                this.getMembers(outEntity, ldapEntry, grpMbrCtrl);
            }
            this.getDescendants(outEntity, ldapEntry, descCtrl);
            this.getAncestors(outEntity, ldapEntry, ancesCtrl);
            if (chkGrpMbrshipCtrl == null) continue;
            int level = chkGrpMbrshipCtrl.getLevel();
            CheckGroupMembershipControl reChkCtrl = new CheckGroupMembershipControl();
            reChkCtrl.setInGroup(this.isMemberInGroup(inEntity, ldapEntry, level));
        }
        return outRoot;
    }

    @FFDCIgnore(value={EntityNotFoundException.class, InvalidNameException.class, NamingException.class})
    public Root login(Root root) throws WIMException {
        List entities = root.getEntities();
        LoginAccount inAccount = (LoginAccount)entities.get(0);
        String qName = inAccount.getTypeName();
        Map ctrlMap = ControlsHelper.getControlMap((Root)root);
        LoginControl loginCtrl = (LoginControl)ctrlMap.get("LoginControl");
        if (loginCtrl == null) {
            loginCtrl = new LoginControl();
        }
        LdapSearchControl srchCtrl = null;
        String principalName = inAccount.getPrincipalName();
        if (principalName != null) {
            principalName = principalName.replace("*", "\\*");
        }
        byte[] pwd = inAccount.getPassword();
        List certList = inAccount.getCertificate();
        int certListSize = certList.size();
        LdapEntry acctEntry = null;
        Root outRoot = new Root();
        if (certListSize > 0) {
            X509Certificate[] certs = new X509Certificate[certListSize];
            try {
                for (int i = 0; i < certs.length; ++i) {
                    ByteArrayInputStream bais = new ByteArrayInputStream((byte[])certList.get(i));
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    certs[i] = (X509Certificate)cf.generateCertificate(bais);
                    bais.close();
                }
            }
            catch (IOException i) {
                FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"510", (Object)((Object)this), (Object[])new Object[]{root});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"CERTIFICATE_MAP_FAILED", (Object[])new Object[]{null});
                throw new com.ibm.wsspi.security.wim.exception.CertificateMapFailedException("CERTIFICATE_MAP_FAILED", msg);
            }
            catch (CertificateException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"513", (Object)((Object)this), (Object[])new Object[]{root});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"CERTIFICATE_MAP_FAILED", (Object[])new Object[]{null});
                throw new com.ibm.wsspi.security.wim.exception.CertificateMapFailedException("CERTIFICATE_MAP_FAILED", msg);
            }
            srchCtrl = this.getLdapSearchControl((SearchControl)loginCtrl, false, false);
            acctEntry = this.mapCertificate(certs, srchCtrl);
            if (acctEntry == null) {
                return outRoot;
            }
        } else {
            if (principalName == null || principalName.trim().isEmpty()) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PRINCIPAL_NAME", (Object[])new Object[]{null});
                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", msg);
            }
            if (pwd == null || pwd.length == 0) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PASSWORD", (Object[])new Object[]{null});
                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PASSWORD", msg);
            }
            String quote = "'";
            if (principalName.indexOf("'") != -1) {
                quote = "\"";
            }
            String searchExpr = "@xsi:type=" + quote + qName + quote + " and " + "principalName" + "=" + quote + principalName + quote;
            loginCtrl.setExpression(searchExpr);
            srchCtrl = this.getLdapSearchControl((SearchControl)loginCtrl, false, false);
            String[] searchBases = srchCtrl.getBases();
            String sFilter = srchCtrl.getFilter();
            if (this.iLdapConfigMgr.getUseEncodingInSearchExpression() != null) {
                sFilter = LdapHelper.encodeAttribute(sFilter, this.iLdapConfigMgr.getUseEncodingInSearchExpression());
            }
            String principalNameDN = null;
            try {
                principalNameDN = new LdapName(principalName).toString();
            }
            catch (InvalidNameException e) {
                e.getMessage();
            }
            Filter userFilter = this.iLdapConfigMgr.getUserFilter();
            if (principalNameDN == null && userFilter != null) {
                sFilter = userFilter.prepare(principalName);
                sFilter = this.setAttributeNamesInFilter(sFilter, "PersonAccount");
            }
            int countLimit = srchCtrl.getCountLimit();
            int timeLimit = srchCtrl.getTimeLimit();
            List<String> entityTypes = srchCtrl.getEntityTypes();
            List<String> propNames = srchCtrl.getPropertyNames();
            propNames.addAll(this.iLdapConfigMgr.getLoginProperties());
            int scope = srchCtrl.getScope();
            int count = 0;
            for (int i = 0; i < searchBases.length; ++i) {
                try {
                    Set<LdapEntry> ldapEntries = this.iLdapConn.searchEntities(searchBases[i], sFilter, null, scope, entityTypes, propNames, false, false, countLimit, timeLimit);
                    if (ldapEntries.size() > 1) {
                        throw new PasswordCheckFailedException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)principalName)));
                    }
                    if (ldapEntries.size() != 1) continue;
                    if (count == 0) {
                        acctEntry = ldapEntries.iterator().next();
                    }
                    if (++count <= 1) continue;
                    throw new PasswordCheckFailedException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)principalName)));
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
            }
            if (acctEntry == null) {
                return outRoot;
            }
            String dn = acctEntry.getDN();
            if (!this.iLdapConn.isIgnoreCase()) {
                boolean foundMatch = false;
                Attributes attrs = acctEntry.getAttributes();
                List<String> loginProperties = this.iLdapConfigMgr.getLoginAttributes();
                for (String loginProp : loginProperties) {
                    try {
                        Attribute loginAttr = attrs.get(loginProp);
                        if (loginAttr != null) {
                            String attributeValue = String.valueOf(loginAttr.get());
                            if (!principalName.equals(attributeValue)) continue;
                            foundMatch = true;
                            break;
                        }
                        foundMatch = true;
                        break;
                    }
                    catch (NamingException e) {
                    }
                }
                if (!foundMatch) {
                    return outRoot;
                }
            }
            this.authenticateWithPassword(dn, pwd, principalName);
        }
        this.createEntityFromLdapEntry(outRoot, "entities", acctEntry, loginCtrl.getProperties());
        return outRoot;
    }

    @FFDCIgnore(value={InvalidNameException.class})
    public Root search(Root root) throws WIMException {
        Root outRoot;
        block37: {
            int scope;
            List<String> propNames;
            List<String> entityTypes;
            int timeLimit;
            int countLimit;
            String sFilter;
            String[] searchBases;
            block36: {
                String METHODNAME = "search";
                boolean bFirstChangeSearchCall = false;
                String searchExpr = null;
                Map ctrlMap = ControlsHelper.getControlMap((Root)root);
                CacheControl cacheCtrl = (CacheControl)ctrlMap.get("CacheControl");
                if (cacheCtrl != null) {
                    String cacheMode = cacheCtrl.getMode();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("search Cache Control is passed with mode " + cacheMode), (Object[])new Object[0]);
                    }
                    if (cacheMode != null && "clearAll".equalsIgnoreCase(cacheMode)) {
                        this.iLdapConn.invalidateAttributeCache();
                        this.iLdapConn.invalidateSearchCache();
                        String uniqueName = this.getCallerUniqueName();
                        if (tc.isWarningEnabled()) {
                            Tr.warning((TraceComponent)tc, (String)"CLEAR_ALL_CLEAR_CACHE_MODE", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)cacheMode, (Object)uniqueName));
                        }
                    } else if (cacheMode != null && "clearEntity".equalsIgnoreCase(cacheMode)) {
                        if (tc.isWarningEnabled()) {
                            Tr.warning((TraceComponent)tc, (String)"UNSUPPORTED_CLEAR_CACHE_MODE", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)cacheMode));
                        }
                    } else if (tc.isWarningEnabled()) {
                        Tr.warning((TraceComponent)tc, (String)"UNKNOWN_CLEAR_CACHE_MODE", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)cacheMode));
                    }
                }
                boolean bChangeSearch = true;
                ChangeControl searchControl = (ChangeControl)ctrlMap.get("ChangeControl");
                if (searchControl == null) {
                    bChangeSearch = false;
                    searchControl = (SearchControl)ctrlMap.get("SearchControl");
                } else {
                    List checkpoint = searchControl.getCheckPoint();
                    if (checkpoint.size() == 0) {
                        bFirstChangeSearchCall = true;
                    }
                }
                if (searchControl != null) {
                    searchExpr = searchControl.getExpression();
                    if (!(bFirstChangeSearchCall || searchExpr != null && searchExpr.length() != 0)) {
                        throw new SearchControlException("MISSING_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_SEARCH_EXPRESSION", null));
                    }
                }
                Set<String> realms = LdapAdapter.getSpecifiedRealms(root);
                boolean isSearchBaseSetByClient = realms.contains("n/a");
                String customProperty = LdapAdapter.getContextProperty(root, "allowDNPrincipalNameAsLiteral");
                boolean ignoreDNBaseSearch = customProperty.equalsIgnoreCase("true");
                LdapSearchControl srchCtrl = this.getLdapSearchControl((SearchControl)searchControl, isSearchBaseSetByClient, ignoreDNBaseSearch);
                searchBases = srchCtrl.getBases();
                sFilter = srchCtrl.getFilter();
                countLimit = srchCtrl.getCountLimit();
                timeLimit = srchCtrl.getTimeLimit();
                entityTypes = srchCtrl.getEntityTypes();
                propNames = srchCtrl.getPropertyNames();
                scope = srchCtrl.getScope();
                outRoot = new Root();
                if (!bChangeSearch) break block36;
                ChangeControl changeControl = searchControl;
                String checkPoint = this.changeHandler.getCurrentCheckPoint();
                CheckPointType currCheckPointDO = new CheckPointType();
                currCheckPointDO.setRepositoryId(this.reposId);
                currCheckPointDO.setRepositoryCheckPoint(checkPoint);
                ChangeResponseControl changeResponseCtrl = new ChangeResponseControl();
                changeResponseCtrl.getCheckPoint().add(currCheckPointDO);
                List checkPointList = changeControl.getCheckPoint();
                if (checkPointList == null || checkPointList.size() <= 0) break block37;
                CheckPointType checkPointDO = (CheckPointType)checkPointList.get(0);
                checkPoint = checkPointDO.getRepositoryCheckPoint();
                if (checkPoint == null) {
                    throw new ChangeControlException("NULL_CHECKPOINT_VALUE", Tr.formatMessage((TraceComponent)tc, (String)"NULL_CHECKPOINT_VALUE", null));
                }
                boolean isAttrCacheNotEmpty = true;
                List changeTypes = changeControl.getChangeTypes();
                for (int i = 0; i < searchBases.length; ++i) {
                    List<LdapEntry> ldapEntriesList = this.changeHandler.searchChangedEntities(checkPoint, changeTypes, searchBases[i], sFilter, scope, entityTypes, propNames, countLimit, timeLimit);
                    if (ldapEntriesList == null) continue;
                    for (int j = 0; j < ldapEntriesList.size(); ++j) {
                        LdapEntry entry = ldapEntriesList.get(j);
                        if (this.isActiveDirectory) {
                            if ("delete".equalsIgnoreCase(entry.getChangeType())) {
                                this.iLdapConn.invalidateAttributes(this.iLdapConfigMgr.switchToLdapNode(entry.getUniqueName()), entry.getExtId(), entry.getUniqueName());
                            } else {
                                this.iLdapConn.invalidateAttributes(entry.getDN(), entry.getExtId(), entry.getUniqueName());
                            }
                        } else if (isAttrCacheNotEmpty) {
                            if (entry.getExtId() == null && "delete".equalsIgnoreCase(entry.getChangeType())) {
                                this.iLdapConn.invalidateAttributeCache();
                                isAttrCacheNotEmpty = false;
                            } else {
                                this.iLdapConn.invalidateAttributes(entry.getDN(), entry.getExtId(), entry.getUniqueName());
                            }
                        }
                        this.createEntityFromLdapEntry(outRoot, "entities", entry, propNames);
                    }
                    if (ldapEntriesList.size() <= 0) continue;
                    this.iLdapConn.invalidateSearchCache();
                }
                break block37;
            }
            if (root.isSetContexts()) {
                Filter f;
                String dn;
                String inputPattern = LdapAdapter.getContextProperty(root, "useUserFilterForSearch");
                if (inputPattern != null && inputPattern.length() > 0) {
                    dn = null;
                    try {
                        dn = new LdapName(inputPattern).toString();
                    }
                    catch (InvalidNameException e) {
                        e.getMessage();
                    }
                    if (dn == null && (f = this.iLdapConfigMgr.getUserFilter()) != null) {
                        sFilter = f.prepare(inputPattern);
                    }
                } else {
                    inputPattern = LdapAdapter.getContextProperty(root, "useGroupFilterForSearch");
                    if (inputPattern != null && inputPattern.length() > 0) {
                        dn = null;
                        try {
                            dn = new LdapName(inputPattern).toString();
                        }
                        catch (InvalidNameException e) {
                            e.getMessage();
                        }
                        if (dn == null && (f = this.iLdapConfigMgr.getGroupFilter()) != null) {
                            sFilter = f.prepare(inputPattern);
                        }
                    }
                }
            }
            for (int i = 0; i < searchBases.length; ++i) {
                Set<LdapEntry> ldapEntriesSet = this.iLdapConn.searchEntities(searchBases[i], sFilter, null, scope, entityTypes, propNames, false, false, countLimit, timeLimit);
                for (LdapEntry entry : ldapEntriesSet) {
                    this.createEntityFromLdapEntry(outRoot, "entities", entry, propNames);
                }
            }
        }
        return outRoot;
    }

    /*
     * WARNING - void declaration
     */
    private String getCallerUniqueName() throws WIMApplicationException {
        String uniqueName = null;
        Subject subject = null;
        WSCredential cred = null;
        try {
            Iterator<WSCredential> iter;
            subject = WSSubject.getRunAsSubject();
            if (subject == null) {
                subject = WSSubject.getCallerSubject();
            }
            if (subject != null && (iter = subject.getPublicCredentials(WSCredential.class).iterator()).hasNext()) {
                cred = iter.next();
            }
            if (cred == null) {
                return null;
            }
            uniqueName = cred.getUniqueSecurityName();
        }
        catch (Exception iter) {
            void excp;
            FFDCFilter.processException((Throwable)iter, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"890", (Object)((Object)this), (Object[])new Object[0]);
            excp.getMessage();
            return null;
        }
        return uniqueName;
    }

    private Entity createEntityFromLdapEntry(Object parentDO, String propName, LdapEntry ldapEntry, List<String> propNames) throws WIMException {
        String METHODNAME = "createEntityFromLdapEntry";
        String outEntityType = ldapEntry.getType();
        Object outEntity = null;
        outEntity = outEntityType != null ? (outEntityType.equalsIgnoreCase("Person") ? new Person() : (outEntityType.equalsIgnoreCase("PersonAccount") ? new PersonAccount() : (outEntityType.equalsIgnoreCase("Group") ? new Group() : new Entity()))) : new Entity();
        if (parentDO instanceof Root) {
            if ("entities".equalsIgnoreCase(propName)) {
                ((Root)parentDO).getEntities().add(outEntity);
            }
        } else if (parentDO instanceof Entity) {
            if ("Group".equalsIgnoreCase(propName)) {
                if (outEntity instanceof Group) {
                    ((Entity)parentDO).getGroups().add((Group)outEntity);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createEntityFromLdapEntry Expected group entity. Group will excluded from group membership. Entity is " + outEntity), (Object[])new Object[]{ldapEntry});
                }
            } else if ("members".equalsIgnoreCase(propName)) {
                ((Group)parentDO).getMembers().add(outEntity);
            } else if ("children".equalsIgnoreCase(propName)) {
                ((Entity)parentDO).getChildren().add(outEntity);
            }
        }
        IdentifierType outId = new IdentifierType();
        outEntity.setIdentifier(outId);
        outId.setUniqueName(ldapEntry.getUniqueName());
        outId.setExternalId(ldapEntry.getExtId());
        outId.setExternalName(ldapEntry.getDN());
        outId.setRepositoryId(this.reposId);
        String changeType = ldapEntry.getChangeType();
        if (changeType != null) {
            outEntity.setChangeType(changeType);
            if (!"delete".equals(changeType)) {
                this.populateEntity((Entity)outEntity, propNames, ldapEntry.getAttributes());
            }
        } else {
            this.populateEntity((Entity)outEntity, propNames, ldapEntry.getAttributes());
        }
        return outEntity;
    }

    /*
     * WARNING - void declaration
     */
    private void populateEntity(Entity entity, List<String> propNames, Attributes attrs) throws WIMException {
        if (propNames == null || propNames.size() == 0 || attrs == null) {
            return;
        }
        String entityType = entity.getTypeName();
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(entityType);
        Set<String> allSupportedAttrs = ldapEntity.getAttributes();
        List<String> supportedProps = this.iLdapConfigMgr.getSupportedProperties(entityType, propNames);
        try {
            ArrayList<String> propVisitedList = new ArrayList<String>();
            NamingEnumeration<? extends Attribute> neu = attrs.getAll();
            while (neu.hasMore()) {
                boolean contain = false;
                Attribute attr = neu.next();
                String attrName = attr.getID();
                int pos = attrName.indexOf(59);
                if (pos > 0) {
                    attrName = attrName.substring(0, pos);
                }
                if (allSupportedAttrs.contains(attrName)) {
                    contain = true;
                } else {
                    for (String curAttr : allSupportedAttrs) {
                        if (!curAttr.equalsIgnoreCase(attrName)) continue;
                        contain = true;
                        break;
                    }
                }
                if (!contain && ("userPassword".equalsIgnoreCase(attrName) || "unicodePwd".equalsIgnoreCase(attrName))) {
                    contain = true;
                }
                Set<String> props = this.iLdapConfigMgr.getPropertyName(ldapEntity, attrName);
                boolean exclude = false;
                if (props.contains("ibmPrimaryEmail") && props.contains("ibm-primaryEmail")) {
                    exclude = true;
                }
                if (props.contains("ibmJobTitle") && props.contains("ibm-jobTitle")) {
                    exclude = true;
                }
                block4: for (String propName : props) {
                    if (propName.equalsIgnoreCase("ibmPrimaryEmail") && exclude || propName.equalsIgnoreCase("ibmJobTitle") && exclude) continue;
                    for (int i = 0; i < supportedProps.size(); ++i) {
                        String reqPropName = supportedProps.get(i);
                        if ((!"*".equals(reqPropName) || !contain) && !reqPropName.equalsIgnoreCase(propName)) continue;
                        Object prop = entity.get(propName);
                        if (propVisitedList.contains(propName) && attrName.equalsIgnoreCase(propName)) continue block4;
                        this.setPropertyValue(entity, attr, propName, this.iLdapConfigMgr.getLdapAttribute(attrName));
                        if (propVisitedList.contains(propName)) continue block4;
                        propVisitedList.add(propName);
                        continue block4;
                    }
                }
            }
        }
        catch (NamingException propVisitedList) {
            void e;
            FFDCFilter.processException((Throwable)propVisitedList, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1067", (Object)((Object)this), (Object[])new Object[]{entity, propNames, attrs});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
    }

    @Trivial
    private String getString(boolean isOctet, Object ldapValue) {
        if (isOctet) {
            return LdapHelper.getOctetString((byte[])ldapValue);
        }
        return ldapValue.toString();
    }

    private String getDateString(Object ldapValue) throws WIMSystemException {
        return String.valueOf(this.getDateString(ldapValue, false));
    }

    private Date getDateObject(Object ldapValue) throws WIMSystemException {
        return (Date)this.getDateString(ldapValue, true);
    }

    /*
     * WARNING - void declaration
     */
    private Object getDateString(Object ldapValue, boolean getCalendar) throws WIMSystemException {
        if (ldapValue instanceof Date) {
            return LdapHelper.getDateString((Date)ldapValue);
        }
        String timestampFormat = null;
        SimpleDateFormat dateFormat = null;
        StringBuffer originValue = new StringBuffer(ldapValue.toString());
        int pos = originValue.indexOf("Z");
        if (pos == -1) {
            pos = originValue.indexOf("z");
        }
        if (pos != -1) {
            originValue.replace(pos, pos, "-0000");
        }
        if ((timestampFormat = this.iLdapConfigMgr.getTimestampFormat()) != null) {
            dateFormat = new SimpleDateFormat(timestampFormat);
        } else if ("IBM TIVOLI DIRECTORY SERVER".equalsIgnoreCase(this.iLdapConfigMgr.getLdapType())) {
            int position = originValue.indexOf("-");
            if (originValue.indexOf(".-") == -1) {
                while (originValue.substring(0, position).length() < 21) {
                    if (originValue.indexOf(".") == -1) {
                        originValue.replace(position, position, ".");
                        ++position;
                    }
                    originValue.replace(position, position, "0");
                    position = originValue.indexOf("-");
                }
            }
            dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
            originValue = new StringBuffer(originValue.substring(0, 18) + originValue.substring(21));
        } else {
            dateFormat = "SUN JAVA SYSTEM DIRECTORY SERVER".equalsIgnoreCase(this.iLdapConfigMgr.getLdapType()) || "IBM LOTUS DOMINO".equalsIgnoreCase(this.iLdapConfigMgr.getLdapType()) || "NOVELL EDIRECTORY".equalsIgnoreCase(this.iLdapConfigMgr.getLdapType()) ? new SimpleDateFormat("yyyyMMddHHmmssZ") : (originValue.toString().contains(".") ? new SimpleDateFormat("yyyyMMddHHmmss.SZ") : new SimpleDateFormat("yyyyMMddHHmmssZ"));
        }
        Date date = null;
        try {
            date = dateFormat.parse(originValue.toString());
        }
        catch (ParseException parseException) {
            void e;
            FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1167", (Object)((Object)this), (Object[])new Object[]{ldapValue, getCalendar});
            throw new WIMSystemException("SYSTEM_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"SYSTEM_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)(e.toString() + ".  Timestamp received from Ldap: " + ldapValue))));
        }
        if (getCalendar) {
            return date;
        }
        return LdapHelper.getDateString(date);
    }

    @Trivial
    private IdentifierType createIdentiferFromLdapEntry(LdapEntry ldapEntry) throws WIMException {
        IdentifierType outId = new IdentifierType();
        outId.setUniqueName(ldapEntry.getUniqueName());
        outId.setExternalId(ldapEntry.getExtId());
        outId.setExternalName(ldapEntry.getDN());
        outId.setRepositoryId(this.reposId);
        return outId;
    }

    /*
     * WARNING - void declaration
     */
    private void setPropertyValue(Entity entity, Attribute attr, String propName, LdapAttribute ldapAttr) throws WIMException {
        block14: {
            String dataType = entity.getDataType(propName);
            boolean isMany = entity.isMultiValuedProperty(propName);
            String syntax = "string";
            if (ldapAttr != null) {
                syntax = ldapAttr.getSyntax();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("ldapAttr " + ldapAttr + " syntax is " + syntax), (Object[])new Object[0]);
                }
            }
            try {
                if (isMany) {
                    NamingEnumeration<?> enu = attr.getAll();
                    while (enu.hasMoreElements()) {
                        Object ldapValue = enu.nextElement();
                        if (ldapValue == null) continue;
                        entity.set(propName, this.processPropertyValue(entity, propName, dataType, syntax, ldapValue));
                    }
                } else {
                    Object ldapValue = attr.get();
                    if (ldapValue != null) {
                        entity.set(propName, this.processPropertyValue(entity, propName, dataType, syntax, ldapValue));
                    }
                }
            }
            catch (NamingException ldapValue) {
                void e;
                FFDCFilter.processException((Throwable)ldapValue, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1237", (Object)((Object)this), (Object[])new Object[]{entity, attr, propName, ldapAttr});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected on " + propName + " with dataType " + dataType), (Object[])new Object[]{e});
                }
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
            catch (ClassCastException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1243", (Object)((Object)this), (Object[])new Object[]{entity, attr, propName, ldapAttr});
                if (tc.isEventEnabled()) {
                    void ce;
                    Tr.event((TraceComponent)tc, (String)("Failed to cast property " + propName + " to " + dataType), (Object[])new Object[]{ce});
                }
                if (tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"INVALID_PROPERTY_DATA_TYPE", (Object[])WIMMessageHelper.generateMsgParms((Object)propName));
                }
            }
            catch (ArrayStoreException ce) {
                FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1249", (Object)((Object)this), (Object[])new Object[]{entity, attr, propName, ldapAttr});
                if (tc.isEventEnabled()) {
                    void ae;
                    Tr.event((TraceComponent)tc, (String)("Unexpected on " + propName + " with dataType " + dataType), (Object[])new Object[]{ae});
                }
                if (!tc.isErrorEnabled()) break block14;
                Tr.error((TraceComponent)tc, (String)"INVALID_PROPERTY_DATA_TYPE", (Object[])WIMMessageHelper.generateMsgParms((Object)propName));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object processPropertyValue(Entity entity, String propName, String dataType, String syntax, Object ldapValue) throws WIMException {
        if ("String".equals(dataType)) {
            boolean octet = "octetString".equalsIgnoreCase(syntax);
            return this.getString(octet, ldapValue);
        }
        if ("DateTime".equals(dataType)) {
            return this.getDateString(ldapValue);
        }
        if ("Date".equals(dataType)) {
            return this.getDateObject(ldapValue);
        }
        if ("Int".equals(dataType)) {
            return Integer.parseInt(ldapValue.toString());
        }
        if ("IdentifierType".equals(dataType)) {
            try {
                String stringValue = (String)ldapValue;
                LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(stringValue, null, null, null, null, false, false);
                return this.createIdentiferFromLdapEntry(ldapEntry);
            }
            catch (WIMException stringValue) {
                void we;
                FFDCFilter.processException((Throwable)stringValue, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1285", (Object)((Object)this), (Object[])new Object[]{entity, propName, dataType, syntax, ldapValue});
                if ("LDAP_ENTRY_NOT_FOUND".equalsIgnoreCase(we.getMessageKey())) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"INVALID_PROPERTY_VALUE", (Object[])WIMMessageHelper.generateMsgParms((Object)propName, (Object)entity.getIdentifier().getExternalName()));
                    throw new WIMSystemException("INVALID_PROPERTY_VALUE", msg);
                }
                throw we;
            }
        }
        if ("Base64Binary".equals(dataType)) {
            return ldapValue;
        }
        if ("LangType".equals(dataType)) {
            LangType lang = new LangType();
            lang.setValue(String.valueOf(ldapValue));
            return lang;
        }
        if ("Boolean".equals(dataType)) {
            return Boolean.parseBoolean(ldapValue.toString());
        }
        if ("Long".equals(dataType)) {
            return Long.parseLong(ldapValue.toString());
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Datatype for " + propName + " was null, process without casting"), (Object[])new Object[0]);
        }
        return ldapValue;
    }

    private void getGroups(Entity entity, LdapEntry ldapEntry, GroupMembershipControl grpMbrshipCtrl) throws WIMException {
        if (grpMbrshipCtrl == null) {
            return;
        }
        int level = grpMbrshipCtrl.getLevel();
        List propNames = grpMbrshipCtrl.getProperties();
        String[] bases = null;
        List searchBases = grpMbrshipCtrl.getSearchBases();
        int size = searchBases.size();
        String[] grpBases = this.iLdapConfigMgr.getGroupSearchBases();
        if (size == 0) {
            bases = grpBases.length != 0 ? grpBases : this.iLdapConfigMgr.getTopLdapNodes();
        } else {
            ArrayList<String> baseList = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                String uName = (String)searchBases.get(i);
                String dn = this.getDN(uName, null, null, true, false);
                baseList.add(dn);
            }
            bases = baseList.toArray(new String[0]);
        }
        bases = NodeHelper.getTopNodes((String[])bases);
        if (this.iLdapConfigMgr.getMembershipAttribute() != null) {
            if (this.iLdapConfigMgr.isRacf()) {
                this.getGroupsByMembershipRacf(entity, ldapEntry, bases, level, propNames, null);
            } else {
                this.getGroupsByMembership(entity, ldapEntry, bases, level, propNames, null);
            }
        } else if ("IBM TIVOLI DIRECTORY SERVER".equalsIgnoreCase(this.iLdapConfigMgr.getLdapType()) && this.iLdapConfigMgr.isLdapOperationalAttributeSet()) {
            this.getGroupsByOperationalAttribute(entity, ldapEntry, bases, level, propNames);
        } else {
            this.getGroupsByMember(entity, ldapEntry, bases, level, propNames, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean getGroupsByMembershipRacf(Entity entity, LdapEntry ldapEntry, String[] bases, int level, List<String> propNames, String groupDN) throws WIMException {
        String METHODNAME = "getGroupsByMembershipRacf";
        boolean isInGrp = false;
        String mbrshipAttrName = this.iLdapConfigMgr.getMembershipAttribute();
        Attribute mbrshipAttr = ldapEntry.getAttributes().get(mbrshipAttrName);
        if (mbrshipAttr == null || mbrshipAttr.size() == 0) {
            String dn = ldapEntry.getDN();
            String[] attrIds = new String[]{};
            attrIds[0] = mbrshipAttrName;
            ArrayList<String> entityTypes = new ArrayList<String>(1);
            entityTypes.add(ldapEntry.getType());
            Attributes attrs = this.iLdapConn.getAttributesByUniqueName(dn, attrIds, entityTypes);
            mbrshipAttr = attrs.get(mbrshipAttrName);
        }
        if (mbrshipAttr != null && mbrshipAttr.size() > 0) {
            NamingEnumeration<?> enm;
            try {
                enm = mbrshipAttr.getAll();
            }
            catch (NamingException attrIds) {
                void e;
                FFDCFilter.processException((Throwable)attrIds, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1395", (Object)((Object)this), (Object[])new Object[]{entity, ldapEntry, bases, level, propNames, groupDN});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
            List<String> supportedProps = this.iLdapConfigMgr.getSupportedProperties("Group", propNames);
            List<String> groupTypes = this.iLdapConfigMgr.getGroupTypes();
            while (enm.hasMoreElements()) {
                String dn = (String)enm.nextElement();
                dn = LdapHelper.getValidDN(dn);
                if (groupDN != null && groupDN.equalsIgnoreCase(dn)) {
                    isInGrp = true;
                    return isInGrp;
                }
                if (!LdapHelper.isUnderBases(dn, bases)) continue;
                LdapEntry grpEntry = null;
                try {
                    grpEntry = this.iLdapConn.getEntityByIdentifier(dn, null, null, groupTypes, supportedProps, false, false);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    FFDCFilter.processException((Throwable)entityNotFoundException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1422", (Object)((Object)this), (Object[])new Object[]{entity, ldapEntry, bases, level, propNames, groupDN});
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("getGroupsByMembershipRacf Group " + dn + " is not found and ingored."), (Object[])new Object[0]);
                    continue;
                }
                if (!this.iLdapConfigMgr.isGroup(grpEntry.getType())) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("getGroupsByMembershipRacf Ldap entry " + dn + " is not a Group."), (Object[])new Object[0]);
                    continue;
                }
                if (entity == null) continue;
                this.createEntityFromLdapEntry(entity, "Group", grpEntry, supportedProps);
            }
        }
        return isInGrp;
    }

    /*
     * WARNING - void declaration
     */
    private void getGroupsByOperationalAttribute(Entity entity, LdapEntry ldapEntry, String[] bases, int level, List<String> propNames) throws WIMException {
        Attribute attribute;
        String filter = "(objectclass=*)";
        List<String> grpTypes = this.iLdapConfigMgr.getGroupTypes();
        List<String> supportedProps = this.iLdapConfigMgr.getSupportedProperties("Group", propNames);
        SearchResult result = this.iLdapConn.searchByOperationalAttribute(ldapEntry.getDN(), filter, grpTypes, supportedProps, "ibm-allGroups");
        if (result != null && (attribute = result.getAttributes().get("ibm-allGroups")) != null) {
            try {
                NamingEnumeration<?> groups = attribute.getAll();
                while (groups.hasMore()) {
                    if (entity == null) continue;
                    String groupDN = String.valueOf(groups.next());
                    LdapEntry grpEntry = this.iLdapConn.getEntityByIdentifier(groupDN, null, null, this.iLdapConfigMgr.getGroupTypes(), propNames, false, false);
                    this.createEntityFromLdapEntry(entity, "Group", grpEntry, supportedProps);
                }
            }
            catch (NamingException groups) {
                void e;
                FFDCFilter.processException((Throwable)groups, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1471", (Object)((Object)this), (Object[])new Object[]{entity, ldapEntry, bases, level, propNames});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getDN(String uniqueName, String entityType, Attributes attrs, boolean queryLdap, boolean translate) throws WIMException {
        String METHODNAME = "getDN";
        String dn = null;
        String ldapNode = this.iLdapConfigMgr.getLdapNode(uniqueName);
        if (ldapNode != null) {
            return ldapNode;
        }
        uniqueName = this.iLdapConfigMgr.switchToLdapNode(uniqueName);
        if ((translate || this.iLdapConfigMgr.needTranslateRDN()) && this.iLdapConfigMgr.needTranslateRDN(entityType)) {
            try {
                LdapEntity ldapEntity;
                if (entityType != null && (ldapEntity = this.iLdapConfigMgr.getLdapEntity(entityType)) != null && attrs != null) {
                    String[] rdnName = LdapHelper.getRDNAttributes(uniqueName);
                    String[][] rdnWIMProps = ldapEntity.getWIMRDNProperties();
                    String[][] rdnAttrs = ldapEntity.getRDNAttributes();
                    Attribute[] rdnAttributes = new Attribute[rdnWIMProps.length];
                    String[] rdnAttrValues = new String[rdnWIMProps.length];
                    for (int i = 0; i < rdnWIMProps.length; ++i) {
                        String[] rdnProp = rdnWIMProps[i];
                        boolean isRDN = true;
                        for (int j = 0; j < rdnProp.length; ++j) {
                            if (rdnProp[j].equalsIgnoreCase(rdnName[j])) continue;
                            isRDN = false;
                        }
                        if (!isRDN) continue;
                        String[] rdnAttr = rdnAttrs[i];
                        for (int k = 0; k < rdnAttr.length; ++k) {
                            rdnAttributes[k] = attrs.get(rdnAttr[k]);
                            if (rdnAttributes[k] == null && !queryLdap) {
                                throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_MANDATORY_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)rdnProp[k])));
                            }
                            rdnAttrValues[k] = (String)rdnAttributes[k].get();
                        }
                        dn = LdapHelper.replaceRDN(uniqueName, rdnAttr, rdnAttrValues);
                    }
                }
                if (dn == null && queryLdap) {
                    Attributes reAttrs = this.iLdapConn.getAttributesByUniqueName(uniqueName, new String[0], null);
                    Attribute dnAttr = reAttrs.get("distinguishedName");
                    dn = (String)dnAttr.get();
                }
            }
            catch (NamingException reAttrs) {
                void e;
                FFDCFilter.processException((Throwable)reAttrs, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1531", (Object)((Object)this), (Object[])new Object[]{uniqueName, entityType, attrs, queryLdap, translate});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
        }
        if (dn == null) {
            dn = uniqueName;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDN Translated DN: " + dn), (Object[])new Object[0]);
        }
        return dn;
    }

    /*
     * WARNING - void declaration
     */
    private boolean getGroupsByMembership(Entity entity, LdapEntry ldapEntry, String[] bases, int level, List<String> propNames, String groupDN) throws WIMException {
        boolean nested;
        String METHODNAME = "getGroupsByMembership";
        boolean bl = nested = level == 0 && this.iLdapConfigMgr.getMembershipAttributeScope() == 0;
        if (!nested && this.iLdapConfigMgr.isRecursiveSearch()) {
            nested = true;
        }
        boolean isInGrp = false;
        List<String> supportedProps = this.iLdapConfigMgr.getSupportedProperties("Group", propNames);
        String mbrshipAttrName = this.iLdapConfigMgr.getMembershipAttribute();
        Attribute mbrshipAttr = ldapEntry.getAttributes().get(mbrshipAttrName);
        try {
            boolean findDynaGrp;
            if (mbrshipAttr == null || mbrshipAttr.size() == 1 && mbrshipAttr.get(0) == null) {
                isInGrp = "IBM TIVOLI DIRECTORY SERVER".equalsIgnoreCase(this.iLdapConfigMgr.getLdapType()) && mbrshipAttrName != null && mbrshipAttrName.equalsIgnoreCase("ibm-allGroups") ? false : this.getGroupsByMember(entity, ldapEntry, bases, level, supportedProps, groupDN);
                return isInGrp;
            }
            if (mbrshipAttr.size() == 0) {
                isInGrp = false;
                return isInGrp;
            }
            HashMap<String, Attribute> DNMbrshipMap = null;
            if (nested) {
                DNMbrshipMap = new HashMap<String, Attribute>();
            }
            HashSet<String> groupsToDo = new HashSet<String>();
            List<String> groupTypes = this.iLdapConfigMgr.getGroupTypes();
            NamingEnumeration<?> enm = mbrshipAttr.getAll();
            while (enm.hasMoreElements()) {
                LdapEntry grpEntry22;
                String dn;
                block31: {
                    dn = (String)enm.nextElement();
                    dn = LdapHelper.getValidDN(dn);
                    if (groupDN != null && groupDN.equalsIgnoreCase(dn)) {
                        isInGrp = true;
                        return isInGrp;
                    }
                    if (!LdapHelper.isUnderBases(dn, bases)) continue;
                    List<String> grpTypes = this.iLdapConfigMgr.getGroupTypes();
                    HashSet<String> entityType = new HashSet<String>(groupTypes);
                    String entityTypeFilter = this.iLdapConfigMgr.getEntityTypesFilter(entityType);
                    grpEntry22 = null;
                    Object var22_25 = null;
                    try {
                        Set<LdapEntry> set = this.iLdapConn.searchEntities(dn, entityTypeFilter, null, 0, grpTypes, supportedProps, true, false);
                        if (set == null) break block31;
                        for (LdapEntry grpEntry22 : set) {
                        }
                    }
                    catch (EntityNotFoundException itr) {
                        FFDCFilter.processException((Throwable)itr, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1614", (Object)((Object)this), (Object[])new Object[]{entity, ldapEntry, bases, level, propNames, groupDN});
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("getGroupsByMembership Group " + dn + " is not found and ingored."), (Object[])new Object[0]);
                        continue;
                    }
                }
                if (grpEntry22 != null && !this.iLdapConfigMgr.isGroup(grpEntry22.getType())) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("getGroupsByMembership Ldap entry " + dn + " is not a Group."), (Object[])new Object[0]);
                    continue;
                }
                if (grpEntry22 != null && entity != null) {
                    this.createEntityFromLdapEntry(entity, "Group", grpEntry22, supportedProps);
                }
                if (grpEntry22 == null || !nested) continue;
                String key = dn.toLowerCase();
                DNMbrshipMap.put(key, grpEntry22.getAttributes().get(mbrshipAttrName));
                groupsToDo.add(key);
            }
            Map<String, LdapEntry> dynaGrpMap = null;
            HashMap<String, LdapURL[]> dynaGrpURLsMap = null;
            boolean bl2 = findDynaGrp = this.iLdapConfigMgr.getMembershipAttributeScope() != 2 && this.iLdapConfigMgr.supportDynamicGroup();
            if (findDynaGrp) {
                dynaGrpMap = this.iLdapConn.getDynamicGroups(bases, supportedProps, true);
                dynaGrpURLsMap = new HashMap<String, LdapURL[]>(dynaGrpMap.size());
                Set<Map.Entry<String, LdapEntry>> dynaGrpMapEntrySet = dynaGrpMap.entrySet();
                for (Map.Entry entry : dynaGrpMapEntrySet) {
                    LdapURL[] ldapURLs;
                    String dynaGrpDn = (String)entry.getKey();
                    String dynaGrpKey = dynaGrpDn.toLowerCase();
                    LdapEntry dynaGrpEntry = (LdapEntry)entry.getValue();
                    Attributes attrs = dynaGrpEntry.getAttributes();
                    Attribute dynaMbrAttr = attrs.get(this.iLdapConfigMgr.getDynamicMemberAttribute(attrs.get("objectClass")));
                    if (dynaMbrAttr == null || (ldapURLs = LdapHelper.getLdapURLs(dynaMbrAttr)) == null || ldapURLs.length <= 0) continue;
                    dynaGrpURLsMap.put(dynaGrpDn, ldapURLs);
                    if (DNMbrshipMap.containsKey(dynaGrpKey) || !this.iLdapConn.isMemberInURLQuery(ldapURLs, ldapEntry.getDN())) continue;
                    if (groupDN != null && groupDN.equalsIgnoreCase(dynaGrpDn)) {
                        isInGrp = true;
                        return isInGrp;
                    }
                    if (entity != null) {
                        this.createEntityFromLdapEntry(entity, "Group", dynaGrpEntry, supportedProps);
                    }
                    if (!nested) continue;
                    DNMbrshipMap.put(dynaGrpKey, dynaGrpEntry.getAttributes().get(mbrshipAttrName));
                    groupsToDo.add(dynaGrpKey);
                }
            }
            if (!nested && groupDN != null) {
                return isInGrp;
            }
            while (groupsToDo.size() > 0) {
                HashSet<String> nextGroups = new HashSet<String>();
                for (String string : groupsToDo) {
                    Attribute grpMbrshipAttr = (Attribute)DNMbrshipMap.get(string.toLowerCase());
                    if (grpMbrshipAttr != null) {
                        NamingEnumeration<?> grpEnum = grpMbrshipAttr.getAll();
                        while (grpEnum.hasMoreElements()) {
                            LdapEntry grpEntry32;
                            String grpKey;
                            String grpDn;
                            block32: {
                                grpDn = (String)grpEnum.nextElement();
                                if (grpDn == null) continue;
                                if (groupDN != null && groupDN.equalsIgnoreCase(grpDn)) {
                                    isInGrp = true;
                                    return isInGrp;
                                }
                                if (!LdapHelper.isUnderBases(grpDn, bases) || DNMbrshipMap.containsKey(grpKey = grpDn.toLowerCase())) continue;
                                grpEntry32 = null;
                                Set<LdapEntry> grpEntries = null;
                                List<String> grpTypes = this.iLdapConfigMgr.getGroupTypes();
                                HashSet<String> entityType = new HashSet<String>(groupTypes);
                                String entityTypeFilter = this.iLdapConfigMgr.getEntityTypesFilter(entityType);
                                try {
                                    grpEntries = this.iLdapConn.searchEntities(grpDn, entityTypeFilter, null, 0, grpTypes, supportedProps, true, false);
                                    if (grpEntries == null) break block32;
                                    for (LdapEntry grpEntry32 : grpEntries) {
                                    }
                                }
                                catch (EntityNotFoundException itr) {
                                    FFDCFilter.processException((Throwable)itr, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1720", (Object)((Object)this), (Object[])new Object[]{entity, ldapEntry, bases, level, propNames, groupDN});
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)("getGroupsByMembership Group " + grpDn + " is not found and ingored."), (Object[])new Object[0]);
                                    continue;
                                }
                            }
                            if (grpEntry32 != null && !this.iLdapConfigMgr.isGroup(grpEntry32.getType())) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("getGroupsByMembership Ldap entry " + grpDn + " is not a Group."), (Object[])new Object[0]);
                                continue;
                            }
                            if (grpEntry32 != null && entity != null) {
                                this.createEntityFromLdapEntry(entity, "Group", grpEntry32, supportedProps);
                            }
                            if (grpEntry32 == null || !nested) continue;
                            DNMbrshipMap.put(grpKey, grpEntry32.getAttributes().get(mbrshipAttrName));
                            if (groupsToDo.contains(grpKey)) continue;
                            nextGroups.add(grpKey);
                        }
                    }
                    if (!findDynaGrp) continue;
                    Set dynaGrpUrlEntrySet = dynaGrpURLsMap.entrySet();
                    for (Map.Entry dynaUrlEntry : dynaGrpUrlEntrySet) {
                        String dynaGrpDn = (String)dynaUrlEntry.getKey();
                        String dynaGrpKey = dynaGrpDn.toLowerCase();
                        if (DNMbrshipMap.containsKey(dynaGrpKey) || !this.iLdapConn.isMemberInURLQuery((LdapURL[])dynaUrlEntry.getValue(), string)) continue;
                        if (groupDN != null && groupDN.equalsIgnoreCase(dynaGrpDn)) {
                            isInGrp = true;
                            return isInGrp;
                        }
                        LdapEntry dynaGrpEntry = dynaGrpMap.get(dynaGrpDn);
                        if (entity != null) {
                            this.createEntityFromLdapEntry(entity, "Group", dynaGrpEntry, supportedProps);
                        }
                        DNMbrshipMap.put(dynaGrpKey, dynaGrpEntry.getAttributes().get(mbrshipAttrName));
                        if (groupsToDo.contains(dynaGrpKey)) continue;
                        nextGroups.add(dynaGrpKey);
                    }
                }
                groupsToDo = nextGroups;
            }
        }
        catch (NamingException DNMbrshipMap) {
            void e;
            FFDCFilter.processException((Throwable)DNMbrshipMap, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1771", (Object)((Object)this), (Object[])new Object[]{entity, ldapEntry, bases, level, propNames, groupDN});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
        return isInGrp;
    }

    private boolean getGroupsByMember(Entity entity, LdapEntry ldapEntry, String[] bases, int level, List<String> propNames, String groupDN) throws WIMException {
        boolean findDynaGrp;
        boolean nested;
        boolean bl = nested = level == 0 && !this.iLdapConfigMgr.isMemberAttributesNestedScope();
        if (!nested && this.iLdapConfigMgr.isRecursiveSearch()) {
            nested = true;
        }
        boolean isInGrp = false;
        String filter = this.iLdapConfigMgr.getGroupMemberFilter(ldapEntry.getDN());
        List<String> grpTypes = this.iLdapConfigMgr.getGroupTypes();
        HashSet<String> groupsToDo = new HashSet<String>();
        HashSet<String> allGroups = new HashSet<String>();
        List<String> supportedProps = this.iLdapConfigMgr.getSupportedProperties("Group", propNames);
        int n = bases.length;
        for (int i = 0; i < n; ++i) {
            Set<LdapEntry> grpEntries = this.iLdapConn.searchEntities(bases[i], filter, null, 2, grpTypes, supportedProps, false, false);
            for (LdapEntry grpEntry : grpEntries) {
                if (entity != null) {
                    this.createEntityFromLdapEntry(entity, "Group", grpEntry, supportedProps);
                }
                String string2 = grpEntry.getDN();
                string2 = LdapHelper.getValidDN(string2);
                if (groupDN != null && groupDN.equalsIgnoreCase(string2)) {
                    isInGrp = true;
                    return isInGrp;
                }
                if (!nested) continue;
                String key = string2.toLowerCase();
                groupsToDo.add(key);
                allGroups.add(key);
            }
        }
        Map<String, LdapEntry> dynaGrpMap = null;
        HashMap<String, LdapURL[]> dynaGrpURLsMap = null;
        boolean bl2 = findDynaGrp = !this.iLdapConfigMgr.isMemberAttributesAllScope() && this.iLdapConfigMgr.supportDynamicGroup();
        if (findDynaGrp) {
            dynaGrpMap = this.iLdapConn.getDynamicGroups(bases, supportedProps, false);
            dynaGrpURLsMap = new HashMap<String, LdapURL[]>(dynaGrpMap.size());
            Set<Map.Entry<String, LdapEntry>> dynaGrpEntrySet = dynaGrpMap.entrySet();
            for (Map.Entry entry : dynaGrpEntrySet) {
                LdapURL[] ldapURLs;
                String dynaGrpDn = (String)entry.getKey();
                String dynaGrpKey = dynaGrpDn.toLowerCase();
                LdapEntry dynaGrpEntry = (LdapEntry)entry.getValue();
                Attributes attrs = dynaGrpEntry.getAttributes();
                Attribute dynaMbrAttr = attrs.get(this.iLdapConfigMgr.getDynamicMemberAttribute(attrs.get("objectClass")));
                if (dynaMbrAttr == null || (ldapURLs = LdapHelper.getLdapURLs(dynaMbrAttr)) == null || ldapURLs.length <= 0) continue;
                dynaGrpURLsMap.put(dynaGrpDn, ldapURLs);
                if (allGroups.contains(dynaGrpKey) || !this.iLdapConn.isMemberInURLQuery(ldapURLs, ldapEntry.getDN())) continue;
                if (groupDN != null && groupDN.equalsIgnoreCase(dynaGrpDn)) {
                    isInGrp = true;
                    return isInGrp;
                }
                if (entity != null) {
                    this.createEntityFromLdapEntry(entity, "Group", dynaGrpEntry, supportedProps);
                }
                if (!nested) continue;
                groupsToDo.add(dynaGrpKey);
                allGroups.add(dynaGrpKey);
            }
        }
        if (!nested && groupDN != null) {
            return isInGrp;
        }
        while (groupsToDo.size() > 0) {
            HashSet<String> nextGroups = new HashSet<String>();
            for (String string : groupsToDo) {
                filter = this.iLdapConfigMgr.getGroupMemberFilter(string);
                int n2 = bases.length;
                for (int i = 0; i < n2; ++i) {
                    Set<LdapEntry> grpEntries = this.iLdapConn.searchEntities(bases[i], filter, null, 2, grpTypes, supportedProps, false, false);
                    for (LdapEntry grpEntry : grpEntries) {
                        String grpDn = grpEntry.getDN();
                        if (groupDN != null && groupDN.equalsIgnoreCase(grpDn)) {
                            isInGrp = true;
                            return isInGrp;
                        }
                        String grpKey = grpDn.toLowerCase();
                        if (allGroups.contains(grpKey)) continue;
                        if (entity != null) {
                            this.createEntityFromLdapEntry(entity, "Group", grpEntry, supportedProps);
                        }
                        allGroups.add(grpKey);
                        if (groupsToDo.contains(grpKey)) continue;
                        nextGroups.add(grpKey);
                    }
                }
                if (!findDynaGrp) continue;
                Set dynaGrpURLsEntrySet = dynaGrpURLsMap.entrySet();
                for (Map.Entry urlEntry : dynaGrpURLsEntrySet) {
                    String dynaGrpDn = (String)urlEntry.getKey();
                    String dynaGrpKey = dynaGrpDn.toLowerCase();
                    if (allGroups.contains(dynaGrpKey) || !this.iLdapConn.isMemberInURLQuery((LdapURL[])urlEntry.getValue(), string)) continue;
                    LdapEntry dynaGrpEntry = dynaGrpMap.get(dynaGrpDn);
                    if (groupDN != null && groupDN.equalsIgnoreCase(dynaGrpDn)) {
                        isInGrp = true;
                        return isInGrp;
                    }
                    if (entity != null) {
                        this.createEntityFromLdapEntry(entity, "Group", dynaGrpEntry, supportedProps);
                    }
                    allGroups.add(dynaGrpKey);
                    if (groupsToDo.contains(dynaGrpKey)) continue;
                    nextGroups.add(dynaGrpKey);
                }
            }
            groupsToDo = nextGroups;
        }
        return isInGrp;
    }

    private void getMembers(Entity entity, LdapEntry ldapEntry, GroupMemberControl grpMbrCtrl) throws WIMException {
        if (grpMbrCtrl == null) {
            return;
        }
        int level = grpMbrCtrl.getLevel();
        List propNames = grpMbrCtrl.getProperties();
        List<String> mbrTypes = this.getEntityTypes((SearchControl)grpMbrCtrl);
        String[] bases = this.getBases((SearchControl)grpMbrCtrl, mbrTypes);
        if (!this.iLdapConfigMgr.isDefaultMbrAttr()) {
            this.getMembersByMember(entity, ldapEntry, bases, level, propNames, mbrTypes);
        } else if (this.iLdapConfigMgr.getMembershipAttribute() != null) {
            this.getMembersByMembership(entity, ldapEntry, bases, level, propNames, mbrTypes);
        } else {
            this.getMembersByMember(entity, ldapEntry, bases, level, propNames, mbrTypes);
        }
    }

    private List<String> getEntityTypes(SearchControl ctrl) throws WIMException {
        String searchExpr = ctrl.getExpression();
        HashSet<String> mbrTypes = new HashSet<String>();
        if (searchExpr != null && searchExpr.trim().length() > 0) {
            WIMXPathInterpreter parser = new WIMXPathInterpreter((Reader)new StringReader(searchExpr));
            try {
                parser.parse(null);
            }
            catch (com.ibm.ws.security.wim.xpath.ParseException parseException) {
                FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1946", (Object)((Object)this), (Object[])new Object[]{ctrl});
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
            }
            catch (TokenMgrError e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"1951", (Object)((Object)this), (Object[])new Object[]{ctrl});
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
            }
            List mbrTypeList = parser.getEntityTypes();
            mbrTypes.addAll(mbrTypeList);
        } else {
            List<LdapEntity> ldapEntities = this.iLdapConfigMgr.getLdapEntities();
            for (int i = 0; i < ldapEntities.size(); ++i) {
                mbrTypes.add(ldapEntities.get(i).getName());
            }
        }
        return new ArrayList<String>(mbrTypes);
    }

    private String[] getBases(SearchControl ctrl, List<String> mbrTypes) throws WIMException {
        String[] bases = null;
        List searchBaseList = ctrl.getSearchBases();
        int size = searchBaseList.size();
        if (size > 0) {
            bases = searchBaseList.toArray(new String[0]);
            bases = NodeHelper.getTopNodes((String[])bases);
            for (int i = 0; i < bases.length; ++i) {
                String dn;
                String uName = bases[i];
                bases[i] = dn = this.getDN(uName, null, null, true, false);
                bases = NodeHelper.getTopNodes((String[])bases);
            }
        } else {
            ArrayList<? extends String> searchBases = new ArrayList<String>();
            if (mbrTypes == null) {
                bases = this.iLdapConfigMgr.getTopLdapNodes();
            } else {
                for (int i = 0; i < mbrTypes.size(); ++i) {
                    LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(mbrTypes.get(i));
                    if (ldapEntity == null) {
                        bases = this.iLdapConfigMgr.getTopLdapNodes();
                        break;
                    }
                    searchBases.addAll(ldapEntity.getSearchBaseList());
                }
                if (bases == null) {
                    bases = searchBases.toArray(new String[0]);
                    bases = NodeHelper.getTopNodes((String[])bases);
                }
            }
        }
        return bases;
    }

    private void getMembersByMembership(Entity entity, LdapEntry ldapEntry, String[] bases, int level, List<String> propNames, List<String> mbrTypes) throws WIMException {
        boolean nested;
        boolean bl = nested = level == 0 && this.iLdapConfigMgr.getMembershipAttributeScope() == 0;
        if (!nested && this.iLdapConfigMgr.isRecursiveSearch()) {
            nested = true;
        }
        String mbrshipAttrName = this.iLdapConfigMgr.getMembershipAttribute();
        boolean returnGrp = this.iLdapConfigMgr.containGroup(mbrTypes);
        HashMap mbrMap = new HashMap();
        ArrayList<? extends String> searchBaseList = new ArrayList<String>();
        for (int i = 0; i < bases.length; ++i) {
            searchBaseList.add(bases[i]);
        }
        StringBuffer memberFilter = new StringBuffer("(&(" + mbrshipAttrName + "={0})");
        if (mbrTypes.size() > 1 || !returnGrp && nested) {
            memberFilter.append("(|");
        }
        for (String entityType : mbrTypes) {
            LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(entityType);
            memberFilter.append(ldapEntity.getSearchFilter());
        }
        if (!returnGrp && nested) {
            LdapEntity grpEntity = this.iLdapConfigMgr.getLdapEntity("Group");
            memberFilter.append(grpEntity.getSearchFilter());
            searchBaseList.addAll(grpEntity.getSearchBaseList());
            mbrTypes.add("Group");
        }
        if (mbrTypes.size() > 1 || !returnGrp && nested) {
            memberFilter.append(")");
        }
        memberFilter.append(")");
        Object[] filterArgs = new Object[]{ldapEntry.getDN()};
        String[] searchBases = new String[]{};
        searchBases = searchBaseList.toArray(searchBases);
        searchBases = NodeHelper.getTopNodes((String[])searchBases);
        HashSet<String> groupsToDo = new HashSet<String>();
        HashSet<String> requestedGrps = new HashSet<String>();
        for (int i = 0; i < searchBases.length; ++i) {
            Set<LdapEntry> entities = this.iLdapConn.searchEntities(searchBases[i], memberFilter.toString(), filterArgs, 2, mbrTypes, propNames, false, false);
            for (LdapEntry mbrEntity : entities) {
                String dn = mbrEntity.getDN();
                dn = LdapHelper.getValidDN(dn);
                if (this.iLdapConfigMgr.isGroup(mbrEntity.getType())) {
                    if (nested) {
                        String key = dn.toLowerCase();
                        groupsToDo.add(key);
                        requestedGrps.add(key);
                    }
                    if (!returnGrp) continue;
                }
                if (LdapHelper.isUnderBases(dn, bases) && !mbrMap.containsKey(mbrEntity.getUniqueName())) {
                    this.createEntityFromLdapEntry(entity, "members", mbrEntity, propNames);
                }
                mbrMap.put(mbrEntity.getUniqueName(), null);
            }
        }
        if (nested) {
            while (groupsToDo.size() > 0) {
                HashSet<String> nextGroups = new HashSet<String>();
                for (String grpDN : groupsToDo) {
                    filterArgs[0] = grpDN;
                    for (int i = 0; i < searchBases.length; ++i) {
                        Set<LdapEntry> entities = this.iLdapConn.searchEntities(searchBases[i], memberFilter.toString(), filterArgs, 2, mbrTypes, propNames, false, false);
                        for (LdapEntry mbrEntity : entities) {
                            String dn = mbrEntity.getDN();
                            String key = (dn = LdapHelper.getValidDN(dn)).toLowerCase();
                            if (!requestedGrps.contains(key) && this.iLdapConfigMgr.isGroup(mbrEntity.getType())) {
                                if (!groupsToDo.contains(key)) {
                                    nextGroups.add(key);
                                }
                                requestedGrps.add(key);
                                if (!returnGrp) continue;
                            }
                            if (LdapHelper.isUnderBases(dn, bases) && !mbrMap.containsKey(mbrEntity.getUniqueName())) {
                                this.createEntityFromLdapEntry(entity, "members", mbrEntity, propNames);
                            }
                            mbrMap.put(mbrEntity.getUniqueName(), null);
                        }
                    }
                }
                groupsToDo = nextGroups;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EntityNotFoundException.class})
    private void getMembersByMember(Entity entity, LdapEntry ldapEntry, String[] bases, int level, List<String> propNames, List<String> mbrTypes) throws WIMException {
        block35: {
            boolean nested;
            List<String> dynaMemberDNs;
            String dynaMbrAttr;
            String METHODNAME = "getMembersByMember";
            Attributes attrs = ldapEntry.getAttributes();
            Attribute[] memberAttrs = this.iLdapConfigMgr.getGroupMemberAttrs(attrs, attrs.get("objectClass"));
            Attribute memberAttr = null;
            if (memberAttrs != null && memberAttrs.length > 0) {
                memberAttr = memberAttrs[0];
            }
            List<String> supportedProps = this.iLdapConfigMgr.getSupportedProperties("PersonAccount", propNames);
            HashMap mbrMap = new HashMap();
            if (this.iLdapConfigMgr.supportDynamicGroup() && (dynaMbrAttr = this.iLdapConfigMgr.getDynamicMemberAttribute(attrs.get("objectClass"))) != null && (dynaMemberDNs = this.getDynamicMembers(attrs.remove(dynaMbrAttr))) != null && dynaMemberDNs.size() > 0) {
                if (memberAttr == null) {
                    Object mbrAttrName = null;
                    if (attrs.get("objectClass") != null) {
                        mbrAttrName = this.iLdapConfigMgr.getDynamicMemberAttribute(attrs.get("objectClass"));
                    }
                    memberAttr = new BasicAttribute((String)mbrAttrName);
                }
                for (String dynaMemberDN : dynaMemberDNs) {
                    memberAttr.add(dynaMemberDN);
                }
            }
            if (memberAttr == null) {
                return;
            }
            if (memberAttrs == null) {
                memberAttrs = new Attribute[]{memberAttr};
            }
            boolean bl = nested = level == 0 && !this.iLdapConfigMgr.isMemberAttributesNestedScope();
            if (!nested && this.iLdapConfigMgr.isRecursiveSearch()) {
                nested = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMembersByMember nested = " + nested), (Object[])new Object[0]);
            }
            HashMap<String, Attribute> grpDNAttrs = new HashMap<String, Attribute>();
            ArrayList<String> mbrTypesWithGroup = new ArrayList<String>();
            if (mbrTypes != null) {
                mbrTypesWithGroup.addAll(mbrTypes);
            }
            if (nested && !mbrTypesWithGroup.contains("Group")) {
                mbrTypesWithGroup.add("Group");
            }
            String entityTypeFilter = null;
            HashSet<String> entityType = null;
            if (mbrTypes != null) {
                entityType = new HashSet<String>(mbrTypesWithGroup);
                entityTypeFilter = this.iLdapConfigMgr.getEntityTypesFilter(entityType);
            }
            try {
                if (memberAttrs != null) {
                    ArrayList<String> RDNCheckType = new ArrayList<String>();
                    for (int i = 0; i < memberAttrs.length; ++i) {
                        memberAttr = memberAttrs[i];
                        NamingEnumeration<?> enu = memberAttr.getAll();
                        while (enu.hasMoreElements()) {
                            Attributes mbrAttrs;
                            Attribute[] mbrAttr;
                            LdapEntry mbrEntity22;
                            String string;
                            block34: {
                                String string = (String)enu.next();
                                string = LdapHelper.getValidDN(string);
                                if (this.iLdapConfigMgr.isDummyMember(string) || !LdapHelper.isUnderBases(string, bases) || !this.startWithSameRDN(string, mbrTypes, nested)) continue;
                                mbrEntity22 = null;
                                Set<LdapEntry> mbrEntries = null;
                                try {
                                    mbrEntries = this.iLdapConn.searchEntities(string, entityTypeFilter, null, 0, mbrTypesWithGroup, supportedProps, false, true);
                                    if (mbrEntries == null || mbrEntries.size() <= 0) break block34;
                                    for (LdapEntry mbrEntity22 : mbrEntries) {
                                    }
                                }
                                catch (EntityNotFoundException e) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)("getMembersByMember Group member " + string + " is not found and ignored."), (Object[])new Object[0]);
                                    continue;
                                }
                            }
                            if (mbrEntity22 == null) continue;
                            String mbrType = mbrEntity22.getType();
                            if (mbrType != null) {
                                RDNCheckType.clear();
                                RDNCheckType.add(mbrType);
                                if (!this.startWithSameRDN(string, RDNCheckType, nested)) continue;
                            }
                            if (LdapHelper.isEntityTypeInList(mbrType, mbrTypes)) {
                                List<String> supportedProps1 = this.iLdapConfigMgr.getSupportedProperties(mbrType, propNames);
                                if (!mbrMap.containsKey(mbrEntity22.getUniqueName())) {
                                    this.createEntityFromLdapEntry(entity, "members", mbrEntity22, supportedProps1);
                                }
                                mbrMap.put(mbrEntity22.getUniqueName(), null);
                            }
                            if (!nested || !this.iLdapConfigMgr.isGroup(mbrType) || (mbrAttr = this.iLdapConfigMgr.getGroupMemberAttrs(mbrAttrs = mbrEntity22.getAttributes(), mbrAttrs.get("objectClass"))) == null) continue;
                            for (int loop = 0; loop < mbrAttr.length; ++loop) {
                                grpDNAttrs.put(string.toLowerCase(), mbrAttr[loop]);
                            }
                        }
                    }
                }
                if (!nested) break block35;
                HashSet<Object> groupsToDo = new HashSet(grpDNAttrs.keySet());
                while (groupsToDo.size() > 0) {
                    HashSet<String> nextGroups = new HashSet<String>();
                    for (String string : groupsToDo) {
                        String grpKey = string.toLowerCase();
                        memberAttr = (Attribute)grpDNAttrs.get(grpKey);
                        if (memberAttr == null) continue;
                        NamingEnumeration<?> enu = memberAttr.getAll();
                        while (enu.hasMoreElements()) {
                            LdapEntry mbrEntity32;
                            String key;
                            String dn;
                            block36: {
                                dn = (String)enu.next();
                                if ((dn = LdapHelper.getValidDN(dn)) == null) continue;
                                key = dn.toLowerCase();
                                if (this.iLdapConfigMgr.isDummyMember(dn) || !LdapHelper.isUnderBases(dn, bases) || !this.startWithSameRDN(dn, mbrTypes, nested) || grpDNAttrs.containsKey(key)) continue;
                                mbrEntity32 = null;
                                Set<LdapEntry> mbrEntries = null;
                                try {
                                    mbrEntries = this.iLdapConn.searchEntities(dn, entityTypeFilter, null, 0, mbrTypesWithGroup, supportedProps, false, true);
                                    if (mbrEntries == null || mbrEntries.size() <= 0) break block36;
                                    for (LdapEntry mbrEntity32 : mbrEntries) {
                                    }
                                }
                                catch (EntityNotFoundException e) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)("getMembersByMember Group member " + dn + " is not found and ignored."), (Object[])new Object[0]);
                                    continue;
                                }
                            }
                            if (mbrEntity32 == null) continue;
                            String mbrType = mbrEntity32.getType();
                            if (LdapHelper.isEntityTypeInList(mbrType, mbrTypes)) {
                                List<String> supportedProps2 = this.iLdapConfigMgr.getSupportedProperties(mbrType, propNames);
                                if (!mbrMap.containsKey(mbrEntity32.getUniqueName())) {
                                    this.createEntityFromLdapEntry(entity, "members", mbrEntity32, supportedProps2);
                                }
                                mbrMap.put(mbrEntity32.getUniqueName(), null);
                            }
                            if (!nested || !this.iLdapConfigMgr.isGroup(mbrType)) continue;
                            Attributes mbrAttrs = mbrEntity32.getAttributes();
                            Attribute[] mbrAttr = this.iLdapConfigMgr.getGroupMemberAttrs(mbrAttrs, mbrAttrs.get("objectClass"));
                            if (mbrAttr != null) {
                                for (int loop = 0; loop < mbrAttr.length; ++loop) {
                                    grpDNAttrs.put(dn.toLowerCase(), mbrAttr[loop]);
                                }
                            }
                            if (groupsToDo.contains(key)) continue;
                            nextGroups.add(key);
                        }
                    }
                    groupsToDo = nextGroups;
                }
            }
            catch (NamingException groupsToDo) {
                void e;
                FFDCFilter.processException((Throwable)groupsToDo, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"2334", (Object)((Object)this), (Object[])new Object[]{entity, ldapEntry, bases, level, propNames, mbrTypes});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
        }
    }

    @Trivial
    private boolean startWithSameRDN(String dn, List<String> mbrTypes, boolean nested) {
        dn = dn.toLowerCase();
        boolean containGrp = false;
        for (int i = 0; i < mbrTypes.size(); ++i) {
            String mbrType = mbrTypes.get(i);
            if (this.iLdapConfigMgr.isGroup(mbrType)) {
                containGrp = true;
            }
            if (!this.iLdapConfigMgr.getLdapEntity(mbrType).startWithSameRDN(dn)) continue;
            return true;
        }
        return nested && !containGrp && this.iLdapConfigMgr.getLdapEntity("Group").startWithSameRDN(dn);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getDynamicMembers(Attribute groupMemberURLs) throws WIMException {
        String METHODNAME = "getDynamicMembers";
        ArrayList<String> memberDNs = new ArrayList<String>();
        if (groupMemberURLs != null) {
            try {
                NamingEnumeration<?> enu = groupMemberURLs.getAll();
                while (enu.hasMoreElements()) {
                    String ldapurlStr = (String)enu.nextElement();
                    if (ldapurlStr != null) {
                        String searchFilter;
                        LdapURL ldapURL = new LdapURL(ldapurlStr);
                        if (!ldapURL.parsedOK()) continue;
                        int searchScope = 0;
                        String scopeBuf = ldapURL.get_scope();
                        if (scopeBuf != null) {
                            if (scopeBuf.compareToIgnoreCase("base") == 0) {
                                searchScope = 0;
                            } else if (scopeBuf.compareToIgnoreCase("one") == 0) {
                                searchScope = 1;
                            } else if (scopeBuf.compareToIgnoreCase("sub") == 0) {
                                searchScope = 2;
                            }
                        }
                        if ((searchFilter = ldapURL.get_filter()) == null) {
                            searchFilter = "(objectClass=*)";
                        }
                        String searchBase = ldapURL.get_dn();
                        String[] attributesToReturn = ldapURL.get_attributes();
                        NamingEnumeration<SearchResult> nenu = this.iLdapConn.search(searchBase, searchFilter, searchScope, attributesToReturn);
                        while (nenu.hasMoreElements()) {
                            SearchResult thisEntry = (SearchResult)nenu.nextElement();
                            if (thisEntry == null) continue;
                            String dynaMbrDN = LdapHelper.prepareDN(thisEntry.getName(), searchBase);
                            memberDNs.add(dynaMbrDN);
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"getDynamicMembers LDAP URL=null.", (Object[])new Object[0]);
                }
            }
            catch (NamingException enu) {
                void e;
                FFDCFilter.processException((Throwable)enu, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"2417", (Object)((Object)this), (Object[])new Object[]{groupMemberURLs});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
        }
        return memberDNs;
    }

    private void getDescendants(Entity entity, LdapEntry ldapEntry, DescendantControl descCtrl) throws WIMException {
        if (descCtrl == null) {
            return;
        }
        List propNames = descCtrl.getProperties();
        int level = descCtrl.getLevel();
        List<String> descTypes = this.getEntityTypes(descCtrl);
        String[] bases = this.getBases(descCtrl, descTypes);
        boolean treeView = descCtrl.isSetTreeView();
        int scope = 1;
        if (level == 0 && !treeView) {
            scope = 2;
        }
        HashSet<String> descToDo = new HashSet<String>();
        HashMap<String, Entity> descendants = new HashMap<String, Entity>();
        Set<LdapEntry> descEntries = this.iLdapConn.searchEntities(ldapEntry.getDN(), "objectClass=*", null, scope, descTypes, propNames, false, false);
        for (LdapEntry descEntry : descEntries) {
            String descType = descEntry.getType();
            String descDn = descEntry.getDN();
            Entity descendant = null;
            if (LdapHelper.isUnderBases(descDn, bases) && descTypes.contains(descType)) {
                descendant = this.createEntityFromLdapEntry(entity, "children", descEntry, propNames);
            } else if (treeView) {
                descendant = this.createEntityFromLdapEntry(entity, "children", descEntry, null);
            }
            if (!treeView) continue;
            descToDo.add(descDn);
            descendants.put(descDn, descendant);
        }
        if (treeView) {
            while (descToDo.size() > 0) {
                HashSet<String> nextDescs = new HashSet<String>();
                for (String dn : descToDo) {
                    Entity parent = (Entity)descendants.get(dn);
                    descEntries = this.iLdapConn.searchEntities(dn, "objectClass=*", null, scope, descTypes, propNames, false, false);
                    for (LdapEntry descEntry : descEntries) {
                        String descType = descEntry.getType();
                        String descDn = descEntry.getDN();
                        Entity descendant = null;
                        if (descTypes.contains(descType)) {
                            descendant = this.createEntityFromLdapEntry(parent, "children", descEntry, propNames);
                        } else if (treeView) {
                            descendant = this.createEntityFromLdapEntry(parent, "children", descEntry, null);
                        }
                        if (descToDo.contains(descDn)) continue;
                        nextDescs.add(descDn);
                        descendants.put(descDn, descendant);
                    }
                }
                descToDo = nextDescs;
            }
        }
    }

    private List<String> getEntityTypes(DescendantControl ctrl) throws WIMException {
        String searchExpr = ctrl.getExpression();
        HashSet<String> mbrTypes = new HashSet<String>();
        if (searchExpr != null && searchExpr.trim().length() > 0) {
            WIMXPathInterpreter parser = new WIMXPathInterpreter((Reader)new StringReader(searchExpr));
            try {
                parser.parse(null);
            }
            catch (com.ibm.ws.security.wim.xpath.ParseException parseException) {
                FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"2503", (Object)((Object)this), (Object[])new Object[]{ctrl});
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
            }
            catch (TokenMgrError e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"2508", (Object)((Object)this), (Object[])new Object[]{ctrl});
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
            }
            List mbrTypeList = parser.getEntityTypes();
            mbrTypes.addAll(mbrTypeList);
        } else {
            List<LdapEntity> ldapEntities = this.iLdapConfigMgr.getLdapEntities();
            for (int i = 0; i < ldapEntities.size(); ++i) {
                mbrTypes.add(ldapEntities.get(i).getName());
            }
        }
        return new ArrayList<String>(mbrTypes);
    }

    private String[] getBases(DescendantControl ctrl, List<String> mbrTypes) throws WIMException {
        String[] bases = null;
        List searchBaseList = ctrl.getSearchBases();
        int size = searchBaseList.size();
        if (size > 0) {
            bases = searchBaseList.toArray(new String[0]);
            bases = NodeHelper.getTopNodes((String[])bases);
            for (int i = 0; i < bases.length; ++i) {
                String dn;
                String uName = bases[i];
                bases[i] = dn = this.getDN(uName, null, null, true, false);
                bases = NodeHelper.getTopNodes((String[])bases);
            }
        } else {
            ArrayList<? extends String> searchBases = new ArrayList<String>();
            if (mbrTypes == null) {
                bases = this.iLdapConfigMgr.getTopLdapNodes();
            } else {
                for (int i = 0; i < mbrTypes.size(); ++i) {
                    LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(mbrTypes.get(i));
                    if (ldapEntity == null) {
                        bases = this.iLdapConfigMgr.getTopLdapNodes();
                        break;
                    }
                    searchBases.addAll(ldapEntity.getSearchBaseList());
                }
                if (bases == null) {
                    bases = searchBases.toArray(new String[0]);
                    bases = NodeHelper.getTopNodes((String[])bases);
                }
            }
        }
        return bases;
    }

    private void getAncestors(Entity entity, LdapEntry ldapEntry, AncestorControl ancesCtrl) throws WIMException {
        if (ancesCtrl == null) {
            return;
        }
        List propNames = ancesCtrl.getProperties();
        int level = ancesCtrl.getLevel();
        List<String> ancesTypes = this.getEntityTypes((SearchControl)ancesCtrl);
        String[] bases = this.getBases((SearchControl)ancesCtrl, ancesTypes);
        String dn = ldapEntry.getDN();
        List<String> ancestorDns = this.iLdapConn.getAncestorDNs(dn, level);
        Entity parentEntity = entity;
        for (int i = 0; i < ancestorDns.size(); ++i) {
            String ancesDn = ancestorDns.get(i);
            if (ancesDn.length() == 0 || !LdapHelper.isUnderBases(ancesDn, bases)) continue;
            LdapEntry ancesEntry = this.iLdapConn.getEntityByIdentifier(ancesDn, null, null, ancesTypes, propNames, false, false);
            String ancesType = ancesEntry.getType();
            Entity ancestor = null;
            ancestor = ancesTypes.contains(ancesType) ? this.createEntityFromLdapEntry(parentEntity, "parent", ancesEntry, propNames) : this.createEntityFromLdapEntry(parentEntity, "parent", ancesEntry, null);
            parentEntity = ancestor;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMemberInGroup(Entity inEntity, LdapEntry inEntry, int level) throws WIMException {
        List grps = inEntity.getGroups();
        LdapEntry memberEntry = null;
        String grpDN = null;
        if (grps.size() > 0) {
            memberEntry = inEntry;
            Group grp = (Group)grps.get(0);
            LdapEntry grpEntry = this.iLdapConn.getEntityByIdentifier(grp.getIdentifier(), null, null, false, false);
            if (!this.iLdapConfigMgr.isGroup(grpEntry.getType())) {
                throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IS_NOT_A_GROUP", (Object[])WIMMessageHelper.generateMsgParms((Object)grpEntry.getUniqueName())));
            }
            grpDN = grpEntry.getDN();
        } else {
            if (!this.iLdapConfigMgr.isGroup(inEntry.getType())) return false;
            List mbrs = ((Group)inEntity).getMembers();
            if (mbrs.size() <= 0) return false;
            Entity mbr = (Entity)mbrs.get(0);
            memberEntry = this.iLdapConn.getEntityByIdentifier(mbr.getIdentifier(), null, null, true, false);
            grpDN = inEntry.getDN();
        }
        String[] grpBases = this.iLdapConfigMgr.getGroupSearchBases();
        if (this.iLdapConfigMgr.getMembershipAttribute() == null) return this.getGroupsByMember(null, memberEntry, grpBases, level, null, grpDN);
        if (!this.iLdapConfigMgr.isRacf()) return this.getGroupsByMembership(null, memberEntry, grpBases, level, null, grpDN);
        return this.getGroupsByMembershipRacf(null, memberEntry, grpBases, level, null, grpDN);
    }

    public static Set<String> getSpecifiedRealms(Root root) {
        HashSet<String> result = new HashSet<String>();
        List contexts = root.getContexts();
        for (Context context : contexts) {
            String key = context.getKey();
            if (key == null || !key.equals(REALM)) continue;
            String value = (String)context.getValue();
            result.add(value);
        }
        return result;
    }

    public static String getContextProperty(Root root, String propertyName) {
        String result = "";
        List contexts = root.getContexts();
        for (Context context : contexts) {
            String key = context.getKey();
            if (key == null || !key.equals(propertyName)) continue;
            result = (String)context.getValue();
            break;
        }
        return result;
    }

    private LdapSearchControl getLdapSearchControl(SearchControl searchControl, boolean isSearchBaseSetByClient, boolean ignoreDNBaseSearch) throws WIMException {
        boolean isEntityBaseConfigured;
        String METHODNAME = "getLdapSearchControl";
        List propNames = searchControl.getProperties();
        int countLimit = searchControl.getCountLimit();
        int timeLimit = searchControl.getTimeLimit();
        boolean returnSubTypes = searchControl.isReturnSubType();
        String searchExpr = searchControl.getExpression();
        HashSet<String> entityTypes = new HashSet<String>();
        ArrayList<String> entityTypeList = null;
        String filter = null;
        boolean pNameSearch = false;
        String pNameBase = null;
        if (searchExpr != null && searchExpr.trim().length() > 0) {
            WIMXPathInterpreter parser = new WIMXPathInterpreter((Reader)new StringReader(searchExpr));
            try {
                XPathNode node = parser.parse(null);
                List typeList = parser.getEntityTypes();
                if (returnSubTypes) {
                    for (int i = 0; i < typeList.size(); ++i) {
                        String entityType = (String)typeList.get(i);
                        entityTypes.add(entityType);
                        List<String> subTypes = this.iLdapConfigMgr.getLdapSubEntityTypes(entityType);
                        entityTypes.addAll(subTypes);
                    }
                } else {
                    entityTypes.addAll(typeList);
                }
                entityTypeList = new ArrayList<String>(entityTypes);
                if (node != null) {
                    HashMap propNodeMap = new HashMap();
                    Iterator iter = node.getPropertyNodes(propNodeMap);
                    while (iter.hasNext()) {
                        PropertyNode pNode = (PropertyNode)iter.next();
                        String propName = pNode.getName();
                        if (!propName.equals("principalName")) continue;
                        if (propNodeMap.size() > 1) {
                            String msg = Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS", (Object[])new Object[]{null});
                            throw new SearchControlException("CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS", msg);
                        }
                        pNameSearch = true;
                        break;
                    }
                }
                if (pNameSearch) {
                    if (node.getNodeType() != 0) {
                        String msg = Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS", (Object[])new Object[]{null});
                        throw new SearchControlException("CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS", msg);
                    }
                    PropertyNode pNameNode = (PropertyNode)node;
                    String value = (String)pNameNode.getValue();
                    String uName = UniqueNameHelper.getValidUniqueName((String)value);
                    if (uName == null || ignoreDNBaseSearch) {
                        filter = this.getPrincipalNameFilter(value);
                    }
                    pNameBase = this.getDN(uName, "PersonAccount", null, true, false);
                }
                filter = this.getSearchFilter(entityTypes, node);
            }
            catch (com.ibm.ws.security.wim.xpath.ParseException node) {
                FFDCFilter.processException((Throwable)node, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"2759", (Object)((Object)this), (Object[])new Object[]{searchControl, isSearchBaseSetByClient, ignoreDNBaseSearch});
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
            }
            catch (TokenMgrError e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"2764", (Object)((Object)this), (Object[])new Object[]{searchControl, isSearchBaseSetByClient, ignoreDNBaseSearch});
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
            }
        } else {
            List<LdapEntity> ldapEntities = this.iLdapConfigMgr.getLdapEntities();
            for (int i = 0; i < ldapEntities.size(); ++i) {
                entityTypes.add(ldapEntities.get(i).getName());
            }
        }
        filter = filter != null ? "(&" + this.iLdapConfigMgr.getEntityTypesFilter(entityTypes) + filter + ")" : this.iLdapConfigMgr.getEntityTypesFilter(entityTypes);
        if (entityTypeList != null && entityTypeList.size() > 0 && (isEntityBaseConfigured = this.isEntitySearchBaseConfigured((List<String>)entityTypeList)) && !isSearchBaseSetByClient) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getLdapSearchControl Entity search base is configured, so realm search base will be ignored", (Object[])new Object[0]);
            }
            searchControl.getSearchBases().clear();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getLdapSearchControl Search base has been changed to entity search base", (Object[])new Object[0]);
            }
        }
        if (isSearchBaseSetByClient && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLdapSearchControl Search base explicitly set by client, so configured search bases will be ignored", (Object[])new Object[0]);
        }
        String[] bases = this.getBases(searchControl, (List<String>)entityTypeList);
        if (pNameBase != null) {
            bases = !LdapHelper.isUnderBases(pNameBase, bases) ? new String[]{} : new String[]{pNameBase};
        }
        int iTimeLimit = this.iLdapConn.getSearchTimeout();
        if (timeLimit <= 0) {
            timeLimit = iTimeLimit;
        } else if (iTimeLimit < timeLimit) {
            timeLimit = iTimeLimit;
        }
        LdapSearchControl ldapSearchCtrl = new LdapSearchControl(bases, entityTypeList, filter, propNames, countLimit, timeLimit);
        if (pNameBase != null) {
            ldapSearchCtrl.setScope(0);
        }
        return ldapSearchCtrl;
    }

    private String getPrincipalNameFilter(String principalName) {
        List<String> loginAttrs = this.iLdapConfigMgr.getLoginAttributes();
        principalName = Rdn.escapeValue(principalName);
        StringBuffer filter = new StringBuffer();
        if (loginAttrs != null) {
            if (loginAttrs.size() > 1) {
                filter.append("(|");
            }
            for (int i = 0; i < loginAttrs.size(); ++i) {
                filter.append("(" + loginAttrs.get(i) + "=" + principalName + ")");
            }
            if (loginAttrs.size() > 1) {
                filter.append(")");
            }
        }
        return filter.toString();
    }

    private String getSearchFilter(Set<String> entityTypes, XPathNode node) throws WIMException {
        String filter = null;
        StringBuffer propsFilter = new StringBuffer();
        if (node != null) {
            LdapXPathTranslateHelper helper = new LdapXPathTranslateHelper(entityTypes, this.iLdapConfigMgr);
            helper.genSearchString(propsFilter, node);
            if (propsFilter.length() > 0 && (propsFilter.charAt(0) != '(' || propsFilter.charAt(propsFilter.length() - 1) != ')')) {
                propsFilter.insert(0, '(');
                propsFilter.append(')');
            }
            filter = propsFilter.toString();
        }
        return filter;
    }

    private boolean isEntitySearchBaseConfigured(List<String> mbrTypes) {
        String METHODNAME = "isEntitySearchBaseConfigured(mbrTypes)";
        boolean isConfigured = false;
        if (mbrTypes != null) {
            for (String mbrType : mbrTypes) {
                LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(mbrType);
                if (ldapEntity == null || !ldapEntity.isSearchBaseConfigured()) continue;
                isConfigured = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Search base is explicitly configured for " + mbrType + ": " + ldapEntity.getSearchBaseList()), (Object[])new Object[0]);
            }
        }
        return isConfigured;
    }

    @FFDCIgnore(value={EntityNotFoundException.class, CertificateMapNotSupportedException.class, CertificateMapFailedException.class})
    private LdapEntry mapCertificate(X509Certificate[] certs, LdapSearchControl srchCtrl) throws WIMException {
        LdapEntry result = null;
        String dn = null;
        String filter = null;
        String certMapMode = this.iLdapConfigMgr.getCertificateMapMode();
        if ("NOT_SUPPORTED".equalsIgnoreCase(certMapMode)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Certificate authentication has been disabled for this LDAP registry.", (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_REGISTRY_CERT_IGNORED", (Object[])new Object[0]);
            throw new com.ibm.wsspi.security.wim.exception.CertificateMapNotSupportedException("LDAP_REGISTRY_CERT_IGNORED", msg);
        }
        if ("CUSTOM".equalsIgnoreCase(certMapMode)) {
            String mapping;
            try {
                X509CertificateMapper mapper = this.iCertificateMapperRef.get();
                if (mapper == null) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_REGISTRY_MAPPER_NOT_BOUND", (Object[])new Object[0]);
                    throw new com.ibm.wsspi.security.wim.exception.CertificateMapFailedException("LDAP_REGISTRY_MAPPER_NOT_BOUND", msg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using custom X.509 certificate mapper: " + mapper.getClass()), (Object[])new Object[0]);
                }
                mapping = mapper.mapCertificate(certs);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The custom X.509 certificate mapper returned the following mapping: " + mapping), (Object[])new Object[0]);
                }
            }
            catch (CertificateMapNotSupportedException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_REGISTRY_CUSTOM_MAPPER_NOT_SUPPORTED", (Object[])new Object[0]);
                throw new com.ibm.wsspi.security.wim.exception.CertificateMapNotSupportedException("LDAP_REGISTRY_CUSTOM_MAPPER_NOT_SUPPORTED", msg, (Throwable)e);
            }
            catch (CertificateMapFailedException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_REGISTRY_CUSTOM_MAPPER_FAILED", (Object[])new Object[0]);
                throw new com.ibm.wsspi.security.wim.exception.CertificateMapFailedException("LDAP_REGISTRY_CUSTOM_MAPPER_FAILED", msg, (Throwable)e);
            }
            if (mapping == null || mapping.trim().isEmpty()) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_REGISTRY_INVALID_MAPPING", (Object[])new Object[0]);
                throw new com.ibm.wsspi.security.wim.exception.CertificateMapFailedException("LDAP_REGISTRY_INVALID_MAPPING", msg);
            }
            dn = LdapHelper.getValidDN(mapping);
            if (dn == null) {
                filter = mapping;
            }
        } else if ("CERTIFICATE_FILTER".equalsIgnoreCase(certMapMode)) {
            filter = this.iLdapConfigMgr.getCertificateLDAPFilter(certs[0]).trim();
        } else {
            dn = LdapHelper.getValidDN(certs[0].getSubjectX500Principal().getName());
        }
        if (dn != null) {
            try {
                result = this.iLdapConn.getEntityByIdentifier(dn, null, null, null, srchCtrl.getPropertyNames(), false, false);
            }
            catch (EntityNotFoundException mapping) {}
        } else {
            String[] searchBases = srchCtrl.getBases();
            int countLimit = srchCtrl.getCountLimit();
            int timeLimit = srchCtrl.getTimeLimit();
            List<String> entityTypes = srchCtrl.getEntityTypes();
            List<String> propNames = srchCtrl.getPropertyNames();
            int scope = srchCtrl.getScope();
            int count = 0;
            for (int i = 0; i < searchBases.length; ++i) {
                try {
                    Set<LdapEntry> ldapEntries = this.iLdapConn.searchEntities(searchBases[i], filter, null, scope, entityTypes, propNames, false, false, countLimit, timeLimit);
                    if (ldapEntries.size() > 1) {
                        String msg = Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)filter));
                        throw new com.ibm.wsspi.security.wim.exception.CertificateMapFailedException("MULTIPLE_PRINCIPALS_FOUND", msg);
                    }
                    if (ldapEntries.size() != 1) continue;
                    if (count == 0) {
                        result = ldapEntries.iterator().next();
                    }
                    if (++count <= 1) continue;
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)filter));
                    throw new com.ibm.wsspi.security.wim.exception.CertificateMapFailedException("MULTIPLE_PRINCIPALS_FOUND", msg);
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={AuthenticationException.class})
    private void authenticateWithPassword(String dn, byte[] pwd, String principalName) throws WIMException {
        try {
            TimedDirContext ctx = null;
            ctx = this.iLdapConfigMgr.isSetUsePrincipalNameForLogin() ? this.iLdapConn.getContextManager().createDirContext(principalName, pwd) : this.iLdapConn.getContextManager().createDirContext(dn, pwd);
            ctx.close();
        }
        catch (AuthenticationNotSupportedException ctx) {
            void e;
            FFDCFilter.processException((Throwable)ctx, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3029", (Object)((Object)this), (Object[])new Object[]{dn, pwd, principalName});
            throw new com.ibm.wsspi.security.wim.exception.AuthenticationNotSupportedException("AUTHENTICATE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"AUTHENTICATE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)e.toString(true))));
        }
        catch (AuthenticationException e) {
            throw new PasswordCheckFailedException("PASSWORD_CHECKED_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"PASSWORD_CHECKED_FAILED", (Object[])WIMMessageHelper.generateMsgParms((Object)principalName, (Object)e.toString(true))));
        }
        catch (NameNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3039", (Object)((Object)this), (Object[])new Object[]{dn, pwd, principalName});
            throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)dn, (Object)e.toString(true))));
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3044", (Object)((Object)this), (Object[])new Object[]{dn, pwd, principalName});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
    }

    public String getRealm() {
        return this.reposRealm;
    }

    public Root delete(Root root) throws WIMException {
        Map ctrlMap = ControlsHelper.getControlMap((Root)root);
        DeleteControl deleteCtrl = (DeleteControl)ctrlMap.get("DeleteControl");
        boolean delDesc = false;
        if (deleteCtrl != null) {
            delDesc = deleteCtrl.isDeleteDescendants();
        }
        Entity inEntity = (Entity)root.getEntities().get(0);
        IdentifierType inId = inEntity.getIdentifier();
        LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(inId, null, null, false, false);
        Root outRoot = new Root();
        List<LdapEntry> delEntries = this.deleteAll(ldapEntry, delDesc);
        for (int i = 0; i < delEntries.size(); ++i) {
            LdapEntry delEntry = delEntries.get(i);
            this.createEntityFromLdapEntry(outRoot, "entities", delEntry, null);
            this.updateGroupMember(ldapEntry.getDN(), null);
            this.iLdapConn.invalidateAttributes(delEntry.getDN(), delEntry.getExtId(), delEntry.getUniqueName());
        }
        this.iLdapConn.invalidateSearchCache();
        return outRoot;
    }

    private List<LdapEntry> deleteAll(LdapEntry ldapEntry, boolean delDescendant) throws WIMException {
        String dn = ldapEntry.getDN();
        ArrayList<LdapEntry> delEntries = new ArrayList<LdapEntry>();
        List<LdapEntry> descs = this.getDescendants(dn, 1);
        if (descs.size() > 0) {
            if (delDescendant) {
                for (int i = 0; i < descs.size(); ++i) {
                    LdapEntry descEntry = descs.get(i);
                    delEntries.addAll(this.deleteAll(descEntry, true));
                }
            } else {
                throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_HAS_DESCENDENTS", (Object[])WIMMessageHelper.generateMsgParms((Object)dn)));
            }
        }
        this.deletePreExit(dn);
        List<String> grpList = this.getGroups(dn);
        this.iLdapConn.getContextManager().destroySubcontext(dn);
        delEntries.add(ldapEntry);
        for (int i = 0; i < grpList.size(); ++i) {
            String grpDN = grpList.get(i);
            this.iLdapConn.invalidateAttributes(grpDN, null, null);
        }
        return delEntries;
    }

    protected void deletePreExit(String ldapDN) throws WIMException {
    }

    private List<LdapEntry> getDescendants(String DN, int level) throws WIMException {
        int scope = 1;
        if (level == 0) {
            scope = 2;
        }
        ArrayList<LdapEntry> descendants = new ArrayList<LdapEntry>();
        Set<LdapEntry> ldapEntries = this.iLdapConn.searchEntities(DN, "objectClass=*", null, scope, null, null, false, false);
        for (LdapEntry entry : ldapEntries) {
            descendants.add(entry);
        }
        return descendants;
    }

    private List<String> getGroups(String dn) throws WIMException {
        ArrayList<String> grpList = new ArrayList<String>();
        String filter = this.iLdapConfigMgr.getGroupMemberFilter(dn);
        String[] searchBases = this.iLdapConfigMgr.getGroupSearchBases();
        for (int i = 0; i < searchBases.length; ++i) {
            String searchBase = searchBases[i];
            NamingEnumeration<SearchResult> nenu = this.iLdapConn.search(searchBase, filter, 2, LdapConstants.LDAP_ATTR_OBJECTCLASS_ARRAY);
            while (nenu.hasMoreElements()) {
                String entryName;
                SearchResult thisEntry = (SearchResult)nenu.nextElement();
                if (thisEntry == null || (entryName = thisEntry.getName()) == null || entryName.trim().length() == 0) continue;
                grpList.add(LdapHelper.prepareDN(entryName, searchBase));
            }
        }
        return grpList;
    }

    /*
     * WARNING - void declaration
     */
    private void updateGroupMember(String oldDN, String newDN) throws WIMException {
        if (!this.iLdapConfigMgr.updateGroupMembership()) {
            return;
        }
        String filter = this.iLdapConfigMgr.getGroupMemberFilter(oldDN);
        String[] mbrAttrs = this.iLdapConfigMgr.getMemberAttributes();
        HashMap<String, ModificationItem[]> mbrAttrMap = new HashMap<String, ModificationItem[]>(mbrAttrs.length);
        for (int i = 0; i < mbrAttrs.length; ++i) {
            String mbrAttr = mbrAttrs[i];
            ModificationItem removeAttr = new ModificationItem(3, new BasicAttribute(mbrAttr, oldDN));
            ModificationItem[] modifAttrs = null;
            if (newDN != null) {
                ModificationItem addAttr = new ModificationItem(1, new BasicAttribute(mbrAttr, newDN));
                modifAttrs = new ModificationItem[]{addAttr, removeAttr};
            } else {
                modifAttrs = new ModificationItem[]{removeAttr};
            }
            mbrAttrMap.put(mbrAttr.toLowerCase(), modifAttrs);
        }
        String[] searchBases = this.iLdapConfigMgr.getGroupSearchBases();
        for (int i = 0; i < searchBases.length; ++i) {
            String searchBase = searchBases[i];
            NamingEnumeration<SearchResult> nenu = this.iLdapConn.search(searchBase, filter, 2, LdapConstants.LDAP_ATTR_OBJECTCLASS_ARRAY);
            while (nenu.hasMoreElements()) {
                String entryName;
                SearchResult thisEntry = (SearchResult)nenu.nextElement();
                if (thisEntry == null || (entryName = thisEntry.getName()) == null || entryName.trim().length() == 0) continue;
                String DN = LdapHelper.prepareDN(entryName, searchBase);
                Attributes attrs = thisEntry.getAttributes();
                String[] thisMbrAttrs = this.iLdapConfigMgr.getMemberAttribute(attrs.get("objectClass"));
                if (thisMbrAttrs == null) continue;
                for (int j = 0; j < thisMbrAttrs.length; ++j) {
                    ModificationItem[] attrsTobeModify = (ModificationItem[])mbrAttrMap.get(thisMbrAttrs[j].toLowerCase());
                    if (attrsTobeModify == null) continue;
                    try {
                        this.iLdapConn.modifyAttributes(DN, attrsTobeModify);
                        continue;
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3246", (Object)((Object)this), (Object[])new Object[]{oldDN, newDN});
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Updating group " + DN + " for " + oldDN + " failed due to: " + e.toString()), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Root create(Root root) throws WIMException {
        String dummyMbr;
        String mbrAttrName;
        Entity entity = (Entity)root.getEntities().get(0);
        String typeName = entity.getTypeName();
        Root outRoot = new Root();
        IdentifierType id = entity.getIdentifier();
        String dn = id.getExternalName();
        String uniqueName = id.getUniqueName();
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(typeName);
        if (ldapEntity == null) {
            throw new EntityTypeNotSupportedException("ENTITY_TYPE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_TYPE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)typeName)));
        }
        String qEntityType = ldapEntity.getName();
        if (this.iLdapConfigMgr.isPersonAccount(qEntityType)) {
            if (entity.get("principalName") != null) {
                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)"principalName", (Object)this.reposId)));
            }
            if (entity.get(REALM) != null) {
                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)REALM, (Object)this.reposId)));
            }
        }
        List propertyNames = Entity.getPropertyNames((String)entity.getTypeName());
        BasicAttributes attrs = new BasicAttributes();
        List groups = null;
        List members = null;
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                if (entity.isMandatory(propertyName) && !entity.isSet(propertyName)) {
                    throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_MANDATORY_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)propertyName)));
                }
                if (!entity.isSet(propertyName)) continue;
                if (entity.isPersistentProperty(propertyName)) {
                    Set<Attribute> attrSet = this.getAttribute(entity, null, propertyName, ldapEntity);
                    Iterator<Attribute> iter = attrSet.iterator();
                    while (iter.hasNext()) {
                        attrs.put(iter.next());
                    }
                    continue;
                }
                if ("members".equals(propertyName)) {
                    members = ((Group)entity).getMembers();
                    continue;
                }
                if (!"groups".equals(propertyName)) continue;
                groups = entity.getGroups();
            }
        }
        if (dn == null) {
            dn = this.getDN(uniqueName, qEntityType, attrs, false, true);
        }
        Attribute objClsAttr = ldapEntity.getObjectClassAttribute(dn);
        attrs.put(objClsAttr);
        String extIdName = ldapEntity.getExtId();
        String extId = null;
        LdapAttribute extIdAttr = this.iLdapConfigMgr.getAttribute(extIdName);
        if (extIdAttr != null && extIdAttr.isWIMGenerate()) {
            extId = UniqueIdGenerator.newUniqueId();
            attrs.put(new BasicAttribute(extIdName, extId));
        }
        boolean isGroup = this.iLdapConfigMgr.isGroup(qEntityType);
        if (members != null && members.size() > 0) {
            if (!isGroup) {
                throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IS_NOT_A_GROUP", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName)));
            }
            mbrAttrName = this.iLdapConfigMgr.getMemberAttribute(objClsAttr)[0];
            if (members.size() > 0) {
                BasicAttribute attr = new BasicAttribute(mbrAttrName);
                for (int j = 0; j < members.size(); ++j) {
                    IdentifierType mbrId = ((Entity)members.get(j)).getIdentifier();
                    LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(mbrId, null, null, false, false);
                    String mbrDN = ldapEntry.getDN();
                    attr.add(mbrDN);
                }
                attrs.put(attr);
            }
        } else if (isGroup && (dummyMbr = this.iLdapConfigMgr.getDummyMember(mbrAttrName = this.iLdapConfigMgr.getMemberAttribute(objClsAttr)[0])) != null) {
            BasicAttribute attr = new BasicAttribute(mbrAttrName, dummyMbr);
            attrs.put(attr);
        }
        Set<String> valueAttrs = this.iLdapConfigMgr.getAttributesWithDefaultValue();
        for (String valueAttr : valueAttrs) {
            Object defaultValue;
            LdapAttribute ldapAttr = this.iLdapConfigMgr.getLdapAttribute(valueAttr);
            if (ldapAttr == null || (defaultValue = ldapAttr.getDefaultValue(qEntityType)) == null || LdapHelper.inAttributes(valueAttr, attrs)) continue;
            attrs.put(new BasicAttribute(ldapAttr.getName(), defaultValue));
        }
        Set<String> attrAttrs = this.iLdapConfigMgr.getAttributesWithDefaultAttribute();
        for (String attrAttr : attrAttrs) {
            Attribute attr;
            String defaultAttr;
            LdapAttribute ldapAttr = this.iLdapConfigMgr.getLdapAttribute(attrAttr);
            if (ldapAttr == null || (defaultAttr = ldapAttr.getDefaultAttribute(qEntityType)) == null || LdapHelper.inAttributes(attrAttr, attrs) || (attr = attrs.get(defaultAttr)) == null) continue;
            attrs.put(LdapHelper.cloneAttribute(ldapAttr.getName(), attr));
        }
        Attribute accCtrl = null;
        if (this.iLdapConfigMgr.getLdapType().equals("AD2003")) {
            accCtrl = attrs.remove("userAccountControl");
        }
        DirContext subCtx = this.iLdapConn.getContextManager().createSubcontext(dn, attrs);
        try {
            subCtx.close();
        }
        catch (NamingException ldapAttr) {
            void e;
            FFDCFilter.processException((Throwable)ldapAttr, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3403", (Object)((Object)this), (Object[])new Object[]{root});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
        if (accCtrl != null) {
            BasicAttributes accCtrlAttrs = new BasicAttributes();
            accCtrlAttrs.put(accCtrl);
            try {
                this.iLdapConn.modifyAttributes(dn, 2, accCtrlAttrs);
            }
            catch (NamingException defaultAttr) {
                void e;
                FFDCFilter.processException((Throwable)defaultAttr, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3412", (Object)((Object)this), (Object[])new Object[]{root});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
        }
        if (groups != null) {
            this.updateGroups(dn, groups, 1);
        }
        if (extId == null) {
            extId = this.getExtId(dn, extIdName, null);
        }
        this.iLdapConn.invalidateSearchCache();
        Entity returnEntity = new Entity();
        outRoot.getEntities().add(returnEntity);
        IdentifierType returnId = new IdentifierType();
        returnEntity.setIdentifier(returnId);
        if (this.iLdapConfigMgr.needTranslateRDN(typeName) && !this.iLdapConfigMgr.needTranslateRDN()) {
            returnId.setUniqueName(this.iLdapConfigMgr.switchToNode(dn));
        } else {
            returnId.setUniqueName(uniqueName);
        }
        returnId.setExternalName(dn);
        returnId.setExternalId(extId);
        return outRoot;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Attribute> getAttribute(Entity entity, Object values, String propertyName, LdapEntity ldapEntity) throws WIMException {
        HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>();
        ArrayList<String> props = new ArrayList<String>(1);
        props.add(propertyName);
        List<String> supportedProp = this.iLdapConfigMgr.getSupportedProperties(ldapEntity, props);
        if (supportedProp == null || supportedProp.size() == 0) {
            return new HashSet<Attribute>();
        }
        String attrName = this.iLdapConfigMgr.getAttributeName(ldapEntity, propertyName);
        String dataType = entity.getDataType(propertyName);
        LdapAttribute ldapAttr = this.iLdapConfigMgr.getLdapAttribute(attrName);
        String ldapType = this.iLdapConfigMgr.getLdapType();
        List<Object> attrValues = null;
        if (entity.get(propertyName) instanceof List) {
            attrValues = values != null ? (ArrayList<Object>)values : (List)entity.get(propertyName);
        } else if ("password".equalsIgnoreCase(propertyName)) {
            attrValues = new ArrayList<Object>(1);
            attrValues.add(new String((byte[])entity.get(propertyName)));
        } else {
            attrValues = new ArrayList(1);
            if (values != null) {
                attrValues.add(values);
            } else {
                attrValues.add(entity.get(propertyName));
            }
        }
        for (int i = 0; i < attrValues.size(); ++i) {
            String newAttrName = attrName;
            Object value = attrValues.get(i);
            Object ldapValue = null;
            if ("String".equals(dataType)) {
                ldapValue = LdapHelper.getStringLdapValue(value, ldapAttr, ldapType);
            } else if ("DateTime".equals(dataType)) {
                ldapValue = LdapHelper.getDateLdapValue(value, ldapAttr, ldapType);
            } else if ("IdentifierType".equals(dataType)) {
                if (value != null) {
                    IdentifierType id = (IdentifierType)value;
                    try {
                        LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(id, null, null, false, false);
                        ldapValue = ldapEntry.getDN();
                    }
                    catch (EntityNotFoundException ldapEntry) {
                        void e;
                        FFDCFilter.processException((Throwable)ldapEntry, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3492", (Object)((Object)this), (Object[])new Object[]{entity, values, propertyName, ldapEntity});
                        e.getMessage();
                        throw new InvalidPropertyValueException("INVALID_PROPERTY_VALUE", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_PROPERTY_VALUE", (Object[])WIMMessageHelper.generateMsgParms((Object)propertyName, (Object)entity.getTypeName())));
                    }
                }
            } else if ("Base64Binary".equals(dataType)) {
                ldapValue = ldapAttr != null && "unicodePwd".equalsIgnoreCase(ldapAttr.getSyntax()) ? (Object)LdapHelper.encodePassword(new String((byte[])value)) : value;
            } else if ("Int".equals(dataType)) {
                ldapValue = LdapHelper.getIntLdapValue(value, ldapAttr, ldapType);
            } else if ("LangType".equals(dataType)) {
                LangType langDO = (LangType)value;
                ldapValue = langDO.getValue();
            } else {
                ldapValue = value.toString();
            }
            if (ldapValue == null) continue;
            Attribute attr = (Attribute)attrMap.get(newAttrName);
            if (attr == null) {
                attr = new BasicAttribute(newAttrName);
                attrMap.put(newAttrName, attr);
            }
            attr.add(ldapValue);
        }
        HashSet<Attribute> attrSet = new HashSet<Attribute>(attrMap.values());
        return attrSet;
    }

    @FFDCIgnore(value={NoSuchAttributeException.class, OperationNotSupportedException.class, AttributeInUseException.class, NameAlreadyBoundException.class})
    private void updateGroups(String mbrDn, List<Group> groups, int modifiedMode) throws WIMException {
        String METHODNAME = "updateGroups(String, List, int)";
        if (groups.size() > 0) {
            String mbrAttr = null;
            List<String> grpTypes = this.iLdapConfigMgr.getGroupTypes();
            for (Group group : groups) {
                String dn;
                LdapEntry ldapEntry;
                block23: {
                    IdentifierType id = group.getIdentifier();
                    ldapEntry = this.iLdapConn.getEntityByIdentifier(id, grpTypes, null, false, false);
                    if (!this.iLdapConfigMgr.isGroup(ldapEntry.getType())) {
                        throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IS_NOT_A_GROUP", (Object[])WIMMessageHelper.generateMsgParms((Object)id.getUniqueName())));
                    }
                    dn = ldapEntry.getDN();
                    if (mbrAttr == null) {
                        Attributes attrs = ldapEntry.getAttributes();
                        Attribute objClsAttr = attrs.get("objectClass");
                        mbrAttr = this.iLdapConfigMgr.getMemberAttribute(objClsAttr)[0];
                    }
                    BasicAttributes grpMbrAttrs = new BasicAttributes();
                    BasicAttribute grpMbrAttr = new BasicAttribute(mbrAttr, mbrDn);
                    grpMbrAttrs.put(grpMbrAttr);
                    try {
                        if (3 == modifiedMode) {
                            try {
                                this.iLdapConn.modifyAttributes(dn, 3, grpMbrAttrs);
                            }
                            catch (NoSuchAttributeException e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("updateGroups(String, List, int) Entity " + mbrDn + " is already not a member of group " + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                                }
                                break block23;
                            }
                            catch (OperationNotSupportedException e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("updateGroups(String, List, int) Entity " + mbrDn + " is already not a member of group " + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                                }
                                break block23;
                            }
                        }
                        if (2 == modifiedMode) {
                            try {
                                this.iLdapConn.modifyAttributes(dn, 2, grpMbrAttrs);
                            }
                            catch (NoSuchAttributeException e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("updateGroups(String, List, int) Entity " + mbrDn + " is already not a member of group " + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                                }
                                break block23;
                            }
                            catch (OperationNotSupportedException e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("updateGroups(String, List, int) Entity " + mbrDn + " is already not a member of group " + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                                }
                                break block23;
                            }
                        }
                        try {
                            this.iLdapConn.modifyAttributes(dn, 1, grpMbrAttrs);
                        }
                        catch (AttributeInUseException e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("updateGroups(String, List, int) Entity " + mbrDn + " is already a member of group " + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                            }
                        }
                        catch (NameAlreadyBoundException e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("updateGroups(String, List, int) Entity " + mbrDn + " is already a member of group" + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                            }
                        }
                    }
                    catch (NamingException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3601", (Object)((Object)this), (Object[])new Object[]{mbrDn, groups, modifiedMode});
                        throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
                    }
                }
                this.iLdapConn.invalidateAttributes(dn, ldapEntry.getExtId(), ldapEntry.getUniqueName());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getExtId(String dn, String extIdName, Attributes attrs) throws WIMException {
        if ("distinguishedName".equalsIgnoreCase(extIdName)) {
            return LdapHelper.toUpperCase(dn);
        }
        Attribute extIdAttr = null;
        if (attrs != null) {
            extIdAttr = attrs.get(extIdName);
        }
        if (extIdAttr == null) {
            String[] attrIds = new String[]{extIdName};
            attrs = this.iLdapConn.checkAttributesCache(dn, attrIds);
            extIdAttr = attrs.get(extIdName);
        }
        if (extIdAttr == null) {
            return LdapHelper.toUpperCase(dn);
        }
        if (extIdAttr.size() > 1) {
            throw new WIMSystemException("EXT_ID_HAS_MULTIPLE_VALUES", Tr.formatMessage((TraceComponent)tc, (String)"EXT_ID_HAS_MULTIPLE_VALUES", (Object[])WIMMessageHelper.generateMsgParms((Object)extIdAttr)));
        }
        LdapAttribute ldapAttr = this.iLdapConfigMgr.getAttribute(extIdName);
        try {
            Object val = extIdAttr.get();
            if (ldapAttr != null && "octetString".equalsIgnoreCase(ldapAttr.getSyntax())) {
                return LdapHelper.getOctetString((byte[])val);
            }
            if (ldapAttr != null && "GUID".equalsIgnoreCase(ldapAttr.getSyntax())) {
                return LdapHelper.convertToDashedString((byte[])val);
            }
            return val.toString();
        }
        catch (NamingException val) {
            void e;
            FFDCFilter.processException((Throwable)val, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3641", (Object)((Object)this), (Object[])new Object[]{dn, extIdName, attrs});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
    }

    public Root update(Root root) throws WIMException {
        String METHODNAME = "update";
        Map ctrlMap = ControlsHelper.getControlMap((Root)root);
        CacheControl cacheCtrl = (CacheControl)ctrlMap.get("CacheControl");
        if (cacheCtrl != null) {
            String cacheMode = cacheCtrl.getMode();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("update Cache Control is passed with mode " + cacheMode), (Object[])new Object[0]);
            }
            if (cacheMode != null && "clearAll".equalsIgnoreCase(cacheMode)) {
                this.iLdapConn.invalidateAttributeCache();
                this.iLdapConn.invalidateSearchCache();
                String uniqueName = this.getCallerUniqueName();
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"CLEAR_ALL_CLEAR_CACHE_MODE", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)cacheMode, (Object)uniqueName));
                }
            } else if (cacheMode != null && "clearEntity".equalsIgnoreCase(cacheMode)) {
                Entity inEntity = (Entity)root.getEntities().get(0);
                IdentifierType id = inEntity.getIdentifier();
                String externalName = id.getExternalName();
                String extId = id.getExternalId();
                String uniqueName = id.getUniqueName();
                this.iLdapConn.invalidateAttributes(externalName, extId, uniqueName);
                this.iLdapConn.invalidateSearchCache();
            } else if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"UNKNOWN_CLEAR_CACHE_MODE", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)cacheMode));
            }
            return null;
        }
        Root outRoot = this.updateEntity(root);
        return outRoot;
    }

    /*
     * WARNING - void declaration
     */
    private Root updateEntity(Root root) throws WIMException {
        String METHODNAME = "updateEntity";
        Root outRoot = new Root();
        Entity inEntity = (Entity)root.getEntities().get(0);
        String inEntityType = inEntity.getTypeName();
        if (inEntity.getSuperTypes().contains("LoginAccount") && inEntity.isSet("principalName")) {
            throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)"principalName", (Object)this.reposId)));
        }
        ArrayList<String> inEntityTypes = new ArrayList<String>(1);
        inEntityTypes.add(inEntityType);
        IdentifierType inId = inEntity.getIdentifier();
        LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(inId, inEntityTypes, null, false, false);
        String dn = ldapEntry.getDN();
        String extId = ldapEntry.getExtId();
        String uniqueName = ldapEntry.getUniqueName();
        String outEntityType = ldapEntry.getType();
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(outEntityType);
        Map ctrlMap = ControlsHelper.getControlMap((Root)root);
        GroupMemberControl grpMbrCtrl = (GroupMemberControl)ctrlMap.get("GroupMemberControl");
        GroupMembershipControl grpMbrshipCtrl = (GroupMembershipControl)ctrlMap.get("GroupMembershipControl");
        List propertyNames = Entity.getPropertyNames((String)inEntityType);
        ArrayList<ModificationItem> modItemList = new ArrayList<ModificationItem>();
        List groups = null;
        List members = null;
        String[] rdnAttrNames = LdapHelper.getRDNAttributes(dn);
        String[] rdnAttrValues = null;
        for (String propertyName : propertyNames) {
            boolean isSet = inEntity.isSet(propertyName);
            boolean isUnset = inEntity.isUnset(propertyName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateEntity Property '" + propertyName + "': Set? " + isSet + ", Unset? " + isUnset), (Object[])new Object[0]);
            }
            if (!isSet && !isUnset) continue;
            if (inEntity.isPersistentProperty(propertyName)) {
                Attribute attr;
                Object attrName;
                HashSet<Attribute> attrSet = null;
                if (isSet) {
                    attrSet = this.getAttribute(inEntity, null, propertyName, ldapEntity);
                } else if (isUnset && !this.isRDN((String)(attrName = this.iLdapConfigMgr.getAttributeName(ldapEntity, propertyName)), rdnAttrNames)) {
                    attr = new BasicAttribute((String)attrName);
                    attrSet = new HashSet<Attribute>();
                    attrSet.add(attr);
                }
                if (attrSet == null) continue;
                attrName = attrSet.iterator();
                while (attrName.hasNext()) {
                    attr = (Attribute)attrName.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("updateEntity Property '" + propertyName + "': Attribute: " + attr), (Object[])new Object[0]);
                    }
                    boolean isRdnAttr = false;
                    for (int j = 0; j < rdnAttrNames.length; ++j) {
                        if (!attr.getID().equalsIgnoreCase(rdnAttrNames[j])) continue;
                        if (rdnAttrValues == null) {
                            rdnAttrValues = new String[rdnAttrNames.length];
                        }
                        try {
                            rdnAttrValues[j] = (String)attr.get();
                        }
                        catch (NamingException namingException) {
                            void e;
                            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3792", (Object)((Object)this), (Object[])new Object[]{root});
                            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
                        }
                        catch (NoSuchElementException e) {
                            void nse;
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3795", (Object)((Object)this), (Object[])new Object[]{root});
                            nse.getMessage();
                            throw new UpdatePropertyException("MISSING_MANDATORY_PROPERTY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_MANDATORY_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)attr.getID())));
                        }
                        isRdnAttr = true;
                    }
                    if (isRdnAttr) continue;
                    if (isSet) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("updateEntity The following LDAP attribute is to be set: " + attr), (Object[])new Object[0]);
                        }
                        modItemList.add(new ModificationItem(2, attr));
                        continue;
                    }
                    if (!isUnset) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("updateEntity The following LDAP attribute is to be unset: " + attr), (Object[])new Object[0]);
                    }
                    modItemList.add(new ModificationItem(3, attr));
                }
                continue;
            }
            if ("members".equals(propertyName)) {
                members = ((Group)inEntity).getMembers();
                continue;
            }
            if (!"groups".equals(propertyName)) continue;
            groups = inEntity.getGroups();
        }
        boolean updateMbr = false;
        int grpMbrMode = 1;
        if (members != null && members.size() > 0) {
            if (!this.iLdapConfigMgr.isGroup(outEntityType)) {
                throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IS_NOT_A_GROUP", (Object[])WIMMessageHelper.generateMsgParms((Object)ldapEntry.getUniqueName())));
            }
            String[] mbrAttrNames = this.iLdapConfigMgr.getMemberAttribute(ldapEntry.getAttributes().get("objectClass"));
            BasicAttribute attr = new BasicAttribute(mbrAttrNames[0]);
            if (grpMbrCtrl != null) {
                grpMbrMode = grpMbrCtrl.getModifyMode();
            }
            for (Entity member : members) {
                IdentifierType mbrId = member.getIdentifier();
                LdapEntry mbrEntry = this.iLdapConn.getEntityByIdentifier(mbrId, null, null, false, false);
                String mbrDN = mbrEntry.getDN();
                this.iLdapConn.invalidateAttributes(mbrDN, mbrEntry.getExtId(), mbrEntry.getUniqueName());
                attr.add(mbrDN);
            }
            if (3 == grpMbrMode) {
                modItemList.add(new ModificationItem(3, attr));
                String dummyMbr = this.iLdapConfigMgr.getDummyMember(mbrAttrNames[0]);
                if (dummyMbr != null) {
                    BasicAttribute dummyMbrAttr = new BasicAttribute(mbrAttrNames[0], dummyMbr);
                    modItemList.add(new ModificationItem(1, dummyMbrAttr));
                }
            } else if (2 == grpMbrMode) {
                modItemList.add(new ModificationItem(2, attr));
            } else {
                modItemList.add(new ModificationItem(1, attr));
            }
            updateMbr = true;
        }
        if (modItemList.size() > 0) {
            ModificationItem[] items = new ModificationItem[]{};
            items = modItemList.toArray(items);
            try {
                this.iLdapConn.modifyAttributes(dn, items);
            }
            catch (AttributeInUseException attr) {
                void e;
                FFDCFilter.processException((Throwable)attr, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3881", (Object)((Object)this), (Object[])new Object[]{root});
                if (updateMbr && 1 == grpMbrMode) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("updateEntity Entity is already a member of group " + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                    }
                }
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
            catch (NoSuchAttributeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3891", (Object)((Object)this), (Object[])new Object[]{root});
                if (updateMbr && 3 == grpMbrMode) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("updateEntity Entity is already not a member of group " + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                    }
                }
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
            catch (OperationNotSupportedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3901", (Object)((Object)this), (Object[])new Object[]{root});
                if (updateMbr && 3 == grpMbrMode) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("updateEntity Entity is already not a member of group " + dn + ":" + e.toString(true)), (Object[])new Object[0]);
                    }
                }
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapAdapter", (String)"3911", (Object)((Object)this), (Object[])new Object[]{root});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
        }
        String newDn = null;
        boolean renamed = false;
        if (rdnAttrValues != null && !(newDn = LdapHelper.replaceRDN(dn, rdnAttrNames, rdnAttrValues)).equalsIgnoreCase(dn)) {
            this.iLdapConn.rename(dn, newDn);
            this.updateGroupMember(dn, newDn);
            ArrayList<String> entityTypes = new ArrayList<String>(1);
            entityTypes.add(outEntityType);
            ldapEntry = this.iLdapConn.getEntityByIdentifier(newDn, null, null, entityTypes, null, false, false);
            renamed = true;
        }
        if (groups != null) {
            int grpMbrshipMode = 1;
            if (grpMbrshipCtrl != null) {
                grpMbrshipMode = grpMbrshipCtrl.getModifyMode();
            }
            this.updateGroups(renamed ? newDn : dn, groups, grpMbrshipMode);
        }
        this.iLdapConn.invalidateAttributes(dn, extId, uniqueName);
        this.iLdapConn.invalidateSearchCache();
        this.createEntityFromLdapEntry(outRoot, "entities", ldapEntry, null);
        return outRoot;
    }

    private String setAttributeNamesInFilter(String sFilter, String entityType) {
        int index = -1;
        int attrIndex = -1;
        String name = null;
        String attributeName = null;
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(entityType);
        while (sFilter.indexOf("~=", index) > -1 || sFilter.indexOf(">=", index) > -1 || sFilter.indexOf("<=", index) > -1 || sFilter.indexOf("=", index) > -1) {
            if (sFilter.indexOf("~=", index) > -1) {
                index = sFilter.indexOf("~=", index);
            } else if (sFilter.indexOf(">=", index) > -1) {
                index = sFilter.indexOf(">=", index);
            } else if (sFilter.indexOf("<=", index) > -1) {
                index = sFilter.indexOf("<=", index);
            } else if (sFilter.indexOf("=", index) > -1) {
                index = sFilter.indexOf("=", index);
            }
            for (attrIndex = index; attrIndex > -1 && sFilter.charAt(attrIndex) != '('; --attrIndex) {
            }
            name = sFilter.substring(attrIndex + 1, index);
            attributeName = this.iLdapConfigMgr.getAttributeName(ldapEntity, name);
            index = (sFilter = sFilter.substring(0, attrIndex + 1) + attributeName + sFilter.substring(index)).indexOf(41, index);
            if (index != -1) continue;
            index = sFilter.length() - 1;
        }
        return sFilter;
    }

    private boolean isRDN(String attrName, String[] rdnAttrNames) {
        if (rdnAttrNames == null || attrName == null) {
            return false;
        }
        for (int i = 0; i < rdnAttrNames.length; ++i) {
            if (!attrName.equalsIgnoreCase(rdnAttrNames[i])) continue;
            return true;
        }
        return false;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setCertificateMapper(X509CertificateMapper mapper) {
        this.iCertificateMapperRef.set(mapper);
    }

    protected void unsetCertificateMapper(X509CertificateMapper mapper) {
        this.iCertificateMapperRef.compareAndSet(mapper, null);
    }
}

