/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

@Trivial
public class SSLUtilImpl {
    private static final TraceComponent tc = Tr.register(SSLUtilImpl.class);

    public Properties getSSLPropertiesOnThread() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){
            static final long serialVersionUID = -5198282697207071533L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Properties run() {
                return JSSEHelper.getInstance().getSSLPropertiesOnThread();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    public void resetSSLAlias() {
        this.setSSLPropertiesOnThread(null);
    }

    public void setSSLAlias(final String sslAlias, Hashtable<?, ?> ldapEnv) throws WIMException {
        Properties props;
        String METHODNAME = "setSSLAlias";
        final HashMap<String, String> connectionInfo = new HashMap<String, String>();
        String provider = (String)ldapEnv.get("java.naming.provider.url");
        if (provider != null) {
            StringTokenizer providerTokens = new StringTokenizer(provider);
            provider = providerTokens.nextToken();
            provider = provider.replaceFirst("ldap", "http");
            URL providerURL = null;
            try {
                providerURL = new URL(provider);
            }
            catch (MalformedURLException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"INVALID_INIT_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms(ldapEnv.get("java.naming.provider.url")));
                throw new WIMSystemException("INVALID_INIT_PROPERTY", msg);
            }
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", providerURL.getHost());
            connectionInfo.put("com.ibm.ssl.remotePort", providerURL.getPort() == -1 ? "636" : Integer.toString(providerURL.getPort()));
        }
        try {
            props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                static final long serialVersionUID = 166736558844308639L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Properties run() throws Exception {
                    if (!connectionInfo.isEmpty()) {
                        return JSSEHelper.getInstance().getProperties(sslAlias, connectionInfo, null);
                    }
                    return JSSEHelper.getInstance().getProperties(sslAlias);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"INVALID_INIT_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)"sslConfiguration"));
            throw new WIMSystemException("INVALID_INIT_PROPERTY", msg, (Throwable)e);
        }
        this.setSSLPropertiesOnThread(props);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSSLAlias Properties for SSL Alias '" + sslAlias + "':" + props), (Object[])new Object[0]);
        }
    }

    public void setSSLPropertiesOnThread(final Properties props) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 1812829659255304831L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                JSSEHelper.getInstance().setSSLPropertiesOnThread(props);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
    }
}

