/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.identitystore;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStoreDefinitionWrapper;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.security.enterprise.credential.CallerOnlyCredential;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStorePermission;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;

@Default
@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LdapIdentityStore
implements IdentityStore {
    private static final TraceComponent tc = Tr.register(LdapIdentityStore.class);
    private final LdapIdentityStoreDefinitionWrapper idStoreDefinition;
    static final long serialVersionUID = -6976246879957428054L;

    public LdapIdentityStore(LdapIdentityStoreDefinition idStoreDefinition) {
        this.idStoreDefinition = new LdapIdentityStoreDefinitionWrapper(idStoreDefinition);
    }

    private DirContext bind() throws NamingException {
        return this.bind(this.idStoreDefinition.getBindDn(), this.idStoreDefinition.getBindDnPassword());
    }

    private DirContext bind(String bindDn, ProtectedString bindPw) throws NamingException {
        boolean sslEnabled;
        Hashtable<Object, Object> env = new Hashtable<Object, Object>();
        String url = this.idStoreDefinition.getUrl();
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("No URL was provided to the LdapIdentityStore.");
        }
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        boolean bl = sslEnabled = url != null && url.startsWith("ldaps");
        if (sslEnabled) {
            env.put("java.naming.ldap.factory.socket", "com.ibm.ws.ssl.protocol.LibertySSLSocketFactory");
            env.put("java.naming.security.protocol", "ssl");
        }
        if (bindDn != null && !bindDn.isEmpty() && bindPw != null) {
            String decodedBindPw = PasswordUtil.passwordDecode((String)new String(bindPw.getChars()).trim());
            if (decodedBindPw == null || decodedBindPw.isEmpty()) {
                throw new IllegalArgumentException("An empty password is invalid.");
            }
            env.put("java.naming.security.principal", bindDn);
            env.put("java.naming.security.credentials", decodedBindPw);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JNDI_CALL bind", (Object[])new Object[]{bindDn, url});
        }
        return this.getDirContext(env);
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private DirContext getDirContext(final Hashtable<Object, Object> env) throws NamingException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<DirContext>(){
                static final long serialVersionUID = -7023566102694133429L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public DirContext run() throws NamingException {
                    return new InitialLdapContext(env, null);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception oe = e.getException();
            if (oe instanceof NamingException) {
                throw (NamingException)oe;
            }
            if (oe instanceof RuntimeException) {
                throw (RuntimeException)oe;
            }
            throw new UndeclaredThrowableException(oe);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        String userDn;
        if (!this.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
            return new HashSet<String>();
        }
        SecurityManager secManager = System.getSecurityManager();
        if (secManager != null) {
            secManager.checkPermission((Permission)new IdentityStorePermission("getGroups"));
        }
        if ((userDn = validationResult.getCallerDn()) == null || userDn.isEmpty()) {
            String user = validationResult.getCallerPrincipal().getName();
            if (this.isValidDn(user)) {
                userDn = user;
            } else {
                String filter = this.getFormattedFilter(this.idStoreDefinition.getCallerSearchFilter(), user, this.idStoreDefinition.getCallerNameAttribute());
                userDn = this.getUserDn(user, filter, this.getCallerSearchControls());
            }
        }
        if (userDn == null || userDn.isEmpty()) {
            return new HashSet<String>();
        }
        try {
            return this.getGroups(this.bind(), userDn);
        }
        catch (NamingException user) {
            void e;
            FFDCFilter.processException((Throwable)user, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"176", (Object)this, (Object[])new Object[]{validationResult});
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_EXCEPTION_ON_BIND", (Object[])new Object[]{this.idStoreDefinition.getBindDn(), e});
            throw new IllegalStateException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public CredentialValidationResult validate(Credential credential) {
        if (!(credential instanceof UsernamePasswordCredential) && !(credential instanceof CallerOnlyCredential)) {
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_WRONG_CRED", (Object[])new Object[0]);
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        if (credential.isValid()) {
            String user;
            boolean usernameOnly = false;
            if (credential instanceof UsernamePasswordCredential) {
                user = ((UsernamePasswordCredential)credential).getCaller();
            } else {
                usernameOnly = true;
                user = ((CallerOnlyCredential)credential).getCaller();
            }
            String filter = this.idStoreDefinition.getCallerSearchFilter();
            String callerNameAttribute = this.idStoreDefinition.getCallerNameAttribute();
            String callerName = null;
            String userDn = null;
            Set<Object> groups = new HashSet();
            if (this.isValidDn(user)) {
                userDn = user;
            } else {
                filter = this.getFormattedFilter(filter, user, callerNameAttribute);
                userDn = this.getUserDn(user, filter, this.getCallerSearchControls());
            }
            if (userDn == null) {
                return CredentialValidationResult.INVALID_RESULT;
            }
            DirContext context = null;
            if (!usernameOnly) {
                try {
                    context = this.bind(userDn, new ProtectedString(((UsernamePasswordCredential)credential).getPassword().getValue()));
                }
                catch (NamingException namingException) {
                    void e;
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"225", (Object)this, (Object[])new Object[]{credential});
                    Tr.debug((TraceComponent)tc, (String)"JAVAEESEC_ERROR_EXCEPTION_ON_BIND", (Object[])new Object[]{userDn, e});
                    return CredentialValidationResult.INVALID_RESULT;
                }
            }
            try {
                context = this.bind();
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"232", (Object)this, (Object[])new Object[]{credential});
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_EXCEPTION_ON_BIND", (Object[])new Object[]{this.idStoreDefinition.getBindDn(), e});
                throw new IllegalStateException(e);
            }
            if (context == null) {
                return CredentialValidationResult.INVALID_RESULT;
            }
            if (callerNameAttribute.equalsIgnoreCase("dn")) {
                callerName = userDn;
            } else {
                try {
                    Attributes attrs = context.getAttributes(userDn, new String[]{callerNameAttribute});
                    Attribute attribute = attrs.get(callerNameAttribute);
                    if (attribute == null) {
                        Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_MISSING_CALLER_ATTR", (Object[])new Object[]{userDn, callerNameAttribute});
                        return CredentialValidationResult.INVALID_RESULT;
                    }
                    NamingEnumeration<?> ne = attribute.getAll();
                    while (ne.hasMoreElements()) {
                        callerName = (String)ne.nextElement();
                    }
                }
                catch (NamingException attrs) {
                    FFDCFilter.processException((Throwable)attrs, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"255", (Object)this, (Object[])new Object[]{credential});
                    Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_EXCEPTION_ON_GETATTRIBUTES", (Object[])new Object[]{userDn, callerNameAttribute, e});
                }
            }
            if (this.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
                groups = this.getGroups(context, userDn);
            }
            String url = this.idStoreDefinition.getUrl();
            if ((url = url.replaceFirst("(?i)ldaps?:\\/\\/", "")).endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            return new CredentialValidationResult(url, callerName, userDn, userDn, groups);
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    /*
     * WARNING - void declaration
     */
    private String getUserDn(String callerName, String filter, SearchControls controls) {
        String userDn = null;
        String searchBase = this.idStoreDefinition.getCallerSearchBase();
        if (searchBase == null || searchBase.isEmpty()) {
            userDn = this.idStoreDefinition.getCallerNameAttribute() + "=" + callerName + "," + this.idStoreDefinition.getCallerBaseDn();
        } else {
            DirContext ctx = null;
            try {
                ctx = this.bind();
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"301", (Object)this, (Object[])new Object[]{callerName, filter, controls});
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_EXCEPTION_ON_BIND", (Object[])new Object[]{this.idStoreDefinition.getBindDn(), e});
                throw new IllegalStateException((Throwable)e);
            }
            try {
                NamingEnumeration<SearchResult> ne;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JNDI_CALL search", (Object[])new Object[]{searchBase, filter, this.printControls(controls)});
                }
                if ((ne = ctx.search((Name)new LdapName(searchBase), filter, controls)).hasMoreElements()) {
                    userDn = ((SearchResult)ne.nextElement()).getNameInNamespace();
                    if (ne.hasMoreElements()) {
                        Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_MULTI_CALLER_LDAP", (Object[])new Object[]{callerName, filter, searchBase});
                        return null;
                    }
                }
            }
            catch (NamingException ne) {
                void e;
                FFDCFilter.processException((Throwable)ne, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"317", (Object)this, (Object[])new Object[]{callerName, filter, controls});
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_EXCEPTION_ON_SEARCH", (Object[])new Object[]{callerName, filter, searchBase, e});
                throw new IllegalStateException((Throwable)e);
            }
        }
        return userDn;
    }

    private Set<String> getGroups(DirContext context, String callerDn) {
        Set<String> groups = null;
        String groupSearchBase = this.idStoreDefinition.getGroupSearchBase();
        String groupSearchFilter = this.idStoreDefinition.getGroupSearchFilter();
        groups = groupSearchBase.isEmpty() || groupSearchFilter.isEmpty() ? this.getGroupsByMembership(context, callerDn) : this.getGroupsByMember(context, callerDn, groupSearchBase, groupSearchFilter);
        return groups;
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getGroupsByMember(DirContext context, String callerDn, String groupSearchBase, String groupSearchFilter) {
        String groupNameAttribute = this.idStoreDefinition.getGroupNameAttribute();
        String[] attrIds = new String[]{groupNameAttribute};
        long limit = this.idStoreDefinition.getMaxResults();
        int timeOut = this.idStoreDefinition.getReadTimeout();
        int scope = this.getSearchScope(this.idStoreDefinition.getGroupSearchScope());
        SearchControls controls = new SearchControls(scope, limit, timeOut, attrIds, false, false);
        String filter = this.getFormattedFilter(groupSearchFilter, callerDn, this.idStoreDefinition.getGroupMemberAttribute());
        HashSet<String> groupNames = new HashSet<String>();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JNDI_CALL search", (Object[])new Object[]{groupSearchBase, filter, this.printControls(controls)});
            }
            NamingEnumeration<SearchResult> ne = context.search((Name)new LdapName(groupSearchBase), filter, controls);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Iterate through the search results", (Object[])new Object[0]);
            }
            while (ne.hasMoreElements()) {
                SearchResult sr = (SearchResult)ne.nextElement();
                String groupDn = sr.getNameInNamespace();
                if (groupNameAttribute.equalsIgnoreCase("dn")) {
                    groupNames.add(groupDn);
                    continue;
                }
                Attribute groupNameAttr = sr.getAttributes().get(groupNameAttribute);
                if (groupNameAttr == null) {
                    Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_MISSING_GROUP_ATTR", (Object[])new Object[]{groupDn, groupNameAttribute});
                    continue;
                }
                NamingEnumeration<?> ne2 = groupNameAttr.getAll();
                if (!ne2.hasMoreElements()) continue;
                groupNames.add((String)ne2.nextElement());
            }
        }
        catch (NamingException ne) {
            void e;
            FFDCFilter.processException((Throwable)ne, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"396", (Object)this, (Object[])new Object[]{context, callerDn, groupSearchBase, groupSearchFilter});
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_EXCEPTION_ON_GROUP_SEARCH", (Object[])new Object[]{callerDn, e});
            throw new IllegalStateException((Throwable)e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getGroupsByMember", (Object[])new Object[]{groupNames});
        }
        return groupNames;
    }

    private String getFormattedFilter(String searchFilter, String caller, String attribute) {
        String filter = searchFilter.replaceAll("%v", "%s");
        if (!(filter.startsWith("(") && filter.endsWith(")") || filter.isEmpty())) {
            filter = "(" + filter + ")";
        }
        filter = filter.contains("%s") ? String.format(filter, caller) : "(&" + filter + "(" + attribute + "=" + caller + "))";
        return filter;
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getGroupsByMembership(DirContext context, String callerDn) {
        String memberOfAttribute = this.idStoreDefinition.getGroupMemberOfAttribute();
        String groupNameAttribute = this.idStoreDefinition.getGroupNameAttribute();
        HashSet<String> groupDns = new HashSet<String>();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JNDI_CALL getAttributes", (Object[])new Object[]{callerDn, memberOfAttribute});
        }
        try {
            Attributes attrs = context.getAttributes(callerDn, new String[]{memberOfAttribute});
            Attribute groupSet = attrs.get(memberOfAttribute);
            if (groupSet != null) {
                NamingEnumeration<?> ne = groupSet.getAll();
                while (ne.hasMoreElements()) {
                    groupDns.add((String)ne.nextElement());
                }
            }
        }
        catch (NamingException groupSet) {
            void e;
            FFDCFilter.processException((Throwable)groupSet, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"456", (Object)this, (Object[])new Object[]{context, callerDn});
            Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_EXCEPTION_ON_GETATTRIBUTES", (Object[])new Object[]{callerDn, memberOfAttribute, e});
        }
        if (groupNameAttribute.equalsIgnoreCase("dn")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getGroupsByMembership", (Object[])new Object[]{groupDns});
            }
            return groupDns;
        }
        HashSet<String> groupNames = new HashSet<String>();
        String groupDn = null;
        Iterator it = groupDns.iterator();
        try {
            while (it.hasNext()) {
                Attributes groupNameAttrs;
                Attribute groupNameAttr;
                groupDn = (String)it.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JNDI_CALL getAttributes", (Object[])new Object[]{groupDn, groupNameAttribute});
                }
                if ((groupNameAttr = (groupNameAttrs = context.getAttributes(groupDn, new String[]{groupNameAttribute})).get(groupNameAttribute)) == null) {
                    Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_MISSING_GROUP_ATTR", (Object[])new Object[]{groupDn, groupNameAttribute});
                    continue;
                }
                NamingEnumeration<?> ne = groupNameAttr.getAll();
                if (!ne.hasMoreElements()) continue;
                groupNames.add((String)ne.nextElement());
            }
        }
        catch (NamingException groupNameAttrs) {
            void e;
            FFDCFilter.processException((Throwable)groupNameAttrs, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStore", (String)"487", (Object)this, (Object[])new Object[]{context, callerDn});
            Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_EXCEPTION_ON_GETATTRIBUTES", (Object[])new Object[]{groupDn, groupNameAttribute, e});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getGroupsByMembership", (Object[])new Object[]{groupNames});
        }
        return groupNames;
    }

    @FFDCIgnore(value={InvalidNameException.class})
    private boolean isValidDn(String user) {
        try {
            new LdapName(user).toString();
        }
        catch (InvalidNameException e) {
            return false;
        }
        return true;
    }

    private SearchControls getCallerSearchControls() {
        String[] attrIds = new String[]{this.idStoreDefinition.getCallerNameAttribute()};
        long limit = this.idStoreDefinition.getMaxResults();
        int timeOut = this.idStoreDefinition.getReadTimeout();
        int scope = this.getSearchScope(this.idStoreDefinition.getCallerSearchScope());
        return new SearchControls(scope, limit, timeOut, attrIds, false, false);
    }

    private String printControls(SearchControls controls) {
        StringBuffer result = new StringBuffer();
        result.append("[searchScope: ").append(controls.getSearchScope());
        result.append(", timeLimit: ").append(controls.getTimeLimit());
        result.append(", countLimit: ").append(controls.getCountLimit());
        result.append(", returningObjFlag: ").append(controls.getReturningObjFlag());
        result.append(", returningAttributes: ").append(controls.getReturningAttributes()[0]).append("]");
        return result.toString();
    }

    private int getSearchScope(LdapIdentityStoreDefinition.LdapSearchScope scope) {
        if (scope == LdapIdentityStoreDefinition.LdapSearchScope.ONE_LEVEL) {
            return 1;
        }
        return 2;
    }

    public int priority() {
        return this.idStoreDefinition.getPriority();
    }

    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.idStoreDefinition.getUseFor();
    }
}

