/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.config.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.config.FilesetChangeListener;
import com.ibm.wsspi.config.internal.ConfigTypeConstants;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, configurationPid={"com.ibm.ws.kernel.metatype.helper.fileset"}, property={"service.vendor=IBM", "monitor.filter=files", "monitor.recurse:Boolean=false"})
public class FilesetImpl
implements Fileset,
FileMonitor {
    private static final TraceComponent tc = Tr.register(FilesetImpl.class);
    private static final boolean DEFAULT_CASE_SENSITIVITY = true;
    private static final String DEFAULT_INCLUDES = "*";
    private static final String DEFAULT_EXCLUDES = "";
    static final Long MONITOR_OFF;
    private static final Long DEFAULT_MONITOR;
    private volatile ComponentContext context;
    private String pid;
    private volatile ServiceRegistration<Fileset> filesetRegistration = null;
    private volatile String resolvedBasePath;
    private volatile String basedir;
    private volatile boolean caseSensitive = true;
    private volatile String includesAttribute = "*";
    private volatile String excludesAttribute = "";
    private final Map<String, Object> fileMonitorProps = new Hashtable<String, Object>(5);
    private Collection<File> fileset = Collections.emptySet();
    private volatile boolean isCurrent = false;
    private volatile boolean returnCached = false;
    private final FilesetNameFilter filter = new FilesetNameFilter();
    private final List<FilesetChangeListener> listeners = new ArrayList<FilesetChangeListener>();
    private boolean listenersNotified;
    private ServiceRegistration<FileMonitor> fileMonitorRegistration;
    private final Collection<File> filesToCheckForMatches = new ArrayList<File>();
    static final long serialVersionUID = -3717223041295743642L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.context = context;
        this.pid = (String)props.get("service.pid");
        this.modified(props);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) throws IOException {
        if (this.filesetRegistration != null) {
            this.filesetRegistration.unregister();
            this.filesetRegistration = null;
        }
        this.fileMonitorRegistration.unregister();
    }

    Dictionary<String, Object> getServiceRegistrationProps() {
        return (Dictionary)((Object)this.fileMonitorProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setListener(FilesetChangeListener listener) {
        boolean listenersNotified;
        List<FilesetChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
            listenersNotified = this.listenersNotified;
        }
        if (listenersNotified) {
            listener.filesetNotification(this.pid, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetListener(FilesetChangeListener listener) {
        List<FilesetChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Reference
    protected void setLocationAdmin(WsLocationAdmin locationAdmin) {
        this.resolvedBasePath = locationAdmin.resolveString("${server.config.dir}/");
    }

    @Override
    @Trivial
    public String getDir() {
        return this.basedir;
    }

    private void setDir(String basedir) {
        this.basedir = PathUtils.slashify((String)basedir);
        if (!PathUtils.pathIsAbsolute((String)this.basedir)) {
            this.basedir = this.resolvedBasePath + this.basedir;
        }
        this.basedir = PathUtils.normalize((String)this.basedir);
        this.fileMonitorProps.put("monitor.directories", Arrays.asList(this.basedir));
    }

    private void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    private void setIncludesAttribute(String includesAttribute) {
        this.includesAttribute = includesAttribute;
    }

    private void setExcludesAttribute(String excludesAttribute) {
        this.excludesAttribute = excludesAttribute;
    }

    private void setMonitorAttribute(Long monitorInterval) {
        if (MONITOR_OFF.equals(monitorInterval)) {
            this.fileMonitorProps.remove("monitor.interval");
        } else {
            this.fileMonitorProps.put("monitor.interval", monitorInterval);
        }
    }

    @Modified
    protected synchronized void modified(Map<String, Object> props) {
        this.fileMonitorProps.putAll(props);
        this.isCurrent = false;
        block7: for (ConfigTypeConstants.FilesetAttribute attr : ConfigTypeConstants.FilesetAttribute.values()) {
            Object o = props.get(attr.toString());
            switch (attr) {
                case dir: {
                    this.setDir((String)o);
                    continue block7;
                }
                case caseSensitive: {
                    Boolean b = o != null ? (Boolean)o : true;
                    this.setCaseSensitive(b);
                    continue block7;
                }
                case includes: {
                    String s = o != null ? (String)o : DEFAULT_INCLUDES;
                    this.setIncludesAttribute(s);
                    continue block7;
                }
                case excludes: {
                    String s = o != null ? (String)o : DEFAULT_EXCLUDES;
                    this.setExcludesAttribute(s);
                    continue block7;
                }
                case scanInterval: {
                    Long scan = o != null ? (Long)o : DEFAULT_MONITOR;
                    this.setMonitorAttribute(scan);
                }
            }
        }
        if (this.fileMonitorRegistration != null) {
            this.fileMonitorRegistration.setProperties(this.getServiceRegistrationProps());
        } else {
            this.fileMonitorRegistration = this.context.getBundleContext().registerService(FileMonitor.class, (Object)this, this.getServiceRegistrationProps());
        }
    }

    @Override
    @Trivial
    public synchronized Collection<File> getFileset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Retrieving fileSet", (Object[])new Object[]{this.pid});
        }
        if (!this.isCurrent) {
            this.evaluateFilters();
        }
        if (!this.returnCached) {
            this.applyFilters();
        }
        ArrayList<File> filesetToReturn = new ArrayList<File>(this.fileset.size());
        filesetToReturn.addAll(this.fileset);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("returning fileset: " + filesetToReturn), (Object[])new Object[]{this.pid});
        }
        return filesetToReturn;
    }

    private void evaluateFilters() {
        this.filter.clearFilters();
        if (this.includesAttribute != null && this.includesAttribute.length() != 0) {
            this.filter.addFilter(FilterType.INCLUDE, this.includesAttribute);
        }
        if (this.excludesAttribute != null && this.excludesAttribute.length() != 0) {
            this.filter.addFilter(FilterType.EXCLUDE, this.excludesAttribute);
        }
        this.isCurrent = true;
        this.returnCached = false;
    }

    private void applyFilters() {
        ArrayList<File> matchingFiles = new ArrayList<File>(this.filesToCheckForMatches.size());
        for (File f : this.filesToCheckForMatches) {
            if (!this.filter.accept(f)) continue;
            matchingFiles.add(f);
        }
        this.fileset = matchingFiles;
        this.returnCached = true;
    }

    public void onBaseline(Collection<File> baseline) {
        this.filesToCheckForMatches.clear();
        this.filesToCheckForMatches.addAll(baseline);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("FileMonitor init completed for fileset: baseline " + baseline), (Object[])new Object[]{this.pid});
        }
        this.returnCached = false;
        if (this.filesetRegistration == null) {
            this.filesetRegistration = this.context.getBundleContext().registerService(Fileset.class, (Object)this, this.getServiceRegistrationProps());
        }
        this.notifyListeners();
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        if (!deletedFiles.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FileMonitor scan detected files to remove from fileset", (Object[])new Object[]{this.pid, deletedFiles});
            }
            this.filesToCheckForMatches.removeAll(deletedFiles);
            this.returnCached = false;
        }
        if (!createdFiles.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FileMonitor scan detected files to add to fileset", (Object[])new Object[]{this.pid, createdFiles});
            }
            this.filesToCheckForMatches.addAll(createdFiles);
            this.returnCached = false;
        }
        if (!(deletedFiles.isEmpty() && createdFiles.isEmpty() && modifiedFiles.isEmpty())) {
            this.notifyListeners();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"FileMonitor scan completed for fileset", (Object[])new Object[]{this.pid});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        ArrayList<FilesetChangeListener> copy;
        List<FilesetChangeListener> list = this.listeners;
        synchronized (list) {
            copy = new ArrayList<FilesetChangeListener>(this.listeners);
            this.listenersNotified = true;
        }
        for (FilesetChangeListener listener : copy) {
            if (listener == null) continue;
            listener.filesetNotification(this.pid, this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        DEFAULT_MONITOR = MONITOR_OFF = Long.valueOf(0L);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private final class FilesetNameFilter
    implements FilenameFilter,
    FileFilter {
        private final Collection<Pattern> includes = new ArrayList<Pattern>();
        private final Collection<Pattern> excludes = new ArrayList<Pattern>();
        static final long serialVersionUID = 6427867079748419193L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private FilesetNameFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return this.accept(pathname.getPath());
        }

        @Override
        public boolean accept(File dir, String name) {
            String fullname = dir.getPath() + "/" + name;
            return this.accept(fullname);
        }

        private boolean accept(String fullname) {
            Matcher m;
            boolean accept = false;
            fullname = fullname.replace('\\', '/');
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Filtering file name", (Object[])new Object[]{fullname});
            }
            for (Pattern filter : this.includes) {
                m = filter.matcher(fullname);
                if (!m.matches()) continue;
                accept = true;
                break;
            }
            for (Pattern filter : this.excludes) {
                m = filter.matcher(fullname);
                if (!m.matches()) continue;
                accept = false;
                break;
            }
            return accept;
        }

        private Collection<Pattern> getNamePatternFromFilter(String inputFilter) {
            inputFilter = inputFilter.replace('\\', '/');
            Object[] filters = inputFilter.split("\\s*,\\s*|\\s+");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Filter strings", (Object[])new Object[]{Arrays.toString(filters)});
            }
            HashSet<Pattern> patterns = new HashSet<Pattern>(filters.length);
            for (Object filter : filters) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Parsing filter string into pattern", (Object[])new Object[]{filter});
                }
                if (((String)filter).length() == 0) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Empty filter string encountered, will be ignored", (Object[])new Object[0]);
                    continue;
                }
                if (((String)filter).startsWith("./")) {
                    filter = ((String)filter).substring(2);
                }
                filter = FilesetImpl.this.basedir + (FilesetImpl.this.basedir.endsWith("/") ? FilesetImpl.DEFAULT_EXCLUDES : "/") + (String)filter;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Prepended filter with basedir resulting in filter string", (Object[])new Object[]{filter});
                }
                filter = Pattern.quote((String)filter);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Filter string following regex quotation", (Object[])new Object[]{filter});
                }
                filter = ((String)filter).replaceAll("\\*", "\\\\E[^/]+\\\\Q");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Pattern string to compile after replacing * wildcards is", (Object[])new Object[]{filter});
                }
                filter = ((String)filter).replaceAll("\\\\E\\[\\^/\\]\\+\\\\Q\\\\E\\[\\^/\\]\\+\\\\Q", "\\\\E.*\\\\Q");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Pattern string to compile after replacing ** wildcards is", (Object[])new Object[]{filter});
                }
                int patternFlags = 0;
                if (!FilesetImpl.this.caseSensitive) {
                    patternFlags = 66;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Case insensitive matching was specified, applying pattern flags", (Object[])new Object[]{patternFlags});
                    }
                }
                patterns.add(Pattern.compile((String)filter, patternFlags));
            }
            return patterns;
        }

        public void addFilter(FilterType f, String inputFilter) {
            Collection<Pattern> patterns = this.getNamePatternFromFilter(inputFilter);
            switch (f) {
                case INCLUDE: {
                    this.includes.addAll(patterns);
                    break;
                }
                case EXCLUDE: {
                    this.excludes.addAll(patterns);
                }
            }
        }

        public void clearFilters() {
            this.includes.clear();
            this.excludes.clear();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FilesetNameFilter.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class FilterType
    extends Enum<FilterType> {
        public static final /* enum */ FilterType INCLUDE;
        public static final /* enum */ FilterType EXCLUDE;
        private static final /* synthetic */ FilterType[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static FilterType[] values() {
            return (FilterType[])$VALUES.clone();
        }

        public static FilterType valueOf(String name) {
            return Enum.valueOf(FilterType.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FilterType.class);
            INCLUDE = new FilterType();
            EXCLUDE = new FilterType();
            $VALUES = new FilterType[]{INCLUDE, EXCLUDE};
        }
    }
}

