/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.db;

import com.ibm.websphere.concurrent.persistent.PersistentExecutor;
import com.ibm.websphere.concurrent.persistent.TaskState;
import com.ibm.websphere.concurrent.persistent.TaskStatus;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.db.Partition;
import com.ibm.ws.concurrent.persistent.db.Property;
import com.ibm.ws.concurrent.persistent.db.Task;
import com.ibm.ws.concurrent.persistent.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.concurrent.persistent.PartitionRecord;
import com.ibm.wsspi.concurrent.persistent.TaskRecord;
import com.ibm.wsspi.concurrent.persistent.TaskStore;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.persistence.PersistenceServiceUnit;
import java.security.AccessController;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DatabaseTaskStore
implements TaskStore {
    private static final TraceComponent tc = Tr.register(DatabaseTaskStore.class);
    private static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final Map<DatabaseStore, DatabaseTaskStore> dbTaskStores = new HashMap<DatabaseStore, DatabaseTaskStore>();
    private static final Map<DatabaseStore, Integer> refCounts = new HashMap<DatabaseStore, Integer>();
    private final DatabaseStore dbStore;
    private boolean destroyed;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private PersistenceServiceUnit persistenceServiceUnit;
    static final long serialVersionUID = 7205363506545311048L;

    private DatabaseTaskStore(DatabaseStore dbStore) {
        this.dbStore = dbStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseTaskStore get(DatabaseStore dbStore) {
        DatabaseTaskStore dbTaskStore;
        Map<DatabaseStore, Integer> map = refCounts;
        synchronized (map) {
            Integer count = refCounts.get(dbStore);
            count = count == null ? 1 : count + 1;
            refCounts.put(dbStore, count);
            if (count == 1) {
                dbTaskStore = new DatabaseTaskStore(dbStore);
                dbTaskStores.put(dbStore, dbTaskStore);
            } else {
                dbTaskStore = dbTaskStores.get(dbStore);
            }
        }
        return dbTaskStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unget(DatabaseStore dbStore) {
        DatabaseTaskStore removed = null;
        Map<DatabaseStore, Integer> map = refCounts;
        synchronized (map) {
            Integer count = refCounts.get(dbStore);
            if (count > 1) {
                refCounts.put(dbStore, count - 1);
            } else {
                refCounts.remove(dbStore);
                removed = dbTaskStores.remove(dbStore);
            }
        }
        if (removed != null) {
            removed.lock.writeLock().lock();
            try {
                removed.destroyed = true;
                if (removed.persistenceServiceUnit != null) {
                    removed.persistenceServiceUnit.close();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.concurrent.persistent.db.DatabaseTaskStore", (String)"110", null, (Object[])new Object[]{dbStore});
            }
            finally {
                removed.lock.writeLock().unlock();
            }
        }
    }

    @Trivial
    private final Map<String, Object> appendStateComparison(StringBuilder sb, TaskState state, boolean inState) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        switch (state) {
            case SCHEDULED: {
                sb.append("t.STATES").append(inState ? "<" : ">=").append(":s");
                params.put("s", TaskState.SUSPENDED.bit);
                break;
            }
            case SUSPENDED: {
                sb.append(inState ? "t.STATES>=:s1 AND t.STATES<:s2" : "(t.STATES<:s1 OR t.STATES>=:s2)");
                params.put("s1", TaskState.SUSPENDED.bit);
                params.put("s2", TaskState.ENDED.bit);
                break;
            }
            case ENDED: 
            case CANCELED: {
                sb.append("t.STATES").append(inState ? ">=" : "<").append(":s");
                params.put("s", state.bit);
                break;
            }
            case SUCCESSFUL: {
                sb.append(inState ? "t.STATES>=:s1 AND t.STATES<:s2" : "(t.STATES<:s1 OR t.STATES>=:s2)");
                params.put("s1", TaskState.SUCCESSFUL.bit);
                params.put("s2", TaskState.FAILURE_LIMIT_REACHED.bit);
                break;
            }
            case FAILURE_LIMIT_REACHED: {
                sb.append(inState ? "t.STATES>=:s1 AND t.STATES<:s2" : "(t.STATES<:s1 OR t.STATES>=:s2)");
                params.put("s1", TaskState.FAILURE_LIMIT_REACHED.bit);
                params.put("s2", TaskState.CANCELED.bit);
                break;
            }
            default: {
                sb.append("MOD(t.STATES,:s*2)").append(inState ? ">=" : "<").append(":s");
                params.put("s", state.bit);
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public boolean cancel(long taskId) throws Exception {
        StringBuilder update = new StringBuilder(87).append("UPDATE Task t SET t.STATES=").append(TaskState.CANCELED.bit + TaskState.ENDED.bit).append(",t.VERSION=t.VERSION+1 WHERE t.ID=:i AND t.STATES<").append(TaskState.ENDED.bit);
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"cancel", (Object[])new Object[]{taskId, update});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            boolean canceled;
            Query query = em.createQuery(update.toString());
            query.setParameter("i", (Object)taskId);
            boolean bl = canceled = query.executeUpdate() > 0;
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"cancel", (Object)canceled);
            }
            boolean bl2 = canceled;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public int cancel(String pattern, Character escape, TaskState state, boolean inState, String owner) throws Exception {
        StringBuilder update = new StringBuilder(133).append("UPDATE Task t SET t.STATES=").append(TaskState.CANCELED.bit + TaskState.ENDED.bit).append(" WHERE t.STATES<").append(TaskState.ENDED.bit);
        if (owner != null) {
            update.append(" AND t.OWNR=:o");
        }
        if (pattern != null) {
            update.append(" AND t.INAME LIKE :p");
            if (escape != null) {
                update.append(" ESCAPE :e");
            }
        }
        Map<String, Object> stateParams = null;
        if (!TaskState.ANY.equals((Object)state)) {
            stateParams = this.appendStateComparison(update.append(" AND "), state, inState);
        } else if (!inState) {
            return 0;
        }
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"cancel", (Object[])new Object[]{pattern, escape, (Object)((Object)state) + ":" + inState, owner, update});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            Query query = em.createQuery(update.toString());
            if (owner != null) {
                query.setParameter("o", (Object)owner);
            }
            if (pattern != null) {
                query.setParameter("p", (Object)pattern);
                if (escape != null) {
                    query.setParameter("e", (Object)escape);
                }
            }
            if (stateParams != null) {
                for (Map.Entry<String, Object> param : stateParams.entrySet()) {
                    query.setParameter(param.getKey(), param.getValue());
                }
            }
            int count = query.executeUpdate();
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"cancel", (Object)count);
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(TaskRecord taskRecord) throws Exception {
        Task task = new Task(taskRecord);
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            em.persist((Object)task);
            em.flush();
            taskRecord.setId(task.ID);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @FFDCIgnore(value={EntityExistsException.class, PersistenceException.class, Exception.class})
    public boolean createProperty(String name, String value) throws Exception {
        EntityManager em;
        block13: {
            em = this.getPersistenceServiceUnit().createEntityManager();
            Property property = new Property(name, value);
            try {
                em.persist((Object)property);
                em.flush();
            }
            catch (EntityExistsException x) {
                boolean bl = false;
                return bl;
            }
            catch (PersistenceException x2) {
                block12: {
                    block11: {
                        block10: {
                            if (!(x2.getCause() instanceof SQLIntegrityConstraintViolationException)) break block10;
                            boolean bl = false;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            em.close();
                            return bl;
                        }
                        em.detach((Object)property);
                        if (em.find(Property.class, (Object)name) == null) break block11;
                        boolean bl = false;
                        em.close();
                        return bl;
                    }
                    break block12;
                    catch (Exception ex) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"createProperty", (Object[])new Object[]{ex});
                    }
                }
                FFDCFilter.processException((Throwable)x2, (String)this.getClass().getName(), (String)"309", (Object)this);
                throw x2;
            }
            break block13;
            {
                finally {
                    em.close();
                }
            }
        }
        em.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public List<PartitionRecord> find(PartitionRecord expected) throws Exception {
        StringBuilder select = new StringBuilder(172).append("SELECT p.EXECUTOR,p.HOSTNAME,p.ID,p.LSERVER,p.USERDIR FROM Partition p");
        if (expected != null) {
            int length;
            select.append(" WHERE");
            if (expected.hasExecutor()) {
                select.append(" p.EXECUTOR=:x AND");
            }
            if (expected.hasHostName()) {
                select.append(" p.HOSTNAME=:h AND");
            }
            if (expected.hasId()) {
                select.append(" p.ID=:i AND");
            }
            if (expected.hasLibertyServer()) {
                select.append(" p.LSERVER=:l AND");
            }
            if (expected.hasUserDir()) {
                select.append(" p.USERDIR=:u AND");
            }
            select.delete(length - (select.charAt((length = select.length()) - 1) == 'E' ? 6 : 3), length);
        }
        select.append(" ORDER BY p.ID ASC");
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"find", (Object[])new Object[]{expected, select});
        }
        ArrayList<PartitionRecord> records = new ArrayList<PartitionRecord>();
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(select.toString(), Object[].class);
            if (expected != null) {
                if (expected.hasExecutor()) {
                    query.setParameter("x", (Object)expected.getExecutor());
                }
                if (expected.hasHostName()) {
                    query.setParameter("h", (Object)expected.getHostName());
                }
                if (expected.hasId()) {
                    query.setParameter("i", (Object)expected.getId());
                }
                if (expected.hasLibertyServer()) {
                    query.setParameter("l", (Object)expected.getLibertyServer());
                }
                if (expected.hasUserDir()) {
                    query.setParameter("u", (Object)expected.getUserDir());
                }
            }
            List results = query.getResultList();
            for (Object[] result : results) {
                PartitionRecord record = new PartitionRecord(true);
                record.setExecutor((String)result[0]);
                record.setHostName((String)result[1]);
                record.setId((Long)result[2]);
                record.setLibertyServer((String)result[3]);
                record.setUserDir((String)result[4]);
                records.add(record);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"find", records.size() < 20 ? records : Integer.valueOf(records.size()));
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public TaskRecord find(long taskId, long partitionId, long maxNextExecTime, boolean forUpdate) throws Exception {
        StringBuilder find = new StringBuilder(237).append("SELECT t.LOADER,t.OWNR,t.MBITS,t.INAME,t.NEXTEXEC,t.ORIGSUBMT,t.PREVSCHED,t.PREVSTART,t.PREVSTOP,t.RESLT,t.RFAILS,t.STATES,t.TASKB,t.TASKINFO,t.TRIG,t.VERSION FROM Task t WHERE t.ID=:i AND t.PARTN=:p AND t.STATES<").append(TaskState.SUSPENDED.bit).append(" AND t.NEXTEXEC<=:m");
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"find", (Object[])new Object[]{taskId, partitionId, Utils.appendDate(new StringBuilder(30), maxNextExecTime), forUpdate, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(find.toString(), Object[].class);
            if (forUpdate) {
                query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
            }
            query.setParameter("i", (Object)taskId);
            query.setParameter("p", (Object)partitionId);
            query.setParameter("m", (Object)maxNextExecTime);
            List resultList = query.getResultList();
            if (resultList.isEmpty()) {
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"find", null);
                }
                TaskRecord taskRecord = null;
                return taskRecord;
            }
            Object[] result = (Object[])resultList.get(0);
            TaskRecord taskRecord = new TaskRecord(false);
            taskRecord.setId(taskId);
            taskRecord.setIdentifierOfClassLoader((String)result[0]);
            taskRecord.setIdentifierOfOwner((String)result[1]);
            taskRecord.setIdentifierOfPartition(partitionId);
            taskRecord.setMiscBinaryFlags((Short)result[2]);
            taskRecord.setName((String)result[3]);
            taskRecord.setNextExecutionTime((Long)result[4]);
            taskRecord.setOriginalSubmitTime((Long)result[5]);
            taskRecord.setPreviousScheduledStartTime((Long)result[6]);
            taskRecord.setPreviousStartTime((Long)result[7]);
            taskRecord.setPreviousStopTime((Long)result[8]);
            taskRecord.setResult((byte[])result[9]);
            taskRecord.setConsecutiveFailureCount((Short)result[10]);
            taskRecord.setState((Short)result[11]);
            taskRecord.setTask((byte[])result[12]);
            taskRecord.setTaskInformation((byte[])result[13]);
            taskRecord.setTrigger((byte[])result[14]);
            taskRecord.setVersion((Integer)result[15]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"find", (Object)taskRecord);
            }
            TaskRecord taskRecord2 = taskRecord;
            return taskRecord2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public TaskRecord findById(long taskId, String owner, boolean includeTrigger) throws Exception {
        TaskRecord taskRecord;
        List resultList;
        boolean trace;
        StringBuilder find = new StringBuilder(116).append("SELECT t.LOADER,t.MBITS,t.INAME,t.NEXTEXEC,t.RESLT,t.STATES,t.VERSION");
        if (includeTrigger) {
            find.append(",t.TRIG");
        }
        find.append(" FROM Task t WHERE t.ID=:i");
        if (owner != null) {
            find.append(" AND t.OWNR=:o");
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findById", (Object[])new Object[]{taskId, owner, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(find.toString(), Object[].class);
            query.setParameter("i", (Object)taskId);
            if (owner != null) {
                query.setParameter("o", (Object)owner);
            }
            resultList = query.getResultList();
        }
        if (resultList.isEmpty()) {
            taskRecord = null;
        } else {
            Object[] result = (Object[])resultList.get(0);
            taskRecord = new TaskRecord(false);
            taskRecord.setId(taskId);
            taskRecord.setIdentifierOfClassLoader((String)result[0]);
            taskRecord.setMiscBinaryFlags((Short)result[1]);
            taskRecord.setName((String)result[2]);
            taskRecord.setNextExecutionTime((Long)result[3]);
            taskRecord.setResult((byte[])result[4]);
            taskRecord.setState((Short)result[5]);
            taskRecord.setVersion((Integer)result[6]);
            if (includeTrigger) {
                taskRecord.setTrigger((byte[])result[7]);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findById", (Object)taskRecord);
        }
        return taskRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public long findOrCreate(PartitionRecord record) throws Exception {
        Long result;
        String find = "SELECT p.ID FROM Partition p WHERE p.EXECUTOR=:x AND p.HOSTNAME=:h AND p.LSERVER=:l AND p.USERDIR=:u";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findOrCreate", (Object[])new Object[]{record, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(find, Long.class);
            query.setParameter("x", (Object)record.getExecutor());
            query.setParameter("h", (Object)record.getHostName());
            query.setParameter("l", (Object)record.getLibertyServer());
            query.setParameter("u", (Object)record.getUserDir());
            List results = query.getResultList();
            if (results.size() > 0) {
                result = (Long)results.get(0);
            } else {
                Partition partition = new Partition(record);
                em.persist((Object)partition);
                em.flush();
                result = partition.ID;
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findOrCreate", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public List<Long> findTaskIds(String pattern, Character escape, TaskState state, boolean inState, Long minId, Integer maxResults, String owner, Long partition) throws Exception {
        List resultList;
        int i = 0;
        StringBuilder find = new StringBuilder(152).append("SELECT t.ID FROM Task t");
        if (minId != null) {
            find.append(++i == 1 ? " WHERE" : " AND").append(" t.ID>=:m");
        }
        if (owner != null) {
            find.append(++i == 1 ? " WHERE" : " AND").append(" t.OWNR=:o");
        }
        if (partition != null) {
            find.append(++i == 1 ? " WHERE" : " AND").append(" t.PARTN=:p");
        }
        if (pattern != null) {
            find.append(++i == 1 ? " WHERE" : " AND").append(" t.INAME LIKE :n");
            if (escape != null) {
                find.append(" ESCAPE :e");
            }
        }
        Map<String, Object> stateParams = null;
        if (!TaskState.ANY.equals((Object)state)) {
            stateParams = this.appendStateComparison(find.append(++i == 1 ? " WHERE " : " AND "), state, inState);
        } else if (!inState) {
            return Collections.emptyList();
        }
        find.append(" ORDER BY t.ID ASC");
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findTaskIds", (Object[])new Object[]{pattern, escape, (Object)((Object)state) + ":" + inState, minId, maxResults, owner, partition, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(find.toString(), Long.class);
            if (maxResults != null) {
                query.setMaxResults(maxResults.intValue());
            }
            if (minId != null) {
                query.setParameter("m", (Object)minId);
            }
            if (owner != null) {
                query.setParameter("o", (Object)owner);
            }
            if (partition != null) {
                query.setParameter("p", (Object)partition);
            }
            if (pattern != null) {
                query.setParameter("n", (Object)pattern);
                if (escape != null) {
                    query.setParameter("e", (Object)escape);
                }
            }
            if (stateParams != null) {
                for (Map.Entry<String, Object> param : stateParams.entrySet()) {
                    query.setParameter(param.getKey(), param.getValue());
                }
            }
            resultList = query.getResultList();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findTaskIds", (Object)(resultList.size() <= 100 ? resultList : Integer.valueOf(resultList.size())));
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public List<TaskStatus<?>> findTaskStatus(String pattern, Character escape, TaskState state, boolean inState, Long minId, Integer maxResults, String owner, boolean includeTrigger, PersistentExecutor executor) throws Exception {
        List results;
        StringBuilder find = new StringBuilder(187).append("SELECT t.ID,t.LOADER,t.MBITS,t.INAME,t.NEXTEXEC,t.RESLT,t.STATES");
        if (includeTrigger) {
            find.append(",t.TRIG");
        }
        find.append(" FROM Task t");
        int i = 0;
        if (minId != null) {
            find.append(++i == 1 ? " WHERE" : " AND").append(" t.ID>=:m");
        }
        if (owner != null) {
            find.append(++i == 1 ? " WHERE" : " AND").append(" t.OWNR=:o");
        }
        if (pattern != null) {
            find.append(++i == 1 ? " WHERE" : " AND").append(" t.INAME LIKE :p");
            if (escape != null) {
                find.append(" ESCAPE :e");
            }
        }
        Map<String, Object> stateParams = null;
        if (!TaskState.ANY.equals((Object)state)) {
            stateParams = this.appendStateComparison(find.append(++i == 1 ? " WHERE " : " AND "), state, inState);
        } else if (!inState) {
            return Collections.emptyList();
        }
        find.append(" ORDER BY t.ID ASC");
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findTaskStatus", (Object[])new Object[]{pattern, escape, (Object)((Object)state) + ":" + inState, minId, maxResults, owner, executor, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(find.toString(), Object[].class);
            if (maxResults != null) {
                query.setMaxResults(maxResults.intValue());
            }
            if (minId != null) {
                query.setParameter("m", (Object)minId);
            }
            if (owner != null) {
                query.setParameter("o", (Object)owner);
            }
            if (pattern != null) {
                query.setParameter("p", (Object)pattern);
                if (escape != null) {
                    query.setParameter("e", (Object)escape);
                }
            }
            if (stateParams != null) {
                for (Map.Entry<String, Object> param : stateParams.entrySet()) {
                    query.setParameter(param.getKey(), param.getValue());
                }
            }
            results = query.getResultList();
        }
        ArrayList statusList = new ArrayList(results.size());
        for (Object[] result : results) {
            TaskRecord record = new TaskRecord(false);
            record.setId((Long)result[0]);
            record.setIdentifierOfClassLoader((String)result[1]);
            record.setMiscBinaryFlags((Short)result[2]);
            record.setName((String)result[3]);
            record.setNextExecutionTime((Long)result[4]);
            record.setResult((byte[])result[5]);
            record.setState((Short)result[6]);
            if (includeTrigger) {
                record.setTrigger((byte[])result[7]);
            }
            statusList.add(record.toTaskStatus(executor));
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findTaskStatus", statusList.size() < 20 ? statusList : Integer.valueOf(statusList.size()));
        }
        return statusList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public List<Object[]> findUpcomingTasks(long partition, long maxNextExecTime, Integer maxResults) throws Exception {
        List resultList;
        StringBuilder find = new StringBuilder(129).append("SELECT t.ID,t.MBITS,t.NEXTEXEC,t.TXTIMEOUT FROM Task t WHERE t.PARTN=:p AND t.STATES<").append(TaskState.SUSPENDED.bit).append(" AND t.NEXTEXEC<=:m ORDER BY t.NEXTEXEC");
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findUpcomingTasks", (Object[])new Object[]{partition, Utils.appendDate(new StringBuilder(30), maxNextExecTime), maxResults, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            List results;
            TypedQuery query = em.createQuery(find.toString(), Object[].class);
            query.setParameter("p", (Object)partition);
            query.setParameter("m", (Object)maxNextExecTime);
            if (maxResults != null) {
                query.setMaxResults(maxResults.intValue());
            }
            resultList = results = query.getResultList();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findUpcomingTasks", (Object)resultList.size());
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public TaskRecord getNextExecutionTime(long taskId, String owner) throws Exception {
        TaskRecord taskRecord;
        List resultList;
        boolean trace;
        StringBuilder find = new StringBuilder(74).append("SELECT t.MBITS,t.NEXTEXEC,t.STATES FROM Task t WHERE t.ID=:i");
        if (owner != null) {
            find.append(" AND t.OWNR=:o");
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getNextExecutionTime", (Object[])new Object[]{taskId, owner, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(find.toString(), Object[].class);
            query.setParameter("i", (Object)taskId);
            if (owner != null) {
                query.setParameter("o", (Object)owner);
            }
            resultList = query.getResultList();
        }
        if (resultList.isEmpty()) {
            taskRecord = null;
        } else {
            Object[] result = (Object[])resultList.get(0);
            taskRecord = new TaskRecord(false);
            taskRecord.setMiscBinaryFlags((Short)result[0]);
            taskRecord.setNextExecutionTime((Long)result[1]);
            taskRecord.setState((Short)result[2]);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getNextExecutionTime", (Object)taskRecord);
        }
        return taskRecord;
    }

    public final PersistenceServiceUnit getPersistenceServiceUnit() throws Exception {
        this.lock.readLock().lock();
        try {
            if (this.destroyed) {
                throw new IllegalStateException();
            }
            if (this.persistenceServiceUnit == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    if (this.destroyed) {
                        throw new IllegalStateException();
                    }
                    if (this.persistenceServiceUnit == null) {
                        this.persistenceServiceUnit = this.dbStore.createPersistenceServiceUnit(priv.getClassLoader(Task.class), new String[]{Partition.class.getName(), Property.class.getName(), Task.class.getName()});
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            PersistenceServiceUnit persistenceServiceUnit = this.persistenceServiceUnit;
            return persistenceServiceUnit;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public Map<String, String> getProperties(String pattern, Character escape) throws Exception {
        boolean trace;
        StringBuilder find = new StringBuilder(62).append("SELECT p.ID,p.VAL FROM Property p WHERE p.ID LIKE :p");
        if (escape != null) {
            find.append(" ESCAPE :e");
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getProperties", (Object[])new Object[]{pattern, escape, find});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(find.toString(), Object[].class);
            if (pattern != null) {
                query.setParameter("p", (Object)pattern);
                if (escape != null) {
                    query.setParameter("e", (Object)escape);
                }
            }
            List results = query.getResultList();
            for (Object[] row : results) {
                map.put((String)row[0], (String)row[1]);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getProperties", map.size() < 20 ? map : Integer.valueOf(map.size()));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public String getProperty(String name) throws Exception {
        String find = "SELECT p.VAL FROM Property p WHERE p.ID=:i";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getProperty", (Object[])new Object[]{name, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            String value;
            TypedQuery query = em.createQuery(find, String.class);
            query.setParameter("i", (Object)name);
            List results = query.getResultList();
            String string = value = results.isEmpty() ? null : (String)results.get(0);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getProperty", (Object)value);
            }
            String string2 = value;
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public TaskRecord getTrigger(long taskId) throws Exception {
        TaskRecord taskRecord;
        List resultList;
        String find = "SELECT t.OWNR,t.STATES,t.TRIG FROM Task t WHERE t.ID=:i";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getTrigger", (Object[])new Object[]{taskId, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            TypedQuery query = em.createQuery(find.toString(), Object[].class);
            query.setParameter("i", (Object)taskId);
            resultList = query.getResultList();
        }
        if (resultList.isEmpty()) {
            taskRecord = null;
        } else {
            Object[] result = (Object[])resultList.get(0);
            taskRecord = new TaskRecord(false);
            taskRecord.setIdentifierOfOwner((String)result[0]);
            taskRecord.setState((Short)result[1]);
            taskRecord.setTrigger((byte[])result[2]);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getTrigger", (Object)taskRecord);
        }
        return taskRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public short incrementFailureCount(long taskId) throws Exception {
        short consecutiveFailureCount;
        String update = "UPDATE Task t SET t.RFAILS=t.RFAILS+1 WHERE t.ID=:i AND t.RFAILS<32767";
        String find = "SELECT t.RFAILS FROM Task t WHERE t.ID=:i";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"incrementFailureCount", (Object[])new Object[]{taskId, update, find});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            Query updateQuery = em.createQuery(update.toString());
            updateQuery.setParameter("i", (Object)taskId);
            updateQuery.executeUpdate();
            TypedQuery findQuery = em.createQuery(find, Short.class);
            findQuery.setParameter("i", (Object)taskId);
            List results = findQuery.getResultList();
            consecutiveFailureCount = results.size() == 1 ? (short)((Short)results.get(0)) : (short)-1;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"incrementFailureCount", (Object)consecutiveFailureCount);
        }
        return consecutiveFailureCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public int persist(PartitionRecord updates, PartitionRecord expected) throws Exception {
        int length;
        StringBuilder update = new StringBuilder(160).append("UPDATE Partition SET ");
        if (updates.hasExecutor()) {
            update.append("EXECUTOR=:x2,");
        }
        if (updates.hasHostName()) {
            update.append("HOSTNAME=:h2,");
        }
        if (updates.hasId()) {
            update.append("ID=:i2,");
        }
        if (updates.hasLibertyServer()) {
            update.append("LSERVER=:l2,");
        }
        if (updates.hasUserDir()) {
            update.append("USERDIR=:u2,");
        }
        update.setCharAt(update.length() - 1, ' ');
        update.append("WHERE");
        if (expected.hasExecutor()) {
            update.append(" EXECUTOR=:x1 AND");
        }
        if (expected.hasHostName()) {
            update.append(" HOSTNAME=:h1 AND");
        }
        if (expected.hasId()) {
            update.append(" ID=:i1 AND");
        }
        if (expected.hasLibertyServer()) {
            update.append(" LSERVER=:l1 AND");
        }
        if (expected.hasUserDir()) {
            update.append(" USERDIR=:u1 AND");
        }
        update.delete(length - (update.charAt((length = update.length()) - 1) == 'E' ? 6 : 4), length);
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"persist", (Object[])new Object[]{updates, expected, update});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            Query query = em.createQuery(update.toString());
            if (updates.hasExecutor()) {
                query.setParameter("x2", (Object)updates.getExecutor());
            }
            if (updates.hasHostName()) {
                query.setParameter("h2", (Object)updates.getHostName());
            }
            if (updates.hasId()) {
                query.setParameter("i2", (Object)updates.getId());
            }
            if (updates.hasLibertyServer()) {
                query.setParameter("l2", (Object)updates.getLibertyServer());
            }
            if (updates.hasUserDir()) {
                query.setParameter("u2", (Object)updates.getUserDir());
            }
            if (expected.hasExecutor()) {
                query.setParameter("x1", (Object)expected.getExecutor());
            }
            if (expected.hasHostName()) {
                query.setParameter("h1", (Object)expected.getHostName());
            }
            if (expected.hasId()) {
                query.setParameter("i1", (Object)expected.getId());
            }
            if (expected.hasLibertyServer()) {
                query.setParameter("l1", (Object)expected.getLibertyServer());
            }
            if (expected.hasUserDir()) {
                query.setParameter("u1", (Object)expected.getUserDir());
            }
            int count = query.executeUpdate();
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"persist", (Object)count);
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public boolean persist(TaskRecord updates, TaskRecord expected) throws Exception {
        boolean trace;
        StringBuilder update = new StringBuilder(220).append("UPDATE Task t SET ");
        if (updates != null) {
            if (updates.hasIdentifierOfClassLoader()) {
                update.append("t.LOADER=:c2,");
            }
            if (updates.hasIdentifierOfOwner()) {
                update.append("t.OWNR=:o2,");
            }
            if (updates.hasIdentifierOfPartition()) {
                update.append("t.PARTN=:p2,");
            }
            if (updates.hasMiscBinaryFlags()) {
                update.append("t.MBITS=:m2,");
            }
            if (updates.hasName()) {
                update.append("t.INAME=:n2,");
            }
            if (updates.hasNextExecutionTime()) {
                update.append("t.NEXTEXEC=:ne2,");
            }
            if (updates.hasOriginalSubmitTime()) {
                update.append("t.ORIGSUBMT=:os2,");
            }
            if (updates.hasPreviousScheduledStartTime()) {
                update.append("t.PREVSCHED=:sc2,");
            }
            if (updates.hasPreviousStartTime()) {
                update.append("t.PREVSTART=:sa2,");
            }
            if (updates.hasPreviousStopTime()) {
                update.append("t.PREVSTOP=:so2,");
            }
            if (updates.hasResult()) {
                update.append("t.RESLT=:r2,");
            }
            if (updates.hasConsecutiveFailureCount()) {
                update.append("t.RFAILS=:f2,");
            }
            if (updates.hasState()) {
                update.append("t.STATES=:s2,");
            }
            if (updates.hasTask()) {
                update.append("t.TASKB=:t2,");
            }
            if (updates.hasTaskInformation()) {
                update.append("t.TASKINFO=:ti2,");
            }
            if (updates.hasTrigger()) {
                update.append("t.TRIG=:tr2,");
            }
        }
        update.append("t.VERSION=t.VERSION+1 WHERE t.ID=:i");
        if (expected.hasIdentifierOfClassLoader()) {
            update.append(" AND t.LOADER=:c1");
        }
        if (expected.hasIdentifierOfOwner()) {
            update.append(" AND t.OWNR=:o1");
        }
        if (expected.hasIdentifierOfPartition()) {
            update.append(" AND t.PARTN=:p1");
        }
        if (expected.hasMiscBinaryFlags()) {
            update.append(" AND t.MBITS=:m1");
        }
        if (expected.hasName()) {
            update.append(" AND t.INAME=:n1");
        }
        if (expected.hasNextExecutionTime()) {
            update.append(" AND t.NEXTEXEC=:ne1");
        }
        if (expected.hasOriginalSubmitTime()) {
            update.append(" AND t.ORIGSUBMT=:os1");
        }
        if (expected.hasPreviousScheduledStartTime()) {
            update.append(" AND t.PREVSCHED=:sc1");
        }
        if (expected.hasPreviousStartTime()) {
            update.append(" AND t.PREVSTART=:sa1");
        }
        if (expected.hasPreviousStopTime()) {
            update.append(" AND t.PREVSTOP=:so1");
        }
        if (expected.hasResult()) {
            update.append(" AND t.RESLT=:r1");
        }
        if (expected.hasConsecutiveFailureCount()) {
            update.append(" AND t.RFAILS=:f1");
        }
        if (expected.hasState()) {
            update.append(" AND t.STATES=:s1");
        }
        if (expected.hasTask()) {
            update.append(" AND t.TASKB=:t1");
        }
        if (expected.hasTaskInformation()) {
            update.append(" AND t.TASKINFO=:ti1");
        }
        if (expected.hasTrigger()) {
            update.append(" AND t.TRIG=:tr1");
        }
        if (expected.hasVersion()) {
            update.append(" AND t.VERSION=:v1");
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"persist", (Object[])new Object[]{updates, expected, update});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            boolean updated;
            Query query = em.createQuery(update.toString());
            if (updates != null) {
                if (updates.hasIdentifierOfClassLoader()) {
                    query.setParameter("c2", (Object)updates.getIdentifierOfClassLoader());
                }
                if (updates.hasIdentifierOfOwner()) {
                    query.setParameter("o2", (Object)updates.getIdentifierOfOwner());
                }
                if (updates.hasIdentifierOfPartition()) {
                    query.setParameter("p2", (Object)updates.getIdentifierOfPartition());
                }
                if (updates.hasMiscBinaryFlags()) {
                    query.setParameter("m2", (Object)updates.getMiscBinaryFlags());
                }
                if (updates.hasName()) {
                    query.setParameter("n2", (Object)updates.getName());
                }
                if (updates.hasNextExecutionTime()) {
                    query.setParameter("ne2", (Object)updates.getNextExecutionTime());
                }
                if (updates.hasOriginalSubmitTime()) {
                    query.setParameter("os2", (Object)updates.getOriginalSubmitTime());
                }
                if (updates.hasPreviousScheduledStartTime()) {
                    query.setParameter("sc2", (Object)updates.getPreviousScheduledStartTime());
                }
                if (updates.hasPreviousStartTime()) {
                    query.setParameter("sa2", (Object)updates.getPreviousStartTime());
                }
                if (updates.hasPreviousStopTime()) {
                    query.setParameter("so2", (Object)updates.getPreviousStopTime());
                }
                if (updates.hasResult()) {
                    query.setParameter("r2", (Object)updates.getResult());
                }
                if (updates.hasConsecutiveFailureCount()) {
                    query.setParameter("f2", (Object)updates.getConsecutiveFailureCount());
                }
                if (updates.hasState()) {
                    query.setParameter("s2", (Object)updates.getState());
                }
                if (updates.hasTask()) {
                    query.setParameter("t2", (Object)updates.getTask());
                }
                if (updates.hasTaskInformation()) {
                    query.setParameter("ti2", (Object)updates.getTaskInformation());
                }
                if (updates.hasTrigger()) {
                    query.setParameter("tr2", (Object)updates.getTrigger());
                }
            }
            query.setParameter("i", (Object)expected.getId());
            if (expected.hasIdentifierOfClassLoader()) {
                query.setParameter("c1", (Object)expected.getIdentifierOfClassLoader());
            }
            if (expected.hasIdentifierOfOwner()) {
                query.setParameter("o1", (Object)expected.getIdentifierOfOwner());
            }
            if (expected.hasIdentifierOfPartition()) {
                query.setParameter("p1", (Object)expected.getIdentifierOfPartition());
            }
            if (expected.hasMiscBinaryFlags()) {
                query.setParameter("m1", (Object)expected.getMiscBinaryFlags());
            }
            if (expected.hasName()) {
                query.setParameter("n1", (Object)expected.getName());
            }
            if (expected.hasNextExecutionTime()) {
                query.setParameter("ne1", (Object)expected.getNextExecutionTime());
            }
            if (expected.hasOriginalSubmitTime()) {
                query.setParameter("os1", (Object)expected.getOriginalSubmitTime());
            }
            if (expected.hasPreviousScheduledStartTime()) {
                query.setParameter("sc1", (Object)expected.getPreviousScheduledStartTime());
            }
            if (expected.hasPreviousStartTime()) {
                query.setParameter("sa1", (Object)expected.getPreviousStartTime());
            }
            if (expected.hasPreviousStopTime()) {
                query.setParameter("so1", (Object)expected.getPreviousStopTime());
            }
            if (expected.hasResult()) {
                query.setParameter("r1", (Object)expected.getResult());
            }
            if (expected.hasConsecutiveFailureCount()) {
                query.setParameter("f1", (Object)expected.getConsecutiveFailureCount());
            }
            if (expected.hasState()) {
                query.setParameter("s1", (Object)expected.getState());
            }
            if (expected.hasTask()) {
                query.setParameter("t1", (Object)expected.getTask());
            }
            if (expected.hasTaskInformation()) {
                query.setParameter("ti1", (Object)expected.getTaskInformation());
            }
            if (expected.hasTrigger()) {
                query.setParameter("tr1", (Object)expected.getTrigger());
            }
            if (expected.hasVersion()) {
                query.setParameter("v1", (Object)expected.getVersion());
            }
            boolean bl = updated = query.executeUpdate() > 0;
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"persist", (Object)updated);
            }
            boolean bl2 = updated;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public boolean remove(long taskId, String owner, boolean removeIfEnded) throws Exception {
        boolean trace;
        StringBuilder delete = new StringBuilder(66).append("DELETE FROM Task t WHERE t.ID=:i");
        if (!removeIfEnded) {
            delete.append(" AND t.STATES<").append(TaskState.ENDED.bit);
        }
        if (owner != null) {
            delete.append(" AND t.OWNR=:o");
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object[])new Object[]{taskId, owner, removeIfEnded, delete});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            boolean removed;
            Query query = em.createQuery(delete.toString());
            query.setParameter("i", (Object)taskId);
            if (owner != null) {
                query.setParameter("o", (Object)owner);
            }
            boolean bl = removed = query.executeUpdate() > 0;
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)removed);
            }
            boolean bl2 = removed;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public int remove(PartitionRecord criteria) throws Exception {
        int length;
        StringBuilder delete = new StringBuilder(111).append("DELETE FROM Partition p WHERE");
        if (criteria != null) {
            if (criteria.hasExecutor()) {
                delete.append(" p.EXECUTOR=:x AND");
            }
            if (criteria.hasHostName()) {
                delete.append(" p.HOSTNAME=:h AND");
            }
            if (criteria.hasId()) {
                delete.append(" p.ID=:i AND");
            }
            if (criteria.hasLibertyServer()) {
                delete.append(" p.LSERVER=:l AND");
            }
            if (criteria.hasUserDir()) {
                delete.append(" p.USERDIR=:u AND");
            }
        }
        delete.delete(length - (delete.charAt((length = delete.length()) - 1) == 'E' ? 6 : 4), length);
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object[])new Object[]{criteria, delete});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            Query query = em.createQuery(delete.toString());
            if (criteria != null) {
                if (criteria.hasExecutor()) {
                    query.setParameter("x", (Object)criteria.getExecutor());
                }
                if (criteria.hasHostName()) {
                    query.setParameter("h", (Object)criteria.getHostName());
                }
                if (criteria.hasId()) {
                    query.setParameter("i", (Object)criteria.getId());
                }
                if (criteria.hasLibertyServer()) {
                    query.setParameter("l", (Object)criteria.getLibertyServer());
                }
                if (criteria.hasUserDir()) {
                    query.setParameter("u", (Object)criteria.getUserDir());
                }
            }
            int count = query.executeUpdate();
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)count);
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public int remove(String pattern, Character escape, TaskState state, boolean inState, String owner) throws Exception {
        StringBuilder delete = new StringBuilder(100).append("DELETE FROM Task t");
        int i = 0;
        if (owner != null) {
            delete.append(++i == 1 ? " WHERE" : " AND").append(" t.OWNR=:o");
        }
        if (pattern != null) {
            delete.append(++i == 1 ? " WHERE" : " AND").append(" t.INAME LIKE :p");
            if (escape != null) {
                delete.append(" ESCAPE :e");
            }
        }
        Map<String, Object> stateParams = null;
        if (!TaskState.ANY.equals((Object)state)) {
            stateParams = this.appendStateComparison(delete.append(++i == 1 ? " WHERE " : " AND "), state, inState);
        } else if (!inState) {
            return 0;
        }
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object[])new Object[]{pattern, escape, (Object)((Object)state) + ":" + inState, owner, delete});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            Query query = em.createQuery(delete.toString());
            if (owner != null) {
                query.setParameter("o", (Object)owner);
            }
            if (pattern != null) {
                query.setParameter("p", (Object)pattern);
                if (escape != null) {
                    query.setParameter("e", (Object)escape);
                }
            }
            if (stateParams != null) {
                for (Map.Entry<String, Object> param : stateParams.entrySet()) {
                    query.setParameter(param.getKey(), param.getValue());
                }
            }
            int count = query.executeUpdate();
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)count);
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public int removeProperties(String pattern, Character escape) throws Exception {
        boolean trace;
        StringBuilder delete = new StringBuilder(58).append("DELETE FROM Property WHERE ID LIKE :pattern");
        if (escape != null) {
            delete.append(" ESCAPE :escape");
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeProperties", (Object[])new Object[]{pattern, escape, delete});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            Query query = em.createQuery(delete.toString());
            query.setParameter("pattern", (Object)pattern);
            if (escape != null) {
                query.setParameter("escape", (Object)escape);
            }
            int count = query.executeUpdate();
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"removeProperties", (Object)count);
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public boolean removeProperty(String name) throws Exception {
        String update = "DELETE FROM Property WHERE ID=:i";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeProperty", (Object[])new Object[]{name, update});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            boolean removed;
            Query query = em.createQuery(update);
            query.setParameter("i", (Object)name);
            boolean bl = removed = query.executeUpdate() > 0;
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"removeProperty", (Object)removed);
            }
            boolean bl2 = removed;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public boolean setProperty(String name, String value) throws Exception {
        boolean exists;
        String update = "UPDATE Property SET VAL=:v WHERE ID=:i";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object[])new Object[]{name, value, update});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            Query query = em.createQuery(update);
            query.setParameter("v", (Object)value);
            query.setParameter("i", (Object)name);
            exists = query.executeUpdate() > 0;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)exists);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public int transfer(Long maxTaskId, long oldPartitionId, long newPartitionId) throws Exception {
        StringBuilder update = new StringBuilder(69).append("UPDATE Task SET PARTN=:p2 WHERE ");
        if (maxTaskId != null && maxTaskId != Long.MAX_VALUE) {
            update.append("ID<=:i AND ");
        }
        update.append("PARTN=:p1 AND STATES<").append(TaskState.ENDED.bit);
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"transfer", (Object[])new Object[]{"taskId>=" + maxTaskId, "partition:" + oldPartitionId + "-->" + newPartitionId, update});
        }
        try (EntityManager em = this.getPersistenceServiceUnit().createEntityManager();){
            Query query = em.createQuery(update.toString());
            query.setParameter("p2", (Object)newPartitionId);
            if (maxTaskId != null && maxTaskId != Long.MAX_VALUE) {
                query.setParameter("i", (Object)maxTaskId);
            }
            query.setParameter("p1", (Object)oldPartitionId);
            int count = query.executeUpdate();
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"transfer", (Object)count);
            }
            int n = count;
            return n;
        }
    }
}

