/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.ChannelSelector;
import com.ibm.ws.tcpchannel.internal.ChannelTermination;
import com.ibm.ws.tcpchannel.internal.ConnectChannelSelector;
import com.ibm.ws.tcpchannel.internal.ConnectionManager;
import com.ibm.ws.tcpchannel.internal.NioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.SocketRWChannelSelector;
import com.ibm.ws.tcpchannel.internal.TCPBaseRequestContext;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class WorkQueueManager
implements ChannelTermination,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(WorkQueueManager.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected int maxChannelSelectorsPerFlow = 200;
    protected SocketRWChannelSelector[] readInbound = null;
    protected SocketRWChannelSelector[] readOutbound = null;
    protected SocketRWChannelSelector[] writeInbound = null;
    protected SocketRWChannelSelector[] writeOutbound = null;
    protected ConnectChannelSelector[] connect = null;
    protected int[] readInboundCount = null;
    protected int[] readOutboundCount = null;
    protected int[] writeInboundCount = null;
    protected int[] writeOutboundCount = null;
    protected int[] connectCount = null;
    protected static final int CS_READ_INBOUND = 0;
    protected static final int CS_READ_OUTBOUND = 1;
    protected static final int CS_WRITE_INBOUND = 2;
    protected static final int CS_WRITE_OUTBOUND = 3;
    protected static final int CS_CONNECTOR = 4;
    protected static final int CS_OK = 0;
    protected static final int CS_NULL = -1;
    protected static final int CS_DELETE_IN_PROGRESS = -2;
    protected final Object findOpenIndexSync = new Object(){};
    protected final Object shutdownSync = new Object(){};
    protected int maxKeysPerSelector;
    protected boolean checkCancel;
    private final boolean combineSelectors;
    protected int wakeupOption;
    private final ThreadGroup tGroup;

    protected WorkQueueManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WorkQueueManager", (Object[])new Object[0]);
        }
        this.maxKeysPerSelector = TCPFactoryConfiguration.getMaxKeysPerSelector();
        this.checkCancel = TCPFactoryConfiguration.getCancelKeyOnClose();
        this.wakeupOption = TCPFactoryConfiguration.getSelectorWakeup();
        this.combineSelectors = TCPFactoryConfiguration.getCombineSelectors();
        this.tGroup = new PrivGroupCreation("TCP WQM").run();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WorkQueueManager");
        }
    }

    protected void startSelectors(boolean inBound) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startSelectors " + inBound), (Object[])new Object[0]);
        }
        if (!this.combineSelectors && this.readInbound != null && this.readOutbound != null || this.combineSelectors && this.readInbound != null && this.connect != null) {
            return;
        }
        try {
            if (inBound && this.readInbound == null || !inBound && this.readInbound == null && this.combineSelectors) {
                int i;
                this.readInbound = new SocketRWChannelSelector[this.maxChannelSelectorsPerFlow];
                this.writeInbound = new SocketRWChannelSelector[this.maxChannelSelectorsPerFlow];
                this.readInboundCount = new int[this.maxChannelSelectorsPerFlow];
                this.writeInboundCount = new int[this.maxChannelSelectorsPerFlow];
                for (i = 1; i < this.maxChannelSelectorsPerFlow; ++i) {
                    this.readInboundCount[i] = -1;
                    this.writeInboundCount[i] = -1;
                }
                this.readInbound[0] = new SocketRWChannelSelector(this.wakeupOption, this, 0, 0, this.checkCancel);
                this.createNewThread(this.readInbound[0], 0, 1);
                this.readInboundCount[0] = 0;
                this.writeInbound[0] = new SocketRWChannelSelector(this.wakeupOption, this, 0, 2, this.checkCancel);
                this.createNewThread(this.writeInbound[0], 2, 1);
                this.writeInboundCount[0] = 0;
                if (!inBound) {
                    this.connect = new ConnectChannelSelector[this.maxChannelSelectorsPerFlow];
                    this.connectCount = new int[this.maxChannelSelectorsPerFlow];
                    for (i = 1; i < this.maxChannelSelectorsPerFlow; ++i) {
                        this.connectCount[i] = -1;
                    }
                    this.connect[0] = new ConnectChannelSelector(this, 0, 4);
                    this.createNewThread(this.connect[0], 4, 1);
                    this.connectCount[0] = 0;
                }
            } else if (!this.combineSelectors && !inBound && this.readOutbound == null) {
                this.readOutbound = new SocketRWChannelSelector[this.maxChannelSelectorsPerFlow];
                this.writeOutbound = new SocketRWChannelSelector[this.maxChannelSelectorsPerFlow];
                this.connect = new ConnectChannelSelector[this.maxChannelSelectorsPerFlow];
                this.readOutboundCount = new int[this.maxChannelSelectorsPerFlow];
                this.writeOutboundCount = new int[this.maxChannelSelectorsPerFlow];
                this.connectCount = new int[this.maxChannelSelectorsPerFlow];
                this.readOutbound[0] = new SocketRWChannelSelector(this.wakeupOption, this, 0, 1, this.checkCancel);
                this.createNewThread(this.readOutbound[0], 1, 1);
                this.writeOutbound[0] = new SocketRWChannelSelector(this.wakeupOption, this, 0, 3, this.checkCancel);
                this.createNewThread(this.writeOutbound[0], 3, 1);
                this.connect[0] = new ConnectChannelSelector(this, 0, 4);
                this.createNewThread(this.connect[0], 4, 1);
                for (int i = 1; i < this.maxChannelSelectorsPerFlow; ++i) {
                    this.readOutboundCount[i] = -1;
                    this.writeOutboundCount[i] = -1;
                    this.connectCount[i] = -1;
                }
                this.readOutboundCount[0] = 0;
                this.writeOutboundCount[0] = 0;
                this.connectCount[0] = 0;
            } else if (this.combineSelectors && !inBound && this.connect == null) {
                this.connect = new ConnectChannelSelector[this.maxChannelSelectorsPerFlow];
                this.connectCount = new int[this.maxChannelSelectorsPerFlow];
                this.connect[0] = new ConnectChannelSelector(this, 0, 4);
                this.createNewThread(this.connect[0], 4, 1);
                for (int i = 0; i < this.maxChannelSelectorsPerFlow; ++i) {
                    this.connectCount[i] = -1;
                }
                this.connectCount[0] = 0;
            }
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"100", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Caught IOException while trying to create selector: " + ioe), (Object[])new Object[0]);
            }
            ChannelException ce = new ChannelException("Unable to start the TCP Channel", ioe);
            throw ce;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startSelectors");
        }
    }

    protected void updateCount(int index, int value, int channelType) {
        if (channelType == 0) {
            this.readInboundCount[index] = value;
        } else if (channelType == 1) {
            this.readOutboundCount[index] = value;
        } else if (channelType == 2) {
            this.writeInboundCount[index] = value;
        } else if (channelType == 3) {
            this.writeOutboundCount[index] = value;
        } else if (channelType == 4) {
            this.connectCount[index] = value;
        }
    }

    public List<String> introspect() {
        LinkedList<String> rc = new LinkedList<String>();
        rc.add(this.dumpChannelSelectorCounts(this.readInboundCount, "Read Inbound"));
        rc.add(this.dumpChannelSelectorCounts(this.readOutboundCount, "Read Outbound"));
        rc.add(this.dumpChannelSelectorCounts(this.writeInboundCount, "Write Inbound"));
        rc.add(this.dumpChannelSelectorCounts(this.writeOutboundCount, "Write Outbound"));
        rc.add(this.dumpChannelSelectorCounts(this.connectCount, "Connect"));
        return rc;
    }

    public String[] introspectSelf() {
        List<String> rc = this.introspect();
        return rc.toArray(new String[rc.size()]);
    }

    private String dumpChannelSelectorCounts(int[] channelCounts, String channelType) {
        StringBuilder sb = new StringBuilder();
        sb.append(channelType);
        if (null != channelCounts) {
            for (int i = 0; i < channelCounts.length; ++i) {
                if (channelCounts[i] == -1) continue;
                sb.append(' ');
                sb.append(i).append(':').append(channelCounts[i]);
            }
        } else {
            sb.append(" none");
        }
        return sb.toString();
    }

    protected VirtualConnection processWork(TCPBaseRequestContext req, int options) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processWork", (Object[])new Object[0]);
        }
        TCPConnLink conn = req.getTCPConnLink();
        VirtualConnection vc = null;
        if (options != 1 && req.isRequestTypeRead()) {
            ((TCPReadRequestContextImpl)req).setJITAllocateAction(false);
        }
        if (this.attemptIO(req, false)) {
            vc = conn.getVirtualConnection();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processWork");
        }
        return vc;
    }

    @Override
    public void terminate() {
        this.shutdown();
    }

    protected void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object[])new Object[0]);
        }
        if (this.readInboundCount != null) {
            this.shutdownFlow(this.readInboundCount, this.readInbound);
        }
        if (this.readOutboundCount != null) {
            this.shutdownFlow(this.readOutboundCount, this.readOutbound);
        }
        if (this.writeInboundCount != null) {
            this.shutdownFlow(this.writeInboundCount, this.writeInbound);
        }
        if (this.writeOutboundCount != null) {
            this.shutdownFlow(this.writeOutboundCount, this.writeOutbound);
        }
        if (this.connectCount != null) {
            this.shutdownFlow(this.connectCount, this.connect);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownFlow(int[] channelCounts, ChannelSelector[] CS) {
        for (int i = 0; i < this.maxChannelSelectorsPerFlow; ++i) {
            Object object = this.shutdownSync;
            synchronized (object) {
                if (channelCounts[i] != -1) {
                    CS[i].shutDown();
                }
                continue;
            }
        }
    }

    private void queueIO(TCPBaseRequestContext req) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"queueIO", (Object[])new Object[0]);
        }
        TCPConnLink conn = req.getTCPConnLink();
        ChannelSelector channelSelector = req.isRequestTypeRead() ? ((NioSocketIOChannel)conn.getSocketIOChannel()).getChannelSelectorRead() : ((NioSocketIOChannel)conn.getSocketIOChannel()).getChannelSelectorWrite();
        if (channelSelector != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Adding work to selector", (Object[])new Object[0]);
            }
            channelSelector.addWork(req);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Finding selector for IO", (Object[])new Object[0]);
            }
            if (req.isRequestTypeRead()) {
                if (conn.getConfig().isInbound() || this.combineSelectors) {
                    this.moveIntoPosition(this.readInboundCount, this.readInbound, req, 0);
                } else {
                    this.moveIntoPosition(this.readOutboundCount, this.readOutbound, req, 1);
                }
            } else if (conn.getConfig().isInbound() || this.combineSelectors) {
                this.moveIntoPosition(this.writeInboundCount, this.writeInbound, req, 2);
            } else {
                this.moveIntoPosition(this.writeOutboundCount, this.writeOutbound, req, 3);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queueIO");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveIntoPosition(int[] channelCounts, ChannelSelector[] CS, Object req, int channelType) throws IOException {
        for (int i = 0; i < this.maxChannelSelectorsPerFlow; ++i) {
            if (channelCounts[i] < 0 || channelCounts[i] >= this.maxKeysPerSelector) continue;
            CS[i].addWork(req);
            return;
        }
        Object object = this.findOpenIndexSync;
        synchronized (object) {
            int nextOpen;
            for (nextOpen = 0; nextOpen < this.maxChannelSelectorsPerFlow && channelCounts[nextOpen] != -1; ++nextOpen) {
            }
            if (nextOpen < this.maxChannelSelectorsPerFlow) {
                try {
                    if (channelType == 4) {
                        CS[nextOpen] = new ConnectChannelSelector(this, nextOpen, 4);
                    }
                    CS[nextOpen] = new SocketRWChannelSelector(this.wakeupOption, this, nextOpen, channelType, this.checkCancel);
                }
                catch (IOException x) {
                    FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"120", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Caught IOException creating new selector; " + x), (Object[])new Object[0]);
                    }
                    throw x;
                }
            } else {
                String sChannelType = "";
                if (channelType == 0) {
                    sChannelType = "readInbound";
                } else if (channelType == 1) {
                    sChannelType = "readOutbound";
                } else if (channelType == 2) {
                    sChannelType = "writeInbound";
                } else if (channelType == 3) {
                    sChannelType = "writeOutbound";
                } else if (channelType == 4) {
                    sChannelType = "connect";
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("All selectors full, can not handle new request on TCP Channel type: " + sChannelType), (Object[])new Object[0]);
                }
                IOException ioe = new IOException("All selectors full, can not handle new request on TCP Channel type: " + sChannelType);
                FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"130", (Object)this);
                throw ioe;
            }
            this.createNewThread(CS[nextOpen], channelType, nextOpen + 1);
            channelCounts[nextOpen] = 0;
            CS[nextOpen].addWork(req);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void requestComplete(TCPBaseRequestContext req, IOException t) {
        block20: {
            if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)WorkQueueManager.tc, (String)"requestComplete", (Object[])new Object[0]);
            }
            conn = req.getTCPConnLink();
            if (req.blockedThread) {
                if (t != null) {
                    req.blockingIOError = t;
                }
                req.blockWait.simpleNotify();
            } else if (req.isRequestTypeRead()) {
                cc = ((TCPReadRequestContextImpl)req).getReadCompletedCallback();
                if (cc != null) {
                    if (t != null) {
                        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)WorkQueueManager.tc, (String)"calling cc.error callback", (Object[])new Object[0]);
                        }
                        cc.error(conn.getVirtualConnection(), (TCPReadRequestContext)req, t);
                    } else if (!conn.getTCPChannel().getStopFlag()) {
                        try {
                            cc.complete(conn.getVirtualConnection(), (TCPReadRequestContextImpl)req);
                        }
                        catch (RuntimeException err) {
                            if (conn.getTCPChannel().getStopFlag()) ** GOTO lbl37
                            throw err;
                        }
                    }
                }
            } else {
                cc = ((TCPWriteRequestContextImpl)req).getWriteCompletedCallback();
                if (cc != null) {
                    if (t != null) {
                        cc.error(conn.getVirtualConnection(), (TCPWriteRequestContext)req, t);
                    } else if (!conn.getTCPChannel().getStopFlag()) {
                        try {
                            cc.complete(conn.getVirtualConnection(), (TCPWriteRequestContext)req);
                        }
                        catch (RuntimeException err) {
                            if (conn.getTCPChannel().getStopFlag()) break block20;
                            throw err;
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)WorkQueueManager.tc, (String)"requestComplete");
        }
    }

    protected boolean attemptIO(TCPBaseRequestContext req, boolean fromSelector) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"attemptIO", (Object[])new Object[0]);
        }
        SocketIOChannel.IOResult status = SocketIOChannel.IOResult.NOT_COMPLETE;
        TCPConnLink conn = req.getTCPConnLink();
        SocketIOChannel ioChannel = conn.getSocketIOChannel();
        if (ioChannel == null || conn.isClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"attemptIO", (Object)"Closed");
            }
            return false;
        }
        try {
            req.setLastIOAmt(0L);
            if (req.isRequestTypeRead()) {
                if (!req.isForceQueue() && (status = ioChannel.attemptReadFromSocket(req, fromSelector)) == SocketIOChannel.IOResult.COMPLETE && !fromSelector) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"attemptIO");
                    }
                    return true;
                }
                if (status == SocketIOChannel.IOResult.COMPLETE) {
                    this.requestComplete(req, null);
                } else if (status == SocketIOChannel.IOResult.NOT_COMPLETE) {
                    if (!req.isForceQueue() && req.getConfig().getDumpStatsInterval() > 0) {
                        if (req.blockedThread) {
                            conn.getTCPChannel().totalPartialSyncReads.incrementAndGet();
                        } else if (!fromSelector && req.getLastIOAmt() == 0L) {
                            conn.getTCPChannel().totalAsyncReadRetries.incrementAndGet();
                        } else {
                            conn.getTCPChannel().totalPartialAsyncReads.incrementAndGet();
                        }
                    }
                    req.setForceQueue(false);
                    this.queueIO(req);
                }
            } else {
                if (!req.isForceQueue() && (status = ioChannel.attemptWriteToSocket(req)) == SocketIOChannel.IOResult.COMPLETE && !fromSelector) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"attemptIO");
                    }
                    return true;
                }
                if (status == SocketIOChannel.IOResult.COMPLETE) {
                    this.requestComplete(req, null);
                } else if (status == SocketIOChannel.IOResult.NOT_COMPLETE) {
                    if (!req.isForceQueue() && req.config.getDumpStatsInterval() > 0) {
                        if (req.blockedThread) {
                            conn.getTCPChannel().totalPartialSyncWrites.incrementAndGet();
                        } else if (!fromSelector && req.getLastIOAmt() == 0L) {
                            conn.getTCPChannel().totalAsyncWriteRetries.incrementAndGet();
                        } else {
                            conn.getTCPChannel().totalPartialAsyncWrites.incrementAndGet();
                        }
                    }
                    req.setForceQueue(false);
                    this.queueIO(req);
                }
            }
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while doing IO requested on local: " + conn.getSocketIOChannel().getSocket().getLocalSocketAddress() + " remote: " + conn.getSocketIOChannel().getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Exception is: " + e), (Object[])new Object[0]);
            }
            if (req.isRequestTypeRead() && ((TCPReadRequestContextImpl)req).getJITAllocateAction()) {
                req.getBuffer().release();
                req.setBuffer(null);
                ((TCPReadRequestContextImpl)req).setJITAllocateAction(false);
            }
            this.requestComplete(req, e);
        }
        if (status == SocketIOChannel.IOResult.FAILED) {
            IOException ioe = null;
            if (req.isRequestTypeRead()) {
                String s = "Connection closed: Read failed.  Possible end of stream encountered.";
                try {
                    SocketAddress aLocal = conn.getSocketIOChannel().getSocket().getLocalSocketAddress();
                    SocketAddress aRemote = conn.getSocketIOChannel().getSocket().getRemoteSocketAddress();
                    s = s + " local=" + aLocal + " remote=" + aRemote;
                }
                catch (Exception aLocal) {
                    // empty catch block
                }
                ioe = new IOException(s);
            } else {
                String s = "Connection closed: Write failed.";
                try {
                    SocketAddress aLocal = conn.getSocketIOChannel().getSocket().getLocalSocketAddress();
                    SocketAddress aRemote = conn.getSocketIOChannel().getSocket().getRemoteSocketAddress();
                    s = s + " local=" + aLocal + " remote=" + aRemote;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ioe = new IOException(s);
            }
            this.requestComplete(req, ioe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"attemptIO");
        }
        return false;
    }

    protected boolean dispatch(TCPBaseRequestContext req, IOException ioe) {
        if (req.blockedThread) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dispatcher notifying waiting synch request ", (Object[])new Object[0]);
            }
            if (ioe != null) {
                req.blockingIOError = ioe;
            }
            req.blockWait.simpleNotify();
            return true;
        }
        return this.dispatchWorker(new Worker(req, ioe));
    }

    private boolean dispatchWorker(Worker worker) {
        ExecutorService executorService = CHFWBundle.getExecutorService();
        if (null == executorService) {
            if (FrameworkState.isValid()) {
                Tr.error((TraceComponent)tc, (String)"EXECUTOR_SVC_MISSING", (Object[])new Object[0]);
                throw new RuntimeException("Missing executor service");
            }
            return false;
        }
        executorService.execute(worker);
        return true;
    }

    protected void queueConnectForSelector(ConnectionManager.ConnectInfo connectInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"queueConnectForSelector", (Object[])new Object[0]);
        }
        try {
            this.moveIntoPosition(this.connectCount, this.connect, connectInfo, 4);
        }
        catch (IOException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"140", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught IOException...throwing RuntimeException", (Object[])new Object[0]);
            }
            throw new RuntimeException(x);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queueConnectForSelector");
        }
    }

    protected void createNewThread(ChannelSelector sr, int threadType, int number) {
        StartPrivilegedThread privThread = new StartPrivilegedThread(sr, threadType, number, this.tGroup);
        AccessController.doPrivileged(privThread);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean attemptConnectWork(ConnectionManager.ConnectInfo ci) {
        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)WorkQueueManager.tc, (String)"attemptConnectWork", (Object[])new Object[0]);
        }
        returnConnectDone = true;
        switch (ci.action) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)WorkQueueManager.tc, (String)("Finish_connection case for, local: " + ci.localAddress + " remote: " + ci.remoteAddress), (Object[])new Object[0]);
                }
                if (!ci.channel.isConnectionPending()) ** GOTO lbl37
                try {
                    connectDone = ci.channel.finishConnect();
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)WorkQueueManager.tc, (String)("Finishconnect returned " + connectDone + " for, local: " + ci.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + ci.ioSocket.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                    }
                    if (!connectDone) {
                        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                            Tr.event((TraceComponent)WorkQueueManager.tc, (String)"FinishConnect returned false, retrying", (Object[])new Object[0]);
                        }
                        this.queueConnectForSelector(ci);
                        returnConnectDone = false;
                        break;
                    }
                    if (!ci.channel.isConnected()) {
                        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                            Tr.event((TraceComponent)WorkQueueManager.tc, (String)"FinishConnect returned true, but not connected", (Object[])new Object[0]);
                        }
                        iaRemote = ci.remoteAddress;
                        iaLocal = ci.localAddress;
                        e = new IOException("Connection could not be established. local=" + iaLocal + " remote=" + iaRemote);
                        ci.setError(e);
                        ci.tcpConnLink.connectFailed(e);
                    }
                    ** GOTO lbl42
                }
                catch (IOException ioe) {
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)WorkQueueManager.tc, (String)("SocketChannel connect failed, local: " + ci.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + ci.ioSocket.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)WorkQueueManager.tc, (String)("SocketChannel.finishConnect Exception Caught: " + ioe), (Object[])new Object[0]);
                    }
                    ci.setError(ioe);
                    ci.tcpConnLink.connectFailed(ioe);
                }
                break;
lbl37:
                // 1 sources

                if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)WorkQueueManager.tc, (String)"Connection got selected, but isConnectionPending returned false", (Object[])new Object[0]);
                }
                returnConnectDone = false;
                this.queueConnectForSelector(ci);
                break;
lbl42:
                // 1 sources

                if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)WorkQueueManager.tc, (String)("SocketChannel connected, local: " + ci.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + ci.ioSocket.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                }
                ci.setFinishComplete();
                try {
                    ci.tcpConnLink.connectComplete(ci.ioSocket);
                }
                catch (IOException ioe) {
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)WorkQueueManager.tc, (String)("SocketChannel connect failed, local: " + ci.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + ci.ioSocket.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)WorkQueueManager.tc, (String)("SocketChannel.finishConnect Exception Caught: " + ioe), (Object[])new Object[0]);
                    }
                    ci.setError(ioe);
                    ci.tcpConnLink.connectFailed(ioe);
                }
                break;
            }
            case 2: {
                ci.tcpConnLink.connectFailed(ci.errorException);
                break;
            }
            default: {
                if (!TraceComponent.isAnyTracingEnabled() || !WorkQueueManager.tc.isEventEnabled()) break;
                Tr.event((TraceComponent)WorkQueueManager.tc, (String)"Should never get here - default.", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)WorkQueueManager.tc, (String)("attemptConnectWork returning " + returnConnectDone));
        }
        return returnConnectDone;
    }

    void workerRun(TCPBaseRequestContext req, IOException ioe) {
        block14: {
            if (null == req || req.getTCPConnLink().isClosed()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Ignoring IO on closed socket: " + req), (Object[])new Object[0]);
                }
                return;
            }
            try {
                if (ioe == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Worker thread processing IO request: " + req), (Object[])new Object[0]);
                    }
                    this.attemptIO(req, true);
                } else if (req.isRequestTypeRead()) {
                    TCPReadRequestContextImpl readReq = (TCPReadRequestContextImpl)req;
                    if (readReq.getReadCompletedCallback() != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Worker thread processing read error: " + req.getTCPConnLink().getSocketIOChannel().getChannel()), (Object[])new Object[0]);
                        }
                        readReq.getReadCompletedCallback().error(readReq.getTCPConnLink().getVirtualConnection(), readReq, ioe);
                    }
                } else {
                    TCPWriteRequestContextImpl writeReq = (TCPWriteRequestContextImpl)req;
                    if (writeReq.getWriteCompletedCallback() != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Worker thread processing write error: " + req), (Object[])new Object[0]);
                        }
                        writeReq.getWriteCompletedCallback().error(writeReq.getTCPConnLink().getVirtualConnection(), writeReq, ioe);
                    }
                }
            }
            catch (Throwable t) {
                if (FrameworkState.isValid()) {
                    FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"workerRun(req)", (Object[])new Object[]{this, req, ioe});
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block14;
                Tr.event((TraceComponent)tc, (String)("Unexpected error in worker; " + t), (Object[])new Object[0]);
            }
        }
    }

    void workerRun(ConnectionManager.ConnectInfo connInfo) {
        block5: {
            if (connInfo != null) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Worker thread processing connect request", (Object[])new Object[0]);
                    }
                    this.attemptConnectWork(connInfo);
                }
                catch (Throwable t) {
                    if (FrameworkState.isValid()) {
                        FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"workerRun(conn)", (Object[])new Object[]{this, connInfo});
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                    Tr.event((TraceComponent)tc, (String)("Unexpected error in worker; " + t), (Object[])new Object[0]);
                }
            }
        }
    }

    protected boolean dispatchConnect(ConnectionManager.ConnectInfo work) {
        if (work.getSyncObject() != null) {
            work.getSyncObject().simpleNotify();
            return true;
        }
        return this.dispatchWorker(new Worker(work));
    }

    private static class PrivGroupCreation
    implements PrivilegedAction<ThreadGroup> {
        private String name = null;

        protected PrivGroupCreation(String newName) {
            this.name = newName;
        }

        @Override
        public ThreadGroup run() {
            return new ThreadGroup(this.name);
        }
    }

    private static class StartPrivilegedThread
    implements PrivilegedAction<Object> {
        private final ChannelSelector sr;
        private final int threadType;
        private final int number;
        private final ThreadGroup group;

        public StartPrivilegedThread(ChannelSelector _sr, int _threadType, int _number, ThreadGroup tg) {
            this.sr = _sr;
            this.threadType = _threadType;
            this.number = _number;
            this.group = tg;
        }

        @Override
        public Object run() {
            String threadName = null;
            if (this.threadType == 0) {
                threadName = "Inbound Read Selector";
            } else if (this.threadType == 1) {
                threadName = "Outbound Read Selector";
            } else if (this.threadType == 2) {
                threadName = "Inbound Write Selector";
            } else if (this.threadType == 3) {
                threadName = "Outbound Write Selector";
            } else if (this.threadType == 4) {
                threadName = "Connect Selector";
            }
            Thread t = new Thread(this.group, this.sr);
            t.setName(threadName + "." + this.number);
            t.setDaemon(true);
            t.start();
            return null;
        }
    }

    protected class Worker
    implements Runnable {
        private TCPBaseRequestContext req = null;
        private ConnectionManager.ConnectInfo connInfo = null;
        private IOException ioe = null;

        protected Worker(TCPBaseRequestContext _reqIn, IOException _ioe) {
            this.req = _reqIn;
            this.ioe = _ioe;
        }

        protected Worker(ConnectionManager.ConnectInfo ciIn) {
            this.connInfo = ciIn;
        }

        @Override
        public void run() {
            if (this.req != null) {
                WorkQueueManager.this.workerRun(this.req, this.ioe);
            } else if (this.connInfo != null) {
                WorkQueueManager.this.workerRun(this.connInfo);
            }
        }
    }
}

