/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver;

import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resolver.ProductRequirementInformation;
import com.ibm.ws.repository.resolver.internal.LibertyVersion;
import com.ibm.ws.repository.resolver.internal.LibertyVersionRange;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.service.resolver.ResolutionException;

public class RepositoryResolutionException
extends RepositoryException {
    private static final long serialVersionUID = 4270023429850109361L;
    private final Collection<String> topLevelFeaturesNotResolved;
    private final Collection<String> allRequirementsNotFound;
    private final Collection<ProductRequirementInformation> missingProductInformation;
    private final Collection<MissingRequirement> allRequirementsResourcesNotFound;

    public RepositoryResolutionException(ResolutionException cause, Collection<String> topLevelFeaturesNotResolved, Collection<String> allRequirementsNotFound, Collection<ProductRequirementInformation> missingProductInformation, Collection<MissingRequirement> allRequirementsResourcesNotFound) {
        super((Throwable)cause);
        this.topLevelFeaturesNotResolved = topLevelFeaturesNotResolved;
        this.allRequirementsNotFound = allRequirementsNotFound;
        this.missingProductInformation = missingProductInformation;
        this.allRequirementsResourcesNotFound = allRequirementsResourcesNotFound;
    }

    public Collection<String> getTopLevelFeaturesNotResolved() {
        return this.topLevelFeaturesNotResolved;
    }

    @Deprecated
    public Collection<String> getAllRequirementsNotFound() {
        return this.allRequirementsNotFound;
    }

    public Collection<MissingRequirement> getAllRequirementsResourcesNotFound() {
        return this.allRequirementsResourcesNotFound;
    }

    public ResolutionException getCause() {
        return (ResolutionException)super.getCause();
    }

    public String getMinimumVersionForMissingProduct(String productId, String version, String edition) {
        Collection<LibertyVersionRange> filteredRanges = this.filterVersionRanges(productId, edition);
        HashSet<LibertyVersion> minimumVersions = new HashSet<LibertyVersion>();
        for (LibertyVersionRange range : filteredRanges) {
            minimumVersions.add(range.getMinVersion());
        }
        Collection<LibertyVersion> filteredVersions = this.filterVersions(minimumVersions, version);
        LibertyVersion minimumVersion = null;
        for (LibertyVersion potentialNewMinVersion : filteredVersions) {
            if (minimumVersion != null && potentialNewMinVersion.compareTo(minimumVersion) >= 0) continue;
            minimumVersion = potentialNewMinVersion;
        }
        return minimumVersion == null ? null : minimumVersion.toString();
    }

    private Collection<LibertyVersion> filterVersions(Collection<LibertyVersion> minimumVersions, String version) {
        LibertyVersion versionToMatch = LibertyVersion.valueOf(version);
        if (versionToMatch == null) {
            return minimumVersions;
        }
        HashSet<LibertyVersion> filteredVersions = new HashSet<LibertyVersion>();
        for (LibertyVersion versionToTest : minimumVersions) {
            if (!versionToTest.matchesToMicros(versionToMatch)) continue;
            filteredVersions.add(versionToTest);
        }
        return filteredVersions;
    }

    private Collection<LibertyVersionRange> filterVersionRanges(String productId, String edition) {
        HashSet<LibertyVersionRange> filteredRanges = new HashSet<LibertyVersionRange>();
        if (this.missingProductInformation != null) {
            for (ProductRequirementInformation product : this.missingProductInformation) {
                if (product.versionRange == null || productId != null && !productId.equals(product.productId) || edition != null && product.editions != null && !product.editions.isEmpty() && !product.editions.contains(edition)) continue;
                filteredRanges.add(product.versionRange);
            }
        }
        return filteredRanges;
    }

    public String getMaximumVersionForMissingProduct(String productId, String version, String edition) {
        Collection<LibertyVersionRange> filteredRanges = this.filterVersionRanges(productId, edition);
        HashSet<LibertyVersion> maximumVersions = new HashSet<LibertyVersion>();
        for (LibertyVersionRange range : filteredRanges) {
            LibertyVersion maxVersion = range.getMaxVersion();
            if (maxVersion == null) {
                return null;
            }
            maximumVersions.add(maxVersion);
        }
        Collection<LibertyVersion> filteredVersions = this.filterVersions(maximumVersions, version);
        LibertyVersion maximumVersion = null;
        for (LibertyVersion potentialNewMaxVersion : filteredVersions) {
            if (maximumVersion != null && potentialNewMaxVersion.compareTo(maximumVersion) <= 0) continue;
            maximumVersion = potentialNewMaxVersion;
        }
        return maximumVersion == null ? null : maximumVersion.toString();
    }

    public Collection<ProductRequirementInformation> getMissingProducts() {
        return this.missingProductInformation;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (String missing : this.getTopLevelFeaturesNotResolved()) {
            sb.append("Requirement not met: resource=").append(missing).append("\n");
        }
        return sb.toString();
    }

    public static class MissingRequirement {
        public final String requirementName;
        public final RepositoryResource owningResource;

        MissingRequirement(String requirementName, RepositoryResource owningResource) {
            this.requirementName = requirementName;
            this.owningResource = owningResource;
        }

        public String toString() {
            return "MissingRequirement [requirementName=" + this.requirementName + ", owningResource=" + this.owningResource + "]";
        }

        public String getRequirementName() {
            return this.requirementName;
        }

        public RepositoryResource getOwningResource() {
            return this.owningResource;
        }
    }
}

