/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serialization;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DeserializationObjectInputStream
extends ObjectInputStream {
    private static final TraceComponent tc = Tr.register(DeserializationObjectInputStream.class);
    private static final Class<?> thisClass = DeserializationObjectInputStream.class;
    private final ClassLoader classLoader;
    private static final ClassLoader platformClassloader = DeserializationObjectInputStream.getPlatformClassLoader();
    static final long serialVersionUID = -1537167972253875026L;

    public DeserializationObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unable to load " + name), (Object[])new Object[]{e});
            }
            throw e;
        }
    }

    protected Class<?> resolveClass(String name) throws ClassNotFoundException {
        if (name.length() > 0 && name.charAt(0) == '[') {
            int numComponents = 0;
            do {
                if (++numComponents != name.length()) continue;
                throw new ClassNotFoundException(name);
            } while (name.charAt(numComponents) == '[');
            if (name.charAt(numComponents) != 'L') {
                return this.resolveClassWithCL(name);
            }
            if (name.charAt(name.length() - 1) != ';') {
                throw new ClassNotFoundException(name);
            }
            if (name.regionMatches(numComponents + 1, "java.", 0, 5)) {
                return this.resolveClassWithCL(name);
            }
            String className = name.substring(numComponents + 1, name.length() - 1);
            Class<?> klass = this.loadClass(className);
            return Class.forName(name, false, DeserializationObjectInputStream.getClassLoader(klass));
        }
        if (name.startsWith("java.")) {
            return this.resolveClassWithCL(name);
        }
        return this.loadClass(name);
    }

    private Class<?> resolveClassWithCL(String name) throws ClassNotFoundException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            return Class.forName(name, false, DeserializationObjectInputStream.getClassLoader(thisClass));
        }
        return Class.forName(name, false, platformClassloader);
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> resolveClass(ObjectStreamClass klass) throws ClassNotFoundException {
        String name = klass.getName();
        try {
            return this.resolveClass(name);
        }
        catch (ClassNotFoundException e) {
            if (name.indexOf(46) == -1) {
                switch (name.hashCode()) {
                    case 64711720: {
                        if (!name.equals("boolean")) break;
                        return Boolean.TYPE;
                    }
                    case 3039496: {
                        if (!name.equals("byte")) break;
                        return Byte.TYPE;
                    }
                    case 109413500: {
                        if (!name.equals("short")) break;
                        return Short.TYPE;
                    }
                    case 3052374: {
                        if (!name.equals("char")) break;
                        return Character.TYPE;
                    }
                    case 104431: {
                        if (!name.equals("int")) break;
                        return Integer.TYPE;
                    }
                    case 97526364: {
                        if (!name.equals("float")) break;
                        return Float.TYPE;
                    }
                    case 3327612: {
                        if (!name.equals("long")) break;
                        return Long.TYPE;
                    }
                    case -1325958191: {
                        if (!name.equals("double")) break;
                        return Double.TYPE;
                    }
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> resolveProxyClass(String[] interfaceNames) throws ClassNotFoundException {
        ClassLoader proxyClassLoader = this.classLoader;
        Class[] interfaces = new Class[interfaceNames.length];
        Class<?> nonPublicInterface = null;
        for (int i = 0; i < interfaceNames.length; ++i) {
            Class<?> intf = this.loadClass(interfaceNames[i]);
            if (!Modifier.isPublic(intf.getModifiers())) {
                ClassLoader classLoader = DeserializationObjectInputStream.getClassLoader(intf);
                if (nonPublicInterface != null) {
                    if (classLoader != proxyClassLoader) {
                        throw new IllegalAccessError(nonPublicInterface + " and " + intf + " both declared non-public in different class loaders");
                    }
                } else {
                    nonPublicInterface = intf;
                    proxyClassLoader = classLoader;
                }
            }
            interfaces[i] = intf;
        }
        try {
            return Proxy.getProxyClass(proxyClassLoader, interfaces);
        }
        catch (IllegalArgumentException i) {
            void ex;
            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.serialization.DeserializationObjectInputStream", (String)"238", (Object)this, (Object[])new Object[]{interfaceNames});
            throw new ClassNotFoundException(null, (Throwable)ex);
        }
    }

    private static ClassLoader getClassLoader(final Class<?> klass) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -4538302207353097225L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return klass.getClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private static ClassLoader getPlatformClassLoader() {
        if (JavaInfo.majorVersion() >= 9) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = 391341420543513892L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    ClassLoader pcl = null;
                    try {
                        Method getPlatformClassLoader = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
                        pcl = (ClassLoader)getPlatformClassLoader.invoke(null, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.serialization.DeserializationObjectInputStream$2", (String)"264", (Object)this, (Object[])new Object[0]);
                    }
                    return pcl;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        return null;
    }
}

