/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectManager.ConcurrentLinkedList;
import com.ibm.ws.objectManager.List;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableMetaData;
import com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableRawData;
import com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableSlicedData;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PersistableImpl
implements Persistable,
Tuple,
XmlConstants {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register(PersistableImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final long _uniqueID;
    private final long _streamID;
    private long _lockID = -2L;
    private long _referredID = -1L;
    private long _sequence;
    private long _expiryTime;
    private int _storageStrategy = 1;
    private int _priority;
    private int _persistentSize;
    private boolean _canExpireSilently;
    private final TupleTypeEnum _tupleType;
    private String _className;
    private PersistentTranId _persistentTranID;
    private boolean _logicallyDeleted;
    private int _redeliveredCount;
    private long _deliveryDelayTime;
    private boolean _deliveryDelayTimeIsSuspect = false;
    private AbstractItemLink _link;
    private Persistable _containingStream;
    private int _persistableOperationBegunCounter;
    private int _persistableOperationCompletedCounter;
    private Token _metaDataToken;
    private boolean _wasSpillingAtAddition = false;
    private int _inMemoryByteSize;

    public PersistableImpl(long uniqueID, long containingStreamID, TupleTypeEnum tupleType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"UniqueID=" + uniqueID, "StreamID=" + containingStreamID, "Type=" + tupleType});
        }
        this._uniqueID = uniqueID;
        this._streamID = containingStreamID;
        this._tupleType = tupleType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public PersistableImpl(long uniqueID, PersistableImpl containingStream, TupleTypeEnum tupleType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"UniqueID=" + uniqueID, "Type=" + tupleType, "Stream=" + containingStream});
        }
        this._uniqueID = uniqueID;
        this._streamID = containingStream.getUniqueId();
        this._tupleType = tupleType;
        this._containingStream = containingStream;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public PersistableImpl(Token metaDataToken) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("MetaDataToken=" + metaDataToken));
        }
        this._metaDataToken = metaDataToken;
        PersistableMetaData metaData = this.getMetaData();
        this._uniqueID = metaData.getUniqueId();
        this._streamID = metaData.getStreamId();
        this._lockID = metaData.getLockID();
        this._referredID = metaData.getReferredID();
        this._sequence = metaData.getSequence();
        this._expiryTime = metaData.getExpiryTime();
        this._storageStrategy = metaData.getStorageStrategy();
        this._priority = metaData.getPriority();
        this._persistentSize = metaData.getPersistentSize();
        this._canExpireSilently = metaData.canExpireSilently();
        this._tupleType = metaData.getTupleType();
        this._className = metaData.getClassName();
        this._redeliveredCount = metaData.getRedeliveredCount();
        this._deliveryDelayTime = metaData.getDeliveryDelayTime();
        this._deliveryDelayTimeIsSuspect = metaData.getDeliveryDelayTimeIsSuspect();
        byte[] tranId = metaData.getTransactionId();
        if (tranId != null) {
            this._persistentTranID = new PersistentTranId(tranId);
        }
        try {
            if (metaData.getState() == 5) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting logicallyDeleted=true");
                }
                this._logicallyDeleted = true;
            }
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.<init>", (String)"1:188:1.36", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught checking state of meta data!", (Object)ome);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
            }
            throw new PersistenceException("Exception caught checking state of meta data!", (Throwable)ome);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public List<DataSlice> getPersistedData() {
        List<Object> retval;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistedData");
            }
            retval = null;
            try {
                ManagedObject object;
                Token rawDataToken = null;
                if (this._metaDataToken != null) {
                    PersistableMetaData metaData = (PersistableMetaData)this._metaDataToken.getManagedObject();
                    rawDataToken = metaData.getRawDataToken();
                }
                if (rawDataToken != null && (object = rawDataToken.getManagedObject()) != null) {
                    if (object instanceof PersistableSlicedData) {
                        PersistableSlicedData slicedData = (PersistableSlicedData)object;
                        retval = slicedData.getData();
                    } else if (object instanceof PersistableRawData) {
                        PersistableRawData rawData = (PersistableRawData)object;
                        byte[] data = rawData.getData();
                        retval = new ArrayList(1);
                        retval.add(new DataSlice(data));
                    }
                }
            }
            catch (ObjectManagerException ome) {
                FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.getPersistedData", (String)"1:250:1.36", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block10;
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught retrieving persistent data!", (Object)ome);
            }
        }
        if (retval == null) {
            retval = new ArrayList(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistedData", (Object)("return=" + retval));
        }
        return retval;
    }

    public PersistableMetaData getMetaData() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        PersistableMetaData metaData = null;
        try {
            metaData = (PersistableMetaData)this._metaDataToken.getManagedObject();
        }
        catch (ClassCastException cce) {
            FFDCFilter.processException((Throwable)cce, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.getMetaData", (String)"1:282:1.36", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"ClassCaseException caught retrieving meta data!", (Object)cce);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData");
            }
            throw new PersistenceException("ClassCastException caught retrieving meta data!", (Throwable)cce);
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.getMetaData", (String)"1:289:1.36", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught retrieving meta data!", (Object)ome);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData");
            }
            throw new PersistenceException("Exception caught retrieving meta data!", (Throwable)ome);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)("return=" + metaData));
        }
        return metaData;
    }

    public Token getMetaDataToken() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaDataToken");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaDataToken", (Object)("return=" + this._metaDataToken));
        }
        return this._metaDataToken;
    }

    public void addToStore(Transaction tran, ObjectStore store) throws PersistenceException, ObjectManagerException, SevereMessageStoreException {
        this.addToStore(tran, store, this);
    }

    public void addToStore(Transaction tran, ObjectStore store, Persistable persistable) throws PersistenceException, ObjectManagerException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addToStore", (Object)new Object[]{"Tran=" + tran, "ObjectStore=" + store, "Persistable=" + persistable});
        }
        PersistableMetaData metaData = new PersistableMetaData(this._uniqueID, this._streamID, this._tupleType.toString());
        metaData.setLockID(persistable.getLockID());
        metaData.setReferredID(persistable.getReferredID());
        metaData.setSequence(persistable.getSequence());
        metaData.setExpiryTime(persistable.getExpiryTime());
        metaData.setStorageStrategy(persistable.getStorageStrategy());
        metaData.setPriority(persistable.getPriority());
        metaData.setPersistentSize(persistable.getPersistentSize());
        metaData.setCanExpireSilently(persistable.getCanExpireSilently());
        metaData.setClassName(persistable.getItemClassName());
        metaData.setRedeliveredCount(persistable.getRedeliveredCount());
        metaData.setDeliveryDelayTime(persistable.getDeliveryDelayTime());
        PersistentTranId tranId = persistable.getPersistentTranId();
        if (tranId != null) {
            metaData.setTransactionId(tranId.toByteArray());
        }
        try {
            if ((this._tupleType == TupleTypeEnum.ITEM_STREAM || this._tupleType == TupleTypeEnum.REFERENCE_STREAM || this._tupleType == TupleTypeEnum.ROOT) && this._storageStrategy != 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Persistent item is a stream. Building lists.");
                }
                ConcurrentLinkedList streamList = new ConcurrentLinkedList(tran, store, 64);
                metaData.setStreamListToken(streamList.getToken());
                ConcurrentLinkedList itemList = new ConcurrentLinkedList(tran, store, 64);
                metaData.setItemListToken(itemList.getToken());
            }
            PersistableSlicedData slicedData = new PersistableSlicedData();
            try {
                slicedData.setData(persistable.getData());
            }
            catch (SevereMessageStoreException smse) {
                FFDCFilter.processException((Throwable)smse, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.addToStore", (String)"1:416:1.36", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Severe exception caught retrieving latest copy of binary data from Item!", (Object)((Object)smse));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addToStore");
                }
                throw smse;
            }
            catch (PersistentDataEncodingException pdee) {
                FFDCFilter.processException((Throwable)pdee, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.addToStore", (String)"1:423:1.36", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Encoding exception caught retrieving latest copy of binary data from Item!", (Object)((Object)pdee));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"addToStore");
                }
                throw pdee;
            }
            Token rawDataToken = store.allocate(slicedData);
            tran.add(slicedData);
            metaData.setRawDataToken(rawDataToken);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Persistent data token added to transaction: " + rawDataToken));
            }
            this._metaDataToken = store.allocate(metaData);
            if (this._containingStream != null && this._storageStrategy != 2) {
                PersistableImpl parentStream = (PersistableImpl)this._containingStream;
                PersistableMetaData parentMetaData = parentStream.getMetaData();
                if (this.getExpiryTime() > 0L && !parentMetaData.containsExpirables()) {
                    tran.lock(parentMetaData);
                    parentMetaData.setContainsExpirables(true);
                    tran.replace(parentMetaData);
                }
                if (parentStream.getStorageStrategy() != 2) {
                    ConcurrentLinkedList list = (ConcurrentLinkedList)parentMetaData.getItemListToken().getManagedObject();
                    List.Entry itemListEntry = list.addEntry(this._metaDataToken, tran);
                    metaData.setItemListEntryToken(((ManagedObject)((Object)itemListEntry)).getToken());
                    if (this._tupleType == TupleTypeEnum.ITEM_STREAM || this._tupleType == TupleTypeEnum.REFERENCE_STREAM) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Persistent item is a stream. Adding to parent.");
                        }
                        list = (ConcurrentLinkedList)parentMetaData.getStreamListToken().getManagedObject();
                        List.Entry streamListEntry = list.addEntry(this._metaDataToken, tran);
                        metaData.setStreamListEntryToken(((ManagedObject)((Object)streamListEntry)).getToken());
                    }
                }
            }
            tran.add(metaData);
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.addToStore", (String)"1:502:1.36", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught trying to add persistable to object manager!", (Object)ome);
            }
            this._metaDataToken = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addToStore");
            }
            throw ome;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addToStore");
        }
    }

    public void updateDataOnly(Transaction tran, ObjectStore store) throws PersistenceException, ObjectManagerException, SevereMessageStoreException {
        this.updateDataOnly(tran, store, this);
    }

    public void updateDataOnly(Transaction tran, ObjectStore store, Persistable persistable) throws PersistenceException, ObjectManagerException, SevereMessageStoreException {
        PersistableMetaData metaData;
        Token rawDataToken;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateDataOnly", (Object)new Object[]{"Tran=" + tran, "Persistable=" + persistable});
        }
        if ((rawDataToken = (metaData = this.getMetaData()).getRawDataToken()) != null) {
            ManagedObject object = rawDataToken.getManagedObject();
            if (object != null) {
                if (object instanceof PersistableSlicedData) {
                    PersistableSlicedData slicedData = (PersistableSlicedData)object;
                    tran.lock(slicedData);
                    try {
                        slicedData.setData(persistable.getData());
                    }
                    catch (SevereMessageStoreException smse) {
                        FFDCFilter.processException((Throwable)smse, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.updateDataOnly", (String)"1:577:1.36", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Severe exception caught retrieving latest copy of binary data from Item!", (Object)((Object)smse));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"updateDataOnly");
                        }
                        throw smse;
                    }
                    catch (PersistentDataEncodingException pdee) {
                        FFDCFilter.processException((Throwable)pdee, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.updateDataOnly", (String)"1:584:1.36", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Encoding exception caught retrieving latest copy of binary data from Item!", (Object)((Object)pdee));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataOnly");
                        }
                        throw pdee;
                    }
                    tran.replace(slicedData);
                } else if (object instanceof PersistableRawData) {
                    PersistableRawData rawData = (PersistableRawData)object;
                    tran.delete(rawData);
                    PersistableSlicedData slicedData = new PersistableSlicedData();
                    try {
                        slicedData.setData(persistable.getData());
                    }
                    catch (PersistentDataEncodingException pdee) {
                        FFDCFilter.processException((Throwable)pdee, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl.updateDataOnly", (String)"1:614:1.36", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Encoding exception caught retrieving latest copy of binary data from Item!", (Object)((Object)pdee));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataOnly");
                        }
                        throw pdee;
                    }
                    rawDataToken = store.allocate(slicedData);
                    tran.add(slicedData);
                    tran.lock(metaData);
                    metaData.setRawDataToken(rawDataToken);
                    tran.replace(metaData);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Successfully converted PersistableRawData to PersistableSlicedData.");
                    }
                }
            }
        } else {
            PersistenceException pe = new PersistenceException("No raw data Token found for this Persistable!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"No raw data Token found for this Persistable!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataOnly");
            }
            throw pe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataOnly");
        }
    }

    public void updateMetaDataOnly(Transaction tran) throws PersistenceException, ObjectManagerException {
        this.updateMetaDataOnly(tran, this);
    }

    public void updateMetaDataOnly(Transaction tran, Persistable persistable) throws PersistenceException, ObjectManagerException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateMetaDataOnly", (Object)new Object[]{"Tran=" + tran, "Persistable=" + persistable});
        }
        PersistableMetaData metaData = this.getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("MetaData=" + metaData));
        }
        tran.lock(metaData);
        metaData.setLockID(persistable.getLockID());
        metaData.setRedeliveredCount(persistable.getRedeliveredCount());
        tran.replace(metaData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateMetaDataOnly", (Object)("MetaData=" + metaData));
        }
    }

    public void removeFromStore(Transaction tran) throws PersistenceException, ObjectManagerException {
        PersistableImpl parentStream;
        Token rawDataToken;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFromStore", (Object)("Tran=" + tran));
        }
        PersistableMetaData metaData = this.getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("MetaData=" + metaData));
        }
        if ((this._tupleType == TupleTypeEnum.ITEM_STREAM || this._tupleType == TupleTypeEnum.REFERENCE_STREAM || this._tupleType == TupleTypeEnum.ROOT) && this._storageStrategy != 2) {
            tran.delete(metaData.getStreamListToken().getManagedObject());
            tran.delete(metaData.getItemListToken().getManagedObject());
        }
        if ((rawDataToken = metaData.getRawDataToken()) != null) {
            ManagedObject rawData = rawDataToken.getManagedObject();
            tran.delete(rawData);
        }
        if (this._containingStream != null && this._storageStrategy != 2 && (parentStream = (PersistableImpl)this._containingStream).getStorageStrategy() != 2) {
            ((List.Entry)((Object)metaData.getItemListEntryToken().getManagedObject())).remove(tran);
            if (this._tupleType == TupleTypeEnum.ITEM_STREAM || this._tupleType == TupleTypeEnum.REFERENCE_STREAM) {
                ((List.Entry)((Object)metaData.getStreamListEntryToken().getManagedObject())).remove(tran);
            }
        }
        tran.delete(metaData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFromStore");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Persistable[metaDataToken: ");
        buffer.append(this._metaDataToken);
        buffer.append(", link: ");
        buffer.append(this._link);
        buffer.append(", uniqueID: ");
        buffer.append(this._uniqueID);
        buffer.append(", streamID: ");
        buffer.append(this._streamID);
        buffer.append(", lockID: ");
        buffer.append(this._lockID);
        buffer.append(", referredID: ");
        buffer.append(this._referredID);
        buffer.append(", sequence: ");
        buffer.append(this._sequence);
        buffer.append(", expiryTime: ");
        buffer.append(this._expiryTime);
        buffer.append(", storageStrategy: ");
        buffer.append(this._storageStrategy);
        buffer.append(", priority: ");
        buffer.append(this._priority);
        buffer.append(", persistentSize: ");
        buffer.append(this._persistentSize);
        buffer.append(", canExpireSilently: ");
        buffer.append(this._canExpireSilently);
        buffer.append(", type: ");
        buffer.append(this._tupleType);
        buffer.append(", className: ");
        buffer.append(this._className);
        buffer.append(", persistentTranID: ");
        buffer.append(this._persistentTranID);
        buffer.append(", logicallyDeleted: ");
        buffer.append(this._logicallyDeleted);
        buffer.append(", wasSpillingAtAddition: ");
        buffer.append(this._wasSpillingAtAddition);
        buffer.append(", inMemoryByteSize: ");
        buffer.append(this._inMemoryByteSize);
        buffer.append(", redeliveredCount: ");
        buffer.append(this._redeliveredCount);
        buffer.append(", deliveryDelayTime: ");
        buffer.append(this._deliveryDelayTime);
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public boolean requiresPersistence() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requiresPersistence");
        }
        boolean requiresPersistence = false;
        if (this._storageStrategy == 4 || this._storageStrategy == 3) {
            requiresPersistence = true;
        } else if (2 == this._storageStrategy) {
            requiresPersistence = this._wasSpillingAtAddition;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requiresPersistence", (Object)requiresPersistence);
        }
        return requiresPersistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataSlice> getData() throws PersistentDataEncodingException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getData");
        }
        List<DataSlice> retval = null;
        PersistableImpl persistableImpl = this;
        synchronized (persistableImpl) {
            if (this._link != null) {
                retval = this._link.getMemberData();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getData", (Object)("return=" + retval));
        }
        return retval;
    }

    @Override
    public Persistable createPersistable(long uniqueID, TupleTypeEnum tupleType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createPersistable", (Object)new Object[]{"UniqueID=" + uniqueID, "Type=" + tupleType});
        }
        PersistableImpl persistable = new PersistableImpl(uniqueID, this, tupleType);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createPersistable", (Object)("return=" + persistable));
        }
        return persistable;
    }

    @Override
    public synchronized void setAbstractItemLink(AbstractItemLink link) {
        this._link = link;
    }

    @Override
    public void setContainingStream(Persistable containingStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setContainingStream", (Object)("ContainingStream=" + containingStream));
        }
        this._containingStream = containingStream;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setContainingStream");
        }
    }

    @Override
    public Persistable getContainingStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getContainingStream");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getContainingStream", (Object)("return=" + this._containingStream));
        }
        return this._containingStream;
    }

    @Override
    public void setCanExpireSilently(boolean canExpireSilently) {
        this._canExpireSilently = canExpireSilently;
    }

    @Override
    public boolean getCanExpireSilently() {
        return this._canExpireSilently;
    }

    @Override
    public long getContainingStreamId() {
        return this._streamID;
    }

    @Override
    public void setExpiryTime(long expiryTime) {
        this._expiryTime = expiryTime;
    }

    @Override
    public long getExpiryTime() {
        return this._expiryTime;
    }

    @Override
    public void setItemClassName(String className) {
        this._className = className;
    }

    @Override
    public String getItemClassName() {
        return this._className;
    }

    @Override
    public void setLockID(long lockID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLockID", (Object)("LockID=" + lockID));
        }
        this._lockID = lockID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLockID");
        }
    }

    @Override
    public long getLockID() {
        return this._lockID;
    }

    @Override
    public void setLogicallyDeleted(boolean logicallyDeleted) {
        this._logicallyDeleted = logicallyDeleted;
    }

    @Override
    public boolean isLogicallyDeleted() {
        return this._logicallyDeleted;
    }

    @Override
    public void setPersistentSize(int persistentSize) {
        this._persistentSize = persistentSize;
    }

    @Override
    public int getPersistentSize() {
        return this._persistentSize;
    }

    @Override
    public void setInMemoryByteSize(int byteSize) {
        this._inMemoryByteSize = byteSize;
    }

    @Override
    public int getInMemoryByteSize() {
        return this._inMemoryByteSize;
    }

    @Override
    public void setPersistentTranId(PersistentTranId xid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPersistentTranId", (Object)("XID=" + xid));
        }
        this._persistentTranID = xid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPersistentTranId");
        }
    }

    @Override
    public PersistentTranId getPersistentTranId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentTranId");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + this._persistentTranID));
        }
        return this._persistentTranID;
    }

    @Override
    public void setPriority(int priority) {
        this._priority = priority;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public void setRedeliveredCount(int redeliveredCount) {
        this._redeliveredCount = redeliveredCount;
    }

    @Override
    public int getRedeliveredCount() {
        return this._redeliveredCount;
    }

    @Override
    public void setReferredID(long referredID) {
        this._referredID = referredID;
    }

    @Override
    public long getReferredID() {
        return this._referredID;
    }

    @Override
    public void setSequence(long sequence) {
        this._sequence = sequence;
    }

    @Override
    public long getSequence() {
        return this._sequence;
    }

    @Override
    public void setStorageStrategy(int storageStrategy) {
        this._storageStrategy = storageStrategy;
    }

    @Override
    public int getStorageStrategy() {
        return this._storageStrategy;
    }

    @Override
    public TupleTypeEnum getTupleType() {
        return this._tupleType;
    }

    @Override
    public long getUniqueId() {
        return this._uniqueID;
    }

    @Override
    public void setWasSpillingAtAddition(boolean wasSpillingAtAddition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setWasSpillingAtAddition", (Object)wasSpillingAtAddition);
        }
        this._wasSpillingAtAddition = wasSpillingAtAddition;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setWasSpillingAtAddition");
        }
    }

    @Override
    public void xmlWrite(FormattedWriter writer) throws IOException {
        long referredID;
        writer.newLine();
        writer.taggedValue("class", (Object)this.getItemClassName());
        writer.newLine();
        writer.taggedValue("priority", (long)this.getPriority());
        if (this.isLogicallyDeleted()) {
            writer.newLine();
            writer.emptyTag("logicallyDeleted");
        }
        if (this.getCanExpireSilently()) {
            writer.newLine();
            writer.emptyTag("canExpireSilently");
        }
        writer.newLine();
        switch (this.getStorageStrategy()) {
            case 4: {
                writer.taggedValue("storageStrategy", (Object)"StoreAlways");
                break;
            }
            case 2: {
                writer.taggedValue("storageStrategy", (Object)"StoreMaybe");
                break;
            }
            case 3: {
                writer.taggedValue("storageStrategy", (Object)"StoreEventually");
                break;
            }
            case 1: {
                writer.taggedValue("storageStrategy", (Object)"StoreNever");
                break;
            }
            default: {
                writer.taggedValue("storageStrategy", (long)this.getStorageStrategy());
            }
        }
        writer.newLine();
        writer.taggedValue("expiryTime", this.getExpiryTime());
        writer.newLine();
        writer.taggedValue("sequence", this.getSequence());
        writer.newLine();
        PersistentTranId tranId = this.getPersistentTranId();
        if (tranId != null) {
            writer.taggedValue("tranID", (Object)tranId.toTMString());
        } else {
            writer.taggedValue("tranID", (Object)"");
        }
        if (-2L != this.getLockID()) {
            writer.newLine();
            writer.taggedValue("lockID", this.getLockID());
        }
        if (-1L != (referredID = this.getReferredID())) {
            writer.newLine();
            writer.taggedValue("referredID", referredID);
        }
    }

    @Override
    public synchronized void persistableOperationBegun() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistableOperationBegun");
        }
        ++this._persistableOperationBegunCounter;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.event((Object)this, (TraceComponent)tc, (String)("persistableOperationBegunCounter: " + this._persistableOperationBegunCounter));
        }
        if (this._link != null && this._persistableOperationBegunCounter - this._persistableOperationCompletedCounter == 1) {
            this._link.persistentRepresentationIsUnstable();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistableOperationBegun");
        }
    }

    @Override
    public synchronized void persistableOperationCompleted() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistableOperationCompleted");
        }
        ++this._persistableOperationCompletedCounter;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.event((Object)this, (TraceComponent)tc, (String)("persistableOperationCompletedCounter: " + this._persistableOperationCompletedCounter));
        }
        if (this._link != null) {
            if (this._persistableOperationBegunCounter == this._persistableOperationCompletedCounter) {
                this._link.persistentRepresentationIsStable();
            } else if (this._persistableOperationBegunCounter < this._persistableOperationCompletedCounter) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_PERSISTABLE_STATE_SIMS1527", new Object[]{this._persistableOperationBegunCounter, this._persistableOperationCompletedCounter}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistableOperationCompleted");
        }
    }

    @Override
    public synchronized void persistableOperationCancelled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistableOperationCancelled");
        }
        --this._persistableOperationBegunCounter;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.event((Object)this, (TraceComponent)tc, (String)("persistableOperationBegunCounter: " + this._persistableOperationBegunCounter));
        }
        if (this._persistableOperationBegunCounter < this._persistableOperationCompletedCounter) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_PERSISTABLE_STATE_SIMS1527", new Object[]{this._persistableOperationBegunCounter, this._persistableOperationCompletedCounter}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistableOperationCancelled");
        }
    }

    @Override
    public boolean persistableRepresentationWasCreated() {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistableRepresentationWasCreated");
        }
        boolean bl = result = this._persistableOperationCompletedCounter > 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistableRepresentationWasCreated", (Object)("return=" + result));
        }
        return result;
    }

    public synchronized boolean persistableRepresentationIsUnstable() {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistableRepresentationIsUnstable");
        }
        boolean bl = result = this._persistableOperationBegunCounter != this._persistableOperationCompletedCounter;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistableRepresentationIsUnstable", (Object)("return=" + result));
        }
        return result;
    }

    @Override
    public synchronized int persistableOperationsOutstanding() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistableOperationsOutstanding");
        }
        int result = this._persistableOperationBegunCounter - this._persistableOperationCompletedCounter;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistableOperationsOutstanding", (Object)result);
        }
        return result;
    }

    @Override
    public void setPermanentTableId(int permanentTableId) {
    }

    @Override
    public int getPermanentTableId() {
        return 0;
    }

    @Override
    public void setTemporaryTableId(int temporaryTableId) {
    }

    @Override
    public int getTemporaryTableId() {
        return 0;
    }

    @Override
    public void setItemClassId(int itemClassId) {
    }

    @Override
    public int getItemClassId() {
        return 0;
    }

    @Override
    public void setDeliveryDelayTime(long deliveryDelayTime) {
        this._deliveryDelayTime = deliveryDelayTime;
    }

    @Override
    public long getDeliveryDelayTime() {
        return this._deliveryDelayTime;
    }

    @Override
    public boolean getDeliveryDelayTimeIsSuspect() {
        return this._deliveryDelayTimeIsSuspect;
    }
}

